/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.parsers.errorreport;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.j2ee.xml.XMLElement;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.parsers.errorreport.XMLErrorReportParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class FlashFilesParser
extends XMLErrorReportParser {
    @Override
    protected ArrayList<DynamicBean> parseErrorReportData(Appliance appliance, Domain domain, XMLElement rootElement) {
        logger.finer(() -> LMG.log("(Appliance=%s, Domain=%s, rootElement):  Starting.", () -> appliance.getName(), () -> domain.getName()));
        if (rootElement == null) {
            logger.warning(() -> LMG.log("(Appliance=%s, Domain=%s, rootElement):  Root element is null.  Why?", () -> appliance.getName(), () -> domain.getName()));
            return new ArrayList<DynamicBean>();
        }
        Collection<XMLElement> childNodes = rootElement.getNodes("//file");
        ArrayList<DynamicBean> data = new ArrayList<DynamicBean>(childNodes.size());
        for (XMLElement node : childNodes) {
            long size = Long.parseLong(node.getAttributeValue("size"));
            Collection<XMLElement> cdataSections = node.getNodes();
            for (XMLElement cdataSection : cdataSections) {
                String fileName = cdataSection.getValue();
                DynamicBean bean = new DynamicBean();
                bean.setProperty("appliance", appliance.getName());
                bean.setProperty("domain", domain.getName());
                bean.setProperty("fileName", fileName);
                bean.setProperty("size", size);
                logger.finer(() -> LMG.log("(Appliance=%s, Domain=%s, rootElement):  Adding file '%s' of size %d.", () -> appliance.getName(), () -> domain.getName(), () -> fileName, () -> size));
                data.add(bean);
            }
        }
        Collections.sort(data);
        logger.finer(() -> LMG.log("(Appliance=%s, Domain=%s, rootElement):  Done.  Returning %d data elements.", () -> appliance.getName(), () -> domain.getName(), () -> data.size()));
        return data;
    }
}

