/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.parsers.errorreport;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.j2ee.xml.XMLElement;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.parsers.errorreport.AbstractErrorReportParser;
import java.io.File;
import java.util.ArrayList;

public abstract class XMLErrorReportParser
extends AbstractErrorReportParser<ArrayList<DynamicBean>> {
    public XMLErrorReportParser() {
    }

    public XMLErrorReportParser(File file) {
        super(file);
    }

    @Override
    protected ArrayList<DynamicBean> parseErrorReportData(Appliance appliance, Domain domain, byte[] fileData) {
        logger.finer(() -> LMG.log("(Appliance=%s, Domain=%s, fileData): Starting.", () -> appliance.getName(), () -> domain.getName()));
        String stringData = new String(fileData);
        XMLElement rootElement = XMLElement.parseXMLString(stringData);
        if (rootElement == null) {
            logger.warning(() -> LMG.log("(Appliance=%s, Domain=%s, fileData): Failed to parse XML from String:\n\t%s", () -> appliance.getName(), () -> domain.getName(), () -> stringData));
            return new ArrayList<DynamicBean>();
        }
        logger.finer(() -> LMG.log("(Appliance=%s, Domain=%s, fileData): Done extracting root element.  Parsing root element.", () -> appliance.getName(), () -> domain.getName()));
        return this.parseErrorReportData(appliance, domain, rootElement);
    }

    protected abstract ArrayList<DynamicBean> parseErrorReportData(Appliance var1, Domain var2, XMLElement var3);
}

