/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.beans.PropertyNotFoundException;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.j2ee.xml.XMLElement;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.InvocationListener;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ManagementCommandError;
import com.kumbasoft.core.beans.ManagementCommandStatus;
import com.kumbasoft.core.tools.DataPowerXMLManagement;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.util.FileUtility;
import com.kumbasoft.core.util.logging.FinestLogRecord;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;

public abstract class AbstractDataPowerManagementRequest
extends DataPowerXMLManagement {
    private static String somaTemplatesDirectory = applicationProperties.getSomaTemplatesDirectory();
    private static String debuggingDirectory = applicationProperties.getDebuggingDirectory();
    protected AsynchMethodInvoker<Void> processThread;
    private String commandDescription;
    private DynamicBean additionalCommandInfo;
    protected String requestXML;
    protected boolean requestStatus;

    protected AbstractDataPowerManagementRequest() {
    }

    protected AbstractDataPowerManagementRequest(Appliance appliance, Domain domain, String commandDescription) {
        this(appliance, domain, commandDescription, false);
    }

    protected AbstractDataPowerManagementRequest(Appliance appliance, Domain domain, String commandDescription, boolean runSynchronously) {
        super(appliance, domain);
        logger.finer(() -> LMG.log("(appliance=%s, domain=%s, commandDescription=%s, runSynchronously=%s)", () -> appliance.getName(), () -> domain.getName(), () -> commandDescription, () -> runSynchronously));
        this.setCommandDescription(commandDescription);
        if (runSynchronously) {
            this.processCommand();
        } else {
            this.kickoffProcessThread();
        }
    }

    protected void kickoffProcessThread() {
        logger.finer(() -> LMG.log("():  Starting - Running Request for appliance '%s' and domain '%s': '%s'", () -> this.appliance.getName(), () -> this.domain.getName(), () -> this.commandDescription));
        this.processThread = ThreadManager.getThread(this.appliance, this, "processCommand", KumbaCoreConstants.STARTUP_DELAY, new Object[0]);
    }

    public AsynchMethodInvoker<?> getProcessThread() {
        return this.processThread;
    }

    public String getThreadName() {
        if (this.processThread != null) {
            return this.processThread.getThreadName();
        }
        return null;
    }

    public String getCommandDescription() {
        return this.commandDescription;
    }

    public void setCommandDescription(String commandDescription) {
        this.commandDescription = commandDescription;
    }

    public void addInvocationListener(InvocationListener listener) {
        if (listener == null || this.processThread == null) {
            return;
        }
        this.processThread.addInvocationListener(listener);
    }

    public DynamicBean getAdditionalCommandInfo() {
        return this.additionalCommandInfo;
    }

    public void addAdditionalCommandInfo(String propertyName, Object propertyValue) {
        if (StringUtility.isEmpty(this.commandDescription)) {
            return;
        }
        if (this.additionalCommandInfo == null) {
            this.additionalCommandInfo = new DynamicBean();
        }
        this.additionalCommandInfo.setProperty(propertyName, propertyValue);
    }

    public void setAdditionalCommandInfo(DynamicBean additionalCommandInfo) {
        this.additionalCommandInfo = additionalCommandInfo;
    }

    public boolean getRequestStatus() {
        return this.requestStatus;
    }

    protected void processCommand() {
        logger.finer(() -> LMG.log("():  Starting - Running Request for appliance '%s' and domain '%s': '%s'", () -> this.appliance.getName(), () -> this.domain.getName(), () -> this.commandDescription));
        try {
            XMLElement rootElement = this.runRequest();
            if (rootElement == null) {
                logger.finer(() -> LMG.log("():  Response element is NULL for appliance '%s' and domain '%s': '%s'", () -> this.appliance.getName(), () -> this.domain.getName(), () -> this.commandDescription));
                ManagementCommandError commandError = new ManagementCommandError(this.getAppliance(), this.getDomain(), this.commandDescription, this, null);
                commandError.setAdditionalCommandInfo(this.additionalCommandInfo);
                this.notifyManagementCommandSubscribers(commandError);
            } else {
                if (logger.getLevel().equals(Level.FINEST)) {
                    FinestLogRecord logRecord = new FinestLogRecord(Level.FINEST, this.getAppliance(), this.getDomain(), rootElement.toString());
                    logger.log(logRecord);
                }
                logger.finer(() -> LMG.log("():  Processing results for appliance '%s' and domain '%s': '%s'", () -> this.appliance.getName(), () -> this.domain.getName(), () -> this.commandDescription));
                this.requestStatus = this.processResultDocument(rootElement);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.severe(() -> LMG.log("():  Error processing the command for appliance '%s' and domain '%s': '%s'", () -> this.appliance.getName(), () -> this.domain.getName(), () -> this.commandDescription));
        }
        logger.finer(() -> LMG.log("():   Done Running Request for appliance '%s' and domain '%s': '%s'", () -> this.appliance.getName(), () -> this.domain.getName(), () -> this.commandDescription));
    }

    protected boolean processResultDocument(XMLElement rootElement) {
        logger.finer(() -> LMG.log("(XMLElement rootElement):  Starting for appliance '%s' and domain '%s': '%s'", () -> this.appliance.getName(), () -> this.domain.getName(), () -> this.commandDescription));
        if (rootElement == null) {
            logger.warning(() -> LMG.log("(XMLElement rootElement):  Root element is null for appliance '%s' and domain '%s': '%s'", () -> this.appliance.getName(), () -> this.domain.getName(), () -> this.commandDescription));
            ManagementCommandError commandError = new ManagementCommandError(this.getAppliance(), this.getDomain(), this.getCommandDescription(), this, "Result document is null.");
            commandError.setAdditionalCommandInfo(this.additionalCommandInfo);
            this.notifyManagementCommandSubscribers(commandError);
            return false;
        }
        if (logger.getLevel().equals(Level.FINEST)) {
            FinestLogRecord logRecord = new FinestLogRecord(Level.FINEST, this.getAppliance(), this.getDomain(), rootElement.toString());
            logger.log(logRecord);
        }
        Collection<XMLElement> resultNodes = rootElement.getNodes("//dp:result");
        logger.finer(() -> LMG.log("(XMLElement rootElement):  Found %d dp:result nodes for appliance '%s' and domain '%s': '%s'", () -> resultNodes.size(), () -> this.appliance.getName(), () -> this.domain.getName(), () -> this.commandDescription));
        for (XMLElement resultNode : resultNodes) {
            XMLElement errorLogNode = resultNode.getNode("error-log");
            if (errorLogNode == null) {
                logger.finer(() -> LMG.log("(XMLElement rootElement):  Result node is valie.  Notifying subscribers for appliance '%s' and domain '%s': '%s'", () -> this.appliance.getName(), () -> this.domain.getName(), () -> this.commandDescription));
                ManagementCommandStatus commandStatus = new ManagementCommandStatus(this.getAppliance(), this.getDomain(), this.getCommandDescription(), this, resultNode.getValue().trim());
                commandStatus.setAdditionalCommandInfo(this.additionalCommandInfo);
                this.notifyManagementCommandSubscribers(commandStatus);
                continue;
            }
            logger.severe(() -> LMG.log("(XMLElement rootElement):  Found error-log node.  Something is wrong maybe with the request?  Notifiying subscribers for appliance '%s' and domain '%s': '%s'", () -> this.appliance.getName(), () -> this.domain.getName(), () -> this.commandDescription));
            Collection<XMLElement> logEventNodes = errorLogNode.getNodes("(dp.)?log-event");
            StringBuilder sb = new StringBuilder();
            for (XMLElement logEventNode : logEventNodes) {
                sb.append(logEventNode.getValue());
            }
            ManagementCommandError commandError = new ManagementCommandError(this.getAppliance(), this.getDomain(), this.getCommandDescription(), this, sb.toString());
            commandError.setAdditionalCommandInfo(this.additionalCommandInfo);
            this.notifyManagementCommandSubscribers(commandError);
            return false;
        }
        logger.finer(() -> LMG.log("(XMLElement rootElement):  Returning true for appliance '%s' and domain '%s': '%s'", () -> this.appliance.getName(), () -> this.domain.getName(), () -> this.commandDescription));
        return true;
    }

    protected String getSOMATemplateFileName() {
        logger.finer("(): Starting");
        String baseClassName = this.getClass().getSimpleName();
        String somaFileName = baseClassName + ".xml";
        logger.finer(() -> LMG.log("(): Done.  Returning %s", () -> somaFileName));
        return somaFileName;
    }

    @Override
    protected String getRequestMessage() {
        String propertyName;
        logger.finer("(): Starting");
        String requestXML = this.getSOMATemplate();
        if (requestXML == null) {
            logger.finer("(): Done.  Response from getSOMATemplate() is null.  Returning null.");
            return null;
        }
        if (logger.getLevel().equals(Level.FINEST)) {
            FinestLogRecord logRecord = new FinestLogRecord(Level.FINEST, this.getAppliance(), this.getDomain(), requestXML);
            logger.log(logRecord);
        }
        String lastPropertyValue = null;
        while ((propertyName = StringUtility.getMarkupContent(requestXML, "${", "}")) != null) {
            try {
                Object value = BeanService.getPropertyValue(this, propertyName);
                if (value == null) {
                    value = "";
                }
                String propertyMarker = String.format("${%s}", propertyName);
                if (value instanceof String || value instanceof Boolean || value instanceof Number) {
                    String strValue = value.toString();
                    requestXML = requestXML.replace(propertyMarker, strValue);
                    lastPropertyValue = value.toString();
                    continue;
                }
                if (value instanceof ArrayList) {
                    ArrayList values = (ArrayList)value;
                    String nextPropertyMarker = String.format("<%s>${propertyValue}</%s>", lastPropertyValue, lastPropertyValue);
                    if (CollectionUtility.isEmpty(values)) {
                        requestXML = requestXML.replace(propertyMarker, "");
                        continue;
                    }
                    int i = 0;
                    while (i < values.size()) {
                        Object v = values.get(i);
                        String strValue = v.toString();
                        requestXML = requestXML.replace(propertyMarker, strValue);
                        if (i < values.size() - 1) {
                            String lastReplacement = String.format("<%s>%s</%s>", lastPropertyValue, strValue, lastPropertyValue);
                            int lastReplacementIndex = requestXML.indexOf(lastReplacement);
                            requestXML = StringUtility.insertInto(nextPropertyMarker, requestXML, lastReplacementIndex + lastReplacement.length());
                        }
                        ++i;
                    }
                    continue;
                }
                Object valueF = value;
                logger.severe(() -> LMG.log("(): Value %s is an instance of %s which is not handled by the code", () -> valueF, () -> valueF.getClass().getName()));
            }
            catch (PropertyNotFoundException pne) {
                String errorMessage = String.format("(): Property %s from %s not found in %s", propertyName, this.getSOMATemplateFileName(), this.getClass().getName());
                logger.severe(() -> LMG.log("():  %s\n", () -> errorMessage));
                ManagementCommandError commandError = new ManagementCommandError(this.getAppliance(), this.getDomain(), this.commandDescription, this, errorMessage);
                commandError.setAdditionalCommandInfo(this.additionalCommandInfo);
                this.notifyManagementCommandSubscribers(commandError);
                logger.info("(): Aborting on error.  Returning null.");
                return null;
            }
        }
        requestXML = this.finalizeRequestMessage(requestXML);
        if (requestXML.contains("${")) {
            String errorMessage = String.format("*** WARNING:  Property Marker still exists in resulting request XML:\n%s\n", requestXML);
            logger.severe(() -> LMG.log("():  %s\n", () -> errorMessage));
            ManagementCommandError commandError = new ManagementCommandError(this.getAppliance(), this.getDomain(), this.commandDescription, this, errorMessage);
            commandError.setAdditionalCommandInfo(this.additionalCommandInfo);
            this.notifyManagementCommandSubscribers(commandError);
            return null;
        }
        this.requestXML = requestXML;
        if (logger.getLevel().equals(Level.FINEST)) {
            FinestLogRecord logRecord = new FinestLogRecord(Level.FINEST, this.getAppliance(), this.getDomain(), this.requestXML);
            logger.log(logRecord);
        }
        logger.finer("(): Done.  Returning Request XML.");
        return requestXML;
    }

    protected String getSOMATemplate() {
        String somaTemplateFileName = this.getSOMATemplateFileName();
        String fullFileName = String.format("%s/%s", somaTemplatesDirectory, somaTemplateFileName);
        String requestXML = null;
        try {
            requestXML = FileUtility.readFile(fullFileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return requestXML;
    }

    protected String finalizeRequestMessage(String requestXML) {
        return requestXML;
    }
}

