/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.JMBean;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.Index;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ManagementCommandSubscriber;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.actions.ActionDeleteFile;
import com.kumbasoft.core.beans.actions.ActionDomainQuiesce;
import com.kumbasoft.core.beans.actions.ActionDomainUnquiesce;
import com.kumbasoft.core.beans.actions.ActionFlushAAACache;
import com.kumbasoft.core.beans.actions.ActionQuiesceDP;
import com.kumbasoft.core.beans.actions.ActionRemoveCheckpoint;
import com.kumbasoft.core.beans.actions.ActionResetDomain;
import com.kumbasoft.core.beans.actions.ActionRestartDomain;
import com.kumbasoft.core.beans.actions.ActionRollbackCheckpoint;
import com.kumbasoft.core.beans.actions.ActionSaveCheckpoint;
import com.kumbasoft.core.beans.actions.ActionShutdown;
import com.kumbasoft.core.beans.actions.ActionUnquiesceDP;
import com.kumbasoft.core.beans.config.ConfigAAAPolicy;
import com.kumbasoft.core.beans.config.ConfigDomain;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.ActionTool;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.util.DataStructureUtility;
import java.util.Collection;
import java.util.HashMap;

public final class ActionController
extends AbstractTool {
    private ActionController() {
    }

    public static void deleteFiles(Collection<DataPowerFileInfo> files, ManagementCommandSubscriber ... subscribers) {
        logger.finer("(Collection<DataPowerFileInfo> files, ManagementCommandSubscriber...subscribers):  Starting.");
        HashMap<Appliance, Index<Domain, DataPowerFileInfo>> deleteIndex = DataStructureUtility.mapByApplianceDomain(files);
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        for (Appliance appliance : deleteIndex.keySet()) {
            logger.finer(() -> LMG.log("(Collection<DataPowerFileInfo> files, ManagementCommandSubscriber...subscribers):  Deleting files from %s.", () -> appliance.getName()));
            Index<Domain, DataPowerFileInfo> domainDeleteIndex = deleteIndex.get(appliance);
            mtil.addThread(new AsynchMethodInvoker(ActionController.class, "deleteFiles", new Object[]{domainDeleteIndex, subscribers, mtil}));
        }
        logger.finer("(Collection<DataPowerFileInfo> files, ManagementCommandSubscriber...subscribers):  Waiting for delete files to complete.");
        ThreadManager.monitorAsynchThreadLifeCycle("ActionController.deleteFiles()", mtil, deleteIndex.size() * KumbaCoreConstants.STARTUP_DELAY, 0);
        logger.finer("(Collection<DataPowerFileInfo> files, ManagementCommandSubscriber...subscribers):  Done.");
    }

    @Reflected
    private static void deleteFiles(Index<Domain, DataPowerFileInfo> domainDeleteIndex, ManagementCommandSubscriber[] subscribers, MultiThreadInvocationListener mtil) {
        logger.finer("(Index<Domain, DataPowerFileInfo>, ManagementCommandSubscriber[], MultiThreadInvocationListener):  Starting");
        for (Domain domain : domainDeleteIndex.getKeys()) {
            Collection<DataPowerFileInfo> filesToDelete = domainDeleteIndex.get(domain);
            for (DataPowerFileInfo fileToDelete : filesToDelete) {
                logger.config(() -> LMG.log("(Index<Domain, DataPowerFileInfo>, ManagementCommandSubscriber[], MultiThreadInvocationListener):  Deleting file %s->%s->%s", () -> fileToDelete.getAppliance().getName(), () -> fileToDelete.getSourceDomain(), () -> fileToDelete.getAbsolutePath()));
                ActionDeleteFile actionDeleteFile = new ActionDeleteFile();
                actionDeleteFile.setFile(fileToDelete.getName());
                SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
                Appliance appliance = fileToDelete.getAppliance();
                ActionTool fileDeleter = new ActionTool(appliance, domain, actionDeleteFile);
                fileDeleter.setCommandDescription(String.format("Delete file %s in %s domain of %s", fileToDelete.getAbsolutePath(), domain.getName(), appliance.getName()));
                mtil.addThread(fileDeleter.getProcessThread());
                fileDeleter.getProcessThread().addInvocationListener(stil);
                fileDeleter.addAdditionalCommandInfo("file", fileToDelete);
                ManagementCommandSubscriber[] managementCommandSubscriberArray = subscribers;
                int n = subscribers.length;
                int n2 = 0;
                while (n2 < n) {
                    ManagementCommandSubscriber subscriber = managementCommandSubscriberArray[n2];
                    fileDeleter.addManagementCommandSubscriber(subscriber);
                    ++n2;
                }
                stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
            }
        }
        logger.finer("(Index<Domain, DataPowerFileInfo>, ManagementCommandSubscriber[], MultiThreadInvocationListener):  Done");
    }

    public static ActionTool flushAAACache(Appliance appliance, Domain domain, String aaaPolicy, ManagementCommandSubscriber ... subscribers) {
        logger.finer(() -> LMG.log("Appliance=%s, Domain=%s, aaaPolicy=%s, ManagementCommandSubscriber...subscribers): Starting", () -> appliance.getName(), () -> domain.getName(), () -> aaaPolicy));
        ActionFlushAAACache flushAAACache = new ActionFlushAAACache();
        ObjectReference<ConfigAAAPolicy> or = new ObjectReference<ConfigAAAPolicy>();
        or.setClassName("AAAPolicy");
        or.setName(aaaPolicy);
        flushAAACache.setPolicyName(or);
        ActionTool actionTool = new ActionTool(appliance, domain, flushAAACache);
        ActionController.addActionSubscribers(actionTool, subscribers);
        return actionTool;
    }

    public static ActionTool quiesceAppliance(Appliance appliance, int timeout, int delay, ManagementCommandSubscriber ... subscribers) {
        logger.finer(() -> LMG.log("(Appliance=%s, timeout=%d, delay=%d, ManagementCommandSubscriber...subscribers): Starting", () -> appliance.getName(), () -> timeout, () -> delay));
        ActionQuiesceDP quiesceDP = new ActionQuiesceDP();
        quiesceDP.setTimeout(timeout);
        quiesceDP.setDelay(delay);
        logger.config(() -> LMG.log("(Appliance=%s, timeout=%d, delay=%d, ManagementCommandSubscriber...subscribers): Quiescing", () -> appliance.getName(), () -> timeout, () -> delay));
        ActionTool actionTool = new ActionTool(appliance, (JMBean)quiesceDP);
        actionTool.setConnectionTimeout(120000);
        actionTool.setReadTimeout(120000);
        ActionController.addActionSubscribers(actionTool, subscribers);
        logger.finer(() -> LMG.log("(Appliance=%s, timeout=%d, delay=%d, ManagementCommandSubscriber...subscribers): Done", () -> appliance.getName(), () -> timeout, () -> delay));
        return actionTool;
    }

    public static ActionTool quiesceDomain(Appliance appliance, Domain domain, int timeout, int delay, ManagementCommandSubscriber ... subscribers) {
        logger.finer(() -> LMG.log("(Appliance=%s, Domain=%s, timeout=%d, delay=%d, ManagementCommandSubscriber...subscribers): Starting", () -> appliance.getName(), () -> domain.getName(), () -> timeout, () -> delay));
        if (domain.getName().equals("default")) {
            logger.info(() -> LMG.log("(Appliance=%s, Domain=%s, timeout=%d, delay=%d, ManagementCommandSubscriber...subscribers): Skipping default domain", () -> appliance.getName(), () -> domain.getName(), () -> timeout, () -> delay));
            return null;
        }
        ActionDomainQuiesce quiesceObject = new ActionDomainQuiesce();
        quiesceObject.setName(domain.getName());
        quiesceObject.setTimeout(timeout);
        quiesceObject.setDelay(delay);
        logger.config(() -> LMG.log("(Appliance=%s, Domain=%s, timeout=%d, delay=%d, ManagementCommandSubscriber...subscribers): Quiescing", () -> appliance.getName(), () -> domain.getName(), () -> timeout, () -> delay));
        ActionTool actionTool = new ActionTool(appliance, domain, quiesceObject);
        actionTool.setConnectionTimeout(120000);
        actionTool.setReadTimeout(120000);
        ActionController.addActionSubscribers(actionTool, subscribers);
        logger.finer(() -> LMG.log("(Appliance=%s, Domain=%s, timeout=%d, delay=%d, ManagementCommandSubscriber...subscribers): Done", () -> appliance.getName(), () -> domain.getName(), () -> timeout, () -> delay));
        return actionTool;
    }

    public static ActionTool shutdownAppliance(Appliance appliance, String shutdownMode, int delay, ManagementCommandSubscriber ... subscribers) {
        logger.finer(() -> LMG.log("(Appliance=%s, shutdownMode=%s, delay=%d, ManagementCommandSubscriber...subscribers): Starting", () -> appliance.getName(), () -> shutdownMode, () -> delay));
        String shutdownDescription = switch (shutdownMode) {
            case "reboot" -> "Reboot Appliance";
            case "reload" -> "Reload Firmware";
            case "halt" -> "Halt Appliance";
            case "poweroff" -> "Power Off Appliance";
            default -> "SHOULD NOT HAPPEN : FIX IT";
        };
        ActionShutdown action = new ActionShutdown();
        action.setMode(shutdownMode);
        action.setDelay(delay);
        logger.config(() -> LMG.log("(Appliance=%s, shutdownMode=%s, delay=%d, ManagementCommandSubscriber...subscribers)", () -> appliance.getName(), () -> shutdownMode, () -> delay));
        ActionTool actionTool = new ActionTool(appliance, (JMBean)action);
        actionTool.setCommandDescription(shutdownDescription);
        actionTool.setConnectionTimeout(120000);
        actionTool.setReadTimeout(120000);
        ActionController.addActionSubscribers(actionTool, subscribers);
        logger.finer(() -> LMG.log("(Appliance=%s, shutdownMode=%s, delay=%d, ManagementCommandSubscriber...subscribers): Done", () -> appliance.getName(), () -> shutdownMode, () -> delay));
        return actionTool;
    }

    public static ActionTool unquiesceAppliance(Appliance appliance, ManagementCommandSubscriber ... subscribers) {
        logger.finer(() -> LMG.log("(Appliance=%s, ManagementCommandSubscriber...subscribers): Starting", () -> appliance.getName()));
        ActionUnquiesceDP action = new ActionUnquiesceDP();
        logger.config(() -> LMG.log("(Appliance=%s, ManagementCommandSubscriber...subscribers): UnQuiescing", () -> appliance.getName()));
        ActionTool actionTool = new ActionTool(appliance, (JMBean)action);
        actionTool.setConnectionTimeout(120000);
        actionTool.setReadTimeout(120000);
        ActionController.addActionSubscribers(actionTool, subscribers);
        logger.finer(() -> LMG.log("(Appliance=%s, ManagementCommandSubscriber...subscribers): Done", () -> appliance.getName()));
        return actionTool;
    }

    public static ActionTool unquiesceDomain(Appliance appliance, Domain domain, ManagementCommandSubscriber ... subscribers) {
        logger.finer(() -> LMG.log("(Appliance=%s, Domain=%s, ManagementCommandSubscriber...subscribers): Starting", () -> appliance.getName(), () -> domain.getName()));
        if (domain.getName().equals("default")) {
            logger.info(() -> LMG.log("(Appliance=%s, Domain=%s, ManagementCommandSubscriber...subscribers): Skipping default domain", () -> appliance.getName(), () -> domain.getName()));
            return null;
        }
        ActionDomainUnquiesce domainUnquiesceObject = new ActionDomainUnquiesce();
        domainUnquiesceObject.setName(domain.getName());
        logger.config(() -> LMG.log("(Appliance=%s, Domain=%s, ManagementCommandSubscriber...subscribers): Unquiescing", () -> appliance.getName(), () -> domain.getName()));
        ActionTool actionTool = new ActionTool(appliance, domain, domainUnquiesceObject);
        ActionController.addActionSubscribers(actionTool, subscribers);
        logger.finer(() -> LMG.log("(Appliance=%s, Domain=%s, ManagementCommandSubscriber...subscribers): Done", () -> appliance.getName(), () -> domain.getName()));
        return actionTool;
    }

    public static ActionTool resetDomain(Appliance appliance, Domain domain, ManagementCommandSubscriber ... subscribers) {
        logger.finer(() -> LMG.log("(Appliance=%s, Domain=%s, ManagementCommandSubscriber...subscribers): Starting", () -> appliance.getName(), () -> domain.getName()));
        if (domain.getName().equals("default")) {
            logger.info(() -> LMG.log("(Appliance=%s, Domain=%s, ManagementCommandSubscriber...subscribers): Skipping default domain", () -> appliance.getName(), () -> domain.getName()));
            return null;
        }
        ActionResetDomain actionResetDomain = new ActionResetDomain();
        ObjectReference<ConfigDomain> objectRef = new ObjectReference<ConfigDomain>();
        objectRef.setClassName("Domain");
        objectRef.setName(domain.getName());
        actionResetDomain.setDomain(objectRef);
        logger.config(() -> LMG.log("(Appliance=%s, Domain=%s, ManagementCommandSubscriber...subscribers): Resetting", () -> appliance.getName(), () -> domain.getName()));
        ActionTool actionTool = new ActionTool(appliance, domain, actionResetDomain);
        actionTool.setRetryOnSocketTimeout(false);
        ActionController.addActionSubscribers(actionTool, subscribers);
        logger.finer(() -> LMG.log("(Appliance=%s, Domain=%s, ManagementCommandSubscriber...subscribers): Done", () -> appliance.getName(), () -> domain.getName()));
        return actionTool;
    }

    public static ActionTool restartDomain(Appliance appliance, Domain domain, ManagementCommandSubscriber ... subscribers) {
        logger.finer(() -> LMG.log("(Appliance=%s, Domain=%s, ManagementCommandSubscriber...subscribers): Starting", () -> appliance.getName(), () -> domain.getName()));
        if (domain.getName().equals("default")) {
            logger.info(() -> LMG.log("(Appliance=%s, Domain=%s, ManagementCommandSubscriber...subscribers): Skipping default domain", () -> appliance.getName(), () -> domain.getName()));
            return null;
        }
        ActionRestartDomain actionRestartDomain = new ActionRestartDomain();
        ObjectReference<ConfigDomain> orRestart = new ObjectReference<ConfigDomain>();
        orRestart.setClassName("Domain");
        orRestart.setName(domain.getName());
        actionRestartDomain.setDomain(orRestart);
        logger.config(() -> LMG.log("(Appliance=%s, Domain=%s, ManagementCommandSubscriber...subscribers): Restarting", () -> appliance.getName(), () -> domain.getName()));
        ActionTool actionTool = new ActionTool(appliance, domain, actionRestartDomain);
        actionTool.setConnectionTimeout(120000);
        actionTool.setReadTimeout(120000);
        actionTool.setRetryOnSocketTimeout(false);
        ActionController.addActionSubscribers(actionTool, subscribers);
        logger.finer(() -> LMG.log("(Appliance=%s, Domain=%s, ManagementCommandSubscriber...subscribers): Done", () -> appliance.getName(), () -> domain.getName()));
        return actionTool;
    }

    public static ActionTool deleteCheckpoint(Appliance appliance, Domain domain, String checkpointName, ManagementCommandSubscriber ... subscribers) {
        logger.finer(() -> LMG.log("(Appliance=%s, Domain=%s, checkpointName=%s, ManagementCommandSubscriber...subscribers): Starting", () -> appliance.getName(), () -> domain.getName(), () -> checkpointName));
        ActionRemoveCheckpoint action = new ActionRemoveCheckpoint();
        action.setChkName(checkpointName);
        logger.config(() -> LMG.log("(Appliance=%s, Domain=%s, checkpointName=%s, ManagementCommandSubscriber...subscribers): Deleting Checkpoint", () -> appliance.getName(), () -> domain.getName(), () -> checkpointName));
        ActionTool actionTool = new ActionTool(appliance, domain, action);
        ActionController.addActionSubscribers(actionTool, subscribers);
        logger.finer(() -> LMG.log("(Appliance=%s, Domain=%s, checkpointName=%s, ManagementCommandSubscriber...subscribers): Done", () -> appliance.getName(), () -> domain.getName(), () -> checkpointName));
        return actionTool;
    }

    public static ActionTool restoreCheckpoint(Appliance appliance, Domain domain, String checkpointName, ManagementCommandSubscriber ... subscribers) {
        logger.finer(() -> LMG.log("(Appliance=%s, Domain=%s, checkpointName=%s, ManagementCommandSubscriber...subscribers): Starting", () -> appliance.getName(), () -> domain.getName(), () -> checkpointName));
        ActionRollbackCheckpoint asp = new ActionRollbackCheckpoint();
        asp.setChkName(checkpointName);
        logger.config(() -> LMG.log("(Appliance=%s, Domain=%s, checkpointName=%s, ManagementCommandSubscriber...subscribers): Restoring Checkpoint", () -> appliance.getName(), () -> domain.getName(), () -> checkpointName));
        ActionTool actionTool = new ActionTool(appliance, domain, asp);
        ActionController.addActionSubscribers(actionTool, subscribers);
        logger.finer(() -> LMG.log("(Appliance=%s, Domain=%s, checkpointName=%s, ManagementCommandSubscriber...subscribers): Done", () -> appliance.getName(), () -> domain.getName(), () -> checkpointName));
        return actionTool;
    }

    public static ActionTool saveCheckpoint(Appliance appliance, Domain domain, String checkpointName, ManagementCommandSubscriber ... subscribers) {
        logger.finer(() -> LMG.log("(Appliance=%s, Domain=%s, checkpointName=%s, ManagementCommandSubscriber...subscribers): Starting", () -> appliance.getName(), () -> domain.getName(), () -> checkpointName));
        ActionSaveCheckpoint asp = new ActionSaveCheckpoint();
        asp.setChkName(checkpointName);
        logger.config(() -> LMG.log("(Appliance=%s, Domain=%s, checkpointName=%s, ManagementCommandSubscriber...subscribers): Saving Checkpoint", () -> appliance.getName(), () -> domain.getName(), () -> checkpointName));
        ActionTool actionTool = new ActionTool(appliance, domain, asp);
        ActionController.addActionSubscribers(actionTool, subscribers);
        logger.finer(() -> LMG.log("(Appliance=%s, Domain=%s, checkpointName=%s, ManagementCommandSubscriber...subscribers): Done", () -> appliance.getName(), () -> domain.getName(), () -> checkpointName));
        return actionTool;
    }

    private static void addActionSubscribers(ActionTool action, ManagementCommandSubscriber[] subscribers) {
        if (action == null) {
            logger.severe("(ActionTool, ManagementCommandSubscriber[]): Action is null.  Returning.");
            return;
        }
        if (ArrayUtility.isEmpty(subscribers)) {
            logger.info("(ActionTool, ManagementCommandSubscriber[]): No subscribers provided.  Nothing to add.");
            return;
        }
        ManagementCommandSubscriber[] managementCommandSubscriberArray = subscribers;
        int n = subscribers.length;
        int n2 = 0;
        while (n2 < n) {
            ManagementCommandSubscriber subscriber = managementCommandSubscriberArray[n2];
            action.addManagementCommandSubscriber(subscriber);
            ++n2;
        }
    }
}

