/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.DataPowerXMLClassInfo;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.util.DataPowerXMLMgmtProcessor;
import com.kumbasoft.core.util.FileUtility;
import java.io.File;
import java.util.HashMap;
import java.util.function.Supplier;

public class CreatePropertyMapForFirmwareVersion
extends AbstractTool {
    private String firmwareVersion;
    private File xmlMgmtDirectory;
    private File xmlMgmtWSDLFile;
    private File baseOutputDirectory;
    private AsynchMethodInvoker<Void> processThread;
    private static final boolean COMPRESS = true;

    public CreatePropertyMapForFirmwareVersion(String firmwareVersion, File xmlMgmtDirectory, File baseOutputDirectory) {
        if (StringUtility.isEmpty(firmwareVersion)) {
            throw new IllegalArgumentException("CreatePropertyMapForFirmwareVersion(String firmwareVersion, File xmlMgmtDirectory, File baseOutputDirectory):  firmwareVersion cannot be null or empty.");
        }
        if (!xmlMgmtDirectory.exists() || !xmlMgmtDirectory.isDirectory()) {
            throw new IllegalArgumentException("CreatePropertyMapForFirmwareVersion(String firmwareVersion, File xmlMgmtDirectory, File baseOutputDirectory):  xmlMgmtDirectory must exist and be a directory.");
        }
        this.xmlMgmtWSDLFile = new File(xmlMgmtDirectory, "xml-mgmt.wsdl");
        if (!this.xmlMgmtWSDLFile.exists()) {
            throw new IllegalArgumentException("CreatePropertyMapForFirmwareVersion(String firmwareVersion, File xmlMgmtDirectory, File baseOutputDirectory):  xmlMgmtDirectory (" + xmlMgmtDirectory.getAbsolutePath() + ") must contain the xml-mgmt files.");
        }
        if (!baseOutputDirectory.exists()) {
            baseOutputDirectory.mkdirs();
        }
        this.firmwareVersion = firmwareVersion;
        this.xmlMgmtDirectory = xmlMgmtDirectory;
        this.baseOutputDirectory = baseOutputDirectory;
        this.processThread = new AsynchMethodInvoker((Object)this, "createFirmwarePropertyMap", KumbaCoreConstants.THREAD_WAIT);
    }

    public AsynchMethodInvoker<Void> getProcessThread() {
        return this.processThread;
    }

    @Reflected
    private void createFirmwarePropertyMap() {
        Object[] files;
        logger.finer(() -> LMG.log("(): Starting", new Supplier[0]));
        File firmwareOutputDirectory = new File(this.baseOutputDirectory, this.firmwareVersion);
        if (firmwareOutputDirectory.exists() && !ArrayUtility.isEmpty(files = firmwareOutputDirectory.listFiles())) {
            return;
        }
        firmwareOutputDirectory.mkdir();
        DataPowerXMLMgmtProcessor processor = new DataPowerXMLMgmtProcessor(this.xmlMgmtWSDLFile);
        HashMap<String, DataPowerXMLClassInfo> dataPowerClasses = processor.getClassIndex();
        for (String dataPowerClassName : dataPowerClasses.keySet()) {
            String dataPowerClassMapFileName = String.format("%s.xgn", dataPowerClassName);
            File dataPowerClassMapFile = new File(firmwareOutputDirectory, dataPowerClassMapFileName);
            DataPowerXMLClassInfo dataPowerClassInfo = dataPowerClasses.get(dataPowerClassName);
            logger.finer(() -> LMG.log("(): Writing map to %s", () -> dataPowerClassMapFile.getAbsolutePath()));
            FileUtility.writeObject(dataPowerClassMapFile, (Object)dataPowerClassInfo, true);
        }
        logger.finer(() -> LMG.log("(): Done", new Supplier[0]));
    }
}

