/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.j2ee.xml.XMLElement;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigObjectSubscriber;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.tools.AbstractFileManagementRequest;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.DataPowerXMLManagement;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.util.DataStructureUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.codec.binary.Base64;

public class DataPowerFileReader
extends AbstractFileManagementRequest {
    private boolean abortReading;

    public static ArrayList<DataPowerFileReader> readFiles(ArrayList<DataPowerFileInfo> dataPowerFiles, MultiThreadInvocationListener invocationListener, ConfigObjectSubscriber<DataPowerFileInfo> subscriber) {
        logger.finer("(...);  Starting");
        HashMap<Appliance, Index<Domain, DataPowerFileInfo>> filesByApplianceDomain = DataStructureUtility.mapByApplianceDomain(dataPowerFiles);
        Index<Appliance, DataPowerFileInfo> filesByAppliance = new Index<Appliance, DataPowerFileInfo>();
        for (Appliance appliance : filesByApplianceDomain.keySet()) {
            Index<Domain, DataPowerFileInfo> filesByDomain = filesByApplianceDomain.get(appliance);
            for (Domain domain : filesByDomain.getKeys()) {
                Collection<DataPowerFileInfo> files = filesByDomain.get(domain);
                for (DataPowerFileInfo file : files) {
                    filesByAppliance.put(appliance, file);
                }
            }
        }
        Runtime runTime = Runtime.getRuntime();
        long freeMemory = runTime.freeMemory();
        long maxAggregateSize = freeMemory / 50L;
        logger.finer(() -> LMG.log("(...): Free memory %d, Max Aggregate: %d.", () -> freeMemory, () -> maxAggregateSize));
        ArrayList<DataPowerFileReader> instances = new ArrayList<DataPowerFileReader>();
        for (Appliance appliance : filesByAppliance.getKeys()) {
            ArrayList filesByApplianceAggregated = (ArrayList)filesByAppliance.get(appliance);
            logger.finer(() -> LMG.log("(...): Processing %d files for appliance '%s'", () -> filesByApplianceAggregated.size(), () -> appliance.getName()));
            long aggregateSize = 0L;
            ArrayList<DataPowerFileInfo> groupToProcess = new ArrayList<DataPowerFileInfo>();
            int numberOfFiles = filesByApplianceAggregated.size();
            while (numberOfFiles-- > 0) {
                DataPowerFileInfo file = (DataPowerFileInfo)filesByApplianceAggregated.remove(numberOfFiles);
                groupToProcess.add(file);
                long fileSize = file.getFileSize();
                if ((aggregateSize += fileSize) < maxAggregateSize) continue;
                long totalAggregate = aggregateSize;
                logger.finer(() -> LMG.log("(...): Processing %d files for appliance '%s' due to aggregated size being %d", () -> groupToProcess.size(), () -> appliance.getName(), () -> totalAggregate));
                SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
                DataPowerFileReader reader = new DataPowerFileReader(groupToProcess);
                reader.addConfigObjectSubscriber(DataPowerFileInfo.class, subscriber);
                invocationListener.addThread(reader.getProcessThread());
                reader.getProcessThread().addInvocationListener(stil);
                instances.add(reader);
                boolean completedOnTime = stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
                if (completedOnTime) {
                    logger.finer(() -> LMG.log("(...): Processed the aggregate group for '%s'", () -> appliance.getName()));
                } else {
                    logger.info(() -> LMG.log("(...): Timed out processing the aggregate group for '%s'", () -> appliance.getName()));
                }
                aggregateSize = 0L;
                groupToProcess.clear();
            }
            int runningThreads = invocationListener.getRunningThreadCount();
            if (runningThreads > 0) {
                logger.finer(() -> LMG.log("(...): There are %d running threads for '%s'.  Should this be?", () -> runningThreads, () -> appliance.getName()));
            }
            logger.finer(() -> LMG.log("(...): There are %d remaining in the large files group plus another %d in the aggregated group for '%s'", () -> filesByApplianceAggregated.size(), () -> groupToProcess.size(), () -> appliance.getName()));
            if (numberOfFiles <= 0 && groupToProcess.size() <= 0) continue;
            if (groupToProcess.size() > 0) {
                filesByApplianceAggregated.addAll(groupToProcess);
            }
            logger.finer(() -> LMG.log("(...): Processing remaining %d files for appliance '%s'", () -> filesByApplianceAggregated.size(), () -> appliance.getName()));
            DataPowerFileReader reader = new DataPowerFileReader(filesByApplianceAggregated);
            reader.addConfigObjectSubscriber(DataPowerFileInfo.class, subscriber);
            invocationListener.addThread(reader.getProcessThread());
            instances.add(reader);
            aggregateSize = 0L;
        }
        logger.finer(() -> LMG.log("(...): Done, returning %d thread instances with %d threads running.", () -> instances.size(), () -> invocationListener.getRunningThreadCount()));
        return instances;
    }

    public DataPowerFileReader(ArrayList<DataPowerFileInfo> dataPowerFiles) {
        super(dataPowerFiles);
        this.processThread = ThreadManager.getThread(this.appliance, this, "processCommand", KumbaCoreConstants.STARTUP_DELAY, new Object[0]);
    }

    public DataPowerFileReader(DataPowerFileInfo dataPowerFileInfo) {
        this(dataPowerFileInfo, false);
    }

    public DataPowerFileReader(DataPowerFileInfo dataPowerFileInfo, boolean forceRead) {
        super(dataPowerFileInfo, String.format("Read file %s", dataPowerFileInfo.getName()));
        String loggerPrefix = String.format("(DataPowerFileInfo dataPowerFiles='%s', boolean forceRead=%b)", dataPowerFileInfo.getAbsolutePath(), forceRead);
        String dataPowerFile = dataPowerFileInfo.getName();
        String dataPowerFileF = dataPowerFile = StringUtility.coalesce(dataPowerFile, "/");
        AbstractTool.logger.finer(() -> LMG.log("%s: Reading file '%s'", () -> loggerPrefix, () -> dataPowerFileF));
    }

    public boolean isAbortReading() {
        return this.abortReading;
    }

    public void setAbortReading(boolean abortReading) {
        this.abortReading = abortReading;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean processResultDocument(XMLElement rootElement) {
        AbstractTool.logger.finer("(XMLElement rootElement):  Starting");
        if (this.abortReading) {
            AbstractTool.logger.info("(XMLElement rootElement):  Process is aborting.  Returning now.");
            return true;
        }
        try {
            if (rootElement == null) {
                this.setErrorCode(28);
                AbstractTool.logger.severe("(XMLElement rootElement): Result is null reading files.");
                this.notifyConfigObjectSubscribers();
                return false;
            }
            Collection<XMLElement> responseElements = rootElement.getNodes("//dp:response");
            AbstractTool.logger.finer(() -> LMG.log("(XMLElement rootElement): Processing %d response elements of %d requested files.", () -> responseElements.size(), () -> this.dataPowerFiles.size()));
            int responseElementIndex = 0;
            for (XMLElement responseElement : responseElements) {
                if (this.abortReading) {
                    AbstractTool.logger.info("(XMLElement rootElement):  Process is aborting.  Returning now.");
                    return true;
                }
                int fIndex = responseElementIndex;
                if (responseElementIndex >= this.dataPowerFiles.size()) {
                    AbstractTool.logger.info(() -> LMG.log("(XMLElement rootElement): Response element %d of %d requested files exceeds files expected.  Skipping the rest.", () -> fIndex, () -> this.dataPowerFiles.size()));
                    break;
                }
                AbstractTool.logger.finer(() -> LMG.log("(XMLElement rootElement): Processing response element %d of %d requested files.", () -> fIndex, () -> this.dataPowerFiles.size()));
                DataPowerFileInfo dataPowerFile = (DataPowerFileInfo)this.dataPowerFiles.get(responseElementIndex);
                ++responseElementIndex;
                XMLElement resultElement = responseElement.getNode("dp:result");
                if (resultElement != null) {
                    AbstractTool.logger.finer(() -> LMG.log("(XMLElement rootElement): Response element %d is a dp:result.", () -> fIndex));
                    String resultText = resultElement.getValue();
                    dataPowerFile.setFileContent(resultText);
                    if (resultText.contains("Authentication failure")) {
                        this.setErrorCode(10);
                        AbstractTool.logger.severe(() -> LMG.log("(XMLElement rootElement): Authentication Failure reading file '%s'.", () -> this.getFQFN(dataPowerFile)));
                        this.notifyConfigObjectSubscribers(dataPowerFile);
                        continue;
                    }
                    if (resultText.contains("Cannot read the specified file")) {
                        this.setErrorCode(28);
                        AbstractTool.logger.severe(() -> LMG.log("(XMLElement rootElement): Error reading file '%s'.", () -> this.getFQFN(dataPowerFile)));
                        this.notifyConfigObjectSubscribers(dataPowerFile);
                        continue;
                    }
                    AbstractTool.logger.severe(() -> LMG.log("(XMLElement rootElement): Unknown error '%s' reading file '%s'.", () -> resultText, () -> this.getFQFN(dataPowerFile)));
                    this.notifyConfigObjectSubscribers(dataPowerFile);
                    continue;
                }
                AbstractTool.logger.finer(() -> LMG.log("(XMLElement rootElement): Response element %d is a dp:file.", () -> fIndex));
                XMLElement fileElement = responseElement.getNode("dp:file");
                String fileName = fileElement.getAttributeValue("name");
                if (!fileName.equals(this.getFQFN(dataPowerFile))) {
                    AbstractTool.logger.severe(() -> LMG.log("(XMLElement rootElement): Result file name '%s' doesn't match the requested file name '%s'.", () -> fileName, () -> this.getFQFN(dataPowerFile)));
                    this.notifyConfigObjectSubscribers(dataPowerFile);
                    continue;
                }
                long fileSize = dataPowerFile.getFileSize();
                String base64Content = fileElement.getValue();
                byte[] fileBytes = null;
                if (StringUtility.isNotEmpty(base64Content)) {
                    fileBytes = Base64.decodeBase64(base64Content);
                    if (fileSize > 0L && ArrayUtility.isEmpty(fileBytes)) {
                        AbstractTool.logger.severe(() -> LMG.log("(XMLElement rootElement): Error reading content of dp:file element for %s.  Invalid base64 encoding.", () -> fileName));
                        dataPowerFile.setFileContent("File is empty.");
                        this.notifyConfigObjectSubscribers(dataPowerFile);
                        continue;
                    }
                } else {
                    fileBytes = new byte[]{};
                    AbstractTool.logger.info(() -> LMG.log("(XMLElement rootElement): Base64 content is empty in dp:file element for %s.  File size on box is %d.", () -> fileName, () -> fileSize));
                }
                DataPowerFileInfo dpFileInfo = (DataPowerFileInfo)dataPowerFile.clone();
                dpFileInfo.setFileData(fileBytes);
                AbstractTool.logger.fine("(XMLElement rootElement): Notifying config object subscribers.");
                this.notifyConfigObjectSubscribers(dpFileInfo);
            }
        }
        catch (Exception e) {
            AbstractTool.logger.warning(() -> LMG.log("(XMLElement rootElement): Caught exception %s processing files:  %s", () -> e.getClass().getSimpleName(), () -> e.getMessage()));
            this.setErrorCode(28);
            e.printStackTrace();
        }
        AbstractTool.logger.finer("(XMLElement rootElement): Done.");
        return true;
    }

    @Override
    protected String getRequestMessage() {
        String somaTemplate = this.getSOMATemplate();
        String requestStanza = DataPowerXMLManagement.getRequestStanza(somaTemplate);
        String requestXML = somaTemplate.replace(requestStanza, "${requestStanzas}");
        StringBuilder stanzas = new StringBuilder();
        for (DataPowerFileInfo file : this.dataPowerFiles) {
            String fileStanza = requestStanza.replace("${domain.name}", "default");
            String FQFN = this.getFQFN(file);
            fileStanza = fileStanza.replace("${dataPowerFileInfo.name}", FQFN);
            stanzas.append(fileStanza);
            stanzas.append("\n");
        }
        requestXML = requestXML.replace("${requestStanzas}", stanzas.toString());
        return requestXML;
    }

    @Override
    protected String getSOMATemplateFileName() {
        return "GetFileRequest.xml";
    }
}

