/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.config.ConfigIPInterface;
import com.kumbasoft.core.tools.AbstractIPManager;
import java.util.ArrayList;

public class DeleteIP
extends AbstractIPManager {
    public DeleteIP(Appliance appliance, ConfigIPInterface ipInterface, ArrayList<String> ipsToDelete) {
        super(appliance, ipInterface, ipsToDelete);
    }

    @Override
    protected String getCommandDescription() {
        return String.format("Delete ips from %s of %s", this.ipInterface.getName(), this.appliance.getName());
    }

    @Override
    protected void configureInterface() {
        for (String ipToDelete : this.ipsToManage) {
            ArrayList<String> secondaryVirtuals;
            String ipAddress = this.ipInterface.getIPAddress();
            String virtualIP = this.ipInterface.getVirtualIP();
            if (StringUtility.isNotEmpty(ipAddress) && ipAddress.startsWith(ipToDelete)) {
                this.ipInterface.setIPAddress("");
                continue;
            }
            if (StringUtility.isNotEmpty(virtualIP) && virtualIP.equals(ipToDelete)) {
                this.ipInterface.setVirtualIP("");
                continue;
            }
            ArrayList<String> secondaryIPs = this.ipInterface.getSecondaryAddress();
            if (CollectionUtility.containsElementStartingWith(secondaryIPs, ipToDelete)) {
                CollectionUtility.removeElementsStartingWith(secondaryIPs, ipToDelete);
            }
            if (!CollectionUtility.containsElementStartingWith(secondaryVirtuals = this.ipInterface.getSecondaryVirtualIP(), ipToDelete)) continue;
            CollectionUtility.removeElementsStartingWith(secondaryVirtuals, ipToDelete);
        }
        this.modifyInterface();
    }
}

