/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.io.FileHierarchy;
import com.jmorgan.lang.Application;
import com.jmorgan.util.Date;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.Pair;
import com.jmorgan.util.Time;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreApplicationProperties;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.CopyMoveFilesBean;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ManagementCommandStatus;
import com.kumbasoft.core.tools.AbstractCommandProcessFileTool;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.DataPowerFileExporter;
import com.kumbasoft.core.tools.DirectoryDeleter;
import com.kumbasoft.core.tools.LocalFileSystemImporter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class DirectoryCopyMove
extends AbstractCommandProcessFileTool {
    private CopyMoveFilesBean copyMoveFilesBean;

    public DirectoryCopyMove(CopyMoveFilesBean copyMoveFilesBean) {
        this.copyMoveFilesBean = copyMoveFilesBean;
    }

    @Override
    public void performProcess() {
        AbstractTool.logger.finer("(): Starting");
        String tempDirectory = ((KumbaCoreApplicationProperties)Application.getApplication().getApplicationProperties()).getTemporaryDirectory();
        DateTime now = new DateTime();
        now.getDate().setFormat(Date.SQL_FORMAT);
        now.getTime().setFormat(Time.FILENAME_FRIENDLY_FORMAT);
        String outputLocation = String.format("%s/dex/%s", tempDirectory, now.toString());
        File outputDirectory = new File(outputLocation);
        AbstractTool.logger.fine(() -> LMG.log("() : Creating output directory for files:  %s", () -> outputDirectory.getAbsolutePath()));
        outputDirectory.mkdirs();
        ArrayList<Appliance> destinationAppliances = new ArrayList<Appliance>();
        AbstractTool.logger.finer("(): Starting Copy.");
        ArrayList<Pair<DataPowerFileInfo, DataPowerFileInfo>> destinationInfoList = this.copyMoveFilesBean.getDestinationNames();
        for (Pair<DataPowerFileInfo, DataPowerFileInfo> destinationInfo : destinationInfoList) {
            DataPowerFileInfo source = (DataPowerFileInfo)destinationInfo.first;
            DataPowerFileInfo destination = (DataPowerFileInfo)destinationInfo.second;
            Appliance sourceAppliance = source.getAppliance();
            Domain sourceDomain = source.getSourceDomain();
            Appliance destinationAppliance = destination.getAppliance();
            Domain destinationDomain = destination.getSourceDomain();
            AbstractTool.logger.finer("(): Exporting files.");
            new DataPowerFileExporter(sourceAppliance, sourceDomain, source, outputDirectory);
            AbstractTool.logger.finer(() -> LMG.log("(): Completed export of %s", () -> source.getAbsolutePath()));
            String sourceApplianceName = sourceAppliance.getName();
            String sourceDomainName = sourceDomain.getName();
            String sourceDirectory = source.getBaseDirectory();
            sourceDirectory = sourceDirectory.replaceAll(":", "");
            String inputDirectory = String.format("%s/%s/%s/FileSystem/%s", outputDirectory.getAbsolutePath(), sourceApplianceName, sourceDomainName, sourceDirectory);
            AbstractTool.logger.finer(() -> LMG.log("Starting File System Import from: %s", () -> inputDirectory));
            destinationAppliances.add(destinationAppliance);
            LocalFileSystemImporter fsImporter = new LocalFileSystemImporter(destinationAppliance, destinationDomain, inputDirectory, destination);
            fsImporter.addManagementCommandSubscriber(this.managementCommandSubscribers);
            fsImporter.uploadFiles();
            int mode = this.copyMoveFilesBean.getMode();
            String prefix = mode == 0 ? "Copy" : "Move";
            String resultMessage = String.format("%s '%s' from the %s domain of %s to '%s' of the %s domain of %s complete.", prefix, sourceDirectory, sourceDomain.getName(), sourceAppliance.getName(), destination.getBaseDirectory(), destinationDomain.getName(), destinationAppliance.getName());
            ManagementCommandStatus copyStatus = new ManagementCommandStatus(sourceAppliance, sourceDomain, sourceDirectory, null, resultMessage);
            this.notifyManagementCommandSubscribers(copyStatus);
            AbstractTool.logger.finer(() -> LMG.log("(): Completed File System Import from: %s", () -> inputDirectory));
        }
        AbstractTool.logger.finer("(): Finished Imports.");
        if (this.copyMoveFilesBean.getMode() == 1) {
            AbstractTool.logger.config("(): Deleting Source Directories");
            ArrayList<DataPowerFileInfo> selectedDirectories = this.copyMoveFilesBean.getObjects();
            DirectoryDeleter directoryDeleter = new DirectoryDeleter(selectedDirectories);
            directoryDeleter.addManagementCommandSubscriber(this.managementCommandSubscribers);
        }
        AbstractTool.logger.finer("(): Starting delete of temporary files");
        FileHierarchy fileHierarchy = new FileHierarchy(outputDirectory.getParentFile().getAbsolutePath());
        HashMap<File, Boolean> deletedFiles = fileHierarchy.delete();
        for (File file : deletedFiles.keySet()) {
            boolean deleted = deletedFiles.get(file);
            if (deleted) continue;
            AbstractTool.logger.severe(() -> LMG.log("Temp file %s was not property deleted\n", () -> file.getAbsoluteFile()));
        }
        AbstractTool.logger.finer("(): Done");
    }
}

