/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.io.ASCFileWriter;
import com.jmorgan.j2ee.xml.XMLElement;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigObjectSubscriber;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.tools.AbstractListFiles;
import com.kumbasoft.core.tools.ThreadManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;

public class DirectoryLister
extends AbstractListFiles {
    private static ArrayList<DirectoryLister> instances;

    public static ArrayList<DirectoryLister> list(Index<Appliance, Domain> searchDomains, ArrayList<String> fileStores, MultiThreadInvocationListener mtil) {
        instances = CollectionUtility.createOrClear(instances);
        for (Appliance appliance : searchDomains.getKeys()) {
            ArrayList domains = (ArrayList)searchDomains.get(appliance);
            DirectoryLister directoryLister = new DirectoryLister(appliance, (ArrayList<Domain>)domains, fileStores);
            AsynchMethodInvoker<Void> processThread = directoryLister.getProcessThread();
            if (mtil != null) {
                mtil.addThread(processThread);
            }
            instances.add(directoryLister);
        }
        return instances;
    }

    public static void addConfigObjectSubscriber(ConfigObjectSubscriber<DataPowerFileInfo> subscriber) {
        if (instances == null) {
            return;
        }
        for (AbstractListFiles abstractListFiles : instances) {
            if (abstractListFiles.getProcessThread().hasCompleted()) continue;
            abstractListFiles.addConfigObjectSubscriber(DataPowerFileInfo.class, subscriber);
        }
    }

    private DirectoryLister(Appliance appliance, ArrayList<Domain> domains, ArrayList<String> fileStores) {
        super(appliance, domains, fileStores);
        this.setLayoutOnly(true);
        this.processThread = ThreadManager.getThread(appliance, this, "listDirectories", KumbaCoreConstants.STARTUP_DELAY, new Object[0]);
        this.processThread.addInvocationListener(this);
    }

    @Reflected
    private void listDirectories() {
        Appliance appliance = this.getAppliance();
        String applianceName = appliance.getName();
        HashSet<String> defaultFileStores = new HashSet<String>();
        logger.finer(() -> LMG.log("(): Starting for %s", () -> applianceName));
        try {
            XMLElement rootNode = this.runRequest();
            if (rootNode == null) {
                logger.info(() -> LMG.log("(): Response XML for %s is null.  Returning.", () -> applianceName));
                return;
            }
            if (this.responseXML.contains("Authentication failure")) {
                logger.severe(() -> LMG.log("(): Authentication Failure Connecting to %s.", () -> applianceName));
                return;
            }
            if (logger.getLevel().equals(Level.FINEST)) {
                new ASCFileWriter("DirectoryLister.listDirectories.xml", rootNode.toString());
            }
            ArrayList directoryNodes = (ArrayList)rootNode.getNodes("//(directory|location)");
            logger.finer(() -> LMG.log("(): Found %d directory nodes in %s", () -> directoryNodes.size(), () -> applianceName));
            ArrayList<Domain> applianceDomains = this.appliance.getDomains();
            for (XMLElement directoryNode : directoryNodes) {
                String directoryName;
                String startingDirectoryName = directoryName = directoryNode.getAttributeValue("name");
                if (AbstractListFiles.isTemporaryExempt(directoryName, applianceDomains)) continue;
                String reference = directoryNode.getAttributeValue("reference");
                boolean isReferenced = reference != null;
                logger.finer(() -> LMG.log("():  Directory: %s - is Referenced in %s", () -> startingDirectoryName, () -> applianceName));
                Domain directoryDomain = this.appliance.getDomain("default");
                boolean isDefaultInScope = Comparison.isIn(directoryDomain, this.domains);
                String fileStore = StringUtility.substringBefore(directoryName, "/");
                String relativeFilePath = StringUtility.substringAfter(directoryName, "/");
                if (isReferenced) {
                    String actualDomainName = StringUtility.substringBefore(relativeFilePath, "/");
                    relativeFilePath = relativeFilePath.contains("/") ? StringUtility.substringAfter(relativeFilePath, "/") : "";
                    directoryDomain = this.appliance.getDomain(actualDomainName);
                    directoryName = String.format("%s/%s", fileStore, relativeFilePath);
                } else if (isDefaultInScope && !defaultFileStores.contains(fileStore)) {
                    DataPowerFileInfo dataPowerFileInfo = new DataPowerFileInfo(appliance, directoryDomain, null, 0L, fileStore, "");
                    this.notifyConfigObjectSubscribers(dataPowerFileInfo);
                    defaultFileStores.add(fileStore);
                }
                String finalDirectoryName = directoryName;
                Domain finalDirectoryDomain = directoryDomain;
                if (!Comparison.isIn(directoryDomain, this.domains)) {
                    logger.finer(() -> LMG.log("():  Skipping as this directory (%s) is in the %s->%s domain and not in the list of search domains", () -> finalDirectoryName, () -> applianceName, () -> finalDirectoryDomain.getName()));
                    continue;
                }
                logger.finer(() -> LMG.log("():  Notifying subscribers on directory in the %s domain of %s: %s", () -> applianceName, () -> finalDirectoryDomain.getName(), () -> finalDirectoryName));
                DataPowerFileInfo dataPowerFileInfo = new DataPowerFileInfo(appliance, directoryDomain, null, 0L, directoryName, "");
                this.notifyConfigObjectSubscribers(dataPowerFileInfo);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        logger.finer(() -> LMG.log("(): Done listing directories for %s", () -> applianceName));
    }
}

