/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.beans.JMBean;
import com.jmorgan.io.FileOutputStreamHelper;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.util.Date;
import com.jmorgan.util.Time;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.ConfigObjectSubscriber;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.ManagementCommandError;
import com.kumbasoft.core.beans.ManagementCommandStatus;
import com.kumbasoft.core.beans.ManagementCommandSubscriber;
import com.kumbasoft.core.beans.actions.ActionDeleteFile;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.ActionTool;
import com.kumbasoft.core.tools.DataPowerFileReader;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.function.Supplier;

public class ErrorReportDownloader
extends AbstractTool
implements ConfigObjectSubscriber<DataPowerFileInfo> {
    private static final String ERROR_REPORTS_DIRECTORY = applicationProperties.getErrorReportsDirectory();
    private AsynchMethodInvoker<?> processThread;
    private File outputFile;
    private boolean removeAfterDownload;

    public ErrorReportDownloader(DataPowerFileInfo dataPowerFileInfo) {
        this(dataPowerFileInfo, false);
    }

    public ErrorReportDownloader(DataPowerFileInfo dataPowerFileInfo, boolean removeAfterDownload) {
        this.removeAfterDownload = removeAfterDownload;
        AbstractTool.logger.finer(() -> LMG.log("(dataPowerFiles=%s, removeAfterDownload=%b): Dowloading error report.", () -> dataPowerFileInfo.getName(), () -> removeAfterDownload));
        DataPowerFileReader fileReader = new DataPowerFileReader(dataPowerFileInfo, true);
        fileReader.addConfigObjectSubscriber(DataPowerFileInfo.class, this);
        this.processThread = fileReader.getProcessThread();
    }

    public AsynchMethodInvoker<?> getProcessThread() {
        return this.processThread;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void processDataPowerConfig(DataPowerFileInfo dataPowerFileInfo) {
        block8: {
            loggerPrefix = String.format("(dataPowerFiles=%s) - Appliance %s: ", new Object[]{dataPowerFileInfo.getName(), dataPowerFileInfo.getAppliance().getName()});
            AbstractTool.logger.finer((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$3(java.lang.String ), ()Ljava/lang/String;)((String)loggerPrefix));
            baseDirName = String.format("%s%s%s", new Object[]{ErrorReportDownloader.ERROR_REPORTS_DIRECTORY, File.separator, dataPowerFileInfo.getAppliance().getName()});
            baseDir = new File(baseDirName);
            baseDir.mkdirs();
            dpFileName = dataPowerFileInfo.getFileName();
            stripFrom = dpFileName.indexOf(":") + 1;
            while (dpFileName.charAt(stripFrom) == '/') {
                ++stripFrom;
            }
            fileDate = dataPowerFileInfo.getFileDate();
            fileDate.getDate().setFormat(Date.SQL_FORMAT);
            fileDate.getTime().setFormat(Time.FILENAME_FRIENDLY_FORMAT);
            fileName = String.format("%s_%s", new Object[]{fileDate.toString().replace(" ", "_"), dpFileName.substring(stripFrom)});
            this.outputFile = new File(baseDir, fileName);
            AbstractTool.logger.finest((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$5(java.lang.String ), ()Ljava/lang/String;)((ErrorReportDownloader)this, (String)loggerPrefix));
            try {
                fw = new FileOutputStreamHelper(this.outputFile);
                out = fw.open();
                out.write(dataPowerFileInfo.getFileData());
                fw.close();
                status = new ManagementCommandStatus(dataPowerFileInfo.getAppliance(), dataPowerFileInfo.getSourceDomain(), "Save File " + this.outputFile.getAbsolutePath(), null, "Save succeeded");
                if (CollectionUtility.isNotEmpty(this.managementCommandSubscribers)) {
                    for (ManagementCommandSubscriber subscriber : this.managementCommandSubscribers) {
                        subscriber.commandSucceeded(status);
                    }
                }
                if (!this.removeAfterDownload) break block8;
                stil = new SingleThreadInvocationListener();
                AbstractTool.logger.finer((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$8(java.lang.String ), ()Ljava/lang/String;)((String)loggerPrefix));
                deleteFile = new ActionDeleteFile();
                deleteFile.setFile(dataPowerFileInfo.getName());
                fileDeleter = new ActionTool(dataPowerFileInfo.getAppliance(), (JMBean)deleteFile);
                fileDeleter.getProcessThread().addInvocationListener(stil);
                fileDeleter.setCommandDescription(String.format("Delete file %s in %s domain of %s", new Object[]{dataPowerFileInfo.getAbsolutePath(), dataPowerFileInfo.getSourceDomain().getName(), dataPowerFileInfo.getAppliance().getName()}));
                fileDeleter.addAdditionalCommandInfo("file", dataPowerFileInfo);
                if (CollectionUtility.isNotEmpty(this.managementCommandSubscribers)) {
                    for (ManagementCommandSubscriber subscriber : this.managementCommandSubscribers) {
                        fileDeleter.addManagementCommandSubscriber(subscriber);
                    }
                }
                stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
                break block8;
            }
            catch (IOException e) {
                error = new ManagementCommandError(dataPowerFileInfo.getAppliance(), dataPowerFileInfo.getSourceDomain(), "Save File " + this.outputFile.getAbsolutePath(), null, "Failed to save file: " + e.getMessage());
                if (!CollectionUtility.isNotEmpty(this.managementCommandSubscribers)) break block8;
                ** for (subscriber : this.managementCommandSubscribers)
            }
lbl-1000:
            // 1 sources

            {
                subscriber.commandFailed(error);
                continue;
            }
        }
        AbstractTool.logger.finer((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$10(java.lang.String ), ()Ljava/lang/String;)((String)loggerPrefix));
    }

    @Override
    public void configProcessingComplete() {
        logger.finer("()");
    }

    private static /* synthetic */ String lambda$3(String string) {
        return LMG.log("%sStarting", () -> string);
    }

    private /* synthetic */ String lambda$5(String string) {
        return LMG.log("%sOutput File Name: %s", () -> string, () -> this.outputFile);
    }

    private static /* synthetic */ String lambda$8(String string) {
        return LMG.log("%sRemoving file", () -> string);
    }

    private static /* synthetic */ String lambda$10(String string) {
        return LMG.log("%sDone", () -> string);
    }
}

