/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.io.FileOutputStreamHelper;
import com.jmorgan.io.FileWriterHelper;
import com.jmorgan.j2ee.xml.XMLElement;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.lang.StackTrace;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.Date;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.Time;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreApplicationProperties;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ExportOptions;
import com.kumbasoft.core.beans.ManagementCommandError;
import com.kumbasoft.core.beans.ManagementCommandStatus;
import com.kumbasoft.core.beans.ManagementCommandSubscriber;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.tools.AbstractDataPowerManagementRequest;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.util.DataStructureUtility;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;

public class ExportConfiguration
extends AbstractDataPowerManagementRequest {
    private static final byte[] FILES_ELEMENT = "<files>".getBytes();
    private static final byte[] END_DPCONFIG_ELEMENT = "</datapower-configuration>".getBytes();
    private Collection<?> dataPowerObjects;
    private ExportOptions exportOptions;
    private long startTime;
    private String exportFileName;

    public static ExportOptions createDefaultExportOptions() {
        ExportOptions exportOptions = new ExportOptions();
        exportOptions.setAllFiles(true);
        exportOptions.setPersisted(false);
        exportOptions.setExportDebug(false);
        exportOptions.setExportObjects(true);
        exportOptions.setExportFiles(true);
        exportOptions.setExportFormat(DPEnumerations.EXPORT_FORMAT[1]);
        return exportOptions;
    }

    public static void exportConfigurations(ArrayList<StatusObjectStatus> dataPowerObjects, ExportOptions exportOptions, ManagementCommandSubscriber commandStatusSubscriber) {
        AbstractTool.logger.finer("(...): Starting.");
        HashMap<Appliance, Index<Domain, StatusObjectStatus>> objectsByAppliance = DataStructureUtility.mapByApplianceDomain(dataPowerObjects);
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        for (Appliance appliance : objectsByAppliance.keySet()) {
            Index<Domain, StatusObjectStatus> objectsByDomain = objectsByAppliance.get(appliance);
            AbstractTool.logger.config(() -> LMG.log("(): Exporting %d objects for appliance '%s'.", () -> objectsByDomain.totalSize(), () -> appliance.getName()));
            AsynchMethodInvoker applianceThread = new AsynchMethodInvoker(ExportConfiguration.class, "exportDomainConfigurations", new Object[]{appliance, objectsByDomain, exportOptions, commandStatusSubscriber});
            mtil.addThread(applianceThread);
        }
        boolean completedOnTime = ThreadManager.monitorAsynchThreadLifeCycle("ExportConfiguration.exportConfigurations(...)", mtil, KumbaCoreConstants.STARTUP_DELAY, mtil.getRunningThreadCount() * KumbaCoreConstants.THREAD_TIMEOUT);
        if (!completedOnTime) {
            AbstractTool.logger.warning("(...):  Not all export threads may have completed on time.  Continuing.");
        } else {
            AbstractTool.logger.finer("(...): All exports completed on time.");
        }
    }

    @Reflected
    private static void exportDomainConfigurations(Appliance appliance, Index<Domain, StatusObjectStatus> objectsByDomain, ExportOptions exportOptions, ManagementCommandSubscriber commandStatusSubscriber) {
        AbstractTool.logger.finer(() -> LMG.log("(...): Starting export for appliance '%s'.", () -> appliance.getName()));
        SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
        for (Domain domain : objectsByDomain.getKeys()) {
            Collection<StatusObjectStatus> exportObjectList = objectsByDomain.get(domain);
            logger.fine(() -> LMG.log("(...): Exporting %d objects from the '%s' domain of '%s'.", () -> exportObjectList.size(), () -> domain.getName(), () -> appliance.getName()));
            ExportConfiguration exportConfiguration = new ExportConfiguration(appliance, domain, exportObjectList, exportOptions);
            exportConfiguration.addManagementCommandSubscriber(commandStatusSubscriber);
            exportConfiguration.getProcessThread().addInvocationListener(stil);
            boolean completedOnTime = stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
            if (completedOnTime) continue;
            logger.warning(() -> LMG.log("(...): Export did not complete on time for the '%s' domain of '%s'.  Continuing.", () -> domain.getName(), () -> appliance.getName()));
        }
        AbstractTool.logger.finer(() -> LMG.log("(...): Done exporting for appliance '%s'.", () -> appliance.getName()));
    }

    public ExportConfiguration(DataPowerConfig dataPowerObject, ExportOptions exportOptions) {
        super(dataPowerObject.getAppliance(), dataPowerObject.getSourceDomain(), String.format("Export %s %s Configuration", dataPowerObject.getConfigObjectType(), dataPowerObject.getName()));
        ArrayList<DataPowerConfig> dataPowerObjects = new ArrayList<DataPowerConfig>();
        dataPowerObjects.add(dataPowerObject);
        this.setupInstance(dataPowerObjects, exportOptions);
    }

    public ExportConfiguration(StatusObjectStatus dataPowerObject, ExportOptions exportOptions) {
        super(dataPowerObject.getAppliance(), dataPowerObject.getSourceDomain(), String.format("Export %s %s Configuration", dataPowerObject.getDataPowerClass(), dataPowerObject.getName()));
        ArrayList<StatusObjectStatus> dataPowerObjects = new ArrayList<StatusObjectStatus>();
        dataPowerObjects.add(dataPowerObject);
        this.setupInstance(dataPowerObjects, exportOptions);
    }

    public ExportConfiguration(Appliance appliance, Domain domain, Collection<?> dataPowerObjects, ExportOptions exportOptions) {
        super(appliance, domain, String.format("Exporting %d Configurations", dataPowerObjects.size()));
        this.setupInstance(dataPowerObjects, exportOptions);
    }

    private void setupInstance(Collection<?> dataPowerObject, ExportOptions exportOptions) {
        this.startTime = System.currentTimeMillis();
        this.setConnectionTimeout(KumbaCoreConstants.SOMA_READ_TIMEOUT);
        this.setDataPowerObjects(dataPowerObject);
        this.setExportOptions(exportOptions);
        this.exportFileName = this.getExportFileName();
        com.jmorgan.io.File exportFile = new com.jmorgan.io.File(this.exportFileName);
        if (exportFile.exists()) {
            logger.info(() -> LMG.log("(Object dataPowerObject, ExportOptions exportOptions):  %s file exists!", () -> exportFile.getAbsolutePath()));
            long lastModified = exportFile.lastModified();
            long sessionTime = this.exportOptions.getSessionTime();
            if (lastModified >= sessionTime) {
                logger.info(() -> LMG.log("(Object dataPowerObject, ExportOptions exportOptions):  %s file was created during the current session.  Skipping export.", () -> exportFile.getAbsolutePath()));
                this.processThread.cancel();
                this.requestStatus = true;
            }
        }
    }

    public Collection<?> getDataPowerObjects() {
        return this.dataPowerObjects;
    }

    public void setDataPowerObjects(Collection<?> dataPowerObject) {
        this.dataPowerObjects = dataPowerObject;
    }

    public ExportOptions getExportOptions() {
        return this.exportOptions;
    }

    public void setExportOptions(ExportOptions exportOptions) {
        String exportOptionsState = exportOptions == null ? "null" : "not null";
        logger.finer(() -> LMG.log("ExportOptions=%s);", () -> exportOptionsState));
        this.exportOptions = exportOptions;
        String configExportDirectoryName = ((KumbaCoreApplicationProperties)Application.getApplication().getApplicationProperties()).getConfigExportsDirectory();
        com.jmorgan.io.File configExportDirectory = new com.jmorgan.io.File(configExportDirectoryName);
        if (this.exportOptions == null) {
            this.exportOptions = ExportConfiguration.createDefaultExportOptions();
            this.exportOptions.setOutputDirectory(configExportDirectory);
        } else if (this.exportOptions.getOutputDirectory() == null) {
            this.exportOptions.setOutputDirectory(configExportDirectory);
        }
    }

    public String getExportFileName() {
        if (this.exportFileName == null) {
            com.jmorgan.io.File outputDirectory;
            String objectOutputDirectoryName = String.format("%s%s%s%s", this.getAppliance().getName(), File.separator, this.getDomain().getName(), File.separator);
            DateTime now = new DateTime();
            now.getDate().setFormat(Date.SQL_FORMAT);
            now.getTime().setFormat(Time.FILENAME_FRIENDLY_FORMAT);
            now.setToStringDelimiter("_");
            Object fileName = "Configuration_Export_" + now.toString();
            if (this.dataPowerObjects.size() == 1) {
                Object dataPowerObject = CollectionUtility.get(this.dataPowerObjects, 0);
                String propertyName = dataPowerObject instanceof DataPowerConfig ? "configObjectType" : "dataPowerClass";
                String dpClassName = (String)BeanService.getPropertyValue(dataPowerObject, propertyName);
                String dpObjectName = (String)BeanService.getPropertyValue(dataPowerObject, "name");
                objectOutputDirectoryName = String.format("%s%s%s", objectOutputDirectoryName, dpClassName, File.separator);
                fileName = dpObjectName;
            }
            if (!(outputDirectory = new com.jmorgan.io.File(this.exportOptions.getOutputDirectory(), objectOutputDirectoryName)).exists()) {
                outputDirectory.mkdirs();
            }
            String extension = this.exportOptions.getExportFormat().toLowerCase();
            fileName = String.format("%s.%s", fileName, extension);
            com.jmorgan.io.File outputFile = new com.jmorgan.io.File(outputDirectory, (String)fileName);
            this.exportFileName = outputFile.getAbsolutePath();
        }
        return this.exportFileName;
    }

    public void setExportFileName(String exportFileName) {
        this.exportFileName = exportFileName;
    }

    @Override
    protected String finalizeRequestMessage(String requestXML) {
        String request = requestXML;
        logger.finest(() -> LMG.log("(requestXML): Input: %s", () -> request));
        for (Object dataPowerObject : this.dataPowerObjects) {
            int doExportLocation = requestXML.indexOf("</dp:do-export>");
            String propertyName = dataPowerObject instanceof DataPowerConfig ? "configObjectType" : "dataPowerClass";
            String dpClassName = (String)BeanService.getPropertyValue(dataPowerObject, propertyName);
            String dpObjectName = (String)BeanService.getPropertyValue(dataPowerObject, "name");
            String objectElement = String.format("\t<dp:object class=\"%s\" name=\"%s\" ref-objects=\"%s\" ref-files=\"%s\" include-debug=\"%s\"/>\n\t\t\t", dpClassName, dpObjectName, this.exportOptions.isExportObjects(), this.exportOptions.isExportFiles(), this.exportOptions.isExportDebug());
            requestXML = StringUtility.insertInto(objectElement, requestXML, doExportLocation);
        }
        StatusObjectStatus deploymentPolicy = this.exportOptions.getDeploymentPolicy();
        String deploymentPolicyName = deploymentPolicy == null ? "" : deploymentPolicy.getName();
        requestXML = StringUtility.isEmpty(deploymentPolicyName) ? requestXML.replace("deployment-policy=\"\"", "") : requestXML.replace("deployment-policy=\"\"", String.format("deployment-policy=\"%s\"", deploymentPolicyName));
        String finalRequest = requestXML;
        logger.finest(() -> LMG.log("(requestXML): Output:\n%s", () -> finalRequest));
        return requestXML;
    }

    @Override
    protected boolean processResultDocument(XMLElement rootElement) {
        logger.entering(this.getClass().getName(), "(XMLElement rootElement)");
        if (rootElement == null) {
            NullPointerException ex = new NullPointerException("ExportConfiguration.processResultDocument(XMLElement rootElement):  rootElement is null");
            String fullStackTrace = StackTrace.getStackTrace(ex);
            logger.severe(() -> LMG.log("(rootElement=null):%s", () -> fullStackTrace));
            this.requestStatus = false;
            throw ex;
        }
        Collection<XMLElement> resultElements = rootElement.getNodes("//dp:result");
        boolean isZipExport = this.exportOptions.getExportFormat().equals(DPEnumerations.EXPORT_FORMAT[0]);
        boolean isXMLExport = this.exportOptions.getExportFormat().equals(DPEnumerations.EXPORT_FORMAT[1]);
        for (XMLElement resultElement : resultElements) {
            String resultText = resultElement.toString();
            if (!resultText.contains("Authentication failure")) continue;
            String errorMessage = String.format("(): Authentication Failure from the %s domain of %s", this.getDomain(), this.getAppliance().getName());
            logger.severe(errorMessage);
            ManagementCommandError commandError = new ManagementCommandError(this.getAppliance(), this.getDomain(), "Export Configuration", this, errorMessage);
            commandError.setAdditionalCommandInfo(this.getAdditionalCommandInfo());
            this.notifyManagementCommandSubscribers(commandError);
            return false;
        }
        Collection<XMLElement> fileElements = rootElement.getNodes("//dp:file");
        for (XMLElement fileElement : fileElements) {
            byte[] fileBytes;
            String base64Content = fileElement.getValue();
            byte[] exportBytes = fileBytes = Base64.getDecoder().decode(base64Content);
            if (isXMLExport && !this.exportOptions.isExportFiles()) {
                logger.fine("(rootElement):  Removing files from export.");
                int filesElement = ArrayUtility.indexOf(FILES_ELEMENT, fileBytes);
                if (filesElement > 0) {
                    int endDPConfigElement = fileBytes.length - END_DPCONFIG_ELEMENT.length;
                    exportBytes = new byte[filesElement + END_DPCONFIG_ELEMENT.length];
                    int exportByteCount = exportBytes.length;
                    logger.finer(() -> LMG.log("(rootElement):  arrayCopy -> fileBytes.length=%d, exportBytes.length=%d, filesElement=%d", () -> fileBytes.length, () -> exportByteCount, () -> filesElement));
                    System.arraycopy(fileBytes, 0, exportBytes, 0, filesElement);
                    logger.finer(() -> LMG.log("(rootElement):  arrayCopy -> fileBytes.length=%d, endDPConfigElement=%d, exportBytes.length=%d, filesElement=%d, END_DPCONFIG_ELEMENT.length=%d", () -> fileBytes.length, () -> endDPConfigElement, () -> exportByteCount, () -> filesElement, () -> END_DPCONFIG_ELEMENT.length));
                    System.arraycopy(fileBytes, endDPConfigElement, exportBytes, filesElement, END_DPCONFIG_ELEMENT.length);
                } else {
                    logger.warning("(rootElement): No '<files>' elements in the XML element.  Was it read from a cache?");
                }
            }
            logger.info(() -> LMG.log("(rootElement):  Writing export to %s.", () -> this.exportFileName));
            com.jmorgan.io.File outputFile = new com.jmorgan.io.File(this.exportFileName);
            if (isZipExport) {
                BufferedOutputStream bout;
                FileOutputStreamHelper fout;
                block18: {
                    logger.fine("(rootElement):  Writing ZIP output.");
                    fout = new FileOutputStreamHelper(outputFile, KumbaCoreConstants.FILE_READ_BUFFER_SIZE);
                    bout = (BufferedOutputStream)fout.open();
                    if (bout != null) break block18;
                    String errorMessage = "Error exporting zip.";
                    logger.severe(errorMessage);
                    ManagementCommandError commandError = new ManagementCommandError(this.getAppliance(), this.getDomain(), "Export Configuration", this, errorMessage);
                    commandError.setAdditionalCommandInfo(this.getAdditionalCommandInfo());
                    this.notifyManagementCommandSubscribers(commandError);
                    fout.close();
                    return false;
                }
                try {
                    try {
                        bout.write(exportBytes);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        fout.close();
                    }
                }
                catch (Throwable throwable) {
                    fout.close();
                    throw throwable;
                }
                fout.close();
            } else {
                BufferedWriter bw;
                FileWriterHelper fw;
                String fileContent;
                block20: {
                    logger.fine("(rootElement):  Writing XML output.");
                    fileContent = new String(exportBytes);
                    fw = new FileWriterHelper(outputFile, KumbaCoreConstants.FILE_READ_BUFFER_SIZE);
                    bw = (BufferedWriter)fw.open();
                    if (bw != null) break block20;
                    String errorMessage = "Error exporting xml.";
                    logger.severe(errorMessage);
                    ManagementCommandError commandError = new ManagementCommandError(this.getAppliance(), this.getDomain(), "Export Configuration", this, errorMessage);
                    commandError.setAdditionalCommandInfo(this.getAdditionalCommandInfo());
                    this.notifyManagementCommandSubscribers(commandError);
                    fw.close();
                    return false;
                }
                try {
                    try {
                        bw.write(fileContent);
                        bw.flush();
                        logger.finer(() -> LMG.log("(rootElement):  Writing to export file successful: %s.", () -> this.exportFileName));
                    }
                    catch (IOException e) {
                        logger.severe(() -> LMG.log("(rootElement):  IOException Writing export to %s.\n%s", () -> this.exportFileName, () -> StackTrace.getStackTrace(e)));
                        e.printStackTrace();
                        fw.close();
                    }
                }
                catch (Throwable throwable) {
                    fw.close();
                    throw throwable;
                }
                fw.close();
            }
            ManagementCommandStatus commandStatus = new ManagementCommandStatus(this.getAppliance(), this.getDomain(), "Export Configuration", this, "Export of " + this.exportFileName + " successful");
            commandStatus.setAdditionalCommandInfo(this.getAdditionalCommandInfo());
            commandStatus.addAdditionalCommandInfo("outputFileName", outputFile.getAbsolutePath());
            this.notifyManagementCommandSubscribers(commandStatus);
        }
        logger.info(() -> LMG.log("(rootElement):  Time to export from %s %s = %sms", () -> this.getAppliance().getName(), () -> this.getDomain().getName(), () -> System.currentTimeMillis() - this.startTime));
        return true;
    }
}

