/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.JMBean;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.ThreadUtility;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationRelationship;
import com.kumbasoft.core.beans.ConfigurationRelationshipType;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ManagementCommandStatus;
import com.kumbasoft.core.beans.ManagementCommandSubscriber;
import com.kumbasoft.core.beans.actions.ActionDeleteFile;
import com.kumbasoft.core.beans.actions.ActionFetchFile;
import com.kumbasoft.core.tools.AbstractCommandProcessFileTool;
import com.kumbasoft.core.tools.ActionTool;
import com.kumbasoft.core.tools.ConfigTool;
import com.kumbasoft.core.tools.ThreadManager;
import java.util.ArrayList;
import java.util.logging.Logger;

public class FileRename
extends AbstractCommandProcessFileTool {
    private ConfigurationRelationship configurationRelationship;
    private SingleThreadInvocationListener configRelationshipListener;
    private boolean keepOriginalFile;

    public FileRename(DataPowerFileInfo sourceFile, DataPowerFileInfo targetFile) {
        this(sourceFile, targetFile, true);
    }

    public FileRename(DataPowerFileInfo sourceFile, DataPowerFileInfo targetFile, boolean keepOriginalFile) {
        super(sourceFile, targetFile);
        this.keepOriginalFile = keepOriginalFile;
        new AsynchMethodInvoker((Object)this, "createConfigurationRelationship");
    }

    private void addCommandSubscribers(ConfigTool configTool) {
        for (ManagementCommandSubscriber commandSubscriber : this.managementCommandSubscribers) {
            configTool.addManagementCommandSubscriber(commandSubscriber);
        }
    }

    @Override
    @Reflected
    public void performProcess() {
        Logger logger = Application.getApplication().getApplicationLogger();
        Appliance appliance = this.sourceFile.getAppliance();
        Domain domain = this.sourceFile.getSourceDomain();
        String commandDescription = String.format("Copy from %s to %s", this.sourceFile.getAbsolutePath(), this.targetFile.getAbsolutePath());
        logger.finest(commandDescription);
        ActionFetchFile fetchFileAction = new ActionFetchFile();
        fetchFileAction.setURL(this.sourceFile.getAbsolutePath());
        fetchFileAction.setFile(this.targetFile.getAbsolutePath());
        SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
        ActionTool actionTool = new ActionTool(appliance, domain, fetchFileAction);
        actionTool.getProcessThread().addInvocationListener(stil);
        actionTool.setCommandDescription(commandDescription);
        this.addCommandSubscribers(actionTool);
        logger.finest("Waiting for file copy to complete.");
        while (!this.configRelationshipListener.invocationComplete() || !stil.invocationComplete()) {
            ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
        }
        logger.finest("Both configuration relationship and save as have completed");
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        ArrayList<ConfigurationRelationship> relationships = this.configurationRelationship.getReferences();
        logger.finest("Got Relationships");
        for (ConfigurationRelationship relationship : relationships) {
            DataPowerConfig referencingObject = relationship.getObjectInFocus();
            String refactoringDescription = String.format("Refactoring file reference in %s %s", referencingObject.getConfigObjectType(), referencingObject.getName());
            logger.info(refactoringDescription);
            ManagementCommandStatus managementCommandStatus = new ManagementCommandStatus(appliance, domain, refactoringDescription, null, "Starting");
            this.notifyManagementCommandSubscribers(managementCommandStatus);
            this.refactorReference(referencingObject);
            logger.info("Done refactoring references in " + referencingObject.getConfigObjectType() + " " + referencingObject.getName() + ".  Saving Config.");
            ConfigTool configTool = new ConfigTool(referencingObject.getAppliance(), referencingObject.getSourceDomain(), referencingObject);
            mtil.addThread(configTool.getProcessThread());
            this.addCommandSubscribers(configTool);
        }
        logger.finest("Waiting until all save configs are complete.");
        ThreadManager.monitorAsynchThreadLifeCycle("FileRename.performProcess()", mtil, relationships.size() * KumbaCoreConstants.STARTUP_DELAY, 0);
        logger.info("All save configs are complete.");
        if (!this.keepOriginalFile) {
            mtil.resetThreadCount();
            logger.info("Deleting " + this.sourceFile.getAbsolutePath());
            String deleteDescription = String.format("Deleting %s from %s to %s", this.sourceFile.getAbsolutePath(), this.sourceFile.getAppliance().getName(), this.sourceFile.getSourceDomain().getName());
            ActionDeleteFile actionDeleteFile = new ActionDeleteFile();
            actionDeleteFile.setFile(this.sourceFile.getAbsolutePath());
            ActionTool deleteActionTool = new ActionTool(appliance, domain, actionDeleteFile);
            mtil.addThread(deleteActionTool.getProcessThread());
            deleteActionTool.setCommandDescription(deleteDescription);
            this.addCommandSubscribers(deleteActionTool);
            logger.finest("Waiting for Delete of " + this.sourceFile.getAbsolutePath() + " to complete.");
            ThreadManager.monitorAsynchThreadLifeCycle("FileRename.performProcess()", mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
            logger.info("Delete of " + this.sourceFile.getAbsolutePath() + " complete.");
        }
        logger.finest("Done");
    }

    private void refactorReference(Object referencingObject) {
        ArrayList<String> propertyNames = BeanService.getPropertyNames(referencingObject);
        String sourceFileName = this.sourceFile.getAbsolutePath();
        String sourceFileNameTriple = FileRename.convertToTripleSlashName(sourceFileName);
        String targetFileName = this.targetFile.getAbsolutePath();
        String targetFileNameTriple = FileRename.convertToTripleSlashName(targetFileName);
        for (String propertyName : propertyNames) {
            ArrayList listOfObjects;
            Class<Object> propertyType = BeanService.getPropertyType(referencingObject, propertyName);
            if (propertyType.isAssignableFrom(String.class)) {
                String propertyValue = (String)BeanService.getPropertyValue(referencingObject, propertyName);
                if (!StringUtility.isNotEmpty(propertyValue) || !propertyValue.equals(sourceFileName) && !propertyValue.equals(sourceFileNameTriple)) continue;
                BeanService.setPropertyValue(referencingObject, propertyName, targetFileNameTriple);
                continue;
            }
            if (!propertyType.isAssignableFrom(ArrayList.class) || (listOfObjects = (ArrayList)BeanService.getPropertyValue(referencingObject, propertyName)) == null) continue;
            ArrayList copyOfObjects = new ArrayList(listOfObjects);
            int i = 0;
            while (i < copyOfObjects.size()) {
                Object object = copyOfObjects.get(i);
                if (object instanceof String) {
                    String value = (String)object;
                    if (StringUtility.isNotEmpty(value) && (value.equals(sourceFileName) || value.equals(sourceFileNameTriple))) {
                        listOfObjects.set(i, targetFileNameTriple);
                    }
                } else if (object instanceof JMBean) {
                    this.refactorReference(object);
                }
                ++i;
            }
        }
    }

    private static String convertToTripleSlashName(String fileName) {
        String rightSide = StringUtility.substringAfter(fileName, ":");
        if (!rightSide.startsWith("///")) {
            fileName = fileName.replace(":/", ":///");
        }
        return fileName;
    }

    @Reflected
    private void createConfigurationRelationship() {
        this.configRelationshipListener = new SingleThreadInvocationListener();
        this.configurationRelationship = new ConfigurationRelationship(this.sourceFile, ConfigurationRelationshipType.CHILD_UP);
        this.configurationRelationship.getSetupThread().addInvocationListener(this.configRelationshipListener);
    }
}

