/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.IPAddress;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.InvocationEvent;
import com.jmorgan.lang.InvocationListener;
import com.jmorgan.util.Index;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.DataPowerStatusCache;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.IPInfoBean;
import com.kumbasoft.core.beans.IPInfoSubscriber;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigEthernetInterface;
import com.kumbasoft.core.beans.config.ConfigHostAlias;
import com.kumbasoft.core.beans.config.ConfigLoadBalancerGroup;
import com.kumbasoft.core.beans.status.StatusDNSCacheHostStatus4;
import com.kumbasoft.core.beans.status.StatusDNSNameServerStatus2;
import com.kumbasoft.core.beans.status.StatusDNSStaticHostStatus;
import com.kumbasoft.core.beans.status.StatusIPAddressStatus;
import com.kumbasoft.core.beans.status.StatusLoadBalancerStatus2;
import com.kumbasoft.core.beans.status.StatusTCPTable;
import com.kumbasoft.core.beans.types.StaticRoute;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.DataPowerStatusMonitor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class FindIP
extends AbstractTool
implements InvocationListener {
    private Index<Appliance, Domain> selectedDomains;
    private String ipSearchPattern;
    private ArrayList<IPInfoSubscriber> ipInfoSubscribers;
    private DataPowerStatusCache<StatusIPAddressStatus> ipAddressStatusCache;
    private DataPowerStatusCache<StatusDNSStaticHostStatus> dnsStaticHostStatusCache;
    private DataPowerStatusCache<StatusDNSCacheHostStatus4> dnsCacheHostStatusCache;
    private DataPowerStatusCache<StatusDNSNameServerStatus2> dnsNameServerStatusCache;
    private DataPowerStatusCache<StatusTCPTable> tcpTableCache;
    private DataPowerStatusCache<StatusLoadBalancerStatus2> lbgCache;
    private ArrayList<ConfigHostAlias> hostAliases;
    private ArrayList<ConfigEthernetInterface> ethernetInterfaces;
    private boolean tcpTableProcessed;
    private boolean hostAliasesProcessed;
    private boolean ethernetInterfacesProcessed;
    private boolean lbgStatusProcessed;
    private boolean ipAddressStatusProcessed;
    private boolean dnsStaticHostStatusProcessed;
    private boolean dnsCacheHostStatusProcessed;
    private boolean dnsNameServerStatusProcessed;
    private long monitoringTime = 0L;

    public FindIP(Index<Appliance, Domain> selectedDomains, String ipSearchPattern) {
        this.setSelectedDomains(selectedDomains);
        this.setIpSearchPattern(ipSearchPattern);
        new AsynchMethodInvoker((Object)this, "findIP");
    }

    public Index<Appliance, Domain> getSelectedDomains() {
        return this.selectedDomains;
    }

    public void setSelectedDomains(Index<Appliance, Domain> selectedDomains) {
        this.selectedDomains = selectedDomains;
    }

    public String getIpSearchPattern() {
        return this.ipSearchPattern;
    }

    public void setIpSearchPattern(String ipSearchPattern) {
        this.ipSearchPattern = ipSearchPattern;
    }

    public void addIPInfoSubscriber(IPInfoSubscriber subscriber) {
        if (subscriber == null) {
            return;
        }
        if (this.ipInfoSubscribers == null) {
            this.ipInfoSubscribers = new ArrayList();
        }
        this.ipInfoSubscribers.add(subscriber);
    }

    @Reflected
    private void findIP() {
        logger.finer("(): Starting");
        this.ipAddressStatusProcessed = false;
        this.dnsStaticHostStatusProcessed = false;
        this.dnsCacheHostStatusProcessed = false;
        this.dnsNameServerStatusProcessed = false;
        this.ethernetInterfacesProcessed = false;
        this.hostAliasesProcessed = false;
        this.tcpTableProcessed = false;
        this.lbgStatusProcessed = false;
        this.tcpTableCache = FindIP.createOrClearStatusCache(this.tcpTableCache);
        this.ipAddressStatusCache = FindIP.createOrClearStatusCache(this.ipAddressStatusCache);
        this.dnsStaticHostStatusCache = FindIP.createOrClearStatusCache(this.dnsStaticHostStatusCache);
        this.dnsCacheHostStatusCache = FindIP.createOrClearStatusCache(this.dnsCacheHostStatusCache);
        this.dnsNameServerStatusCache = FindIP.createOrClearStatusCache(this.dnsNameServerStatusCache);
        this.lbgCache = FindIP.createOrClearStatusCache(this.lbgCache);
        ArrayList<Appliance> selectedAppliances = new ArrayList<Appliance>(this.selectedDomains.getKeys());
        ConfigurationManager configurationManager = new ConfigurationManager();
        for (Appliance appliance : selectedAppliances) {
            Domain defaultDomain = appliance.getDomain("default");
            if (defaultDomain == null) {
                defaultDomain = new Domain("default");
            }
            logger.fine(() -> LMG.log("(): Getting TCPTable Status for %s.", () -> appliance.getName()));
            DataPowerStatusMonitor tcpTableStatusMonitor = new DataPowerStatusMonitor(appliance, defaultDomain, "TCPTable", 0L);
            tcpTableStatusMonitor.addStatusListener(this.tcpTableCache);
            logger.fine(() -> LMG.log("(): Getting IPAddressStatus Status for %s.", () -> appliance.getName()));
            DataPowerStatusMonitor ipAddressStatusMonitor = new DataPowerStatusMonitor(appliance, defaultDomain, "IPAddressStatus", 0L);
            ipAddressStatusMonitor.addStatusListener(this.ipAddressStatusCache);
            logger.fine(() -> LMG.log("(): Getting DNSStaticHostStatus Status for %s.", () -> appliance.getName()));
            DataPowerStatusMonitor dnsStaticHostStatusMonitor = new DataPowerStatusMonitor(appliance, defaultDomain, "DNSStaticHostStatus", 0L);
            dnsStaticHostStatusMonitor.addStatusListener(this.dnsStaticHostStatusCache);
            logger.fine(() -> LMG.log("(): Getting DNSCacheHostStatus4 Status for %s.", () -> appliance.getName()));
            DataPowerStatusMonitor dnsCacheHostStatusMonitor = new DataPowerStatusMonitor(appliance, defaultDomain, "DNSCacheHostStatus4", 0L);
            dnsCacheHostStatusMonitor.addStatusListener(this.dnsCacheHostStatusCache);
            logger.fine(() -> LMG.log("(): Getting DNSNameServerStatus2 Status for %s.", () -> appliance.getName()));
            DataPowerStatusMonitor dnsNameServerStatusMonitor = new DataPowerStatusMonitor(appliance, defaultDomain, "DNSNameServerStatus2", 0L);
            dnsNameServerStatusMonitor.addStatusListener(this.dnsNameServerStatusCache);
            for (Domain domain : this.selectedDomains.get(appliance)) {
                logger.fine(() -> LMG.log("(): Getting LoadBalancerStatus2 Status for %s -> %s.", () -> appliance.getName(), () -> domain.getName()));
                DataPowerStatusMonitor lbgStatusMonitor = new DataPowerStatusMonitor(appliance, domain, "LoadBalancerStatus2", 0L);
                lbgStatusMonitor.addStatusListener(this.lbgCache);
            }
        }
        if (this.hostAliases != null) {
            this.hostAliases.clear();
            this.hostAliases = null;
        }
        logger.finer("(): Getting Host Aliases.");
        AsynchMethodInvoker getHostAliases = new AsynchMethodInvoker((Object)configurationManager, "getObjects", new Object[]{selectedAppliances, ConfigHostAlias.class, ".*"});
        getHostAliases.addInvocationListener(this);
        if (this.ethernetInterfaces != null) {
            this.ethernetInterfaces.clear();
            this.ethernetInterfaces = null;
        }
        logger.finer("(): Getting Ethernet Interfaces.");
        AsynchMethodInvoker getEthernetInterfaces = new AsynchMethodInvoker((Object)configurationManager, "getObjects", new Object[]{selectedAppliances, ConfigEthernetInterface.class, ".*"}, KumbaCoreConstants.STARTUP_DELAY);
        getEthernetInterfaces.addInvocationListener(this);
        logger.finer("(): Monitoring Caches");
        this.monitoringTime = 0L;
        new AsynchMethodInvoker((Object)this, "monitorCaches");
        logger.finer("(): Done");
    }

    private static DataPowerStatusCache<?> createOrClearStatusCache(DataPowerStatusCache<?> statusCache) {
        if (statusCache == null) {
            return new DataPowerStatusCache();
        }
        statusCache.clearCache();
        return statusCache;
    }

    @Override
    public boolean methodInvocationNotice(InvocationEvent invocationEvent) {
        return true;
    }

    @Override
    public void methodInvoked(InvocationEvent invocationEvent) {
        Object[] methodArguments = invocationEvent.getMethodArguments();
        if (methodArguments[1].equals(ConfigHostAlias.class)) {
            this.hostAliases = (ArrayList)invocationEvent.getReturnValue();
        } else if (methodArguments[1].equals(ConfigEthernetInterface.class)) {
            this.ethernetInterfaces = (ArrayList)invocationEvent.getReturnValue();
        }
    }

    @Override
    public void methodInvocationCancelled(InvocationEvent invocationEvent) {
        Application.getApplication().getApplicationLogger().fine(String.format("FindIP.methodInvocationCancelled(invocationEvent)\n", new Object[0]));
    }

    @Reflected
    private void monitorCaches() {
        logger.finer("(): Starting");
        this.checkDNSStaticHostStatus();
        this.checkDNSCacheHostStatus();
        this.checkDNSNameServerStatus();
        this.checkIPAddressStatus();
        this.checkTCPTableStatus();
        this.checkHostAliasConfig();
        this.checkEthernetInterfacesConfig();
        this.checkLBGStatus();
        if (!(this.tcpTableProcessed && this.ipAddressStatusProcessed && this.dnsStaticHostStatusProcessed && this.dnsCacheHostStatusProcessed && this.dnsNameServerStatusProcessed && this.hostAliasesProcessed && this.ethernetInterfacesProcessed && this.lbgStatusProcessed)) {
            if (this.monitoringTime < (long)KumbaCoreConstants.THREAD_TIMEOUT) {
                logger.finer("(): At least one status has not finished.  Checking again.");
                new AsynchMethodInvoker((Object)this, "monitorCaches", KumbaCoreConstants.THREAD_WAIT);
                this.monitoringTime += (long)KumbaCoreConstants.THREAD_WAIT;
                return;
            }
            logger.warning("(): Timed out waiting for all status providers to complete.");
            if (!this.tcpTableProcessed) {
                logger.info("(): TCPTableStatus did not complete");
            }
            if (!this.ipAddressStatusProcessed) {
                logger.info("(): IPAddressStatus did not complete");
            }
            if (!this.dnsStaticHostStatusProcessed) {
                logger.info("(): DNSStaticHostStatus did not complete");
            }
            if (!this.dnsCacheHostStatusProcessed) {
                logger.info("(): DNSCacheHostStatus did not complete");
            }
            if (!this.dnsNameServerStatusProcessed) {
                logger.info("(): DNSNameServerStatus did not complete");
            }
            if (!this.hostAliasesProcessed) {
                logger.info("(): Host Alias Configurations did not complete");
            }
            if (!this.ethernetInterfacesProcessed) {
                logger.info("(): Ehternet Interface Configurations did not complete");
            }
            if (!this.lbgStatusProcessed) {
                logger.info("(): Load Balancer Configurations did not complete");
            }
        }
        logger.finer("(): Cleaning up");
        this.notifyIPInfoSubscribers();
        logger.finer("(): Done");
    }

    private void notifyIPInfoSubscribers() {
        logger.finer("(): Starting");
        if (!CollectionUtility.isEmpty(this.ipInfoSubscribers)) {
            for (IPInfoSubscriber subscriber : this.ipInfoSubscribers) {
                subscriber.findIPComplete(this);
            }
        }
        logger.finer("(): Done");
    }

    private void checkDNSCacheHostStatus() {
        if (!this.dnsCacheHostStatusProcessed && this.dnsCacheHostStatusCache != null && this.dnsCacheHostStatusCache.isComplete()) {
            ArrayList<StatusDNSCacheHostStatus4> dnsCacheHostStatuses = this.dnsCacheHostStatusCache.getStatusCache();
            for (StatusDNSCacheHostStatus4 dnsCacheHostStatus : dnsCacheHostStatuses) {
                String ip = dnsCacheHostStatus.getIPAddress();
                if (!ip.matches(this.ipSearchPattern)) continue;
                Appliance appliance = dnsCacheHostStatus.getAppliance();
                Domain domain = dnsCacheHostStatus.getSourceDomain();
                String hostName = dnsCacheHostStatus.getHostname();
                this.createAndNotify(appliance, domain, "DNSNameService", hostName, ip, "The host IP from DNS Host Cache");
            }
            this.dnsCacheHostStatusProcessed = true;
        }
    }

    private void checkDNSNameServerStatus() {
        if (!this.dnsNameServerStatusProcessed && this.dnsNameServerStatusCache != null && this.dnsNameServerStatusCache.isComplete()) {
            ArrayList<StatusDNSNameServerStatus2> dnsNameServerStatuses = this.dnsNameServerStatusCache.getStatusCache();
            for (StatusDNSNameServerStatus2 dnsNameServerStatus : dnsNameServerStatuses) {
                String ip = dnsNameServerStatus.getIPAddress();
                if (!ip.matches(this.ipSearchPattern)) continue;
                Appliance appliance = dnsNameServerStatus.getAppliance();
                Domain domain = dnsNameServerStatus.getSourceDomain();
                this.createAndNotify(appliance, domain, "DNSNameService", "DNSSettings", ip, "The Name Server IP from DNS Settings");
            }
            this.dnsNameServerStatusProcessed = true;
        }
    }

    private void checkDNSStaticHostStatus() {
        if (!this.dnsStaticHostStatusProcessed && this.dnsStaticHostStatusCache != null && this.dnsStaticHostStatusCache.isComplete()) {
            ArrayList<StatusDNSStaticHostStatus> dnsStaticHostStatuses = this.dnsStaticHostStatusCache.getStatusCache();
            for (StatusDNSStaticHostStatus dnsStaticHostStatus : dnsStaticHostStatuses) {
                String ip = dnsStaticHostStatus.getIPAddress();
                if (!ip.matches(this.ipSearchPattern)) continue;
                Appliance appliance = dnsStaticHostStatus.getAppliance();
                Domain domain = dnsStaticHostStatus.getSourceDomain();
                String hostName = dnsStaticHostStatus.getHostname();
                String type = dnsStaticHostStatus.getType();
                String objectType = type.equals("alias") ? "HostAlias" : type;
                this.createAndNotify(appliance, domain, objectType, hostName, ip, "The host IP from DNS Name Service");
            }
            this.dnsStaticHostStatusProcessed = true;
        }
    }

    private void checkIPAddressStatus() {
        if (!this.ipAddressStatusProcessed && this.ipAddressStatusCache != null && this.ipAddressStatusCache.isComplete()) {
            ArrayList<StatusIPAddressStatus> ipAddressStatuses = this.ipAddressStatusCache.getStatusCache();
            for (StatusIPAddressStatus ipAddressStatus : ipAddressStatuses) {
                String ip = ipAddressStatus.getIP();
                if (!ip.matches(this.ipSearchPattern)) continue;
                Appliance appliance = ipAddressStatus.getAppliance();
                Domain domain = ipAddressStatus.getSourceDomain();
                String name = ipAddressStatus.getName();
                this.createAndNotify(appliance, domain, "EthernetInterface", name, ip, "The IP from IP Address Status");
            }
            this.ipAddressStatusProcessed = true;
        }
    }

    private void checkTCPTableStatus() {
        if (!this.tcpTableProcessed && this.tcpTableCache != null && this.tcpTableCache.isComplete()) {
            ArrayList<StatusTCPTable> tcpTableCache = this.tcpTableCache.getStatusCache();
            UniqueArrayList<StatusTCPTable> tcpTableInfo = new UniqueArrayList<StatusTCPTable>();
            ArrayList<StatusTCPTable> looper = new ArrayList<StatusTCPTable>(tcpTableCache);
            for (StatusTCPTable status : looper) {
                status.setStatusTime(null);
                status.setLocalPort(0);
                status.setRemotePort(0);
                tcpTableInfo.add(status);
            }
            for (StatusTCPTable status : tcpTableInfo) {
                Domain domain;
                String localIP = status.getLocalIP();
                String remoteIP = status.getRemoteIP();
                Appliance appliance = status.getAppliance();
                Collection<Domain> domains = this.selectedDomains.get(appliance);
                if (!CollectionUtility.isNotEmpty(domains)) continue;
                String serviceDomain = status.getServiceDomain();
                Domain domain2 = domain = serviceDomain == null ? status.getSourceDomain() : appliance.getDomain(serviceDomain);
                if (!domains.contains(domain)) continue;
                String serviceClass = status.getServiceClass();
                if (serviceClass.equals("None")) {
                    serviceClass = "";
                }
                String service = status.getServiceName();
                if (localIP.matches(this.ipSearchPattern)) {
                    this.createAndNotify(appliance, domain, serviceClass, service, localIP, "The local IP from the TCP Table Status");
                }
                if (!remoteIP.matches(this.ipSearchPattern)) continue;
                this.createAndNotify(appliance, domain, serviceClass, service, localIP, "The remote IP from the TCP Table Status");
            }
            this.tcpTableProcessed = true;
        }
    }

    private void checkHostAliasConfig() {
        if (!this.hostAliasesProcessed && this.hostAliases != null) {
            for (ConfigHostAlias ha : this.hostAliases) {
                String ipAddress = ha.getIPAddress();
                if (!ipAddress.matches(this.ipSearchPattern)) continue;
                this.createAndNotify(ha.getAppliance(), ha.getSourceDomain(), ha.getConfigObjectType(), ha.getName(), ipAddress, "The Host from Host Alias Configurations");
            }
            this.hostAliasesProcessed = true;
        }
    }

    private void checkEthernetInterfacesConfig() {
        if (!this.ethernetInterfacesProcessed && this.ethernetInterfaces != null) {
            for (ConfigEthernetInterface eth : this.ethernetInterfaces) {
                ArrayList<StaticRoute> staticRoutes;
                ArrayList<String> secondaryVIPs;
                String virtualIP;
                ArrayList<String> secondaryIPs;
                String gateway;
                Appliance appliance = eth.getAppliance();
                Domain domain = eth.getSourceDomain();
                String ethType = eth.getConfigObjectType();
                String ethName = eth.getName();
                String primaryIP = eth.getIPAddress();
                if (primaryIP != null && primaryIP.matches(this.ipSearchPattern)) {
                    this.createAndNotify(appliance, domain, ethType, ethName, primaryIP, "Primary ethernet interface IP");
                }
                if ((gateway = eth.getDefaultGateway()) != null && gateway.matches(this.ipSearchPattern)) {
                    this.createAndNotify(appliance, domain, ethType, ethName, gateway, "The ethernet interface gateway IP");
                }
                if ((secondaryIPs = eth.getSecondaryAddress()) != null) {
                    for (String secondaryIP : secondaryIPs) {
                        if (!secondaryIP.matches(this.ipSearchPattern)) continue;
                        this.createAndNotify(appliance, domain, ethType, ethName, secondaryIP, "A secondary IP");
                    }
                }
                if ((virtualIP = eth.getVirtualIP()) != null && virtualIP.matches(this.ipSearchPattern)) {
                    this.createAndNotify(appliance, domain, ethType, ethName, virtualIP, "The primary Virtual (standby) IP");
                }
                if ((secondaryVIPs = eth.getSecondaryVirtualIP()) != null) {
                    for (String secondaryVIP : secondaryVIPs) {
                        if (!secondaryVIP.matches(this.ipSearchPattern)) continue;
                        this.createAndNotify(appliance, domain, ethType, ethName, secondaryVIP, "A secondary virtual (standby) IP");
                    }
                }
                if ((staticRoutes = eth.getStaticRoutes()) == null) continue;
                for (StaticRoute staticRoute : staticRoutes) {
                    String destination = staticRoute.getDestination();
                    if (destination.matches(this.ipSearchPattern)) {
                        this.createAndNotify(appliance, domain, ethType, ethName, destination, "Static Route Destination");
                    }
                    if (!(gateway = staticRoute.getGateway()).matches(this.ipSearchPattern)) continue;
                    this.createAndNotify(appliance, domain, ethType, ethName, destination, "Static Route Gateway");
                }
            }
            this.ethernetInterfacesProcessed = true;
        }
    }

    private void checkLBGStatus() {
        if (!this.lbgStatusProcessed && this.lbgCache.isComplete()) {
            HashSet<String> testedServers = new HashSet<String>();
            for (StatusLoadBalancerStatus2 lbgStatus : this.lbgCache.getStatusCache()) {
                String server = lbgStatus.getServer();
                if (IPAddress.isIPAddress(server)) {
                    if (!server.matches(this.ipSearchPattern)) continue;
                    ObjectReference<ConfigLoadBalancerGroup> ref = lbgStatus.getGroup();
                    this.createAndNotify(lbgStatus.getAppliance(), lbgStatus.getSourceDomain(), ref.getClassName(), ref.getName(), server, "Load Balancer Group Member");
                    continue;
                }
                if (testedServers.contains(server)) continue;
                testedServers.add(server);
                new AsynchMethodInvoker((Object)this, "testLBGServerByName", new Object[]{lbgStatus, server});
            }
            this.lbgStatusProcessed = true;
        }
    }

    @Reflected
    private void testLBGServerByName(StatusLoadBalancerStatus2 lbgStatus, String server) {
        AbstractTool.logger.finer(() -> LMG.log("(StatusLoadBalancerStatus2 lbgStatus, String server): Checking %s -> %s for server %s", () -> lbgStatus.getAppliance().getName(), () -> lbgStatus.getSourceDomain().getName(), () -> server));
        try {
            InetAddress[] ipAddresses;
            InetAddress[] inetAddressArray = ipAddresses = InetAddress.getAllByName(server);
            int n = ipAddresses.length;
            int n2 = 0;
            while (n2 < n) {
                InetAddress inetAddress = inetAddressArray[n2];
                String hostIP = inetAddress.getHostAddress();
                if (hostIP.matches(this.ipSearchPattern)) {
                    ObjectReference<ConfigLoadBalancerGroup> ref = lbgStatus.getGroup();
                    String ipInfo = String.format("Load Balancer Group Member - %s", server);
                    this.createAndNotify(lbgStatus.getAppliance(), lbgStatus.getSourceDomain(), ref.getClassName(), ref.getName(), hostIP, ipInfo);
                }
                ++n2;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        AbstractTool.logger.finer(() -> LMG.log("(StatusLoadBalancerStatus2 lbgStatus, String server): Checking %s -> %s for server %s", () -> lbgStatus.getAppliance().getName(), () -> lbgStatus.getSourceDomain().getName(), () -> server));
    }

    private void createAndNotify(Appliance appliance, Domain domain, String sourceObjectType, String sourceObjectName, String ipAddress, String ipInfo) {
        if (!CollectionUtility.isEmpty(this.ipInfoSubscribers)) {
            IPInfoBean ipInfoBean = new IPInfoBean(appliance, domain);
            ipInfoBean.setSourceObjectType(sourceObjectType);
            ipInfoBean.setSourceObjectName(sourceObjectName);
            ipInfoBean.setIpAddress(ipAddress);
            ipInfoBean.setIpInfo(ipInfo);
            for (IPInfoSubscriber subscriber : this.ipInfoSubscribers) {
                subscriber.processIPInfo(ipInfoBean);
            }
        }
    }
}

