/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.beans.JMBean;
import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.DataPowerStatusCache;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ManagementCommandError;
import com.kumbasoft.core.beans.ManagementCommandStatus;
import com.kumbasoft.core.beans.actions.ActionApplyPatch;
import com.kumbasoft.core.beans.status.StatusFirmwareVersion2;
import com.kumbasoft.core.tools.AbstractCommandProcessTool;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.ActionTool;
import com.kumbasoft.core.tools.DataPowerStatusMonitor;
import java.util.ArrayList;

public class FirmwareUpgrader
extends AbstractCommandProcessTool {
    private Appliance appliance;
    private String applianceName;
    private Domain defaultDomain;
    private String imageFileName;
    private StatusFirmwareVersion2 beginningFirmwareStatus;

    public FirmwareUpgrader(Appliance appliance, String imageFileName) {
        this.setAppliance(appliance);
        this.setImageFileName(imageFileName);
    }

    public Appliance getAppliance() {
        return this.appliance;
    }

    public void setAppliance(Appliance appliance) {
        if (appliance == null) {
            throw new NullPointerException("appliance cannot be null.");
        }
        this.appliance = appliance;
        this.applianceName = appliance.getName();
        this.defaultDomain = appliance.getDomain("default");
    }

    public String getImageFileName() {
        return this.imageFileName;
    }

    public void setImageFileName(String imageFileName) {
        if (StringUtility.isEmpty(imageFileName)) {
            throw new IllegalArgumentException("imageFileName cannot be empty");
        }
        if (!imageFileName.startsWith("image:")) {
            throw new IllegalArgumentException("imageFileName must exist within the 'image:' file store.");
        }
        this.imageFileName = imageFileName;
    }

    @Override
    public void performProcess() {
        AbstractTool.logger.fine(() -> LMG.log("():  Starting for %s.", () -> this.applianceName));
        this.beginningFirmwareStatus = this.getFirmwareVersion(1, KumbaCoreConstants.FIRMWARE_UPGRADE_CHECK_RETRY_RECHECK_DELAY);
        AbstractTool.logger.fine(() -> LMG.log("():  Applying firmware for %s.", () -> this.applianceName));
        this.applyFirmware();
        AbstractTool.logger.fine(() -> LMG.log("():  Waiting for appliance %s to go down.", () -> this.applianceName));
        this.waitForApplianceToGoDown();
        AbstractTool.logger.fine(() -> LMG.log("():  Waiting for appliance %s to come up.", () -> this.applianceName));
        this.waitForApplianceToComeUp();
        AbstractTool.logger.fine(() -> LMG.log("():  Verifying firmare on %s.", () -> this.applianceName));
        this.verifyFirmwareVersion();
        AbstractTool.logger.fine(() -> LMG.log("():  Completed for %s.", () -> this.applianceName));
    }

    private StatusFirmwareVersion2 getFirmwareVersion(int retryCount, int recheckInterval) {
        String loggerPrefix = String.format("(retryCount=%d, recheckInterval=%d)", retryCount, recheckInterval);
        AbstractTool.logger.fine(() -> LMG.log("%s:  Starting for %s", () -> loggerPrefix, () -> this.applianceName));
        SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
        DataPowerStatusCache statusCache = new DataPowerStatusCache();
        DataPowerStatusMonitor statusMonitor = new DataPowerStatusMonitor(this.appliance, this.defaultDomain, "FirmwareVersion2", 0L);
        statusMonitor.setRetryCount(retryCount);
        statusMonitor.setSleepInterval(recheckInterval);
        statusMonitor.addStatusListener(statusCache);
        statusMonitor.getProcessThread().addInvocationListener(stil);
        stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
        ManagementCommandStatus mcr = null;
        while (!statusCache.isComplete() && !statusCache.gotError()) {
            ThreadUtility.sleep(KumbaCoreConstants.FIRMWARE_UPGRADE_WAIT_SLEEP_TIME);
            if (mcr == null) {
                mcr = new ManagementCommandStatus(this.appliance, this.defaultDomain, "Waiting for firmware version", this, "Please wait...");
            }
            this.notifyManagementCommandSubscribers(mcr);
        }
        ArrayList firmwareVersionStatus = statusCache.getStatusCache();
        StatusFirmwareVersion2 firmwareVersion = (StatusFirmwareVersion2)firmwareVersionStatus.get(0);
        AbstractTool.logger.fine(() -> LMG.log("%s:  Current firmware version for %s: %s", () -> loggerPrefix, () -> this.applianceName, () -> firmwareVersion.getInstalledDPOS()));
        this.notifyManagementCommandSubscribers("Current Firmware Version", firmwareVersion.getInstalledDPOS(), false);
        return firmwareVersion;
    }

    private void applyFirmware() {
        AbstractTool.logger.config(() -> LMG.log("():  Applying Firmare to %s.", () -> this.applianceName));
        ActionApplyPatch actionApplyPatch = this.getActionObject();
        new ActionTool(this.appliance, (JMBean)actionApplyPatch);
        AbstractTool.logger.finer(() -> LMG.log("():  Completed on %s.", () -> this.applianceName));
    }

    private ActionApplyPatch getActionObject() {
        AbstractTool.logger.finer("(): Starting");
        ActionApplyPatch actionObject = new ActionApplyPatch();
        actionObject.setAcceptLicense("");
        AbstractTool.logger.finer(() -> LMG.log("(): Image File: '%s'", () -> this.imageFileName));
        if (this.imageFileName.startsWith("image:")) {
            int lastSlash = this.imageFileName.lastIndexOf(47);
            if (lastSlash == -1) {
                lastSlash = 5;
            }
            this.imageFileName = this.imageFileName.substring(lastSlash + 1);
        }
        AbstractTool.logger.finer(() -> LMG.log("(): Image File for Action Object: '%s'", () -> this.imageFileName));
        actionObject.setFile(this.imageFileName);
        AbstractTool.logger.finer("(): Done.  Returning action object");
        return actionObject;
    }

    private void waitForApplianceToGoDown() {
        ManagementCommandStatus mcr = new ManagementCommandStatus(this.appliance, this.defaultDomain, "Waiting for firmware to be applied and the appliance to reboot", this, "Please Wait...");
        while (this.appliance.isConnected()) {
            this.notifyManagementCommandSubscribers(mcr);
            ThreadUtility.sleep(KumbaCoreConstants.FIRMWARE_UPGRADE_APPLIANCE_DOWN_DELAY);
            mcr.setResultTime(new DateTime());
        }
        this.notifyManagementCommandSubscribers("Appliance is down", "OK", false);
    }

    private void waitForApplianceToComeUp() {
        ManagementCommandStatus mcr = new ManagementCommandStatus(this.appliance, this.defaultDomain, "Waiting for appliance to come back up", this, "Please Wait...");
        while (!this.appliance.isConnected()) {
            this.notifyManagementCommandSubscribers(mcr);
            ThreadUtility.sleep(KumbaCoreConstants.FIRMWARE_UPGRADE_APPLIANCE_DOWN_DELAY);
            mcr.setResultTime(new DateTime());
        }
        this.notifyManagementCommandSubscribers("Appliance is up", "OK", false);
    }

    private void verifyFirmwareVersion() {
        AbstractTool.logger.finer(() -> LMG.log("(): Checking for firmware status for %s.", () -> this.applianceName));
        while (true) {
            ManagementCommandStatus mcr = null;
            try {
                this.appliance.getDomain("default");
            }
            catch (IllegalStateException ise) {
                if (mcr == null) {
                    mcr = new ManagementCommandStatus(this.appliance, this.defaultDomain, "Waiting for default domain to be up", this, "Please Wait...");
                }
                this.notifyManagementCommandSubscribers(mcr);
                ThreadUtility.sleep(KumbaCoreConstants.FIRMWARE_UPGRADE_CHECK_RETRY_RECHECK_DELAY);
                continue;
            }
            break;
        }
        this.notifyManagementCommandSubscribers("Checking for upgrade completion", "Please wait...", false);
        StatusFirmwareVersion2 firmwareVersion = this.getFirmwareVersion(KumbaCoreConstants.FIRMWARE_UPGRADE_CHECK_RETRY_COUNT, KumbaCoreConstants.FIRMWARE_UPGRADE_CHECK_RETRY_RECHECK_DELAY);
        String installedDPOSBefore = this.beginningFirmwareStatus.getInstalledDPOS();
        String runningDPOSBefore = this.beginningFirmwareStatus.getRunningDPOS();
        String installedDPOSAfter = firmwareVersion.getInstalledDPOS();
        String runningDPOSAfter = firmwareVersion.getRunningDPOS();
        this.notifyManagementCommandSubscribers("Firmware After Application", installedDPOSAfter, false);
        boolean installedDPOSChanged = !installedDPOSBefore.equals(installedDPOSAfter);
        boolean runningDPOSChanged = !runningDPOSBefore.equals(runningDPOSAfter);
        boolean installedSameAsRunning = installedDPOSAfter.equals(runningDPOSAfter);
        if (!installedDPOSChanged) {
            AbstractTool.logger.config(() -> LMG.log("(): The installed DPOS did not change on %s", () -> this.applianceName));
            this.notifyManagementCommandSubscribers("Upgrade Firmware", "The installed DPOS did not change", true);
        } else if (!runningDPOSChanged) {
            AbstractTool.logger.config(() -> LMG.log("(): The running DPOS did not change on %s", () -> this.applianceName));
            this.notifyManagementCommandSubscribers("Upgrade Firmware", "The running DPOS did not change", true);
        } else if (!installedSameAsRunning) {
            AbstractTool.logger.config(() -> LMG.log("(): The installed DPOS does not match the running DPOS on %s", () -> this.applianceName));
            this.notifyManagementCommandSubscribers("Upgrade Firmware", "The installed DPOS does not match the running DPOS", true);
        } else {
            AbstractTool.logger.config(() -> LMG.log("(): Firmware installed successfully on %s", () -> this.applianceName));
            this.notifyManagementCommandSubscribers("Upgrade Firmware", "Firmware installed successfully", false);
        }
    }

    private void notifyManagementCommandSubscribers(String title, String message, boolean error) {
        if (error) {
            ManagementCommandError cmdError = new ManagementCommandError(this.appliance, this.defaultDomain, title, this, message);
            this.notifyManagementCommandSubscribers(cmdError);
        } else {
            ManagementCommandStatus cmdSuccess = new ManagementCommandStatus(this.appliance, this.defaultDomain, title, this, message);
            this.notifyManagementCommandSubscribers(cmdSuccess);
        }
    }
}

