/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.io.FileOutputStreamHelper;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.tools.AbstractTool;
import java.io.File;
import java.io.OutputStream;
import java.net.URL;
import java.security.cert.Certificate;
import javax.net.ssl.HttpsURLConnection;

public class GetCertificatesFromURL
extends AbstractTool {
    private String URL;
    private Certificate[] certificates;
    private File[] exportFiles;
    private Exception exception;

    public GetCertificatesFromURL(String URL2) {
        try {
            this.URL = GetCertificatesFromURL.fixupURL(URL2);
            AbstractTool.logger.finer(() -> LMG.log("(URL): %s fixed to %s", () -> URL2, () -> this.URL));
            URL destinationURL = new URL(this.URL);
            HttpsURLConnection conn = (HttpsURLConnection)destinationURL.openConnection();
            AbstractTool.logger.finer(() -> LMG.log("(URL): connecting to %s", () -> this.URL));
            conn.connect();
            this.certificates = conn.getServerCertificates();
            AbstractTool.logger.finer(() -> LMG.log("(URL): Retreived %d certificates from %s", () -> this.certificates.length, () -> this.URL));
            this.exportFiles = new File[this.certificates.length];
            int fileNo = 0;
            AbstractTool.logger.finer(() -> LMG.log("(URL): disconnecting from %s", () -> this.URL));
            conn.disconnect();
            Certificate[] certificateArray = this.certificates;
            if (this.certificates.length != 0) {
                Certificate cert = certificateArray[0];
                String tempFileName = File.createTempFile("DPAA", ".cer").getAbsolutePath();
                AbstractTool.logger.fine(() -> LMG.log("():  Temporary File Is: %s", () -> tempFileName));
                File file = new File(tempFileName);
                this.exportFiles[fileNo++] = file;
                FileOutputStreamHelper fw = new FileOutputStreamHelper(file, KumbaCoreConstants.FILE_READ_BUFFER_SIZE);
                OutputStream out = fw.open();
                out.write(cert.getEncoded());
                fw.close();
            }
        }
        catch (Exception e) {
            AbstractTool.logger.severe(() -> LMG.log("(URL): %s Exception getting certificates from %s\n\t%s", () -> e.getClass().getSimpleName(), () -> this.URL, () -> e.getMessage()));
            this.exception = e;
        }
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public Certificate[] getCertificates() {
        return this.certificates;
    }

    public File[] getExportFiles() {
        return this.exportFiles;
    }

    public Exception getException() {
        return this.exception;
    }

    private static String fixupURL(String url) {
        if (!url.toLowerCase().startsWith("https")) {
            url = String.format("https://%s", url);
        }
        return url;
    }
}

