/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.beans.JMBean;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.j2ee.xml.XMLElement;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.tools.AbstractDataPowerManagementRequest;
import com.kumbasoft.core.tools.AbstractTool;
import java.util.ArrayList;
import java.util.Collection;

public class GetConfiguration
extends AbstractDataPowerManagementRequest {
    private StatusObjectStatus dataPowerObject;
    private final String recursive = "false";
    private final String persisted = "false";
    private ArrayList<JMBean> dataPowerConfigs;
    private boolean complete;

    public GetConfiguration(StatusObjectStatus dataPowerObject) {
        super(dataPowerObject.getAppliance(), dataPowerObject.getSourceDomain(), String.format("Get Object Configuration for the %s %s from the %s domain of %s", dataPowerObject.getDataPowerClass(), dataPowerObject.getName(), dataPowerObject.getSourceDomain().getName(), dataPowerObject.getAppliance().getName()));
        this.dataPowerObject = dataPowerObject;
    }

    public GetConfiguration(Appliance appliance, Domain domain, String objectClass, String objectName) {
        super(appliance, domain, String.format("Get Object Configuration for the %s %s from the %s domain of %s", objectClass, objectName, domain.getName(), appliance.getName()));
        this.dataPowerObject = new StatusObjectStatus();
        this.dataPowerObject.setAppliance(appliance);
        this.dataPowerObject.setSourceDomain(domain);
        this.dataPowerObject.setDataPowerClass(objectClass);
        this.dataPowerObject.setName(objectName);
    }

    public boolean isComplete() {
        return this.complete;
    }

    public StatusObjectStatus getDataPowerObject() {
        return this.dataPowerObject;
    }

    String getRecursive() {
        return "false";
    }

    String getPersisted() {
        return "false";
    }

    public DataPowerConfig getDataPowerConfig() {
        if (CollectionUtility.isEmpty(this.dataPowerConfigs)) {
            return null;
        }
        return (DataPowerConfig)this.dataPowerConfigs.get(0);
    }

    @Override
    protected boolean processResultDocument(XMLElement rootElement) {
        AbstractTool.logger.finer("(XMLElement rootElement): Starting");
        boolean isValid = super.processResultDocument(rootElement);
        if (isValid) {
            this.dataPowerConfigs = CollectionUtility.createOrClear(this.dataPowerConfigs);
            Collection<XMLElement> dpConfigNodes = rootElement.getNodes("//dp:config");
            AbstractTool.logger.finer(() -> LMG.log("(XMLElement rootElement): Processing %d config nodes.", () -> dpConfigNodes.size()));
            for (XMLElement configNode : dpConfigNodes) {
                Collection<XMLElement> objectNodes = configNode.getNodes();
                for (XMLElement objectNode : objectNodes) {
                    JMBean configObject = (JMBean)ConfigurationManager.xmlToObject(this.getAppliance(), this.getDomain(), objectNode);
                    BeanService.setPropertyValue(configObject, "status", this.dataPowerObject);
                    this.dataPowerConfigs.add(configObject);
                }
            }
        }
        this.complete = true;
        AbstractTool.logger.finer("(XMLElement rootElement): Done");
        return isValid;
    }

    @Override
    protected String getSOMATemplateFileName() {
        return "GetObjectConfiguration.xml";
    }
}

