/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.io.ASCFileWriter;
import com.jmorgan.j2ee.xml.XMLElement;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigObjectSubscriber;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.tools.AbstractListFiles;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.ThreadManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;

public class ListFiles
extends AbstractListFiles {
    private static final String[] TEMPORARY_FILESTORE_PREFIXES = new String[]{"log/", "export/", "image/"};
    public static boolean staticListing = false;
    private static ArrayList<ListFiles> instances;
    private Collection<String> directories;
    private String fileNameMatchPattern;
    private boolean defaultDomainIncluded;

    private static ArrayList<String> getFileStoresFromDirectories(Collection<String> directories) {
        if (CollectionUtility.isEmpty(directories)) {
            return null;
        }
        UniqueArrayList<String> fileStores = new UniqueArrayList<String>();
        for (String directory : directories) {
            if (directory == null) continue;
            String fileStore = StringUtility.substringBefore(directory, ":") + ":";
            fileStores.add(fileStore);
        }
        return fileStores;
    }

    public static ArrayList<ListFiles> list(Index<Appliance, Domain> searchDomains, Collection<String> directories, String fileNameMatchPattern, MultiThreadInvocationListener mtil) {
        AbstractTool.logger.finer("(...): Starting");
        instances = CollectionUtility.createOrClear(instances);
        ArrayList<String> fileStores = ListFiles.getFileStoresFromDirectories(directories);
        AbstractTool.logger.finer("(...): Got file stores");
        if (StringUtility.isEmpty(fileNameMatchPattern)) {
            fileNameMatchPattern = ".*";
        }
        for (Appliance appliance : searchDomains.getKeys()) {
            AbstractTool.logger.finer(() -> LMG.log("(...): Listing files for '%s'", () -> appliance.getName()));
            ArrayList domains = (ArrayList)searchDomains.get(appliance);
            AbstractTool.logger.finer(() -> LMG.log("(...): Listing files for %d domains of '%s'", () -> domains.size(), () -> appliance.getName()));
            ListFiles listFiles = new ListFiles(appliance, domains, fileStores, directories, fileNameMatchPattern);
            AsynchMethodInvoker<Void> processThread = listFiles.getProcessThread();
            mtil.addThread(processThread);
            instances.add(listFiles);
        }
        AbstractTool.logger.finer(() -> LMG.log("(...): Done.  Produced %d instances.", () -> instances.size()));
        return instances;
    }

    public static void addConfigObjectSubscriber(ConfigObjectSubscriber<DataPowerFileInfo> subscriber) {
        if (instances == null) {
            return;
        }
        for (ListFiles instance : instances) {
            if (instance.getProcessThread().hasCompleted()) continue;
            instance.addConfigObjectSubscriber(DataPowerFileInfo.class, subscriber);
        }
    }

    private ListFiles(Appliance appliance, ArrayList<Domain> domains, Collection<String> fileStores, Collection<String> directories, String fileNameMatchPattern) {
        super(appliance, domains, fileStores);
        for (Domain domain : domains) {
            if (!domain.getName().equals("default")) continue;
            this.defaultDomainIncluded = true;
            break;
        }
        this.setDirectories(directories);
        this.setFileNameMatchPattern(fileNameMatchPattern);
        this.setLayoutOnly(false);
        this.processThread = ThreadManager.getThread(appliance, this, "processFileStore", KumbaCoreConstants.STARTUP_DELAY, null);
        this.processThread.addInvocationListener(this);
    }

    public ListFiles(Appliance appliance, Domain domain, String fileStore, String fileNameMatchPattern) {
        super(appliance, CollectionUtility.createListFrom(domain), CollectionUtility.createListFrom(fileStore));
        this.defaultDomainIncluded = domain.getName().equals("default");
        logger.finer(() -> LMG.log("(appliance=%s, domain=%s, fileStore=%s, fileNameMatchPattern='%s'):", () -> appliance.getName(), () -> domain.getName(), () -> fileStore, () -> fileNameMatchPattern));
        this.setFileNameMatchPattern(fileNameMatchPattern);
        this.processThread = ThreadManager.getThread(appliance, this, "processFileStore", KumbaCoreConstants.STARTUP_DELAY, null);
        this.processThread.addInvocationListener(this);
    }

    public Collection<String> getDirectories() {
        return this.directories;
    }

    public void setDirectories(Collection<String> directories) {
        this.directories = directories;
    }

    public String getFileNameMatchPattern() {
        return this.fileNameMatchPattern;
    }

    public void setFileNameMatchPattern(String fileNameMatch) {
        if (StringUtility.isEmpty((String)fileNameMatch) || ((String)fileNameMatch).trim().equals(".*")) {
            fileNameMatch = ".*";
        } else {
            if (!((String)fileNameMatch).startsWith(".*") && !((String)fileNameMatch).startsWith("^")) {
                fileNameMatch = ".*?" + (String)fileNameMatch;
            }
            if (!((String)fileNameMatch).endsWith(".*") && !((String)fileNameMatch).endsWith("$")) {
                fileNameMatch = (String)fileNameMatch + ".*";
            }
        }
        this.fileNameMatchPattern = fileNameMatch;
    }

    @Reflected
    private void processFileStore() {
        logger.finer("(): Starting");
        try {
            XMLElement rootElement = this.runRequest();
            if (rootElement == null) {
                logger.info("(): Empty Root Element after runRequest()");
                return;
            }
            if (logger.getLevel().equals(Level.FINEST)) {
                new ASCFileWriter("ListFiles.xml", rootElement.toString());
            }
            if (this.responseXML.contains("Authentication failure")) {
                logger.warning(() -> LMG.log("(): Authentication Failure Connecting to %s", () -> this.getAppliance().getName()));
                return;
            }
            ArrayList fileElements = (ArrayList)rootElement.getNodes("//file");
            logger.finer(() -> LMG.log("(): Processing %d files.", () -> fileElements.size()));
            for (XMLElement fileElement : fileElements) {
                this.processFile(fileElement);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        logger.finer("(): Done");
    }

    private void processFile(XMLElement fileElement) {
        boolean deleteable;
        boolean instrinsic;
        boolean readOnly;
        Appliance appliance;
        String fileDate;
        long fileSize;
        String FQFN;
        Domain fileDomain;
        String loggerPrefix;
        String fileName;
        String baseDirectory;
        block45: {
            block46: {
                block44: {
                    XMLElement parentElement = fileElement.getParentNode();
                    baseDirectory = parentElement.getAttributeValue("name");
                    if (AbstractListFiles.isTemporaryExempt(baseDirectory, this.domains)) {
                        return;
                    }
                    String referenceAttribute = parentElement.getAttributeValue("reference");
                    boolean isReferenced = referenceAttribute != null;
                    fileName = fileElement.getAttributeValue("name");
                    loggerPrefix = String.format("(XMLElement fileElement=%s/%s)", baseDirectory, fileName);
                    logger.finer(() -> LMG.log("%s: Processing file", () -> loggerPrefix));
                    if (!isReferenced && !this.defaultDomainIncluded) {
                        logger.finer(() -> LMG.log("%s: Skipping because it is not referenced and default is not included.", () -> loggerPrefix));
                        return;
                    }
                    fileDomain = this.appliance.getDomain("default");
                    if (fileDomain == null) {
                        logger.severe(() -> LMG.log("%s: Error.  Appliance %s doesn't have a 'default' domain.  Is it still up?", () -> loggerPrefix, () -> this.appliance.getName()));
                        fileDomain = new Domain("default");
                        this.appliance.addDomain(fileDomain);
                    }
                    String fileStore = StringUtility.substringBefore(baseDirectory, "/");
                    String relativeFilePath = StringUtility.substringAfter(baseDirectory, "/");
                    if (relativeFilePath.startsWith(fileStore)) {
                        relativeFilePath = relativeFilePath.replace(relativeFilePath, fileStore);
                    }
                    if (isReferenced) {
                        if (fileStore.equals("temporary:")) {
                            String[] stringArray = TEMPORARY_FILESTORE_PREFIXES;
                            int n = TEMPORARY_FILESTORE_PREFIXES.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object temporaryFileStorePrefix = stringArray[n2];
                                if (relativeFilePath.startsWith((String)temporaryFileStorePrefix)) {
                                    relativeFilePath = relativeFilePath.substring(((String)temporaryFileStorePrefix).length());
                                }
                                ++n2;
                            }
                        }
                        String actualDomainName = StringUtility.substringBefore(relativeFilePath, "/");
                        relativeFilePath = relativeFilePath.contains("/") ? StringUtility.substringAfter(relativeFilePath, "/") : "";
                        logger.finer(() -> LMG.log("%s: File is referenced. Actual domain is '%s'", () -> loggerPrefix, () -> actualDomainName));
                        fileDomain = this.appliance.getDomain(actualDomainName);
                        if (fileDomain == null) {
                            logger.warning(() -> LMG.log("%s: Actual domain '%s' does not map to an actual domain.  Add to TEMPORARY_FILESTORE_PREFIXES?", () -> loggerPrefix, () -> actualDomainName));
                        }
                        baseDirectory = String.format("%s/%s", fileStore, relativeFilePath);
                    }
                    String fileDomainName = fileDomain == null ? "--null--" : fileDomain.getName();
                    boolean matchesDomain = false;
                    for (Domain domain : this.domains) {
                        if (!fileDomainName.equals(domain.getName())) continue;
                        matchesDomain = true;
                        break;
                    }
                    if (!matchesDomain) {
                        logger.finer(() -> LMG.log("%s: Skipping because the domain '%s' is not in the list of domains.", () -> loggerPrefix, () -> fileDomainName));
                        return;
                    }
                    FQFN = String.format("%s/%s", baseDirectory, fileName);
                    logger.finer(() -> LMG.log("%s: Fully Qualified File Name = '%s'.  Does it match '%s'", () -> loggerPrefix, () -> FQFN, () -> this.fileNameMatchPattern));
                    if (!FQFN.matches(this.fileNameMatchPattern)) {
                        logger.finer(() -> LMG.log("%s: '%s' does not match %s.  Skipping.", () -> loggerPrefix, () -> FQFN, () -> this.fileNameMatchPattern));
                        return;
                    }
                    fileSize = Long.parseLong(fileElement.getNode("size").getValue());
                    fileDate = fileElement.getNode("modified").getValue();
                    appliance = this.getAppliance();
                    readOnly = false;
                    instrinsic = false;
                    deleteable = true;
                    if (!baseDirectory.startsWith("cert:")) break block44;
                    readOnly = true;
                    break block45;
                }
                if (!baseDirectory.startsWith("store:")) break block46;
                switch (baseDirectory) {
                    case "store:/dp/interop/": 
                    case "store:/dp/interop/xslt-test/": 
                    case "store:/dp/msgcat/": 
                    case "store:/meta/": 
                    case "store:/policies/mappings/": 
                    case "store:/dp/": 
                    case "store:/dp/interop/tx-test/": {
                        readOnly = true;
                        instrinsic = true;
                        deleteable = false;
                    }
                }
                break block45;
            }
            switch (baseDirectory) {
                case "tasktemplates:": 
                case "image:": 
                case "sharedcert:": 
                case "pubcert:": {
                    readOnly = true;
                }
            }
        }
        logger.finer(() -> LMG.log("%s: Notifying config object subscribers to '%s'", () -> loggerPrefix, () -> FQFN));
        DataPowerFileInfo dataPowerFileInfo = new DataPowerFileInfo(appliance, fileDomain, fileDate, fileSize, baseDirectory, fileName);
        dataPowerFileInfo.setIsReadOnly(readOnly);
        dataPowerFileInfo.setIsIntrinsic(instrinsic);
        dataPowerFileInfo.setDeleteable(deleteable);
        this.notifyConfigObjectSubscribers(dataPowerFileInfo);
        logger.finer(() -> LMG.log("%s: Done Processing file", () -> loggerPrefix));
    }
}

