/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.tools.AbstractDataPowerManagementRequest;

public class ModifyProperty<PropertyValueType>
extends AbstractDataPowerManagementRequest {
    private String objectType;
    private String objectName;
    private String propertyName;
    private PropertyValueType propertyValue;

    public ModifyProperty(Appliance appliance, Domain domain, String objectType, String objectName, String propertyName, PropertyValueType propertyValue) {
        super(appliance, domain, String.format("Set %s of %s %s to %s", propertyName, objectType, objectName, propertyValue));
        this.setObjectType(objectType);
        this.setObjectName(objectName);
        this.setPropertyName(propertyName);
        this.setPropertyValue(propertyValue);
    }

    public ModifyProperty(StatusObjectStatus objectStatus, String propertyName, PropertyValueType propertyValue) {
        this(objectStatus.getAppliance(), objectStatus.getSourceDomain(), objectStatus.getDataPowerClass(), objectStatus.getName(), propertyName, propertyValue);
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public String getObjectName() {
        String objectName = this.objectName;
        objectName = ConfigurationManager.getCorrectedObjectName(this.objectType, this.objectName);
        return objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public PropertyValueType getPropertyValue() {
        return this.propertyValue;
    }

    public void setPropertyValue(PropertyValueType propertyValue) {
        this.propertyValue = propertyValue;
    }
}

