/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.JMBean;
import com.jmorgan.beans.util.BeanIndexer;
import com.jmorgan.io.ASCFileReader;
import com.jmorgan.io.FileInputStreamHelper;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.CertificateInformation;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.SnapShotDiffListener;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.tools.AbstractCommandProcessTool;
import com.kumbasoft.core.util.CertificateReader;
import com.kumbasoft.core.util.FileUtility;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class SnapshotDiff
extends AbstractCommandProcessTool {
    private static final ArrayList<String> CERT_DIRECTORIES = new ArrayList();
    private Index<Appliance, Domain> domains;
    private String sourceDirectory;
    private String targetDirectory;
    private boolean compareObjects;
    private boolean compareFiles;
    private boolean compareCertificates;
    private String objectTypeExpression;
    private String objectNameExpression;
    private ArrayList<SnapShotDiffListener> diffListeners;
    private MultiThreadInvocationListener eventSync;

    static {
        String[] stringArray = DPEnumerations.FILE_STORE;
        int n = DPEnumerations.FILE_STORE.length;
        int n2 = 0;
        while (n2 < n) {
            String fileStore = stringArray[n2];
            if (fileStore.endsWith("cert:")) {
                CERT_DIRECTORIES.add(fileStore.replaceAll(":", ""));
            }
            ++n2;
        }
    }

    public SnapshotDiff(Index<Appliance, Domain> domains, String sourceDirectory, String targetDirectory) {
        this(domains, sourceDirectory, targetDirectory, ".*", ".*");
    }

    public SnapshotDiff(Index<Appliance, Domain> domains, String sourceDirectory, String targetDirectory, String objectTypeExpression, String objectNameExpression) {
        this(domains, sourceDirectory, targetDirectory, objectTypeExpression, objectNameExpression, true, true, true);
    }

    public SnapshotDiff(Index<Appliance, Domain> domains, String sourceDirectory, String targetDirectory, String objectTypeExpression, String objectNameExpression, boolean compareObjects, boolean compareFiles, boolean compareCertificates) {
        this.domains = domains;
        this.sourceDirectory = sourceDirectory;
        this.targetDirectory = targetDirectory;
        this.objectTypeExpression = objectTypeExpression;
        this.objectNameExpression = objectNameExpression;
        this.compareObjects = compareObjects;
        this.compareFiles = compareFiles;
        this.compareCertificates = compareCertificates;
    }

    public void addSnapShotDiffListener(SnapShotDiffListener listener) {
        if (listener == null) {
            return;
        }
        if (this.diffListeners == null) {
            this.diffListeners = new ArrayList();
        }
        this.diffListeners.add(listener);
    }

    @Override
    public void performProcess() {
        this.eventSync = new MultiThreadInvocationListener();
        File sourceDirectory = new File(this.sourceDirectory);
        File targetDirectory = new File(this.targetDirectory);
        for (Appliance appliance : this.domains.getKeys()) {
            this.processApplianceDirectory(appliance, sourceDirectory, targetDirectory);
        }
        this.eventSync.waitUntilComplete();
    }

    private void processApplianceDirectory(Appliance appliance, File sourceDirectory, File targetDirectory) {
        String applianceName = appliance.getName();
        File sourceApplianceDirectory = new File(sourceDirectory, applianceName);
        File targetApplianceDirectory = new File(targetDirectory, applianceName);
        for (Domain domain : this.domains.get(appliance)) {
            this.processDomainDirectory(appliance, domain, sourceApplianceDirectory, targetApplianceDirectory);
        }
    }

    private void processDomainDirectory(Appliance appliance, Domain domain, File sourceApplianceDirectory, File targetApplianceDirectory) {
        AsynchMethodInvoker t;
        String domainName = domain.getName();
        File sourceDomainDirectory = new File(sourceApplianceDirectory, domainName);
        File targetDomainDirectory = new File(targetApplianceDirectory, domainName);
        Object[] methodArgs = new Object[]{appliance, domain, sourceDomainDirectory, targetDomainDirectory};
        if (this.compareObjects) {
            t = new AsynchMethodInvoker((Object)this, "performConfigObjectDiff", methodArgs);
            this.eventSync.addThread(t);
        }
        if (this.compareFiles || this.compareCertificates) {
            t = new AsynchMethodInvoker((Object)this, "navigateFiles", methodArgs);
            this.eventSync.addThread(t);
        }
    }

    @Reflected
    private void navigateFiles(Appliance appliance, Domain domain, File sourceDomainDirectory, File targetDomainDirectory) {
        AsynchMethodInvoker t;
        File sourceFileSystemDirectory = new File(sourceDomainDirectory, "datapower-file-system");
        File targetFileSystemDirectory = new File(targetDomainDirectory, "datapower-file-system");
        Object[] methodArgs = new Object[]{appliance, domain, sourceFileSystemDirectory, targetFileSystemDirectory};
        if (this.compareFiles) {
            t = new AsynchMethodInvoker((Object)this, "performFileDiff", methodArgs);
            this.eventSync.addThread(t);
        }
        if (this.compareCertificates) {
            t = new AsynchMethodInvoker((Object)this, "performCertificateDiff", methodArgs);
            this.eventSync.addThread(t);
        }
    }

    @Reflected
    private void performFileDiff(Appliance appliance, Domain domain, File sourceFileSystemDirectory, File targetFileSystemDirectory) {
        logger.finer(() -> LMG.log("(appliance='%s', domain='%s',\n\t\tsourceFileSystemDirectory='%s',\n\t\ttargetFileSystemDirectory='%s'):\n\t\t\tStarting.", () -> appliance.getName(), () -> domain.getName(), () -> sourceFileSystemDirectory.getAbsolutePath(), () -> targetFileSystemDirectory.getAbsolutePath()));
        ArrayList<File> sourceFileSystemFiles = SnapshotDiff.getFiles(sourceFileSystemDirectory);
        ArrayList<File> targetFileSystemFiles = SnapshotDiff.getFiles(targetFileSystemDirectory);
        logger.finer(() -> LMG.log("(appliance='%s', domain='%s',\n\t\tsourceFileSystemDirectory='%s',\n\t\ttargetFileSystemDirectory='%s'):\n\t\t\tFound %d source files and %d target files..", () -> appliance.getName(), () -> domain.getName(), () -> sourceFileSystemDirectory.getAbsolutePath(), () -> targetFileSystemDirectory.getAbsolutePath(), () -> sourceFileSystemFiles.size(), () -> targetFileSystemFiles.size()));
        BeanIndexer<File> targetFileIndexer = new BeanIndexer<File>(targetFileSystemFiles);
        HashMap<String, File> targetFileMap = targetFileIndexer.getMapOf("name", "");
        for (File sourceFile : sourceFileSystemFiles) {
            String sourceFileName = sourceFile.getName();
            if (sourceFileName.equals("chkpoints") || sourceFileName.equals("export") || Comparison.isIn(sourceFileName, CERT_DIRECTORIES)) {
                logger.finer(() -> LMG.log("(appliance='%s', domain='%s',\n\t\tsourceFileSystemDirectory='%s',\n\t\ttargetFileSystemDirectory='%s'):\n\t\t\tNot processing ignored directory '%s'.", () -> appliance.getName(), () -> domain.getName(), () -> sourceFileSystemDirectory.getAbsolutePath(), () -> targetFileSystemDirectory.getAbsolutePath(), () -> sourceFileName));
                continue;
            }
            File targetFile = targetFileMap.get(sourceFileName);
            if (targetFile != null) {
                targetFileSystemFiles.remove(targetFile);
                logger.finer(() -> LMG.log("(appliance='%s', domain='%s',\n\t\tsourceFileSystemDirectory='%s',\n\t\ttargetFileSystemDirectory='%s'):\n\t\t\t.Found target file matching source '%s'", () -> appliance.getName(), () -> domain.getName(), () -> sourceFileSystemDirectory.getAbsolutePath(), () -> targetFileSystemDirectory.getAbsolutePath(), () -> sourceFileName));
            } else {
                logger.finer(() -> LMG.log("(appliance='%s', domain='%s',\n\t\tsourceFileSystemDirectory='%s',\n\t\ttargetFileSystemDirectory='%s'):\n\t\t\t.No target file matching source '%s'", () -> appliance.getName(), () -> domain.getName(), () -> sourceFileSystemDirectory.getAbsolutePath(), () -> targetFileSystemDirectory.getAbsolutePath(), () -> sourceFileName));
            }
            if (sourceFile.isDirectory()) {
                if (targetFile == null) {
                    this.processSourceDirectoryToNonExistentTargets(appliance, domain, sourceFile, true);
                    continue;
                }
                this.performFileDiff(appliance, domain, sourceFile, targetFile);
                continue;
            }
            boolean cmp = SnapshotDiff.compareFiles(sourceFile, targetFile);
            if (cmp) continue;
            String sourceFileDirectory = SnapshotDiff.getDataPowerFileDirectory(sourceFile);
            String targetFileDirectory = SnapshotDiff.getDataPowerFileDirectory(targetFile);
            if (targetFileDirectory == null) {
                targetFileDirectory = sourceFileDirectory;
            }
            DataPowerFileInfo sourceFileInfo = new DataPowerFileInfo(appliance, domain, this.sourceDirectory, sourceFile.length(), sourceFileDirectory, sourceFile.getName());
            sourceFileInfo.setLocalFile(sourceFile);
            sourceFileInfo.setFileContent(SnapshotDiff.readFile(sourceFile));
            DataPowerConfig targetFileInfo = null;
            if (targetFile != null) {
                targetFileInfo = new DataPowerFileInfo(appliance, domain, this.targetDirectory, targetFile.length(), targetFileDirectory, targetFile.getName());
                ((DataPowerFileInfo)targetFileInfo).setLocalFile(targetFile);
                ((DataPowerFileInfo)targetFileInfo).setFileContent(SnapshotDiff.readFile(targetFile));
            }
            String targetFileName = targetFile == null ? "--null--" : targetFileInfo.getFQON();
            logger.finer(() -> LMG.log("(appliance='%s', domain='%s',\n\t\tsourceFileSystemDirectory='%s',\n\t\ttargetFileSystemDirectory='%s'):\n\t\t\t.Showing Differences from '%s' to '%s'", () -> appliance.getName(), () -> domain.getName(), () -> sourceFileSystemDirectory.getAbsolutePath(), () -> targetFileSystemDirectory.getAbsolutePath(), () -> sourceFileInfo.getFQON(), () -> targetFileName));
            this.notifyDiffListeners(sourceFileInfo, (DataPowerFileInfo)targetFileInfo);
        }
        for (File targetFile : targetFileSystemFiles) {
            if (!targetFile.exists()) {
                logger.finer(() -> LMG.log("(appliance='%s', domain='%s',\n\t\tsourceFileSystemDirectory='%s',\n\t\ttargetFileSystemDirectory='%s'):\n\t\t\tSkipping non-existent target '%s'.", () -> appliance.getName(), () -> domain.getName(), () -> sourceFileSystemDirectory.getAbsolutePath(), () -> targetFileSystemDirectory.getAbsolutePath(), () -> targetFile.getAbsolutePath()));
                continue;
            }
            String targetFileName = targetFile.getName();
            if (targetFileName.equals("chkpoints") || targetFileName.equals("export") || Comparison.isIn(targetFileName, CERT_DIRECTORIES)) {
                logger.finer(() -> LMG.log("(appliance='%s', domain='%s',\n\t\tsourceFileSystemDirectory='%s',\n\t\ttargetFileSystemDirectory='%s'):\n\t\t\tSkiping ignored directory '%s'.", () -> appliance.getName(), () -> domain.getName(), () -> sourceFileSystemDirectory.getAbsolutePath(), () -> targetFileSystemDirectory.getAbsolutePath(), () -> targetFileName));
                continue;
            }
            if (targetFile.isDirectory()) {
                logger.finer(() -> LMG.log("(appliance='%s', domain='%s',\n\t\tsourceFileSystemDirectory='%s',\n\t\ttargetFileSystemDirectory='%s'):\n\t\t\tProcessing missing source directory to target '%s'.", () -> appliance.getName(), () -> domain.getName(), () -> sourceFileSystemDirectory.getAbsolutePath(), () -> targetFileSystemDirectory.getAbsolutePath(), () -> targetFile.getAbsolutePath()));
                this.processSourceDirectoryToNonExistentTargets(appliance, domain, targetFileSystemDirectory, false);
                continue;
            }
            String targetFileDirectory = SnapshotDiff.getDataPowerFileDirectory(targetFile);
            DataPowerFileInfo targetFileInfo = new DataPowerFileInfo(appliance, domain, this.targetDirectory, targetFile.length(), targetFileDirectory, targetFile.getName());
            targetFileInfo.setLocalFile(targetFile);
            targetFileInfo.setFileContent(SnapshotDiff.readFile(targetFile));
            logger.finer(() -> LMG.log("(appliance='%s', domain='%s',\n\t\tsourceFileSystemDirectory='%s',\n\t\ttargetFileSystemDirectory='%s'):\n\t\t\tNotifying for null source to target '%s'.", () -> appliance.getName(), () -> domain.getName(), () -> sourceFileSystemDirectory.getAbsolutePath(), () -> targetFileSystemDirectory.getAbsolutePath(), () -> targetFileInfo.getFQON()));
            this.notifyDiffListeners(null, targetFileInfo);
        }
        logger.finer(() -> LMG.log("(appliance='%s', domain='%s',\n\t\tsourceFileSystemDirectory='%s',\n\t\ttargetFileSystemDirectory='%s'):\n\t\t\tDone.", () -> appliance.getName(), () -> domain.getName(), () -> sourceFileSystemDirectory.getAbsolutePath(), () -> targetFileSystemDirectory.getAbsolutePath()));
    }

    private static String getDataPowerFileDirectory(File file) {
        String slash;
        if (file == null) {
            return null;
        }
        String absolutePath = file.getAbsolutePath();
        String fsRoot = StringUtility.substringAfter(absolutePath, "datapower-file-system" + File.separator);
        String fqfn = fsRoot.replaceFirst(slash = File.separator.equals("\\") ? "\\\\" : File.separator, ":/");
        int lastSlash = fqfn.lastIndexOf(File.separatorChar);
        if (lastSlash == -1) {
            return "";
        }
        Object fileDirectory = StringUtility.getLeftSubstring(fqfn, lastSlash) + "/";
        fileDirectory = ((String)fileDirectory).replace('\\', '/');
        return fileDirectory;
    }

    private static ArrayList<File> getFiles(File directory) {
        File[] files = null;
        files = directory.exists() && directory.isDirectory() ? directory.listFiles() : new File[]{};
        return new ArrayList<File>(Arrays.asList(files));
    }

    private void processSourceDirectoryToNonExistentTargets(Appliance appliance, Domain domain, File directory, boolean sourceToTarget) {
        File[] files;
        File[] fileArray = files = directory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                this.processSourceDirectoryToNonExistentTargets(appliance, domain, file, sourceToTarget);
            } else {
                String directoryName = SnapshotDiff.getDataPowerFileDirectory(directory);
                String dateDir = sourceToTarget ? this.sourceDirectory : this.targetDirectory;
                DataPowerFileInfo fileInfo = new DataPowerFileInfo(appliance, domain, dateDir, file.length(), directoryName, file.getName());
                fileInfo.setLocalFile(file);
                fileInfo.setFileContent(SnapshotDiff.readFile(file));
                if (sourceToTarget) {
                    this.notifyDiffListeners(fileInfo, null);
                } else {
                    this.notifyDiffListeners(null, fileInfo);
                }
            }
            ++n2;
        }
    }

    private static boolean compareFiles(File source, File target) {
        long targetLength;
        if (source == null && target == null) {
            return true;
        }
        if (source == null && target != null) {
            return false;
        }
        if (source != null && target == null) {
            return false;
        }
        if (!source.exists() && !target.exists()) {
            return true;
        }
        if (source.exists() && !target.exists()) {
            return false;
        }
        if (!source.exists() && target.exists()) {
            return false;
        }
        long sourceLength = source.length();
        if (sourceLength != (targetLength = target.length())) {
            return false;
        }
        FileInputStreamHelper sourceFin = new FileInputStreamHelper(source);
        InputStream sourceIn = sourceFin.open();
        if (sourceIn == null) {
            return false;
        }
        FileInputStreamHelper targetFin = new FileInputStreamHelper(target);
        InputStream targetIn = targetFin.open();
        if (targetIn == null) {
            sourceFin.close();
            return false;
        }
        try {
            long i = 0L;
            while (i < sourceLength) {
                int targetByte;
                int sourceByte = sourceIn.read();
                if (sourceByte != (targetByte = targetIn.read())) {
                    long byteIndex = i;
                    logger.warning(() -> LMG.log("(source=%s[%d], target=%s[%d]):  %d != %d at %d\n", () -> source.getAbsolutePath(), () -> source.length(), () -> target.getAbsolutePath(), () -> target.length(), () -> sourceByte, () -> targetByte, () -> byteIndex));
                    return false;
                }
                try {
                    ++i;
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        finally {
            sourceFin.close();
            targetFin.close();
        }
        return true;
    }

    private static String readFile(File file) {
        try {
            String data = FileUtility.readFile(file);
            return data;
        }
        catch (IOException e) {
            e.printStackTrace();
            return String.format("*** Error reading %s ***", file.getAbsolutePath());
        }
    }

    @Reflected
    private void performCertificateDiff(Appliance appliance, Domain domain, File sourceFileSystemDirectory, File targetFileSystemDirectory) {
        for (String certDir : CERT_DIRECTORIES) {
            File sourceCertDirectory = new File(sourceFileSystemDirectory, certDir);
            File[] sourceCertFiles = SnapshotDiff.getFilesInDirectory(sourceCertDirectory);
            ArrayList<File> matchingSourceCertFiles = this.getMatchingCertificates(sourceCertFiles);
            File targetCertDirectory = new File(targetFileSystemDirectory, certDir);
            File[] targetCertFiles = SnapshotDiff.getFilesInDirectory(targetCertDirectory);
            ArrayList<File> matchingTargetCertFiles = this.getMatchingCertificates(targetCertFiles);
            BeanIndexer<File> mapper = new BeanIndexer<File>(matchingTargetCertFiles);
            HashMap<String, File> targetNameMap = mapper.getMapOf("name", "");
            CertificateReader certificateReader = new CertificateReader();
            for (File sourceCertFile : matchingSourceCertFiles) {
                String sourceCertFileName = sourceCertFile.getAbsolutePath();
                X509Certificate sourceCertificate = (X509Certificate)certificateReader.readCertificate(sourceCertFileName);
                CertificateInformation sourceCertInfo = new CertificateInformation(appliance, domain, sourceCertFileName, sourceCertificate);
                String certBaseName = sourceCertFile.getName();
                sourceCertInfo.setCertificateObjectName(certBaseName);
                File targetCertFile = targetNameMap.get(sourceCertFile.getName());
                if (targetCertFile == null) {
                    this.notifyDiffListeners(sourceCertInfo, null);
                } else {
                    X509Certificate targetCertificate = (X509Certificate)certificateReader.readCertificate(targetCertFile);
                    if (!sourceCertificate.equals(targetCertificate)) {
                        CertificateInformation targetCertInfo = new CertificateInformation(appliance, domain, targetCertFile.getAbsolutePath(), targetCertificate);
                        targetCertInfo.setCertificateObjectName(targetCertFile.getName());
                        this.notifyDiffListeners(sourceCertInfo, targetCertInfo);
                    }
                }
                matchingTargetCertFiles.remove(targetCertFile);
            }
            for (File targetCertFile : matchingTargetCertFiles) {
                String targetCertFileName = targetCertFile.getAbsolutePath();
                X509Certificate targetCertificate = (X509Certificate)certificateReader.readCertificate(targetCertFileName);
                CertificateInformation targetCertInfo = new CertificateInformation(appliance, domain, targetCertFileName, targetCertificate);
                targetCertInfo.setCertificateObjectName(targetCertFile.getName());
                this.notifyDiffListeners(null, targetCertInfo);
            }
        }
    }

    private ArrayList<File> getMatchingCertificates(File[] files) {
        ArrayList<File> matchingCerts = new ArrayList<File>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String name = file.getName();
            if (name.matches(this.objectNameExpression)) {
                matchingCerts.add(file);
            }
            ++n2;
        }
        return matchingCerts;
    }

    @Reflected
    private void performConfigObjectDiff(Appliance appliance, Domain domain, File sourceDomainDirectory, File targetDomainDirectory) {
        File[] sourceObjectTypeDirectories = SnapshotDiff.getFilesInDirectory(sourceDomainDirectory);
        File[] targetObjectTypeDirectories = SnapshotDiff.getFilesInDirectory(targetDomainDirectory);
        ArrayList<File> sourceTypeDirectories = this.getMatchingTypeDirectories(sourceObjectTypeDirectories);
        ArrayList<File> targetTypeDirectories = this.getMatchingTypeDirectories(targetObjectTypeDirectories);
        this.processTypes(appliance, domain, sourceTypeDirectories, targetTypeDirectories);
    }

    private void processTypes(Appliance appliance, Domain domain, ArrayList<File> sourceTypeDirectories, ArrayList<File> targetTypeDirectories) {
        HashMap<String, File> sourceTypeMap = SnapshotDiff.getFilesByName(sourceTypeDirectories);
        HashMap<String, File> targetTypeMap = SnapshotDiff.getFilesByName(targetTypeDirectories);
        for (String sourceTypeName : sourceTypeMap.keySet()) {
            if (!sourceTypeName.matches(this.objectTypeExpression)) continue;
            File targetTypeDirectory = targetTypeMap.get(sourceTypeName);
            File sourceTypeDirectory = sourceTypeMap.get(sourceTypeName);
            if (targetTypeDirectory == null) {
                String sourceTypeDirectoryName = sourceTypeDirectory.getAbsolutePath();
                String targetTypeDirectoryName = sourceTypeDirectoryName.replace(this.sourceDirectory, this.targetDirectory);
                targetTypeDirectory = new File(targetTypeDirectoryName);
            }
            if (!sourceTypeDirectory.isDirectory()) continue;
            this.processObjects(appliance, domain, sourceTypeDirectory, targetTypeDirectory);
        }
    }

    private void processObjects(Appliance appliance, Domain domain, File sourceTypeDirectory, File targetTypeDirectory) {
        File[] sourceObjectFiles = sourceTypeDirectory.listFiles();
        File[] targetObjectFiles = targetTypeDirectory.listFiles();
        HashMap<String, File> sourceObjectNameMap = this.getObjectNameMap(sourceObjectFiles);
        HashMap<String, File> targetObjectNameMap = this.getObjectNameMap(targetObjectFiles);
        try {
            for (String objectName : sourceObjectNameMap.keySet()) {
                File sourceFile = sourceObjectNameMap.get(objectName);
                if (sourceFile.isDirectory()) continue;
                ASCFileReader sourceReader = new ASCFileReader(sourceFile);
                String sourceData = sourceReader.readAll();
                File targetFile = targetObjectNameMap.get(objectName);
                if (targetFile == null) {
                    ArrayList<JMBean> sourceObjects = ConfigurationManager.xmlToObjects(appliance, domain, sourceData);
                    DataPowerConfig sourceObject = (DataPowerConfig)sourceObjects.get(0);
                    this.notifyDiffListeners(sourceObject, null);
                    continue;
                }
                try {
                    ASCFileReader targetReader = new ASCFileReader(targetFile);
                    String targetData = targetReader.readAll();
                    if (sourceData.hashCode() == targetData.hashCode()) continue;
                    DataPowerConfig sourceObject = null;
                    ArrayList<JMBean> sourceObjects = ConfigurationManager.xmlToObjects(appliance, domain, sourceData);
                    if (CollectionUtility.isNotEmpty(sourceObjects)) {
                        sourceObject = (DataPowerConfig)sourceObjects.get(0);
                    }
                    DataPowerConfig targetObject = null;
                    ArrayList<JMBean> targetObjects = ConfigurationManager.xmlToObjects(appliance, domain, targetData);
                    if (CollectionUtility.isNotEmpty(targetObjects)) {
                        targetObject = (DataPowerConfig)targetObjects.get(0);
                    }
                    this.notifyDiffListeners(sourceObject, targetObject);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private HashMap<String, File> getObjectNameMap(File[] sources) {
        HashMap<String, File> nameMap = new HashMap<String, File>();
        if (sources == null) {
            return nameMap;
        }
        File[] fileArray = sources;
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            File source = fileArray[n2];
            String fileName = source.getName();
            if ((fileName = StringUtility.substringBefore(fileName, ".xml")).matches(this.objectNameExpression)) {
                nameMap.put(fileName, source);
            }
            ++n2;
        }
        return nameMap;
    }

    private static HashMap<String, File> getFilesByName(ArrayList<File> files) {
        BeanIndexer<File> indexer = new BeanIndexer<File>(files);
        HashMap<Object, File> index = indexer.getMapOf("name", null);
        return index;
    }

    private ArrayList<File> getMatchingTypeDirectories(File[] objectTypeDirectories) {
        ArrayList<File> matchingTypeDirectories = new ArrayList<File>();
        File[] fileArray = objectTypeDirectories;
        int n = objectTypeDirectories.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String name = file.getName();
            if (!name.equals("all-classes") && !name.equals("datapower-file-system") && name.matches(this.objectTypeExpression)) {
                matchingTypeDirectories.add(file);
            }
            ++n2;
        }
        return matchingTypeDirectories;
    }

    private static File[] getFilesInDirectory(File directory) {
        File[] fileList = null;
        fileList = directory.exists() ? directory.listFiles() : new File[]{};
        return fileList;
    }

    private void notifyDiffListeners(DataPowerConfig source, DataPowerConfig target) {
        if (CollectionUtility.isEmpty(this.diffListeners)) {
            return;
        }
        for (SnapShotDiffListener listener : this.diffListeners) {
            listener.setObjectDifference(source, target);
        }
    }

    private void notifyDiffListeners(DataPowerFileInfo source, DataPowerFileInfo target) {
        if (CollectionUtility.isEmpty(this.diffListeners)) {
            return;
        }
        if (source == null && target == null) {
            return;
        }
        for (SnapShotDiffListener listener : this.diffListeners) {
            listener.setFileDifference(source, target);
        }
    }

    private void notifyDiffListeners(CertificateInformation source, CertificateInformation target) {
        if (CollectionUtility.isEmpty(this.diffListeners)) {
            return;
        }
        for (SnapShotDiffListener listener : this.diffListeners) {
            listener.setCertificateDifference(source, target);
        }
    }
}

