/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.beans.util.BeanIndexer;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.CertificateInformation;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ManagementCommandSubscriber;
import com.kumbasoft.core.beans.config.ConfigCryptoCertificate;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.FileUploader;
import com.kumbasoft.core.tools.ModifyProperty;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.util.DataPowerFileUtility;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;

public class UploadCertificate
extends AbstractTool {
    private ManagementCommandSubscriber managementCommandSubscriber;
    private HashMap<Appliance, Index<Domain, ConfigCryptoCertificate>> objectMap;

    public UploadCertificate(HashMap<Appliance, Index<Domain, ConfigCryptoCertificate>> objectMap, ManagementCommandSubscriber managementCommandSubscriber) {
        this.objectMap = objectMap;
        this.managementCommandSubscriber = managementCommandSubscriber;
    }

    public void uploadCert(CertificateInformation certInfo, File localFile) {
        String fileName;
        Domain uploadDomain;
        Appliance uploadAppliance = certInfo.getAppliance();
        Domain certDomain = uploadDomain = certInfo.getDomain();
        String certificateObjectName = certInfo.getCertificateObjectName();
        AbstractTool.logger.finer(() -> LMG.log("(certInfo, localFileName=%s):  Starting for %s->%s->%s.", () -> localFile.getAbsolutePath(), () -> uploadAppliance.getName(), () -> certDomain.getName(), () -> certificateObjectName));
        String fullFileName = StringUtility.coalesce(certInfo.getFileName(), "/");
        int colon = fullFileName.indexOf(58) + 1;
        String baseDirectory = fullFileName.substring(0, colon);
        String fileName1F = fileName = fullFileName.substring(colon + 1);
        AbstractTool.logger.fine(() -> LMG.log("(certInfo, localFileName=%s):  Base Directory for %s->%s->%s is %s, and file name is %s.", () -> localFile.getAbsolutePath(), () -> uploadAppliance.getName(), () -> certDomain.getName(), () -> certificateObjectName, () -> baseDirectory, () -> fileName1F));
        if (StringUtility.isEmpty(fileName)) {
            fileName = String.format("dpaa_%s.cer", certificateObjectName);
            ModifyProperty<String> modifyProperty = new ModifyProperty<String>(certInfo.getAppliance(), certInfo.getDomain(), "CryptoCertificate", certInfo.getCertificateObjectName(), "Filename", fileName);
            modifyProperty.addManagementCommandSubscriber(this.managementCommandSubscriber);
            String fileName2F = fileName;
            AbstractTool.logger.fine(() -> LMG.log("(certInfo, localFileName=%s):  Dynamically created file name for %s->%s->%s, Base Directory is %s, and file name is %s.", () -> localFile.getAbsolutePath(), () -> uploadAppliance.getName(), () -> certDomain.getName(), () -> certificateObjectName, () -> baseDirectory, () -> fileName2F));
        }
        if (Comparison.isIn(baseDirectory, DataPowerFileUtility.DEFAULT_DOMAIN_FILESTORES) && (uploadDomain = uploadAppliance.getDomain("default")) == null) {
            uploadDomain = new Domain("default");
            uploadAppliance.addDomain(uploadDomain);
        }
        String uploadDomainName = uploadDomain.getName();
        String finalUploadFileName = fileName;
        AbstractTool.logger.config(() -> LMG.log("(certInfo, localFileName=%s):  Uploading Certificate file to %s->%s->%s->%s->%s", () -> localFile.getAbsolutePath(), () -> uploadAppliance.getName(), () -> uploadDomainName, () -> certificateObjectName, () -> baseDirectory, () -> finalUploadFileName));
        DataPowerFileInfo dpFileInfo = new DataPowerFileInfo(uploadAppliance, uploadDomain, null, localFile.length(), baseDirectory, fileName);
        dpFileInfo.setLocalFile(localFile);
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        FileUploader.upload(CollectionUtility.createListFrom(dpFileInfo), mtil);
        FileUploader.addCommandSubscriber(this.managementCommandSubscriber);
        ThreadManager.monitorAsynchThreadLifeCycle("ManageCertificatesPanel.uploadCert(...)", mtil, KumbaCoreConstants.THREAD_WAIT, 0);
        AbstractTool.logger.finer(() -> LMG.log("(certInfo, localFileName=%s):  Certificate file upload complete %s->%s->%s->%s->%s.", () -> localFile.getAbsolutePath(), () -> uploadAppliance.getName(), () -> uploadDomainName, () -> certificateObjectName, () -> baseDirectory, () -> finalUploadFileName));
        Index<Domain, ConfigCryptoCertificate> certsByAppliance = this.objectMap.get(uploadAppliance);
        Collection<ConfigCryptoCertificate> certsByDomain = certsByAppliance.get(certDomain);
        BeanIndexer<ConfigCryptoCertificate> certsByNameIndexer = new BeanIndexer<ConfigCryptoCertificate>(certsByDomain);
        HashMap<String, ConfigCryptoCertificate> certsByName = certsByNameIndexer.getMapOf("name", "");
        ConfigCryptoCertificate certObject = certsByName.get(certificateObjectName);
        String adminState = certObject.getAdminState();
        String inverseAdminState = adminState.equals("enabled") ? "disabled" : "enabled";
        AbstractTool.logger.fine(() -> LMG.log("(certInfo, localFileName=%s):  Toggling Admin State for %s->%s->%s.", () -> localFile.getAbsolutePath(), () -> uploadAppliance.getName(), () -> uploadDomainName, () -> certificateObjectName));
        this.setAdminState(certInfo, inverseAdminState);
        this.setAdminState(certInfo, adminState);
        AbstractTool.logger.finer(() -> LMG.log("(certInfo, localFileName=%s):  Done for %s->%s->%s.", () -> localFile.getAbsolutePath(), () -> certInfo.getAppliance().getName(), () -> certInfo.getDomain().getName(), () -> certInfo.getCertificateObjectName()));
    }

    private void setAdminState(CertificateInformation certInfo, String adminState) {
        ModifyProperty<String> modifyProperty = new ModifyProperty<String>(certInfo.getAppliance(), certInfo.getDomain(), "CryptoCertificate", certInfo.getCertificateObjectName(), "mAdminState", adminState);
        modifyProperty.addManagementCommandSubscriber(this.managementCommandSubscriber);
    }
}

