/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.beans.util.BeanIndexer;
import com.jmorgan.j2ee.xml.XMLElement;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.util.Index;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreApplicationProperties;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ManagementCommandError;
import com.kumbasoft.core.beans.ManagementCommandStatus;
import com.kumbasoft.core.beans.ManagementCommandSubscriber;
import com.kumbasoft.core.beans.config.ConfigCryptoCertificate;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.tools.AbstractDataPowerManagementRequest;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.CertificateExportSubscriber;
import com.kumbasoft.core.tools.DataPowerXMLManagement;
import com.kumbasoft.core.util.CertificateReader;
import com.kumbasoft.core.util.DataStructureUtility;
import com.kumbasoft.core.util.logging.FinestLogRecord;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;

public class ViewCertificateDetails
extends AbstractDataPowerManagementRequest
implements ManagementCommandSubscriber {
    private static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERTIFICATE = "-----END CERTIFICATE-----";
    private static final String CERT_DIRECTORY;
    private ArrayList<ViewCertificateDetails> multiInvokeInstances;
    private ArrayList<ConfigCryptoCertificate> certificateObjects;
    private HashMap<String, ConfigCryptoCertificate> certsByName;
    private Vector<CertificateExportSubscriber> subscribers;
    private File certDirectory;

    static {
        Application application = Application.getApplication();
        KumbaCoreApplicationProperties appProps = (KumbaCoreApplicationProperties)application.getApplicationProperties();
        CERT_DIRECTORY = appProps.getCertificateFileDirectory();
    }

    public ViewCertificateDetails(ArrayList<ConfigCryptoCertificate> certificateObjects, MultiThreadInvocationListener invocationListener) {
        logger.finer("(certificateObjects, invocationListener): Starting");
        this.multiInvokeInstances = new ArrayList();
        HashMap<Appliance, Index<Domain, ConfigCryptoCertificate>> certsByApplianceDomain = DataStructureUtility.mapByApplianceDomain(certificateObjects);
        for (Appliance appliance : certsByApplianceDomain.keySet()) {
            Index<Domain, ConfigCryptoCertificate> certsByDomain = certsByApplianceDomain.get(appliance);
            for (Domain domain : certsByDomain.getKeys()) {
                ArrayList certs = (ArrayList)certsByDomain.get(domain);
                ViewCertificateDetails instance = new ViewCertificateDetails(appliance, domain, certs);
                invocationListener.addThread(instance.getProcessThread());
                this.multiInvokeInstances.add(instance);
            }
        }
        logger.finer("(certificateObjects, invocationListener): Done");
    }

    private ViewCertificateDetails(Appliance appliance, Domain domain, String commandDescription) {
        super(appliance, domain, commandDescription);
        String outputDirectory = String.format("%s%s%s%s%s%s", CERT_DIRECTORY, File.separator, appliance.getName(), File.separator, domain.getName(), File.separator);
        this.certDirectory = new File(outputDirectory);
        if (!this.certDirectory.exists()) {
            this.certDirectory.mkdirs();
        }
        this.addManagementCommandSubscriber(this);
    }

    public ViewCertificateDetails(Appliance appliance, Domain domain, ArrayList<ConfigCryptoCertificate> certificateObjects) {
        this(appliance, domain, String.format("View Certificate Details for %d certificates within the %s domain of %s", certificateObjects.size(), domain.getName(), appliance.getName()));
        this.setCertificateObjects(certificateObjects);
    }

    public ViewCertificateDetails(Appliance appliance, Domain domain, ConfigCryptoCertificate certificateObject) {
        this(appliance, domain, String.format("View Certificate Details for %s within the %s domain of %s", certificateObject.getName(), domain.getName(), appliance.getName()));
        ArrayList<ConfigCryptoCertificate> certObjects = new ArrayList<ConfigCryptoCertificate>();
        certObjects.add(certificateObject);
        this.setCertificateObjects(certObjects);
    }

    public ArrayList<ConfigCryptoCertificate> getCertificateObjects() {
        return this.certificateObjects;
    }

    public void setCertificateObjects(ArrayList<ConfigCryptoCertificate> certificateObjects) {
        this.certificateObjects = certificateObjects;
        BeanIndexer<ConfigCryptoCertificate> nameIndexer = new BeanIndexer<ConfigCryptoCertificate>(certificateObjects);
        this.certsByName = nameIndexer.getMapOf("name", null);
    }

    public void addCertificateExportSubscriber(CertificateExportSubscriber subscriber) {
        AbstractTool.logger.finer("(CertificateExportSubscriber): Starting");
        if (this.multiInvokeInstances != null) {
            AbstractTool.logger.finer(() -> LMG.log("(CertificateExportSubscriber): Adding subscriber to %d instances.", () -> this.multiInvokeInstances.size()));
            for (ViewCertificateDetails invokeInstance : this.multiInvokeInstances) {
                invokeInstance.addCertificateExportSubscriber(subscriber);
            }
            AbstractTool.logger.finer("(CertificateExportSubscriber): Done");
            return;
        }
        AbstractTool.logger.finer("(CertificateExportSubscriber): Adding subscriber to single instance.");
        if (this.subscribers == null) {
            this.subscribers = new Vector();
        }
        this.subscribers.add(subscriber);
        AbstractTool.logger.finer("(CertificateExportSubscriber): Done");
    }

    @Override
    protected String getRequestMessage() {
        AbstractTool.logger.finer("(): Starting");
        if (CollectionUtility.isEmpty(this.certificateObjects)) {
            AbstractTool.logger.finer("(): No certificates to process.  Returning null.");
            return null;
        }
        String somaTemplate = this.getSOMATemplate();
        String requestStanza = DataPowerXMLManagement.getRequestStanza(somaTemplate);
        String requestXML = somaTemplate.replace(requestStanza, "${requestStanzas}");
        StringBuilder stanzas = new StringBuilder();
        for (ConfigCryptoCertificate cert : this.certificateObjects) {
            String certStanza = requestStanza.replace("${domain.name}", cert.getSourceDomain().getName());
            certStanza = certStanza.replace("${certificateObject.name}", cert.getName());
            stanzas.append(certStanza);
            stanzas.append("\n");
        }
        requestXML = requestXML.replace("${requestStanzas}", stanzas.toString());
        AbstractTool.logger.finer("(): Done - Returning requestXML");
        if (AbstractTool.logger.getLevel().equals(Level.FINEST)) {
            FinestLogRecord finestLogRecord = new FinestLogRecord(Level.FINEST, this.appliance, this.domain, requestXML);
            AbstractTool.logger.log(finestLogRecord);
        }
        return requestXML;
    }

    @Override
    protected boolean processResultDocument(XMLElement rootElement) {
        AbstractTool.logger.finer("(XMLElement rootElement): Starting");
        if (AbstractTool.logger.getLevel().equals(Level.FINEST)) {
            FinestLogRecord finestLogRecord = new FinestLogRecord(Level.FINEST, this.appliance, this.domain, this.responseXML);
            AbstractTool.logger.log(finestLogRecord);
        }
        if (rootElement == null) {
            AbstractTool.logger.warning("(XMLElement rootElement): rootElement is NULL.  Returning.");
            return false;
        }
        Collection<XMLElement> certificateElements = rootElement.getNodes("//CryptoCertificate");
        if (CollectionUtility.isNotEmpty(certificateElements)) {
            for (XMLElement certificateElement : certificateElements) {
                XMLElement certificateNameElement = certificateElement.getNode("CertificateObject");
                String certificateObjectName = certificateNameElement.getValue();
                ConfigCryptoCertificate certificateObject = this.certsByName.get(certificateObjectName);
                XMLElement base64Element = certificateElement.getNode("//Base64");
                this.processCertificate(certificateObject, base64Element.getValue());
            }
        } else {
            AbstractTool.logger.warning("(XMLElement rootElement): No certificiate nodes in response document.");
        }
        AbstractTool.logger.finer("(XMLElement rootElement): Finished");
        return true;
    }

    private void processCertificate(ConfigCryptoCertificate certificateObject, String base64Content) {
        Certificate certificate = null;
        AbstractTool.logger.finer(() -> LMG.log("(ConfigCryptoCertificate certificateObject=%s, String base64Content): Writing certificate.", () -> certificateObject.getFQON()));
        File certificateFile = this.writeEncodedCertificate(certificateObject, base64Content);
        AbstractTool.logger.finer(() -> LMG.log("(ConfigCryptoCertificate certificateObject=%s, String base64Content): Reading certificate.", () -> certificateObject.getFQON()));
        CertificateReader cr = new CertificateReader(certificateFile);
        certificate = cr.readCertificate();
        AbstractTool.logger.finer(() -> LMG.log("(ConfigCryptoCertificate certificateObject=%s, String base64Content): Notifying Subscribers.", () -> certificateObject.getFQON()));
        this.notifyCertificateSubscribers(certificateObject, certificate);
        AbstractTool.logger.finer(() -> LMG.log("(ConfigCryptoCertificate certificateObject=%s, String base64Content): Done.", () -> certificateObject.getFQON()));
    }

    protected void notifyCertificateSubscribers(ConfigCryptoCertificate certificateObject, Certificate certificate) {
        AbstractTool.logger.finer(() -> LMG.log("(ConfigCryptoCertificate certificateObject=%s, Certificate certificate): Starting.", () -> certificateObject.getFQON()));
        if (CollectionUtility.isNotEmpty(this.subscribers)) {
            for (CertificateExportSubscriber subscriber : this.subscribers) {
                subscriber.processCertificate(this.getAppliance(), this.getDomain(), certificateObject, certificate);
            }
        }
        AbstractTool.logger.finer(() -> LMG.log("(ConfigCryptoCertificate certificateObject=%s, Certificate certificate): Done.", () -> certificateObject.getFQON()));
    }

    private File writeEncodedCertificate(ConfigCryptoCertificate certificateObject, String encodedCert) {
        File localCertificateFile;
        block13: {
            localCertificateFile = new File(this.certDirectory, String.format("%s.cer", certificateObject.getName()));
            AbstractTool.logger.finer(() -> LMG.log("(certificateObject=%s, encodedCert): Starting.  Writing to '%s'.", () -> certificateObject.getFQON(), () -> localCertificateFile.getAbsolutePath()));
            FileWriter fileWriter = null;
            BufferedWriter bw = null;
            try {
                try {
                    fileWriter = new FileWriter(localCertificateFile);
                    bw = new BufferedWriter(fileWriter, 16384);
                    bw.write(BEGIN_CERTIFICATE);
                    bw.write("\n");
                    int start = 0;
                    int end = 0;
                    int encodedLength = encodedCert.length();
                    while (start < encodedLength) {
                        end = start + 64;
                        if (end > encodedLength) {
                            end = encodedLength;
                        }
                        String encodedPart = encodedCert.substring(start, end);
                        bw.write(encodedPart);
                        bw.write(10);
                        start += 64;
                    }
                    bw.write(END_CERTIFICATE);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        bw.flush();
                        fileWriter.flush();
                        bw.close();
                        fileWriter.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    bw.flush();
                    fileWriter.flush();
                    bw.close();
                    fileWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                bw.flush();
                fileWriter.flush();
                bw.close();
                fileWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        AbstractTool.logger.finer(() -> LMG.log("(certificateObject=%s, encodedCert): Done.  Returning '%s'", () -> certificateObject.getFQON(), () -> localCertificateFile.getAbsolutePath()));
        return localCertificateFile;
    }

    @Override
    public void commandSucceeded(ManagementCommandStatus commandStatus) {
    }

    @Override
    public void commandFailed(ManagementCommandError commandError) {
        Appliance appliance = commandError.getAppliance();
        Domain domain = commandError.getDomain();
        AbstractTool initiator = commandError.getCommandInitiator();
        String description = commandError.getCommandDescription();
        String errorMessage = commandError.getErrorMessage();
        AbstractTool.logger.warning(() -> LMG.log("(ManagementCommandError commandError): Error for '%s' is '%s' from the '%s' domain of '%s'.  '%s' initiated by '%s'", () -> description, () -> errorMessage, () -> appliance.getName(), () -> domain.getName(), () -> description, () -> initiator.getClass().getName()));
        DynamicBean additionalCommandInfo = commandError.getAdditionalCommandInfo();
        if (additionalCommandInfo != null && additionalCommandInfo.hasProperty("10.5")) {
            ConfigCryptoCertificate cert = (ConfigCryptoCertificate)commandError.getAdditionalCommandInfo().getProperty("10.5");
            StatusObjectStatus certStatus = cert.getStatus();
            certStatus.setEventCode("0xfffffffffffffff1");
            certStatus.setErrorCode("This certificate may only appear to be broken due to a 10.5.x.x firmware bug.  Please check the configuration manually.");
            this.notifyCertificateSubscribers(cert, null);
        }
    }
}

