/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.util.LabelUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.DataPowerObject;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ManagementCommandError;
import com.kumbasoft.core.beans.ManagementCommandSubscriber;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.tools.ConfigTool;
import com.kumbasoft.core.tools.DeleteObjectConfiguration;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.AbstractSearchPanel;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public abstract class AbstractCRUDPanel<BeanType extends DataPowerConfig>
extends AbstractSearchPanel<BeanType>
implements TableModelListener,
ManagementCommandSubscriber {
    protected JMCheckBox cbxSynchronizeEdits;
    protected ConfigurationManager configurationManager = new ConfigurationManager();
    protected boolean dirty;
    protected boolean ignoreChanges;

    public AbstractCRUDPanel(Class<BeanType> elementType) {
        super(elementType);
        this.cbxSynchronizeEdits = new JMCheckBox("Synchronize Edits", true);
        this.cbxSynchronizeEdits.setToolTipText(this.getHelpFile("SynchronizeEdits_Button", "Synchronize Edits"));
        this.topControlsPanel.add((Component)this.cbxSynchronizeEdits, "Center");
        this.createPopupMenu();
    }

    @Override
    protected void createPopupMenu() {
        logger.finer("(): Starting");
        if (this.displayTable == null) {
            logger.severe("(): Display Table is NULL.  Timing issue?");
        }
        this.popupMenu = this.getPopupMenu();
        logger.finer("(): Done.");
    }

    @Override
    protected String getProcessMethodName() {
        return "listObjects";
    }

    @Reflected
    protected abstract void listObjects();

    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    protected void searchFind() {
        AbstractPanel.logger.finer("(): Starting");
        this.displayTable.commitEdits();
        if (this.dirty) {
            AbstractPanel.logger.info("():  Objects are modified.  Checking with user.");
            String message = LabelUtility.wrapInHTML(this.getSearchSaveConfirmMessage());
            new JMMessageBox((JFrame)AbstractPanel.frame, "Save Changes?", message, 12);
            if (JMMessageBox.getSelection() == 4) {
                AbstractPanel.logger.info("():  User selected to save previous changes before continuing.");
                this.fileSave();
            }
        }
        this.ignoreChanges = true;
        super.searchFind();
        this.ignoreChanges = false;
        this.dirty = false;
        AbstractPanel.logger.finer("(): Done");
    }

    protected abstract String getSearchSaveConfirmMessage();

    /*
     * Exception decompiling
     */
    @Override
    public void tableChanged(TableModelEvent e) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[11] lbl62 : CaseStatement: default:\u000a, @NONE, blocks:[11] lbl62 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void resolveColumnChanges(BeanType editedObject, String columnName) {
    }

    protected abstract void synchronizeChanges(BeanType var1, int var2, BeanType var3, String var4);

    private String getDataPowerType(BeanType object) {
        String className = object.getClass().getSimpleName();
        return className.replace("Config", "");
    }

    @Reflected
    protected void fileNew() {
        this.ignoreChanges = true;
        UniqueArrayList<Appliance> appliances = ApplianceDomainChangeMonitor.getInstance().getCurrentApplianceSelection();
        for (Appliance appliance : appliances) {
            Domain defaultDomain = appliance.getDomain("default");
            BeanType object = this.getNewInstance();
            ((DataPowerObject)object).setAppliance(appliance);
            ((DataPowerObject)object).setSourceDomain(defaultDomain);
            ((DataPowerConfig)object).setName("");
            ((DataPowerConfig)object).setAdminState("enabled");
            StatusObjectStatus status = new StatusObjectStatus();
            status.setAdminState("enabled");
            status.setAppliance(appliance);
            status.setSourceDomain(defaultDomain);
            status.setConfigState("new");
            status.setOpState("new");
            status.setDataPowerClass(this.getDataPowerType(object));
            ((DataPowerConfig)object).setStatus(status);
            this.tableModel.addRow(object);
        }
        this.displayTable.repaint();
        this.ignoreChanges = false;
    }

    protected abstract BeanType getNewInstance();

    @Reflected
    protected void fileSave() {
        AbstractPanel.logger.finer("(): Starting");
        this.displayTable.commitEdits();
        ArrayList configObjects = this.tableModel.getModelData();
        if (configObjects.isEmpty()) {
            AbstractPanel.logger.info("(): No configurations.  This should never be seen.  The menu item should not be enabled.");
            return;
        }
        if (!this.dirty) {
            AbstractPanel.logger.info("(): Not dirty.  How is this being called.");
        }
        DataPowerConfig firstObject = (DataPowerConfig)configObjects.get(0);
        String objectType = this.getDataPowerType(firstObject);
        this.openResultsDialogAndSetWaitCursor("Save " + objectType + "s");
        for (DataPowerConfig configObject : configObjects) {
            String configObjectName = configObject.getName();
            if (configObjectName.equals("")) continue;
            StatusObjectStatus status = configObject.getStatus();
            String configState = status.getConfigState();
            String opState = status.getOpState();
            String adminState = status.getAdminState();
            if (configState.equals("saved")) {
                AbstractPanel.logger.finer(() -> LMG.log("(): %s information has not changed for '%s'.  Skipping", () -> objectType, () -> configObjectName));
                continue;
            }
            if (configState.equals("deleted") && this.canDelete(configObjectName)) {
                if (!opState.equals("new")) {
                    AbstractPanel.logger.config(() -> LMG.log("(): Deleting %s '%s'", () -> objectType, () -> configObject.getName()));
                    DeleteObjectConfiguration deleteConfiguration = new DeleteObjectConfiguration(status);
                    deleteConfiguration.addManagementCommandSubscriber(this.commandResultsDialog);
                } else {
                    AbstractPanel.logger.info(() -> LMG.log("(): %s '%s' was new and then deleted without being saved.  Just removing from table.", () -> objectType, () -> configObject.getName()));
                }
                this.tableModel.deleteRow(configObject);
                continue;
            }
            if (!configState.equals("new") && !configState.equals("modified")) continue;
            AbstractPanel.logger.config(() -> LMG.log("(): Modifying %s '%s'", () -> objectType, () -> configObject.getName()));
            ConfigTool configTool = new ConfigTool(configObject.getAppliance(), configObject.getSourceDomain(), configObject);
            configTool.addManagementCommandSubscriber(this.commandResultsDialog);
            status.setConfigState("saved");
            status.setOpState(adminState.equals("enabled") ? "up" : "down");
        }
        this.waitForResultsDialogToCloseAndResetCursor();
        this.displayTable.repaint();
        this.dirty = false;
        AbstractPanel.logger.finer("(): Done");
    }

    protected boolean canDelete(String configObjectName) {
        return true;
    }

    @Reflected
    protected void editDelete() {
        AbstractPanel.logger.finer("(): Starting");
        ArrayList selectedConfigs = this.getSelectedValues();
        if (CollectionUtility.isEmpty(selectedConfigs)) {
            AbstractPanel.logger.info("(): Nothing selected to delete - will not delete all.");
            return;
        }
        String objectType = this.getDataPowerType((DataPowerConfig)selectedConfigs.get(0));
        String deleteMessage = this.getDeleteConfirmationMessage(selectedConfigs);
        if (this.continueAction("Delete Selected " + objectType + "s?", deleteMessage)) {
            AbstractPanel.logger.info("(): Marking as deleted.");
            for (DataPowerConfig config : selectedConfigs) {
                String name = config.getName();
                if (this.canDelete(name)) {
                    AbstractPanel.logger.info(() -> LMG.log("(): Ignoring '%s' %s.", () -> name, () -> objectType));
                    continue;
                }
                config.getStatus().setConfigState("deleted");
                this.dirty = true;
            }
        }
        this.displayTable.repaint();
        AbstractPanel.logger.finer("(): Done");
    }

    protected abstract String getDeleteConfirmationMessage(ArrayList<BeanType> var1);

    @Override
    public void commandFailed(ManagementCommandError commandError) {
    }

    private static /* synthetic */ String lambda$0(int n, int n2, int n3, int n4, String string, String string2) {
        return LMG.log("(TableModelEvent e=%d): firstRow=%d, lastRow=%d, column=%d (%s), changeType=%s", () -> n, () -> n2, () -> n3, () -> n4, () -> string, () -> string2);
    }

    private static /* synthetic */ String lambda$7(int n, String string, int n2, int n3, int n4, String string2) {
        return LMG.log("(TableModelEvent e=%d): Status: %s, First Row: %d, Last Row: %d, column=%d (%s) - Synhronizing Edits", () -> n, () -> string, () -> n2, () -> n3, () -> n4, () -> string2);
    }

    private static /* synthetic */ String lambda$14(int n, String string, int n2, int n3, int n4, String string2) {
        return LMG.log("(TableModelEvent e=%d): Status: %s, First Row: %d, Last Row: %d, column=%d (%s) - Done", () -> n, () -> string, () -> n2, () -> n3, () -> n4, () -> string2);
    }
}

