/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.util.ComponentService;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.tools.DataPowerXMLManagement;
import com.kumbasoft.core.ui.AbstractTablePanel;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.util.RegexUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public abstract class AbstractSearchPanel<BeanType>
extends AbstractTablePanel<BeanType> {
    protected JMPanel topPanel = KumbaCoreUIConstants.createVerticalFlowLayoutPanel(3);
    protected JMPanel topControlsPanel;
    protected JMPanel searchFieldPanel = this.getSearchFieldPanel();
    protected JMTextField tfSearchPattern;
    protected JMButton btnSearch;
    private JMButton btnCaseSensitivity;
    private JMButton btnClearCache;
    private String matchPattern;
    protected boolean useCaseSensitiveSearch;

    public AbstractSearchPanel(Class<BeanType> elementType) {
        super(elementType);
        this.topControlsPanel = new JMPanel(new BorderLayout(1, 0));
        this.topControlsPanel.add((Component)this.searchFieldPanel, "West");
        JMPanel rightPanel = new JMPanel(new FlowLayout(2));
        JMButton btnPopupMenu = this.getPopupMenuButton();
        rightPanel.add(btnPopupMenu);
        this.topControlsPanel.add((Component)rightPanel, "East");
        this.topPanel.add(this.topControlsPanel);
        this.centerPanel.add((Component)this.topPanel, "North");
    }

    protected abstract String getTFPatternLabel();

    protected String getMatchPattern() {
        String matchPattern = this.tfSearchPattern.getText();
        return RegexUtility.normalizeRegex(matchPattern, this.useCaseSensitiveSearch);
    }

    protected JMPanel getSearchFieldPanel() {
        if (this.searchFieldPanel == null) {
            boolean includeClearCacheButton;
            this.searchFieldPanel = new JMPanel();
            LabeledComponent lc = new LabeledComponent(this.getTFPatternLabel(), (Component)this.getMatchPatternTF(), this.getMatchPatternLabelWidth(), this.getMatchPatternFieldWidth());
            this.searchFieldPanel.add(lc);
            this.btnSearch = new JMButton(KumbaCoreUIConstants.SEARCH_ICON, "Search");
            this.btnSearch.setActivator(this.tfSearchPattern, 10);
            this.searchFieldPanel.add(this.btnSearch);
            new ActionEventInvoker(this.btnSearch, this, "searchFind");
            boolean includeCaseSensitivityButton = this.includeCaseSensitivityButton();
            if (includeCaseSensitivityButton) {
                this.btnCaseSensitivity = new JMButton(KumbaCoreUIConstants.CASE_SENSITIVITY_OFF_ICON, "Toggle Case Sensitivity");
                this.searchFieldPanel.add(this.btnCaseSensitivity);
                new ActionEventInvoker(this.btnCaseSensitivity, this, "toggleCaseSensitiveSearch");
            }
            if (includeClearCacheButton = this.includeClearCacheButton()) {
                this.btnClearCache = new JMButton(KumbaCoreUIConstants.CLEAN_ICON, "Clear Local Configuration Cache");
                this.searchFieldPanel.add(this.btnClearCache);
                new ActionEventInvoker(this.btnClearCache, this, "clearCache");
            }
        }
        return this.searchFieldPanel;
    }

    protected boolean includeCaseSensitivityButton() {
        return true;
    }

    @Reflected
    private void toggleCaseSensitiveSearch() {
        if (this.useCaseSensitiveSearch) {
            this.useCaseSensitiveSearch = false;
            this.btnCaseSensitivity.setIcon(KumbaCoreUIConstants.CASE_SENSITIVITY_OFF_ICON);
        } else {
            this.useCaseSensitiveSearch = true;
            this.btnCaseSensitivity.setIcon(KumbaCoreUIConstants.CASE_SENSITIVITY_ON_ICON);
        }
    }

    protected boolean includeClearCacheButton() {
        return true;
    }

    @Reflected
    private void clearCache() {
        ConfigurationManager.clearCache(ApplianceDomainChangeMonitor.getInstance().getCurrentDomainSelection());
    }

    private JMTextField getMatchPatternTF() {
        if (this.tfSearchPattern == null) {
            this.tfSearchPattern = new JMTextField(32);
            this.tfSearchPattern.setPreferredSize(this.tfSearchPattern.getPreferredSize().width, 23);
            ComponentService.addClearIcon(this.tfSearchPattern, "Clear the text from the search field.");
            ComponentService.addHelpIcon(this.tfSearchPattern, this.getSearchHelpText());
            String defaultSearchPattern = this.getDefaultSearchPattern();
            this.tfSearchPattern.setText(defaultSearchPattern);
        }
        return this.tfSearchPattern;
    }

    protected String getDefaultSearchPattern() {
        return "";
    }

    protected int getMatchPatternLabelWidth() {
        return 100;
    }

    protected int getMatchPatternFieldWidth() {
        return 400;
    }

    protected String getSearchHelpText() {
        return this.getHelpFile("searchField", "Enter a regular expression matching the item(s) you wish to find.");
    }

    public void setMatchPattern(String matchPattern) {
        this.matchPattern = matchPattern;
    }

    @Reflected
    protected void searchFind() {
        logger.finer("(): Starting");
        if (this.btnClearCache != null && this.btnClearCache.isSelected()) {
            logger.fine("():  Clearing Local Cache");
            DataPowerXMLManagement.clearLocalCache();
            this.btnClearCache.setSelected(false);
        }
        this.btnSearch.setEnabled(false);
        logger.finer("(): Clearing log table data");
        this.resetTableData();
        this.matchPattern = this.getMatchPattern();
        try {
            Pattern.compile(this.matchPattern);
        }
        catch (PatternSyntaxException pse) {
            String message = String.format("The match pattern \"%s\" is not a valid regular expression.", this.matchPattern);
            logger.info(() -> LMG.log("(): PatternSyntaxException: %s", () -> message));
            this.showMessage("Match Pattern Invalid", message);
            this.btnSearch.setEnabled(true);
            return;
        }
        this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
        String processMethodName = this.getProcessMethodName();
        logger.finer(() -> LMG.log("():  processMethodName=%s", () -> processMethodName));
        MethodInvoker mi = new MethodInvoker((Object)this, processMethodName, new Object[0]);
        mi.invoke();
        logger.finer("(): Done");
    }

    protected abstract String getProcessMethodName();

    protected boolean isForAppliancesOnly() {
        return false;
    }

    protected void resetUI() {
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
        this.btnSearch.setEnabled(true);
    }
}

