/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.io.FileInputStreamHelper;
import com.jmorgan.io.FileOutputStreamHelper;
import com.jmorgan.io.filefilter.ExtensionFileFilter;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.GUIApplication;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTable;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.event.BeanRowSorterListener;
import com.jmorgan.swing.event.ColumnModelEventInvoker;
import com.jmorgan.swing.table.BeanColumnModel;
import com.jmorgan.swing.table.BeanRowSorter;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.swing.table.CellFocusEvent;
import com.jmorgan.swing.table.CellFocusListener;
import com.jmorgan.swing.table.ExcelTableModelExport;
import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.util.SystemClipboard;
import com.jmorgan.util.collection.CollectionPropertySelector;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ApplianceGroupObject;
import com.kumbasoft.core.beans.ColumnPreference;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.DomainGroup;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.KumbaCoreFrame;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.beans.TableDisplayPreference;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.JFrame;
import javax.swing.ListSelectionModel;
import javax.swing.ToolTipManager;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public abstract class AbstractTablePanel<BeanType>
extends AbstractPanel
implements CellFocusListener,
BeanRowSorterListener {
    private static final ExtensionFileFilter excelFilter = new ExtensionFileFilter("xls", "xlsm");
    protected JMPanel leftPanel;
    protected JMPanel centerPanel;
    protected JMPanel tableDisplayPanel;
    protected JMTable displayTable;
    protected JMScrollPane displayTableScrollPane;
    protected Class<BeanType> elementType;
    protected BeanColumnModel<BeanType> columnModel;
    protected BeanTableModel<BeanType> tableModel;
    protected BeanRowSorter<BeanType> rowSorter;
    protected Object[] arguments;
    private boolean optimizedTableDisplay;
    private int lastTableModelRowCount;
    private Object threadLock = new Object();
    private AsynchMethodInvoker<Boolean> saveTablePreferencesThread;
    private boolean preferencesFromUser;
    private ArrayList<BeanType> selectedValues;

    protected AbstractTablePanel(Class<BeanType> elementType) {
        this(elementType, null);
    }

    protected AbstractTablePanel(Class<BeanType> elementType, Object ... arguments) {
        super(KumbaCoreUIConstants.createBorderLayout());
        this.arguments = arguments;
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        this.setElementType(elementType);
        this.leftPanel = this.createLeftPanel();
        if (this.leftPanel != null) {
            this.add((Component)this.leftPanel, "West");
        }
        this.tableDisplayPanel = this.createTableDisplayPanel();
        this.centerPanel = KumbaCoreUIConstants.createBorderLayoutPanel();
        this.centerPanel.add((Component)this.tableDisplayPanel, "Center");
        this.add((Component)this.centerPanel, "Center");
    }

    protected JMPanel createLeftPanel() {
        Component topSpacer;
        JMPanel panel = new JMPanel(new BorderLayout(0, 0));
        int spacerHeight = this.getTopLeftPanelSpacerHeight();
        if (spacerHeight > 0 && (topSpacer = this.createLeftPanelTopSpacer(spacerHeight)) != null) {
            panel.add(topSpacer, "North");
        }
        return panel;
    }

    protected Component createLeftPanelTopSpacer(int spacerHeight) {
        return ComponentFactory.createSpacer(20, spacerHeight);
    }

    protected int getTopLeftPanelSpacerHeight() {
        return 0;
    }

    protected JMPanel createTableDisplayPanel() {
        JMPanel panel = KumbaCoreUIConstants.createBorderLayoutPanel();
        this.displayTableScrollPane = KumbaCoreUIConstants.createScrollPane(this.createDisplayTable());
        panel.add(this.displayTableScrollPane);
        return panel;
    }

    protected Class<BeanType> getElementType() {
        return this.elementType;
    }

    protected void setElementType(Class<BeanType> elementType) {
        this.elementType = elementType;
        this.setupModel();
        if (BeanService.hasProperty(elementType, "appliance")) {
            this.tableModel.setValueExpression("appliance", "name");
        }
        if (BeanService.hasProperty(elementType, "sourceDomain")) {
            this.tableModel.setValueExpression("sourceDomain", "name");
        }
        if (elementType.isInstance(DataPowerConfig.class)) {
            this.columnModel.hideColumn("rawXML");
            this.columnModel.hideColumn("xmlNodeContents");
            this.columnModel.setColumnTitle("sourceDomain", "Domain");
            this.columnModel.setColumnTitle("adminState", "Admin State");
            this.columnModel.setColumnTitle("userSummary", "Summary");
            if (!this.preferencesFromUser) {
                this.columnModel.setColumnOrder("appliance", "sourceDomain", "name", "configObjectType", "adminState", "userSummary", "isReadOnly", "isLocal", "isExternal", "isIntrinsic");
            }
        }
    }

    private JMTable createDisplayTable() {
        if (this.displayTable == null) {
            this.displayTable = new JMTable(this.tableModel, this.columnModel);
            this.rowSorter = new BeanRowSorter<BeanType>(this.tableModel);
            this.rowSorter.addBeanSorterListener(this);
            this.displayTable.setRowSorter(this.rowSorter);
            this.displayTable.setAutoResizeMode(0);
            this.displayTable.addCellFocusListener(this);
            new ColumnModelEventInvoker(this.columnModel, 20, (Object)this, "prepareToSaveTablePreferences");
        }
        return this.displayTable;
    }

    @Override
    protected Component getDialogSourceComponent() {
        return this.displayTable;
    }

    @Override
    public void cellFocusChange(CellFocusEvent event) {
        int cell;
        int row = event.getNewRow();
        Object value = this.displayTable.getValueAt(row, cell = event.getNewCell());
        String strValue = value == null ? "" : value.toString();
        try {
            SystemClipboard.setContents(strValue);
        }
        catch (IllegalStateException e) {
            AbstractPanel.logger.info(() -> LMG.log("(CellFocusEvent):  Could not copy the value to the clipboard.  Value is: '%s'", () -> strValue));
        }
        this.displayTable.repaint();
    }

    protected void setupModel() {
        AbstractPanel.logger.finer("(): Starting");
        if (this.tableModel == null) {
            AbstractPanel.logger.finer("(): Building table model.");
            this.tableModel = this.getTableModel();
        }
        if (this.columnModel == null) {
            AbstractPanel.logger.finer("(): Building column model.");
            this.columnModel = this.getColumnModel();
            this.applyTableDisplayPreferences();
        }
        AbstractPanel.logger.finer("(): Done");
    }

    public void resetTableData() {
        AbstractPanel.logger.finer("(): Starting.");
        if (this.tableModel == null || this.tableModel.getRowCount() == 0) {
            return;
        }
        this.displayTable.removeEditor();
        this.displayTable.clearSelection();
        AbstractTablePanel.resetTableModel(this.tableModel);
        AbstractTablePanel.resetColumnModel(this.columnModel);
        this.tableModel = null;
        this.columnModel = null;
        this.setupModel();
        this.displayTable.setModel(this.tableModel);
        this.displayTable.setColumnModel(this.columnModel);
        this.rowSorter.setModel(this.tableModel);
        AbstractPanel.logger.finer("(): Done.");
    }

    protected static void resetTableModel(BeanTableModel<?> tableModel) {
        AbstractPanel.logger.finer("(tableModel): Starting.");
        if (tableModel == null || tableModel.getRowCount() == 0) {
            return;
        }
        try {
            tableModel.reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
        AbstractPanel.logger.finer("(tableModel): Done.");
    }

    protected static void resetColumnModel(BeanColumnModel<?> columnModel) {
        AbstractPanel.logger.finer("(columnModel): Starting.");
        if (columnModel == null || columnModel.getColumnCount() == 0) {
            return;
        }
        try {
            columnModel.reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
        AbstractPanel.logger.finer("(columnModel): Done.");
    }

    protected String getPreferencesTableName() {
        AbstractPanel.logger.finer("(): Starting.");
        String preferencesTableName = this.getClass().getSimpleName();
        AbstractPanel.logger.finer(() -> LMG.log("(): Done.  Returning '%s'", () -> preferencesTableName));
        return preferencesTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reflected
    protected void prepareToSaveTablePreferences() {
        AbstractPanel.logger.finer("(): Starting.");
        Object object = this.threadLock;
        synchronized (object) {
            if (this.saveTablePreferencesThread != null) {
                this.saveTablePreferencesThread.cancel();
            }
            this.saveTablePreferencesThread = new AsynchMethodInvoker((Object)this, "saveTablePreferences", 5000);
        }
        AbstractPanel.logger.finer("(): Done.");
    }

    @Reflected
    protected boolean saveTablePreferences() {
        AbstractPanel.logger.finer("(): Starting.");
        TableDisplayPreference tablePrefs = new TableDisplayPreference();
        int columnCount = this.columnModel.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            TableColumn column = this.columnModel.getColumn(i);
            String columnName = this.displayTable.getColumnName(i);
            int columnOrder = i++;
            int columnWidth = column.getWidth();
            AbstractPanel.logger.finer(() -> LMG.log("():  Column Name: %s, Column Order: %d, Column Width: %d", () -> columnName, () -> columnOrder, () -> columnWidth));
            ColumnPreference columnPreference = new ColumnPreference(columnName, columnWidth, columnOrder);
            tablePrefs.addColumnPreference(columnPreference);
        }
        String preferencesFileName = this.getPreferencesFileName();
        AbstractPanel.logger.finer(() -> LMG.log("():  Saving to '%s'", () -> preferencesFileName));
        FileOutputStreamHelper foutH = new FileOutputStreamHelper(preferencesFileName, KumbaCoreConstants.FILE_READ_BUFFER_SIZE);
        BufferedOutputStream bout = (BufferedOutputStream)foutH.open();
        GZIPOutputStream zipOut = null;
        try {
            zipOut = new GZIPOutputStream((OutputStream)bout, KumbaCoreConstants.FILE_READ_BUFFER_SIZE);
        }
        catch (IOException e) {
            AbstractPanel.logger.severe(() -> LMG.log("():  Error writing to ZIP Stream for '%s'", () -> preferencesFileName));
            e.printStackTrace();
        }
        foutH.stackStream(zipOut);
        XMLEncoder xmlEncoder = new XMLEncoder(zipOut);
        xmlEncoder.writeObject(tablePrefs);
        xmlEncoder.flush();
        foutH.flush();
        xmlEncoder.close();
        boolean saveSucceeded = foutH.close();
        AbstractPanel.logger.finer(() -> LMG.log("():  Finished saving to %s", () -> preferencesFileName));
        this.saveTablePreferencesThread = null;
        return saveSucceeded;
    }

    private TableDisplayPreference restoreTablePreferences() {
        AbstractPanel.logger.finer("():  Starting.");
        String preferencesFileName = this.getPreferencesFileName();
        if (preferencesFileName == null) {
            AbstractPanel.logger.finer("():  Preferences File Name is null.  Nothing to do.");
            return null;
        }
        AbstractPanel.logger.finer(() -> LMG.log("():  Preferences File Name: '%s'", () -> preferencesFileName));
        FileInputStreamHelper finH = new FileInputStreamHelper(preferencesFileName);
        BufferedInputStream bin = (BufferedInputStream)finH.open();
        if (bin == null) {
            AbstractPanel.logger.warning(() -> LMG.log("():  Error reading '%s':  %s", () -> preferencesFileName, () -> finH.getException().getMessage()));
            return null;
        }
        XMLDecoder xmlDecoder = null;
        try {
            GZIPInputStream zipIn = new GZIPInputStream((InputStream)bin, KumbaCoreConstants.FILE_READ_BUFFER_SIZE);
            finH.stackStream(zipIn);
            xmlDecoder = new XMLDecoder(zipIn);
            TableDisplayPreference tablePrefs = (TableDisplayPreference)xmlDecoder.readObject();
            this.preferencesFromUser = true;
            TableDisplayPreference tableDisplayPreference = tablePrefs;
            return tableDisplayPreference;
        }
        catch (IOException e1) {
            AbstractPanel.logger.severe(() -> LMG.log("():  Error reading '%s':  %s", () -> preferencesFileName, () -> e1.getMessage()));
            e1.printStackTrace();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            AbstractPanel.logger.severe(() -> LMG.log("():  Error reading '%s':  %s", () -> preferencesFileName, () -> e.getMessage()));
        }
        finally {
            if (xmlDecoder != null) {
                xmlDecoder.close();
            }
            finH.close();
        }
        AbstractPanel.logger.warning(() -> LMG.log("():  All else failed reading '%s'. Returning NULL.", () -> preferencesFileName));
        return null;
    }

    private String getPreferencesFileName() {
        AbstractPanel.logger.finer("(): Starting");
        String tableName = this.getPreferencesTableName();
        if (tableName == null) {
            return null;
        }
        String preferencesDirectoryName = this.getPreferencesDirectoryName();
        String fileName = String.format("%s%sPrefs.dat", preferencesDirectoryName, tableName);
        AbstractPanel.logger.finer(() -> LMG.log("():  Done.  Preferences File Name: %s", () -> fileName));
        return fileName;
    }

    public boolean fileExportEnabled() {
        return this.displayTable.getRowCount() > 0;
    }

    public void fileExport() {
        AbstractPanel.logger.finest("()");
        File exportFile = GUIServices.fileSaveDialog(null, excelFilter);
        if (exportFile == null) {
            return;
        }
        if (exportFile.exists()) {
            String message = exportFile.getAbsolutePath() + " exists.  Do you want to replace it?";
            new JMMessageBox((JFrame)frame, "File Exists", message, 14);
            switch (JMMessageBox.getSelection()) {
                case 2: {
                    return;
                }
                case 8: {
                    new AsynchMethodInvoker((Object)this, "fileExport");
                    return;
                }
                case 4: {
                    this.exportFile(exportFile);
                }
            }
        }
    }

    private void exportFile(File file) {
        FileOutputStreamHelper fout = new FileOutputStreamHelper(file);
        BufferedOutputStream out = (BufferedOutputStream)fout.open();
        if (out == null) {
            new JMMessageBox((JFrame)frame, "Export Error", "There was an error opening " + file.getAbsolutePath() + " for export.");
            return;
        }
        ExcelTableModelExport exporter = new ExcelTableModelExport(this.getTableModelToExport());
        exporter.exportTo(out);
        fout.close();
    }

    @Reflected
    private boolean editSelectAllEnabled() {
        return this.displayTable.getRowCount() > 0;
    }

    @Reflected
    protected void editSelectAll() {
        if (this.displayTable.getRowCount() > 0) {
            this.displayTable.selectAll();
        }
    }

    protected TableModel getTableModelToExport() {
        return this.tableModel;
    }

    public List<ApplianceGroupObject> getSelectedApplianceGroup() {
        if (frame == null) {
            frame = (KumbaCoreFrame)GUIApplication.getGUIApplication().getApplicationFrame();
        }
        return frame.getSelectedApplianceGroup();
    }

    public List<DomainGroup> getDomainGroup() {
        if (frame == null) {
            frame = (KumbaCoreFrame)GUIApplication.getGUIApplication().getApplicationFrame();
        }
        return frame.getSelectedDomainGroup();
    }

    public Collection<Appliance> getSelectedAppliances() {
        List<ApplianceGroupObject> applianceGroups = this.getSelectedApplianceGroup();
        UniqueArrayList<Appliance> selectedAppliances = new UniqueArrayList<Appliance>();
        if (applianceGroups != null) {
            for (ApplianceGroupObject ago : applianceGroups) {
                selectedAppliances.addAll(ago.getAppliances());
            }
        }
        return selectedAppliances;
    }

    public ArrayList<BeanType> getSelectedValues() {
        return this.getSelectedValues(false);
    }

    public ArrayList<BeanType> getSelectedValues(boolean returnAllIfNoneSelected) {
        int[] selectedRows = this.displayTable.getSelectedRows();
        if (selectedRows.length == 0) {
            if (returnAllIfNoneSelected) {
                int rowCount = this.displayTable.getRowCount();
                selectedRows = new int[rowCount];
                int i = 0;
                while (i < rowCount) {
                    selectedRows[i] = i;
                    ++i;
                }
            } else {
                return new ArrayList();
            }
        }
        ArrayList<BeanType> selectedValues = new ArrayList<BeanType>(selectedRows.length);
        int selectedRow = 0;
        while (selectedRow < selectedRows.length) {
            BeanType object = this.tableModel.getValue(selectedRows[selectedRow]);
            if (object instanceof StatusObjectStatus) {
                StatusObjectStatus statusObject = (StatusObjectStatus)object;
                String objectName = ConfigurationManager.getCorrectedObjectName(statusObject);
                statusObject.setName(objectName);
            } else if (object instanceof DataPowerConfig) {
                DataPowerConfig dpObject = (DataPowerConfig)object;
                String objectName = ConfigurationManager.getCorrectedObjectName(dpObject);
                dpObject.setName(objectName);
            }
            selectedValues.add(object);
            ++selectedRow;
        }
        return selectedValues;
    }

    public void setSelectedValues(ArrayList<BeanType> selectedValues) {
        int rowCount = this.displayTable.getRowCount();
        ListSelectionModel selectionModel = this.displayTable.getSelectionModel();
        int row = 0;
        while (row < rowCount) {
            BeanType value = this.tableModel.getValue(this.displayTable.convertRowIndexToModel(row));
            if (this.selectedValues.contains(value)) {
                selectionModel.addSelectionInterval(row, row);
            }
            ++row;
        }
    }

    public ArrayList<BeanType> removeSelectedValues(String confirmationTitle, String confirmationMessage) {
        if (!this.continueAction(confirmationTitle, confirmationMessage)) {
            return null;
        }
        this.displayTable.removeEditor();
        ArrayList<BeanType> selectedValues = this.getSelectedValues();
        this.displayTable.clearSelection();
        this.tableModel.deleteAll(selectedValues);
        return selectedValues;
    }

    public Collection<Domain> getSelectedDomains() {
        List<DomainGroup> domainGroups = this.getDomainGroup();
        UniqueArrayList<Domain> selectedDomains = new UniqueArrayList<Domain>();
        if (domainGroups != null) {
            for (DomainGroup dg : domainGroups) {
                selectedDomains.addAll(dg.getDomains());
            }
        }
        return selectedDomains;
    }

    public synchronized void addRow(BeanType row) {
        try {
            if (this.tableModel.getRowCount() == 0) {
                this.optimizedTableDisplay = false;
                this.lastTableModelRowCount = 0;
                if (BeanService.hasProperty(row, "appliance")) {
                    this.tableModel.setValueExpression("appliance", "name");
                }
                if (BeanService.hasProperty(row, "sourceDomain")) {
                    this.tableModel.setValueExpression("sourceDomain", "name");
                }
                if (BeanService.hasProperty(row, "domain") && BeanService.getPropertyType(row, "domain").equals(Domain.class)) {
                    this.tableModel.setValueExpression("domain", "name");
                }
                ArrayList<String> propertyNames = BeanService.getPropertyNames(row);
                for (String propertyName : propertyNames) {
                    Class<?> propertyType = BeanService.getPropertyType(row, propertyName);
                    if (!propertyType.equals(ObjectReference.class)) continue;
                    this.tableModel.setValueExpression(propertyName, "name");
                }
            }
            this.tableModel.addRow(row);
            if (!this.optimizedTableDisplay) {
                this.optimizedTableDisplay = true;
                new AsynchMethodInvoker((Object)this, "optimizeColumnWidths", KumbaCoreConstants.THREAD_WAIT * 4);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Reflected
    private void optimizeColumnWidths() {
        int rowCount = this.tableModel.getRowCount();
        if (this.lastTableModelRowCount != rowCount) {
            this.lastTableModelRowCount = rowCount;
            new AsynchMethodInvoker((Object)this, "optimizeColumnWidths", KumbaCoreConstants.THREAD_WAIT * 4);
            return;
        }
        this.displayTable.optimizeColumnWidths();
    }

    public JMTable getDisplayTable() {
        return this.displayTable;
    }

    protected BeanColumnModel<BeanType> getColumnModel() {
        if (this.columnModel == null) {
            this.columnModel = new BeanColumnModel<BeanType>(this.elementType);
        }
        return this.columnModel;
    }

    protected TableDisplayPreference applyTableDisplayPreferences() {
        ArrayList<ColumnPreference> columnPreferences;
        TableDisplayPreference tablePreferences = this.restoreTablePreferences();
        if (tablePreferences != null && (columnPreferences = tablePreferences.getColumnPreferences()) != null) {
            CollectionPropertySelector<ColumnPreference> nameSelector = new CollectionPropertySelector<ColumnPreference>(columnPreferences);
            ArrayList columnNames = (ArrayList)nameSelector.get("columnName", String.class);
            logger.finer(() -> LMG.log("(): Setting column order to: %s", () -> columnNames));
            this.columnModel.setColumnOrder(columnNames);
            for (ColumnPreference columnPreference : columnPreferences) {
                String columnName = columnPreference.getColumnName();
                int columnWidth = columnPreference.getColumnWidth();
                logger.finer(() -> LMG.log("(): Setting column '%s' to width %d.", () -> columnName, () -> columnWidth));
                this.columnModel.setColumnWidth(columnName, columnWidth);
            }
        }
        return tablePreferences;
    }

    public BeanTableModel<BeanType> getTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new BeanTableModel<BeanType>(this.elementType);
        }
        return this.tableModel;
    }

    @Override
    public void beforeRowsSorted() {
        this.selectedValues = this.getSelectedValues();
        this.displayTable.clearSelection();
    }

    @Override
    public void tableRowsSorted() {
        if (CollectionUtility.isNotEmpty(this.selectedValues)) {
            this.setSelectedValues(this.selectedValues);
        }
    }
}

