/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.swing.JMList;
import com.jmorgan.swing.event.ListSelectionEventInvoker;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ApplianceGroupObject;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.DomainGroup;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.ThreadManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public class ApplianceDomainChangeMonitor
extends AbstractTool {
    private static final String SUBSCRIBER = "subscriber";
    private static final String NOTIFICATION_METHOD = "notificationMethod";
    private static final String NOTIFY_FOR_APPLIANCES_ONLY = "notifyForAppliancesOnly";
    private static final String IS_WAITING = "isWaiting";
    private static ApplianceDomainChangeMonitor instance;
    private ArrayList<DynamicBean> subscribers;
    private JMList<ApplianceGroupObject> applianceGroupList;
    private JMList<DomainGroup> domainGroupList;
    private long lastAppliancesChangeTime;
    private long runningApplianceChangeTime;
    private boolean applianceSelectionChanging;
    private AsynchMethodInvoker<Void> applianceNotifier;
    private long lastDomainChangeTime;
    private long runningDomainChangeTime;
    private boolean domainSelectionChanging = false;
    private AsynchMethodInvoker<Void> domainNotifier;
    private final ReentrantLock reThreadLock = new ReentrantLock();

    public static ApplianceDomainChangeMonitor getInstance() {
        if (instance == null) {
            instance = new ApplianceDomainChangeMonitor();
        }
        return instance;
    }

    private ApplianceDomainChangeMonitor() {
        this.subscribers = new ArrayList();
    }

    public void setApplianceGroupList(JMList<ApplianceGroupObject> applianceGroupList) {
        this.applianceGroupList = applianceGroupList;
        new ListSelectionEventInvoker(this.applianceGroupList, this, "applianceSelectionChanged");
    }

    public void setDomainGroupList(JMList<DomainGroup> domainGroupList) {
        this.domainGroupList = domainGroupList;
        new ListSelectionEventInvoker(this.domainGroupList, this, "domainSelectionChanged");
    }

    public void addApplianceChangeSubscriber(Component subscriber, String notificationMethod) {
        this.addSubscriber(subscriber, notificationMethod, true);
    }

    public void addDomainChangeSubscriber(Component subscriber, String notificationMethod) {
        this.addSubscriber(subscriber, notificationMethod, false);
    }

    private void addSubscriber(Component subscriber, String notificationMethod, boolean forAppliancesOnly) {
        if (subscriber == null) {
            throw new NullPointerException("ApplianceDomainChangeMonitor.addApplianceChangeSubscriber(Component, String):  The subscriber cannot be null.");
        }
        if (StringUtility.isEmpty(notificationMethod)) {
            throw new NullPointerException("ApplianceDomainChangeMonitor.addApplianceChangeSubscriber(Component, String):  The notificaton method cannot be null.");
        }
        DynamicBean subscriberInfo = new DynamicBean();
        subscriberInfo.setProperty(SUBSCRIBER, subscriber);
        subscriberInfo.setProperty(NOTIFICATION_METHOD, notificationMethod);
        subscriberInfo.setProperty(NOTIFY_FOR_APPLIANCES_ONLY, forAppliancesOnly);
        subscriberInfo.setProperty(IS_WAITING, false);
        this.subscribers.add(subscriberInfo);
    }

    public MultiThreadInvocationListener invokeProcessByApplianceSelection(Object targetObject, String targetMethod, boolean appliancesOnly) {
        return this.invokeProcessByApplianceSelection(targetObject, targetMethod, appliancesOnly, false);
    }

    public MultiThreadInvocationListener invokeProcessByApplianceSelection(Object targetObject, String targetMethod, boolean appliancesOnly, boolean invokeSynchronously) {
        String loggerPrefix = String.format("(targetObject=%s, targetMethod=%s, appliancesOnly=%b, invokeSynchronously=%b)", targetObject.getClass().getSimpleName(), targetMethod, appliancesOnly, invokeSynchronously);
        AbstractTool.logger.finer(() -> LMG.log("%s: Starting", () -> loggerPrefix));
        MultiThreadInvocationListener mtil = null;
        if (!invokeSynchronously) {
            mtil = new MultiThreadInvocationListener();
        }
        if (appliancesOnly) {
            UniqueArrayList<Appliance> appliances = new UniqueArrayList<Appliance>(this.getCurrentApplianceSelection());
            for (Appliance appliance : appliances) {
                if (invokeSynchronously) {
                    MethodInvoker invoker = new MethodInvoker(targetObject, targetMethod, appliance);
                    invoker.invoke();
                    continue;
                }
                AsynchMethodInvoker thread = ThreadManager.getThread(appliance, targetObject, targetMethod, 0, appliance);
                mtil.addThread(thread);
            }
        } else {
            Index<Appliance, Domain> domains = this.getCurrentDomainSelection();
            ArrayList<Appliance> applianceLooper = new ArrayList<Appliance>(domains.getKeys());
            for (Appliance appliance : applianceLooper) {
                ArrayList<Domain> domainLooper = new ArrayList<Domain>(domains.get(appliance));
                for (Domain domain : domainLooper) {
                    if (invokeSynchronously) {
                        MethodInvoker invoker = new MethodInvoker(targetObject, targetMethod, appliance, domain);
                        invoker.invoke();
                        continue;
                    }
                    AsynchMethodInvoker thread = ThreadManager.getThread(appliance, targetObject, targetMethod, 0, appliance, domain);
                    mtil.addThread(thread);
                }
            }
        }
        AbstractTool.logger.finer(() -> LMG.log("%s: Done.  Returning invocation listener.", () -> loggerPrefix));
        return mtil;
    }

    public boolean isAllApplianceGroupSelected() {
        List selectedApplianceGroups = this.applianceGroupList.getSelectedValuesList();
        for (ApplianceGroupObject ago : selectedApplianceGroups) {
            if (!ago.getGroupName().equals("All")) continue;
            return true;
        }
        return false;
    }

    public UniqueArrayList<Appliance> getCurrentApplianceSelection() {
        List selectedApplianceGroups = this.applianceGroupList.getSelectedValuesList();
        UniqueArrayList<Appliance> selectedAppliances = new UniqueArrayList<Appliance>();
        while (selectedAppliances.size() == 0) {
            for (ApplianceGroupObject ago : selectedApplianceGroups) {
                ArrayList<Appliance> appliances = ago.getAppliances();
                for (Appliance appliance : appliances) {
                    if (!appliance.isConnected()) continue;
                    selectedAppliances.add(appliance);
                }
            }
            if (selectedAppliances.size() != 0) continue;
            ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT * 12);
        }
        return selectedAppliances;
    }

    public boolean isAllDomainGroupSelected() {
        List selectedApplianceGroups = this.applianceGroupList.getSelectedValuesList();
        List selectedDomainGroups = this.domainGroupList.getSelectedValuesList();
        for (ApplianceGroupObject ago : selectedApplianceGroups) {
            ArrayList<Appliance> appliances = ago.getAppliances();
            for (Appliance appliance : appliances) {
                if (!appliance.isConnected()) continue;
                for (DomainGroup dg : selectedDomainGroups) {
                    if (dg == null || !dg.getGroupName().equals("All")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Index<Appliance, Domain> getCurrentDomainSelection() {
        List selectedApplianceGroups = this.applianceGroupList.getSelectedValuesList();
        List selectedDomainGroups = this.domainGroupList.getSelectedValuesList();
        Index<Appliance, Domain> selectedDomainIndex = new Index<Appliance, Domain>();
        for (ApplianceGroupObject ago : selectedApplianceGroups) {
            ArrayList<Appliance> appliances = ago.getAppliances();
            for (Appliance appliance : appliances) {
                if (!appliance.isConnected()) continue;
                ArrayList<Domain> domains = appliance.getDomains();
                if (domains == null) {
                    AbstractTool.logger.warning(() -> LMG.log("(): Did appliance %s lose its connection?n  Domains is null!!", () -> appliance.getName()));
                    continue;
                }
                for (DomainGroup dg : selectedDomainGroups) {
                    if (dg == null) continue;
                    ArrayList<Domain> selectedDomains = dg.getDomains();
                    for (Domain selectedDomain : selectedDomains) {
                        if (!domains.contains(selectedDomain)) continue;
                        selectedDomainIndex.put(appliance, appliance.getDomain(selectedDomain.getName()));
                    }
                }
            }
        }
        return selectedDomainIndex;
    }

    public void applianceSelectionChanged() {
        AbstractTool.logger.finer("(): Starting");
        int waitCount = 0;
        int maxWaitCount = KumbaCoreConstants.THREAD_WAIT * 10;
        while (this.applianceSelectionChanging && waitCount < maxWaitCount) {
            AbstractTool.logger.finer("(): Waiting for last change to complete");
            ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
            ++waitCount;
        }
        if (waitCount >= maxWaitCount) {
            AbstractTool.logger.warning("(): Timeout waiting for last change to complete.  Pushing on.  Find out why!");
        }
        this.applianceSelectionChanging = true;
        AbstractTool.logger.finer("():  Starting");
        this.lastDomainChangeTime = this.lastAppliancesChangeTime = System.currentTimeMillis();
        this.reThreadLock.lock();
        try {
            if (this.applianceNotifier != null) {
                AbstractTool.logger.finer("(): applianceNotifier is active.  Cancelling.");
                this.applianceNotifier.cancel();
                AbstractTool.logger.finer("(): applianceNotifier cancelled.");
                waitCount = 0;
                while (waitCount < maxWaitCount && !this.applianceNotifier.wasCanceled() && this.applianceNotifier.hasCompleted()) {
                    AbstractTool.logger.finer("(): Waiting for applianceNotifier thread to complete.");
                    ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
                    ++waitCount;
                }
                if (waitCount >= maxWaitCount) {
                    AbstractTool.logger.warning("(): Timed out waiting for applianceNotifier thread to complete.  Find out why!");
                }
                AbstractTool.logger.finer("(): Setting applianceNotifier to null.");
                this.applianceNotifier = null;
                AbstractTool.logger.finer("(): applianceNotifier has completed.  Unlocking.");
            }
        }
        finally {
            this.reThreadLock.unlock();
        }
        UniqueArrayList<Appliance> selectedAppliances = this.getCurrentApplianceSelection();
        for (DynamicBean subscriberInfo : this.subscribers) {
            boolean isForAppliancesOnly = (Boolean)subscriberInfo.getProperty(NOTIFY_FOR_APPLIANCES_ONLY);
            if (!isForAppliancesOnly) continue;
            subscriberInfo.setProperty(IS_WAITING, true);
        }
        if (selectedAppliances.size() > 0) {
            this.applianceNotifier = new AsynchMethodInvoker((Object)this, "invokeWhenShowingForAppliances");
        }
        this.applianceSelectionChanging = false;
        AbstractTool.logger.finer("() : Done");
    }

    @Reflected
    private void invokeWhenShowingForAppliances() {
        this.runningApplianceChangeTime = this.lastAppliancesChangeTime;
        AbstractTool.logger.finer(() -> LMG.log("():  Starting:  runningApplianceChangeTime=%d, lastApplianceChangeTime=%d", () -> this.runningApplianceChangeTime, () -> this.lastAppliancesChangeTime));
        while (this.runningApplianceChangeTime == this.lastAppliancesChangeTime) {
            boolean allSubscribersNotified = true;
            for (DynamicBean subscriberInfo : this.subscribers) {
                boolean isForAppliancesOnly = (Boolean)subscriberInfo.getProperty(NOTIFY_FOR_APPLIANCES_ONLY);
                if (!isForAppliancesOnly) continue;
                Component subscriber = (Component)subscriberInfo.getProperty(SUBSCRIBER);
                boolean isWaiting = (Boolean)subscriberInfo.getProperty(IS_WAITING);
                try {
                    if (isWaiting && subscriber.isShowing()) {
                        AbstractTool.logger.finer(() -> LMG.log("(): Invoking for Appliance Changes.  Subscriber=%s, isWaiting=%b, isShowing=%b, forAppliancesOnly=%b\n", () -> subscriber.getClass().getName(), () -> isWaiting, () -> subscriber.isShowing(), () -> isForAppliancesOnly));
                        String notificationMethod = (String)subscriberInfo.getProperty(NOTIFICATION_METHOD);
                        UniqueArrayList<Appliance> selectedAppliances = this.getCurrentApplianceSelection();
                        new AsynchMethodInvoker((Object)subscriber, notificationMethod, selectedAppliances);
                        subscriberInfo.setProperty(IS_WAITING, false);
                        continue;
                    }
                    allSubscribersNotified = false;
                }
                catch (RuntimeException e) {
                    AbstractTool.logger.severe(() -> LMG.log("(): Didn't find %s within %s\n", () -> subscriberInfo.getProperty(NOTIFICATION_METHOD), () -> subscriber.getClass().getName()));
                }
            }
            if (allSubscribersNotified) break;
            ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
        }
        AbstractTool.logger.finer(() -> LMG.log("(selectedAppliances): Ending:  runningApplianceChangeTime=%d, lastApplianceChangeTime=%d", () -> this.runningApplianceChangeTime, () -> this.lastAppliancesChangeTime));
    }

    public void domainSelectionChanged() {
        AbstractTool.logger.finer("(): Starting");
        if (this.domainSelectionChanging) {
            AbstractTool.logger.finer("():  Last invocation is not complete.  Invoking again.");
            new AsynchMethodInvoker((Object)this, "domainSelectionChanged", KumbaCoreConstants.THREAD_WAIT);
            return;
        }
        this.lastDomainChangeTime = System.currentTimeMillis();
        this.domainSelectionChanging = true;
        this.reThreadLock.lock();
        try {
            if (this.domainNotifier != null) {
                AbstractTool.logger.finer("():  Domain notifier is active.  Cancelling its thread.");
                this.domainNotifier.cancel();
                boolean domainNotifierCancelled = this.domainNotifier.wasCanceled();
                boolean domainNotifierComplete = this.domainNotifier.hasCompleted();
                int tries = 0;
                while (tries < 4 && !domainNotifierCancelled && !domainNotifierComplete) {
                    AbstractTool.logger.finer("():  Waiting for domainNotifier thread to complete.");
                    ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
                    if (this.domainNotifier != null) {
                        domainNotifierCancelled = this.domainNotifier.wasCanceled();
                        domainNotifierComplete = this.domainNotifier.hasCompleted();
                    }
                    ++tries;
                }
                if (tries == 4) {
                    AbstractTool.logger.warning("():  Timed out waiting for domainNotifier thread to complete.");
                }
                AbstractTool.logger.finer("():  Cleaning up last domainNotifier thread.");
                this.domainNotifier = null;
            }
        }
        finally {
            this.reThreadLock.unlock();
        }
        AbstractTool.logger.finer("():  Getting the current domain selection.  Notifying subscribers");
        Index<Appliance, Domain> selectedDomainIndex = this.getCurrentDomainSelection();
        for (DynamicBean subscriberInfo : this.subscribers) {
            boolean isForAppliancesOnly = (Boolean)subscriberInfo.getProperty(NOTIFY_FOR_APPLIANCES_ONLY);
            if (isForAppliancesOnly) continue;
            subscriberInfo.setProperty(IS_WAITING, true);
        }
        if (selectedDomainIndex.size() > 0) {
            AbstractTool.logger.fine("():  Visible subscribers being notified.");
            this.domainNotifier = new AsynchMethodInvoker((Object)this, "invokeWhenShowingForDomains", KumbaCoreConstants.THREAD_WAIT);
        }
        AbstractTool.logger.finer("(): Done");
        this.domainSelectionChanging = false;
    }

    @Reflected
    private void invokeWhenShowingForDomains() {
        this.runningDomainChangeTime = this.lastDomainChangeTime;
        AbstractTool.logger.finer(() -> LMG.log("(): Starting:  runningDomainChangeTime=%d lastDomainChangeTime=%d", () -> this.runningDomainChangeTime, () -> this.lastDomainChangeTime));
        while (this.runningDomainChangeTime == this.lastDomainChangeTime) {
            boolean allSubscribersNotified = true;
            for (DynamicBean subscriberInfo : this.subscribers) {
                boolean forAppliancesOnly = (Boolean)subscriberInfo.getProperty(NOTIFY_FOR_APPLIANCES_ONLY);
                if (forAppliancesOnly) continue;
                Component subscriber = (Component)subscriberInfo.getProperty(SUBSCRIBER);
                boolean isWaiting = (Boolean)subscriberInfo.getProperty(IS_WAITING);
                if (isWaiting && subscriber.isShowing()) {
                    AbstractTool.logger.finer(() -> LMG.log("Invoking for Domain Changes.  Subscriber=%s, isWaiting=%b, isShowing=%b\n", () -> subscriber.getClass().getName(), () -> isWaiting, () -> subscriber.isShowing()));
                    String notificationMethod = (String)subscriberInfo.getProperty(NOTIFICATION_METHOD);
                    Index<Appliance, Domain> selectedDomains = this.getCurrentDomainSelection();
                    new AsynchMethodInvoker((Object)subscriber, notificationMethod, selectedDomains);
                    subscriberInfo.setProperty(IS_WAITING, false);
                    continue;
                }
                allSubscribersNotified = false;
            }
            if (allSubscribersNotified) break;
            ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
        }
        AbstractTool.logger.finer(() -> LMG.log("(selectedDomains): Ending:  runningDomainChangeTime=%d lastDomainChangeTime=%d", () -> this.runningDomainChangeTime, () -> this.lastDomainChangeTime));
    }
}

