/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.lang.Application;
import com.jmorgan.swing.JMFrame;
import com.jmorgan.swing.MainPanel;
import com.jmorgan.swing.dialog.wizard.WizardDialog;
import com.jmorgan.swing.statusbar.StatusBar;
import com.kumbasoft.core.app.KumbaCoreApplicationProperties;
import com.kumbasoft.core.beans.ApplianceGroupObject;
import com.kumbasoft.core.beans.DomainGroup;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.LicenseDialog;
import com.kumbasoft.core.ui.dialog.changeCredentialsWizard.CurrentCredentialsPage;
import com.kumbasoft.core.ui.dialog.changeCredentialsWizard.NewCredentialsPage;
import com.kumbasoft.core.ui.panel.ApplianceDomainListPanel;
import com.kumbasoft.core.util.FileUtility;
import com.kumbasoft.core.util.logging.AuditLogHandler;
import com.kumbasoft.core.util.security.SecurityManager;
import java.awt.Container;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Logger;
import javax.swing.JFrame;

public class KumbaCoreFrame
extends JMFrame {
    private StatusBar statusBar;
    protected ApplianceDomainListPanel applianceDomainListPanel;

    public KumbaCoreFrame(String title) {
        super(title);
    }

    @Override
    public Container buildGUI() {
        this.statusBar = new StatusBar(this);
        this.statusBar.addAvailableMemory();
        return new MainPanel(10, 5);
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    @Override
    protected void setFrameIcon() {
        this.setIconImage(KumbaCoreUIConstants.KUMBA_LOGO.getImage());
    }

    @Override
    public Image getAboutDialogIcon() {
        return KumbaCoreUIConstants.KUMBA_HELP_LOGO.getImage();
    }

    @Override
    public void setupEventHandling() {
        super.setupEventHandling();
        Application app = Application.getApplication();
        this.windowCloser.addNotificationTarget(201, app, "cleanupTemporaryFiles", new Object[0]);
    }

    public void editChangeCredentials() {
        Handler[] handlers;
        DynamicBean credentials = new DynamicBean();
        credentials.setProperty("currentUserName", "");
        credentials.setProperty("currentPassword", "");
        credentials.setProperty("newUserName", "");
        credentials.setProperty("newPassword", "");
        WizardDialog<DynamicBean> wizard = new WizardDialog<DynamicBean>((JFrame)this, "Change DPAA\u00ae Credentials");
        wizard.addWizardPage(new CurrentCredentialsPage(credentials), "currentCredentials");
        wizard.addWizardPage(new NewCredentialsPage(credentials), "newCredentials");
        wizard.setSize(580, 200);
        wizard.startWizard();
        if (WizardDialog.wasCancelled()) {
            return;
        }
        String oldUserName = (String)credentials.getProperty("currentUserName");
        String newUserName = (String)credentials.getProperty("newUserName");
        String newPassword = (String)credentials.getProperty("newPassword");
        SecurityManager.setUserSuppliedCredentials(newUserName.toCharArray(), newPassword.toCharArray());
        KumbaCoreApplicationProperties applicationProperties = (KumbaCoreApplicationProperties)Application.getApplication().getApplicationProperties();
        String initConfigFile = applicationProperties.getInitConfigFile();
        Application application = Application.getApplication();
        Logger logger = application.getApplicationLogger();
        Handler[] handlerArray = handlers = logger.getHandlers();
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray[n2];
            if (handler instanceof AuditLogHandler) {
                AuditLogHandler auditLogHandler = (AuditLogHandler)handler;
                auditLogHandler.setApplicationUser(newUserName);
            }
            ++n2;
        }
        ArrayList appliances = (ArrayList)BeanService.getPropertyValue(application, "appliances");
        FileUtility.saveInitConfig(initConfigFile, appliances);
    }

    @Reflected
    private void helpLicenseInfo() {
        new LicenseDialog(this);
    }

    public List<ApplianceGroupObject> getSelectedApplianceGroup() {
        return this.applianceDomainListPanel.getSelectedApplianceGroup();
    }

    public List<DomainGroup> getSelectedDomainGroup() {
        return this.applianceDomainListPanel.getSelectedDomainGroup();
    }

    public ApplianceDomainListPanel getApplianceDomainListPanel() {
        if (this.applianceDomainListPanel == null) {
            this.applianceDomainListPanel = new ApplianceDomainListPanel();
        }
        return this.applianceDomainListPanel;
    }
}

