/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.io.filefilter.DirectoryFileFilter;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.GUIApplication;
import com.jmorgan.swing.JMImageIcon;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.layout.VerticalFlowLayout;
import com.jmorgan.swing.list.JMListCellRenderer;
import com.jmorgan.swing.list.ListCellValueRenderer;
import com.jmorgan.swing.menu.JMMenuItem;
import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.swing.util.HoverBorderController;
import com.jmorgan.swing.util.InsetsFactory;
import com.jmorgan.util.StringUtility;
import com.kumbasoft.core.annotations.PreferencesInfo;
import com.kumbasoft.core.ui.KumbaCoreFrame;
import com.kumbasoft.core.ui.KumbaCoreGUIApplicationProperties;
import com.kumbasoft.core.util.FileUtility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import javax.swing.border.Border;

public final class KumbaCoreUIConstants {
    public static final boolean IS_GRAPHICAL_ENVIRONMENT;
    public static final int FRAME_WAIT_ATTEMPTS = 20;
    public static String ART_ROOT;
    private static final String ICON_PREFERENCES_CATEGORY_NAME = "Icons";
    private static final int ICON_PREFERENCES_CATEGORY_ORDER = 70;
    private static final String ICON_PREFERENCES_GENERAL_GROUP_NAME = "General";
    private static final String APPLIANCE_MANAGEMENT_ICON_PREFERENCES_GROUP_NAME = "Appliance Management";
    private static final int APPLIANCE_MANAGEMENT_ICON_PREFERENCES_CATEGORY_ORDER = 80;
    private static final String ACTIONS_ICON_PREFERENCES_GROUP_NAME = "Actions";
    private static final int ACTIONS_ICON_PREFERENCES_CATEGORY_ORDER = 90;
    private static final String GRAPH_ICON_PREFERENCES_GROUP_NAME = "Graphs";
    private static final int GRAPH_ICON_PREFERENCES_CATEGORY_ORDER = 100;
    private static final String STATUS_ICON_PREFERENCES_GROUP_NAME = "Status Indicators";
    private static final int STATUS_ICON_PREFERENCES_CATEGORY_ORDER = 110;
    private static final String FILE_ICON_PREFERENCES_GROUP_NAME = "File Management";
    private static final int FILE_ICON_PREFERENCES_CATEGORY_ORDER = 120;
    private static final String COLOR_PREFERENCES_CATEGORY_NAME = "Colors";
    private static final int COLOR_PREFERENCES_CATEGORY_ORDER = 60;
    private static final String COLOR_PREFERENCES_GENERAL_GROUP_NAME = "General";
    private static final String COLOR_PREFERENCES_LIST_GROUP_NAME = "Lists";
    private static final int COLOR_PREFERENCES_LIST_CATEGORY_ORDER = 61;
    private static final String COLOR_PREFERENCES_STATUS_GROUP_NAME = "Status";
    private static final int COLOR_PREFERENCES_STATUS_CATEGORY_ORDER = 62;
    private static final String FONT_PREFERENCES_CATEGORY_NAME = "Fonts";
    private static final int FONT_PREFERENCES_CATEGORY_ORDER = 50;
    @PreferencesInfo(categoryName="Icons", groupName="General", displayName="Add", helpFile="AddIcon.html", categoryOrder=70, groupOrder=10)
    public static JMImageIcon ADD_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="General", displayName="Copy", helpFile="CopyIcon.html", categoryOrder=70, groupOrder=20)
    public static JMImageIcon COPY_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="General", displayName="Cancel", helpFile="CancelIcon.html", categoryOrder=70, groupOrder=30)
    public static JMImageIcon CANCEL_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="General", displayName="Close", helpFile="CloseIcon.html", categoryOrder=70, groupOrder=40)
    public static JMImageIcon CLOSE_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="General", displayName="Clear Field", helpFile="ClearIcon.html", categoryOrder=70, groupOrder=50)
    public static JMImageIcon CLEAR_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="General", displayName="Clear Cache", helpFile="Clean.html", categoryOrder=70, groupOrder=60)
    public static JMImageIcon CLEAN_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="General", displayName="Case Sensitivity Off", helpFile="CaseSensitivityOffIcon.html", categoryOrder=70, groupOrder=70)
    public static JMImageIcon CASE_SENSITIVITY_OFF_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="General", displayName="Case Sensitivity On", helpFile="CaseSensitivityOnIcon.html", categoryOrder=70, groupOrder=80)
    public static JMImageIcon CASE_SENSITIVITY_ON_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="General", displayName="Delete", helpFile="DeleteIcon.html", categoryOrder=70, groupOrder=90)
    public static JMImageIcon DELETE_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="General", displayName="Download", helpFile="DownloadIcon.html", categoryOrder=70, groupOrder=100)
    public static JMImageIcon DOWNLOAD_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="General", displayName="Edit", helpFile="EditIcon.html", categoryOrder=70, groupOrder=110)
    public static JMImageIcon EDIT_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="General", displayName="Import", helpFile="ImportIcon.html", categoryOrder=70, groupOrder=120)
    public static JMImageIcon IMPORT_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="General", displayName="Export", helpFile="ExportIcon.html", categoryOrder=70, groupOrder=130)
    public static JMImageIcon EXPORT_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="General", displayName="Filter", helpFile="FilterIcon.html", categoryOrder=70, groupOrder=140)
    public static JMImageIcon FILTER_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="General", displayName="Clear Filter", helpFile="ClearFilterIcon.html", categoryOrder=70, groupOrder=150)
    public static JMImageIcon FILTER_CLEAR_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="General", displayName="Popup Menu Icon", helpFile="HamburgerIcon.html", categoryOrder=70, groupOrder=160)
    public static JMImageIcon HAMBURGER_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="General", displayName="Minimize Icon", helpFile="MaximizeIcon.html", categoryOrder=70, groupOrder=180)
    public static JMImageIcon MINIMIZE_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="General", displayName="File New", helpFile="NewIcon.html", categoryOrder=70, groupOrder=190)
    public static JMImageIcon NEW_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="General", displayName="Next or Forward", helpFile="NextIcon.html", categoryOrder=70, groupOrder=200)
    public static JMImageIcon NEXT_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="General", displayName="Open", helpFile="OpenIcon.html", categoryOrder=70, groupOrder=210)
    public static JMImageIcon OPEN_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="General", displayName="Previous or Back", helpFile="PreviousIcon.html", categoryOrder=70, groupOrder=220)
    public static JMImageIcon PREVIOUS_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="General", displayName="Refresh", helpFile="RefreshIcon.html", categoryOrder=70, groupOrder=230)
    public static JMImageIcon REFRESH_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="General", displayName="Run", helpFile="RunIcon.html", categoryOrder=70, groupOrder=240)
    public static JMImageIcon RUN_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="General", displayName="Save", helpFile="SaveIcon.html", categoryOrder=70, groupOrder=250)
    public static JMImageIcon SAVE_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="General", displayName="Save All", helpFile="SaveAllIcon.html", categoryOrder=70, groupOrder=260)
    public static JMImageIcon SAVE_ALL_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="General", displayName="Save As", helpFile="SaveAsIcon.html", categoryOrder=70, groupOrder=270)
    public static JMImageIcon SAVEAS_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="General", displayName="Search", helpFile="SearchIcon.html", categoryOrder=70, groupOrder=280)
    public static JMImageIcon SEARCH_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="General", displayName="Select All", helpFile="SelectAllIcon.html", categoryOrder=70, groupOrder=290)
    public static JMImageIcon SELECT_ALL_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="General", displayName="Select None", helpFile="SelectNoneIcon.html", categoryOrder=70, groupOrder=300)
    public static JMImageIcon SELECT_NONE_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="General", displayName="Start", helpFile="StartIcon.html", categoryOrder=70, groupOrder=310)
    public static JMImageIcon START_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="General", displayName="Stop", helpFile="StopIcon.html", categoryOrder=70, groupOrder=320)
    public static JMImageIcon STOP_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="General", displayName="Change Credentials", helpFile="ChangeCredentialsIcon.html", categoryOrder=70, groupOrder=1000)
    public static JMImageIcon CHANGECREDS_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="Appliance Management", displayName="Set Categories", helpFile="CategoriesIcon.html", categoryOrder=80, groupOrder=10)
    public static JMImageIcon CATEGORIES_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="Appliance Management", displayName="Add Categories", helpFile="AddCategoriesIcon.html", categoryOrder=80, groupOrder=20)
    public static JMImageIcon ADD_CATEGORIES_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="Appliance Management", displayName="Connect", helpFile="ConnectIcon.html", categoryOrder=80, groupOrder=30)
    public static JMImageIcon CONNECT_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="Actions", displayName="Domain Checkpoint", helpFile="CheckPointIcon.html", categoryOrder=90, groupOrder=10)
    public static JMImageIcon CHECKPOINT_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="Actions", displayName="Restore Checkpoint", helpFile="RestoreCheckPointIcon.html", categoryOrder=90, groupOrder=20)
    public static JMImageIcon RESTORE_CHECKPOINT_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="Actions", displayName="Enable", helpFile="EnabledIcon.html", categoryOrder=90, groupOrder=30)
    public static JMImageIcon ENABLED_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="Actions", displayName="Disable", helpFile="DisabledIcon.html", categoryOrder=90, groupOrder=40)
    public static JMImageIcon DISABLED_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="Actions", displayName="Quiesce", helpFile="SleepIcon.html", categoryOrder=90, groupOrder=50)
    public static JMImageIcon SLEEP_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="Actions", displayName="Un-quiesce", helpFile="WakeIcon.html", categoryOrder=90, groupOrder=60)
    public static JMImageIcon WAKE_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="Actions", displayName="Snap Shot", helpFile="SnapShotIcon.html", categoryOrder=90, groupOrder=60)
    public static JMImageIcon SNAPSHOT_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="Graphs", displayName="Area Chart", helpFile="AreaChartIcon.html", categoryOrder=100, groupOrder=10)
    public static JMImageIcon AREA_CHART_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="Graphs", displayName="Bar Chart", helpFile="BarChartIcon.html", categoryOrder=100, groupOrder=20)
    public static JMImageIcon BAR_CHART_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="Graphs", displayName="Line Chart", helpFile="LineChartIcon.html", categoryOrder=100, groupOrder=30)
    public static JMImageIcon LINE_CHART_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="Status Indicators", displayName="Debug Logs On", helpFile="DebugIcon.html", categoryOrder=110, groupOrder=10)
    public static JMImageIcon DEBUG_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="Status Indicators", displayName="Deleted Resource", helpFile="DeletedIcon.html", categoryOrder=110, groupOrder=20)
    public static JMImageIcon DELETED_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="Status Indicators", displayName="Diagnostic Mode On", helpFile="DiagnosisIcon.html", categoryOrder=110, groupOrder=30)
    public static JMImageIcon DIAGNOSIS_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="Status Indicators", displayName="Failsafe Mode", helpFile="FailSafeIcon.html", categoryOrder=110, groupOrder=33)
    public static JMImageIcon FAILSAFE_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="Status Indicators", displayName="Memory Quarantine", helpFile="QuarantineIcon.html", categoryOrder=110, groupOrder=35)
    public static JMImageIcon QUARANTINE_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="Status Indicators", displayName="Management Traffic Only", helpFile="ManagementTrafficOnlyIcon.html", categoryOrder=110, groupOrder=37)
    public static JMImageIcon MANAGEMENT_TRAFFIC_ONLY_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="Status Indicators", displayName="Save Needed", helpFile="DirtyIcon.html", categoryOrder=110, groupOrder=40)
    public static JMImageIcon DIRTY_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="Status Indicators", displayName="Externally Configured Object", helpFile="ExternalIcon.html", categoryOrder=110, groupOrder=60)
    public static JMImageIcon EXTERNAL_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="Status Indicators", displayName="Configuration Modified", helpFile="ModifiedIcon.html", categoryOrder=110, groupOrder=70)
    public static JMImageIcon MODIFIED_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="Status Indicators", displayName="Operational State Up", helpFile="OpStateUpIcon.html", categoryOrder=110, groupOrder=80)
    public static JMImageIcon OP_STATE_UP_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="Status Indicators", displayName="Operational State Down", helpFile="OpStateDownIcon.html", categoryOrder=110, groupOrder=90)
    public static JMImageIcon OP_STATE_DOWN_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="Status Indicators", displayName="Probe Enabled", helpFile="ProbeIcon.html", categoryOrder=110, groupOrder=100)
    public static JMImageIcon PROBE_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="Status Indicators", displayName="Configuration Saved", helpFile="SavedIcon.html", categoryOrder=110, groupOrder=110)
    public static JMImageIcon SAVED_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="Status Indicators", displayName="Trace Enabled", helpFile="TraceIcon.html", categoryOrder=110, groupOrder=120)
    public static JMImageIcon TRACE_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="File Management", displayName="Generate Error Report", helpFile="ErrorReportIcon.html", categoryOrder=120, groupOrder=10)
    public static JMImageIcon ERROR_REPORT_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="File Management", displayName="Format", helpFile="FormatIcon.html", categoryOrder=120, groupOrder=30)
    public static JMImageIcon FORMAT_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="File Management", displayName="Format All", helpFile="FormatAllIcon.html", categoryOrder=120, groupOrder=40)
    public static JMImageIcon FORMAT_ALL_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="File Management", displayName="Move Directories", helpFile="MoveIcon.html", categoryOrder=120, groupOrder=50)
    public static JMImageIcon MOVE_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="File Management", displayName="Undo", helpFile="UndoIcon.html", categoryOrder=120, groupOrder=60)
    public static JMImageIcon UNDO_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="File Management", displayName="Upload", helpFile="UploadIcon.html", categoryOrder=120, groupOrder=70)
    public static JMImageIcon UPLOAD_ICON;
    @PreferencesInfo(categoryName="Icons", groupName="File Management", displayName="URL", helpFile="URLIcon.html", categoryOrder=120, groupOrder=80)
    public static JMImageIcon URL_ICON;
    public static final JMImageIcon KUMBA_LOGO;
    public static final JMImageIcon KUMBA_HELP_LOGO;
    public static final JMImageIcon LICENSE_ICON;
    public static final JMImageIcon LOGON_ICON;
    public static final JMImageIcon LOGS_ICON;
    public static final JMImageIcon OVERLAY_ICON;
    public static final JMImageIcon QUESTION_ICON;
    public static final JMImageIcon SORT_AZ_ICON;
    public static final JMImageIcon SORT_ZA_ICON;
    public static final JMListCellRenderer<String> DEFAULT_LIST_CELL_RENDERER;
    @PreferencesInfo(categoryName="Colors", groupName="General", displayName="Foreground", helpFile="ForegroundColor.html", categoryOrder=60, groupOrder=10)
    public static Color FOREGROUND;
    @PreferencesInfo(categoryName="Colors", groupName="General", displayName="Selected Foreground", helpFile="SelectedForegroundColor.html", categoryOrder=60, groupOrder=20)
    public static Color SELECTED_FOREGROUND;
    @PreferencesInfo(categoryName="Colors", groupName="General", displayName="Disabled Foreground", helpFile="DisabledForegroundColor.html", categoryOrder=60, groupOrder=30)
    public static Color DISABLED_FOREGROUND;
    @PreferencesInfo(categoryName="Colors", groupName="General", displayName="Background", helpFile="BackgroundColor.html", categoryOrder=60, groupOrder=40)
    public static Color BACKGROUND;
    @PreferencesInfo(categoryName="Colors", groupName="General", displayName="Light Background", helpFile="LightBackgroundColor.html", categoryOrder=60, groupOrder=50)
    public static Color LIGHT_BACKGROUND;
    @PreferencesInfo(categoryName="Colors", groupName="General", displayName="Shadow", helpFile="DarkShadowColor.html", categoryOrder=60, groupOrder=60)
    public static Color DARK_SHADOW;
    @PreferencesInfo(categoryName="Colors", groupName="General", displayName="Error", helpFile="ErrorColor.html", categoryOrder=60, groupOrder=80)
    public static Color ERROR_COLOR;
    @PreferencesInfo(categoryName="Colors", groupName="General", displayName="Error Contrast", helpFile="ErrorContrastColor.html", categoryOrder=60, groupOrder=90)
    public static Color ERROR_CONTRAST;
    @PreferencesInfo(categoryName="Colors", groupName="General", displayName="Externally Configured", helpFile="ExternalColor.html", categoryOrder=60, groupOrder=100)
    public static Color EXTERNAL_COLOR_UNSELECTED;
    @PreferencesInfo(categoryName="Colors", groupName="General", displayName="Externally Configured Selected", helpFile="ExternalSelectedColor.html", categoryOrder=60, groupOrder=110)
    public static Color EXTERNAL_COLOR_SELECTED;
    @PreferencesInfo(categoryName="Colors", groupName="General", displayName="Warning", helpFile="WarnColor.html", categoryOrder=60, groupOrder=120)
    public static Color WARN_COLOR;
    @PreferencesInfo(categoryName="Colors", groupName="General", displayName="New Object Color", helpFile="NewObjectForegroundColor.html", categoryOrder=60, groupOrder=130)
    public static Color NEW_OBJECT_FOREGROUND;
    @PreferencesInfo(categoryName="Colors", groupName="General", displayName="Passwords Match", helpFile="MatchedPasswordColor.html", categoryOrder=60, groupOrder=140)
    public static Color MATCHED_PASSWORD;
    @PreferencesInfo(categoryName="Colors", groupName="General", displayName="Passwords Do Not Match", helpFile="UnmatchedPasswordColor.html", categoryOrder=60, groupOrder=150)
    public static Color UNMATCHED_PASSWORD;
    @PreferencesInfo(categoryName="Colors", groupName="Lists", displayName="Selected Item Foreground", helpFile="ListSelectedForegroundColor.html", categoryOrder=61, groupOrder=10)
    public static Color LIST_SELECTED_FOREGROUND;
    @PreferencesInfo(categoryName="Colors", groupName="Lists", displayName="Selected Item Background", helpFile="ListSelectedBackgroundColor.html", categoryOrder=61, groupOrder=20)
    public static Color LIST_SELECTED_BACKGROUND;
    @PreferencesInfo(categoryName="Colors", groupName="Lists", displayName="Unselected Item Foreground", helpFile="ListUnselectedForegroundColor.html", categoryOrder=61, groupOrder=30)
    public static Color LIST_UNSELECTED_FOREGROUND;
    @PreferencesInfo(categoryName="Colors", groupName="Lists", displayName="Unselected Item Background", helpFile="ListUnselectedBackgroundColor.html", categoryOrder=61, groupOrder=40)
    public static Color LIST_UNSELECTED_BACKGROUND;
    @PreferencesInfo(categoryName="Colors", groupName="Lists", displayName="Won't Delete Item Foreground", helpFile="WontDeleteForegroundColor.html", categoryOrder=61, groupOrder=50)
    public static Color WONT_DELETE_FOREGROUND_COLOR;
    @PreferencesInfo(categoryName="Colors", groupName="Lists", displayName="Won't Delete Item Background", helpFile="WontDeleteBackgroundColor.html", categoryOrder=61, groupOrder=60)
    public static Color WONT_DELETE_BACKGROUND_COLOR;
    @PreferencesInfo(categoryName="Colors", groupName="Lists", displayName="List & Table Borders", helpFile="TableCellBorderColor.html", categoryOrder=61, groupOrder=70)
    public static Color TABLE_CELL_BORDER_COLOR;
    public static final Border HOVER_BUTTON_BORDER;
    public static final Color OVERLAY_COLOR;
    public static final Color OVERLAY_BACKGROUND;
    @PreferencesInfo(categoryName="Colors", groupName="Status", displayName="Unconnected Appliance Foreground", helpFile="ApplianceUnconnectedForegroundColor.html", categoryOrder=62, groupOrder=10)
    public static Color APPLIANCE_UNCONNECTED_FOREGROUND;
    @PreferencesInfo(categoryName="Colors", groupName="Status", displayName="Unconnected Appliance Background", helpFile="ApplianceUnconnectedBackgroundColor.html", categoryOrder=62, groupOrder=20)
    public static Color APPLIANCE_UNCONNECTED_BACKGROUND;
    @PreferencesInfo(categoryName="Colors", groupName="Status", displayName="Partially Connected Appliance Group Foreground", helpFile="ApplianceGroupPartiallyConnectedForegroundColor.html", categoryOrder=62, groupOrder=30)
    public static Color APPLIANCE_GROUP_PARTIALLY_CONNECTED_FOREGROUND;
    @PreferencesInfo(categoryName="Colors", groupName="Status", displayName="Partially Connected Appliance Group Background", helpFile="ApplianceGroupPartiallyConnectedBackgroundColor.html", categoryOrder=62, groupOrder=40)
    public static Color APPLIANCE_GROUP_PARTIALLY_CONNECTED_BACKGROUND;
    @PreferencesInfo(categoryName="Colors", groupName="Status", displayName="Status Being Monitored", helpFile="StatusMonitoredColor.html", categoryOrder=62, groupOrder=50)
    public static Color STATUS_MONITORED_COLOR;
    @PreferencesInfo(categoryName="Fonts", displayName="Application Font", helpFile="ApplicationFont.html", categoryOrder=50)
    public static Font FONT;
    public static final Border BUTTON_BORDER;
    public static final Dimension LIST_VALUE_RENDERER_SIZE;
    public static final HoverBorderController HOVER_BORDER_CONTROLLER;
    public static final Cursor WAIT_CURSOR;
    public static final Cursor NORMAL_CURSOR;
    public static final DirectoryFileFilter DIRECTORY_FILE_FILTER;
    public static final int VERTICAL_GAP = 10;
    public static final int HORIZONTAL_GAP = 10;
    public static final int INSETS_SIZE = 5;

    static {
        HashMap<Class<?>, HashMap<String, Object>> savedPreferences = KumbaCoreUIConstants.readLastUsedPreferences();
        if (savedPreferences != null) {
            for (Class<?> constantsType : savedPreferences.keySet()) {
                HashMap<String, Object> preferences = savedPreferences.get(constantsType);
                if (!constantsType.equals(KumbaCoreUIConstants.class)) continue;
                for (String fieldName : preferences.keySet()) {
                    Object value = preferences.get(fieldName);
                    String stringValue = value.toString();
                    if (value instanceof JMImageIcon) {
                        JMImageIcon imageIcon = (JMImageIcon)value;
                        if (stringValue.contains("/DPAA/resources/") || stringValue.contains("/DPAA.jar!/resources/")) {
                            iconName = StringUtility.substringAfter(stringValue, "/resources/");
                            URL iconResource = GUIApplication.getMenuResource("/resources/", iconName);
                            if (iconResource == null) continue;
                            value = new JMImageIcon(iconResource);
                        } else {
                            iconName = imageIcon.getDescription();
                            value = new JMImageIcon(iconName);
                        }
                    }
                    BeanService.setPropertyValue(constantsType, fieldName, value);
                }
            }
            new AsynchMethodInvoker((Class<?>)KumbaCoreUIConstants.class, "setFrameMenuPreferences", (Object)savedPreferences, 1000);
        } else {
            KumbaCoreUIConstants.setNonFinalStaticDefaults();
        }
        IS_GRAPHICAL_ENVIRONMENT = !GraphicsEnvironment.isHeadless();
        ART_ROOT = "/resources/";
        KUMBA_LOGO = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "KumbaSoft.png"));
        KUMBA_HELP_LOGO = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "KumbaSoftHelp.png"));
        LICENSE_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "License.png"), "View your DPAA software license");
        LOGON_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Key.png"));
        LOGS_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Logs.png"), "View DPAA Logs");
        OVERLAY_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "LargeShield.png"));
        QUESTION_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Question.png"));
        SORT_AZ_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "SortAscending.png"));
        SORT_ZA_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "SortDescending.png"));
        DEFAULT_LIST_CELL_RENDERER = new JMListCellRenderer();
        HOVER_BUTTON_BORDER = BorderFactory.createLineBorder(FOREGROUND);
        OVERLAY_COLOR = Color.WHITE;
        OVERLAY_BACKGROUND = new Color(0.0f, 0.0f, 0.0f, 0.5f);
        BUTTON_BORDER = BorderFactory.createLineBorder(BACKGROUND.brighter().brighter());
        LIST_VALUE_RENDERER_SIZE = new Dimension(200, 18);
        HOVER_BORDER_CONTROLLER = new HoverBorderController(HOVER_BUTTON_BORDER);
        WAIT_CURSOR = new Cursor(3);
        NORMAL_CURSOR = new Cursor(0);
        DIRECTORY_FILE_FILTER = new DirectoryFileFilter();
    }

    public static void setNonFinalStaticDefaults() {
        if (ART_ROOT == null) {
            ART_ROOT = "/resources/";
        }
        ADD_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "FileNew.png"));
        COPY_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Copy.png"));
        CANCEL_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Cancel.png"));
        CLOSE_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Close.png"));
        CLEAR_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "ClearScreen.png"));
        CLEAN_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Clean.png"));
        CASE_SENSITIVITY_OFF_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "CaseSensitiveOff.png"));
        CASE_SENSITIVITY_ON_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "CaseSensitiveOn.png"));
        DELETE_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Delete.png"));
        DOWNLOAD_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Download.png"));
        EDIT_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "FileOpen.png"));
        IMPORT_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Import.png"));
        EXPORT_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Export.png"));
        FILTER_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Filter.png"));
        FILTER_CLEAR_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "FilterClear.png"));
        HAMBURGER_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Hamburger.png"));
        MINIMIZE_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Minimize.png"));
        NEW_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "New.png"));
        NEXT_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Next.png"));
        OPEN_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "OpenFolder.png"));
        PREVIOUS_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Previous.png"));
        REFRESH_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Refresh.png"));
        RUN_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Run.png"));
        SAVE_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Save.png"));
        SAVE_ALL_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "SaveAll.png"));
        SAVEAS_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "SaveAs.png"));
        SEARCH_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Search.png"));
        SELECT_ALL_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "SelectAll.png"));
        SELECT_NONE_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "SelectNone.png"));
        START_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Start.png"));
        STOP_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Stop.png"));
        CHANGECREDS_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "ChangeCreds.png"));
        CATEGORIES_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Categories.png"));
        ADD_CATEGORIES_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "AddCategories.png"));
        CONNECT_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Connect.png"));
        CHECKPOINT_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "CheckPoint.png"));
        RESTORE_CHECKPOINT_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "RestoreCheckpoint.png"));
        ENABLED_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Enabled.png"));
        DISABLED_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Disabled.png"));
        SLEEP_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Sleep.png"));
        WAKE_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Wake.png"));
        SNAPSHOT_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "SnapShot.png"));
        AREA_CHART_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "AreaChart.png"));
        BAR_CHART_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "BarChart.png"));
        LINE_CHART_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "LineChart.png"));
        DEBUG_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Debug.png"));
        DELETED_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Deleted.png"));
        DIAGNOSIS_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Diagnosis.png"));
        FAILSAFE_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "FailSafe.png"));
        QUARANTINE_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Quarantine.png"));
        MANAGEMENT_TRAFFIC_ONLY_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "TrafficCop.png"));
        DIRTY_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "NotSaved.png"));
        EXTERNAL_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "External.png"));
        MODIFIED_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Modified.png"));
        OP_STATE_UP_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "OpStateUp.png"));
        OP_STATE_DOWN_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "OpStateDown.png"));
        PROBE_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Probe.png"));
        SAVED_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Saved.png"));
        TRACE_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Pencil.png"));
        ERROR_REPORT_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "ErrorReport.png"));
        FORMAT_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Reformat.png"));
        FORMAT_ALL_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "ReformatAll.png"));
        MOVE_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Move.png"));
        UNDO_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Undo.png"));
        UPLOAD_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "Upload.png"));
        URL_ICON = new JMImageIcon(GUIApplication.getMenuResource(ART_ROOT, "URL.png"));
        FOREGROUND = new Color(203, 203, 203);
        SELECTED_FOREGROUND = new Color(255, 255, 255);
        DISABLED_FOREGROUND = new Color(130, 130, 130);
        BACKGROUND = new Color(47, 47, 47);
        LIGHT_BACKGROUND = new Color(70, 70, 70);
        DARK_SHADOW = Color.BLACK;
        ERROR_COLOR = Color.RED;
        ERROR_CONTRAST = Color.WHITE;
        EXTERNAL_COLOR_UNSELECTED = new Color(184, 205, 230);
        EXTERNAL_COLOR_SELECTED = EXTERNAL_COLOR_UNSELECTED.darker().darker().darker();
        WARN_COLOR = Color.ORANGE;
        NEW_OBJECT_FOREGROUND = Color.GREEN.darker().darker();
        MATCHED_PASSWORD = Color.GREEN.darker().darker();
        UNMATCHED_PASSWORD = Color.ORANGE.darker().darker();
        LIST_SELECTED_FOREGROUND = Color.WHITE;
        LIST_SELECTED_BACKGROUND = new Color(240, 119, 70);
        LIST_UNSELECTED_FOREGROUND = FOREGROUND;
        LIST_UNSELECTED_BACKGROUND = new Color(47, 47, 47);
        WONT_DELETE_FOREGROUND_COLOR = Color.WHITE;
        WONT_DELETE_BACKGROUND_COLOR = new Color(1, 50, 32);
        TABLE_CELL_BORDER_COLOR = FOREGROUND;
        APPLIANCE_UNCONNECTED_FOREGROUND = FOREGROUND;
        APPLIANCE_UNCONNECTED_BACKGROUND = Color.RED.darker().darker();
        APPLIANCE_GROUP_PARTIALLY_CONNECTED_FOREGROUND = Color.BLACK;
        APPLIANCE_GROUP_PARTIALLY_CONNECTED_BACKGROUND = new Color(255, 215, 0);
        STATUS_MONITORED_COLOR = new Color(87, 204, 0);
        FONT = new Font("Tahoma", 0, 12);
    }

    public static BorderLayout createBorderLayout() {
        return new BorderLayout(10, 10);
    }

    public static JMPanel createBorderLayoutPanel() {
        JMPanel panel = new JMPanel(KumbaCoreUIConstants.createBorderLayout());
        return panel;
    }

    public static FlowLayout createFlowLayout(int layoutJustification) {
        return new FlowLayout(layoutJustification, 10, 10);
    }

    public static JMPanel createFlowLayoutPanel(int layoutJustification) {
        JMPanel panel = new JMPanel(KumbaCoreUIConstants.createFlowLayout(layoutJustification));
        return panel;
    }

    public static VerticalFlowLayout createVerticalFlowLayout(int layoutJustification) {
        return new VerticalFlowLayout(layoutJustification, 10);
    }

    public static JMPanel createVerticalFlowLayoutPanel(int layoutJustification) {
        JMPanel panel = new JMPanel(KumbaCoreUIConstants.createVerticalFlowLayout(layoutJustification));
        panel.setInsets(InsetsFactory.createFixedInsets(5));
        return panel;
    }

    public static GridLayout createGridLayout(int rows, int columns) {
        return new GridLayout(rows, columns, 10, 10);
    }

    public static JMPanel createGridLayoutPanel(int rows, int columns) {
        JMPanel panel = new JMPanel(KumbaCoreUIConstants.createGridLayout(rows, columns));
        panel.setInsets(InsetsFactory.createFixedInsets(5));
        return panel;
    }

    public static <ElementType> JMListCellRenderer<ElementType> createListCellRenderer() {
        JMListCellRenderer renderer = new JMListCellRenderer();
        KumbaCoreUIConstants.setupRenderer(renderer);
        return renderer;
    }

    public static <ElementType> JMListCellRenderer<ElementType> createListCellRenderer(ListCellValueRenderer valueRenderer) {
        JMListCellRenderer renderer = new JMListCellRenderer(valueRenderer);
        KumbaCoreUIConstants.setupRenderer(renderer);
        return renderer;
    }

    public static <ElementType> void setupRenderer(JMListCellRenderer<ElementType> renderer) {
        renderer.setSelectedColor(LIST_SELECTED_FOREGROUND);
        renderer.setSelectedBackground(LIST_SELECTED_BACKGROUND);
        renderer.setUnSelectedColor(LIST_UNSELECTED_FOREGROUND);
        renderer.setUnSelectedBackground(LIST_UNSELECTED_BACKGROUND);
    }

    public static JMScrollPane createScrollPane(Component view) {
        return KumbaCoreUIConstants.createScrollPane(view, 200);
    }

    public static JMScrollPane createScrollPane(Component view, int viewPortWidth) {
        JMScrollPane scrollPanel = new JMScrollPane(view);
        Dimension viewPortMinimum = new Dimension(viewPortWidth, 0);
        view.setMinimumSize(viewPortMinimum);
        return scrollPanel;
    }

    @Reflected
    private static void setFrameMenuPreferences(HashMap<Class<?>, HashMap<String, Object>> savedPreferences) {
        KumbaCoreFrame frame = (KumbaCoreFrame)GUIApplication.getGUIApplication().getApplicationFrame();
        if (frame == null) {
            new AsynchMethodInvoker((Class<?>)KumbaCoreUIConstants.class, "setFrameMenuPreferences", (Object)savedPreferences, 250);
            return;
        }
        JMenuBar menuBar = frame.getJMenuBar();
        if (menuBar == null) {
            new AsynchMethodInvoker((Class<?>)KumbaCoreUIConstants.class, "setFrameMenuPreferences", (Object)savedPreferences, 250);
            return;
        }
        JToolBar toolBar = frame.getToolBar();
        if (toolBar == null) {
            new AsynchMethodInvoker((Class<?>)KumbaCoreUIConstants.class, "setFrameMenuPreferences", (Object)savedPreferences, 250);
            return;
        }
        Collection<JMMenuItem> menuItems = GUIServices.findImplementingComponents(menuBar, JMMenuItem.class);
        HashMap<String, Object> menuItemPreferences = savedPreferences.get(JMMenuItem.class);
        for (JMMenuItem menuItem : menuItems) {
            String newIconURLString;
            String text;
            JMMenuItem preferenceItem;
            JMImageIcon newIcon;
            String newIconFileName;
            JMImageIcon oldIcon = (JMImageIcon)menuItem.getIcon();
            if (oldIcon == null || (newIconFileName = (newIcon = (JMImageIcon)(preferenceItem = (JMMenuItem)menuItemPreferences.get(text = menuItem.getText())).getIcon()).getFileName()) != null && (newIconFileName.contains("/DPAA/resources/") || newIconFileName.contains("/DPAA.jar!/resources/"))) continue;
            URL newIconURL = newIcon.getUrl();
            String string = newIconURLString = newIconURL == null ? "" : newIconURL.toString();
            if (newIconURL != null && (newIconURLString.contains("/DPAA/resources/") || newIconURLString.contains("/DPAA.jar!/resources/")) || newIconFileName == null && newIconURL == null) continue;
            GUIServices.updateMenuIcons(frame, oldIcon, newIcon);
        }
    }

    public static void savePreferences() {
        File lastUsedThemeFile = KumbaCoreUIConstants.getLastUsedThemeFile();
        HashMap<String, Object> uiPreferences = KumbaCoreUIConstants.getConstanValues(KumbaCoreUIConstants.class);
        KumbaCoreFrame frame = (KumbaCoreFrame)GUIApplication.getGUIApplication().getApplicationFrame();
        JMenuBar menuBar = frame.getJMenuBar();
        Collection<JMMenuItem> menuItems = GUIServices.findImplementingComponents(menuBar, JMMenuItem.class);
        HashMap<String, JMMenuItem> menuPreferences = new HashMap<String, JMMenuItem>(menuItems.size());
        for (JMMenuItem menuItem : menuItems) {
            menuPreferences.put(menuItem.getText(), menuItem);
        }
        HashMap<Class, HashMap<String, Object>> preferenceValues = new HashMap<Class, HashMap<String, Object>>();
        preferenceValues.put(KumbaCoreUIConstants.class, uiPreferences);
        preferenceValues.put(JMMenuItem.class, menuPreferences);
        FileUtility.writeObject(lastUsedThemeFile, preferenceValues, true);
    }

    private static HashMap<String, Object> getConstanValues(Class<?> constantsType) {
        HashMap<String, Field> preferenceFields = BeanService.getFieldMap(constantsType, PreferencesInfo.class);
        HashMap<String, Object> preferenceValues = new HashMap<String, Object>(preferenceFields.size());
        for (String fieldName : preferenceFields.keySet()) {
            Field field = preferenceFields.get(fieldName);
            try {
                Object value = field.get(constantsType);
                preferenceValues.put(fieldName, value);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return preferenceValues;
    }

    private static HashMap<Class<?>, HashMap<String, Object>> readLastUsedPreferences() {
        File lastUsedThemeFile = KumbaCoreUIConstants.getLastUsedThemeFile();
        if (!lastUsedThemeFile.exists()) {
            return null;
        }
        HashMap savedPreferences = (HashMap)FileUtility.readObject(lastUsedThemeFile, true);
        return savedPreferences;
    }

    private static File getLastUsedThemeFile() {
        Application application = Application.getApplication();
        KumbaCoreGUIApplicationProperties applicationProperties = null;
        applicationProperties = application == null ? new KumbaCoreGUIApplicationProperties() : (KumbaCoreGUIApplicationProperties)application.getApplicationProperties();
        String themesDirectory = applicationProperties.getThemesDirectory();
        String lastUsedThemeFileName = String.format("%sLastUsedTheme.dat", themesDirectory);
        File lastUsedThemeFile = new File(lastUsedThemeFileName);
        return lastUsedThemeFile;
    }

    public static void deleteLastUsedThemeFile() {
        File lastUsedThemeFile = KumbaCoreUIConstants.getLastUsedThemeFile();
        lastUsedThemeFile.delete();
    }

    private KumbaCoreUIConstants() {
    }
}

