/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.dialog;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.GUIApplication;
import com.jmorgan.swing.AboutDialog;
import com.jmorgan.swing.ActiveLabel;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMDialog;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMPasswordField;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.PictureControl;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.component.PreferredSizeComponent;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.event.ItemEventInvoker;
import com.jmorgan.swing.layout.VerticalFlowLayout;
import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.swing.util.InsetsFactory;
import com.jmorgan.swing.util.LabelUtility;
import com.jmorgan.swing.util.WindowCloser;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.StringUtility;
import com.kumbasoft.core.app.KumbaCoreApplicationServices;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.PasswordVerificationController;
import com.kumbasoft.core.util.security.LicenseInformation;
import com.kumbasoft.core.util.security.SecurityManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JFrame;

public class LogonDialog
extends JMDialog {
    public static boolean logonValid = false;
    private PictureControl logonImage;
    private JMLabel userManagedAccessLabel;
    private JMTextField tfUserName;
    private JMPasswordField tfPassword;
    private JMPasswordField tfVerifyPassword;
    private JMCheckBox cbxLaunchApplianceManagementDialog;
    private JMCheckBox cbxAcceptLicense;
    private ActiveLabel viewLicense;
    private JMButton btnLogon;
    private JMButton btnCancel;
    private JMPanel fieldPanel;
    private boolean isNewUser;
    private int logonErrors;

    public LogonDialog(JFrame owner, Object ... arguments) {
        super(owner, "Log On", true, arguments);
    }

    @Override
    public void buildGUI(Object ... arguments) {
        logonValid = false;
        this.isNewUser = (Boolean)arguments[0];
        this.logonImage = new PictureControl(KumbaCoreUIConstants.LOGON_ICON.getImage());
        this.logonImage.setPreferredSize(48, 48);
        String logonLabel = this.isNewUser ? "Setup" : "Logon";
        int labelWidth = this.isNewUser ? 125 : 75;
        String kumbaHeader = LabelUtility.wrapInHTML("<h2>Kumba Software LLC - DPAA&reg;</h2>");
        JMLabel kumbaCredits = new JMLabel(kumbaHeader);
        String userLogonMessage = KumbaCoreApplicationServices.getLogonMessage("html");
        this.userManagedAccessLabel = new JMLabel(userLogonMessage);
        LicenseInformation licenseInformation = new LicenseInformation();
        String licenseTag = licenseInformation.getLicenseHTML();
        JMLabel licenseLabel = new JMLabel(LabelUtility.wrapInHTML(licenseTag));
        JMPanel htmlPanels = new JMPanel(new VerticalFlowLayout(3, 10));
        htmlPanels.addAll(kumbaCredits, this.userManagedAccessLabel, licenseLabel);
        JMPanel headerPanel = new JMPanel(new BorderLayout(10, 1));
        PreferredSizeComponent logonIconComponent = new PreferredSizeComponent(this.logonImage);
        logonIconComponent.setBorder(BorderFactory.createEmptyBorder(50, 1, 1, 1));
        headerPanel.add((Component)logonIconComponent, "West");
        headerPanel.add((Component)htmlPanels, "Center");
        this.tfUserName = new JMTextField(30);
        this.tfPassword = new JMPasswordField(30);
        this.tfPassword.setName("LogongDialog.password");
        this.btnLogon = new JMButton(logonLabel);
        this.btnCancel = new JMButton("Cancel");
        this.fieldPanel = new JMPanel(new VerticalFlowLayout(3, 5));
        this.fieldPanel.setInsets(InsetsFactory.createFixedInsets(25));
        this.fieldPanel.add(headerPanel);
        this.fieldPanel.add(LogonDialog.createLabeledComponent("User Name:", this.tfUserName, labelWidth, 0));
        this.fieldPanel.add(LogonDialog.createLabeledComponent("Password:", this.tfPassword, labelWidth, 0));
        if (this.isNewUser) {
            this.btnLogon.setEnabled(false);
            this.tfVerifyPassword = new JMPasswordField(30);
            this.fieldPanel.add(LogonDialog.createLabeledComponent("Verify Password:", this.tfVerifyPassword, labelWidth, 0));
            this.viewLicense = new ActiveLabel("Accept Software License");
            this.cbxAcceptLicense = new JMCheckBox();
            JMPanel acceptPanel = new JMPanel(new BorderLayout(10, 1));
            acceptPanel.add((Component)this.cbxAcceptLicense, "West");
            acceptPanel.add((Component)this.viewLicense, "Center");
            this.fieldPanel.add(new PreferredSizeComponent(acceptPanel));
        } else {
            this.cbxLaunchApplianceManagementDialog = new JMCheckBox("Change Appliance Credentials Before Connecting");
            this.fieldPanel.add(ComponentFactory.createSpacer(10, 5));
            JMPanel launchPanel = new JMPanel(new FlowLayout(0, 0, 0));
            launchPanel.addAll(ComponentFactory.createSpacer(78, 23), this.cbxLaunchApplianceManagementDialog);
            this.fieldPanel.add(launchPanel);
        }
        JMPanel buttonPanel = new JMPanel();
        buttonPanel.addAll(this.btnLogon, this.btnCancel);
        this.fieldPanel.add(buttonPanel);
        this.contentPane.add(this.fieldPanel);
        new AsynchMethodInvoker((Object)this.tfUserName, "grabFocus", KumbaCoreConstants.THREAD_WAIT);
    }

    private static LabeledComponent createLabeledComponent(String label, Component field, int labelWidth, int fieldWidth) {
        LabeledComponent lc = new LabeledComponent(label, field, labelWidth, fieldWidth);
        lc.setPreferredSize(lc.getPreferredSize().width, 25);
        return lc;
    }

    @Override
    public void setupEventHandling() {
        new ActionEventInvoker(this.btnLogon, this, "logon");
        new ActionEventInvoker(this.btnCancel, this, "cancel");
        if (this.cbxAcceptLicense != null) {
            new ItemEventInvoker(this.cbxAcceptLicense, this, "licenseAccepted");
        }
        if (this.viewLicense != null) {
            new ActionEventInvoker(this.viewLicense, this, "showAboutDialog");
        }
        this.btnLogon.setActivator(this.tfPassword, 10);
        if (this.tfVerifyPassword != null) {
            new PasswordVerificationController(this.tfPassword, this.tfVerifyPassword);
            this.btnLogon.setActivator(this.tfVerifyPassword, 10);
        }
    }

    @Reflected
    private void licenseAccepted() {
        boolean acceptSelected = this.cbxAcceptLicense.isSelected();
        if (acceptSelected) {
            DateTime licenseAcceptedDate = new DateTime();
            Application.getApplication().setAttribute("acceptedLicenseDate", licenseAcceptedDate);
        } else {
            Application.getApplication().removeAttribute("acceptedLicenseDate");
        }
        this.btnLogon.setEnabled(acceptSelected);
    }

    @Reflected
    private void showAboutDialog() {
        this.setModal(false);
        new AboutDialog((JFrame)GUIApplication.getGUIApplication().getApplicationFrame(), "About DPAA", true);
        this.setModal(true);
    }

    @Reflected
    private void logon() {
        if (!this.btnLogon.isEnabled()) {
            return;
        }
        if (StringUtility.isEmpty(this.tfUserName.getText()) || StringUtility.isEmpty(this.tfPassword.getText())) {
            new JMMessageBox((JFrame)GUIApplication.getGUIApplication().getApplicationFrame(), "Invalid Credentials", "User name and password are required");
            return;
        }
        char[] userName = this.tfUserName.getText().toCharArray();
        char[] password = this.tfPassword.getText().toCharArray();
        if (this.tfVerifyPassword != null) {
            if (StringUtility.isEmpty(this.tfVerifyPassword.getText())) {
                new JMMessageBox((JFrame)GUIApplication.getGUIApplication().getApplicationFrame(), "Invalid Credentials", "Verify password is required");
                return;
            }
            char[] vPassword = this.tfVerifyPassword.getText().toCharArray();
            if (!Arrays.equals(password, vPassword)) {
                return;
            }
        }
        boolean launchApplianceManagement = this.cbxLaunchApplianceManagementDialog == null ? false : this.cbxLaunchApplianceManagementDialog.isSelected();
        Application.getApplication().setAttribute("openApplianceManagementOnStartup", launchApplianceManagement);
        Application.getApplication().setAttribute("healthChecksAllowed", !launchApplianceManagement);
        SecurityManager.setUserSuppliedCredentials(userName, password);
        logonValid = SecurityManager.readInitConfigData();
        if (this.isNewUser) {
            logonValid = true;
        }
        if (!logonValid) {
            if (++this.logonErrors == 5) {
                this.cancel();
                return;
            }
            new JMMessageBox(GUIServices.getFrame(this), "Invalid Credentials", "The user name or password is incorrect.");
            return;
        }
        this.closeDialog();
    }

    @Reflected
    private void cancel() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.tfUserName.setText("");
        this.tfPassword.setText("");
        if (this.tfVerifyPassword != null) {
            this.tfVerifyPassword.setText("");
        }
        WindowCloser.closeWindow(this, 0, false);
    }
}

