/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.dialog.applianceManagement;

import com.jmorgan.swing.JMLabel;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public class CategoriesTableCellRenderer
extends JMLabel
implements TableCellRenderer {
    private Color normalForeground;
    private Color normalBackground;

    public CategoriesTableCellRenderer() {
        this.setBorder(UIManager.getBorder("TextField.border"));
        this.setOpaque(true);
        this.normalForeground = UIManager.getColor("Table.selectionForeground");
        this.normalBackground = UIManager.getColor("Table.selectionBackground");
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setBackground(isSelected ? this.normalBackground : this.normalForeground);
        this.setForeground(isSelected ? this.normalForeground : this.normalBackground);
        this.setText("");
        if (value == null) {
            return this;
        }
        if (value instanceof ArrayList) {
            ArrayList categories = (ArrayList)value;
            StringBuilder sb = new StringBuilder();
            for (String category : categories) {
                sb.append(category.trim());
                sb.append(" ");
            }
            this.setText(sb.toString().trim());
        }
        return this;
    }
}

