/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.dialog.logSearchOptions;

import com.jmorgan.swing.JMCheckBox;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.beans.DataPowerLogSearchOptions;
import com.kumbasoft.core.ui.dialog.logSearchOptions.AbstractSearchOptionsPanel;

public class DataPowerLogSearchOptionsPanel
extends AbstractSearchOptionsPanel<DataPowerLogSearchOptions> {
    private JMCheckBox cbxFollowTransactions;
    private JMCheckBox cbxFollowGlobalTransactions;
    private JMCheckBox cbxAutoClearLogs;

    public DataPowerLogSearchOptionsPanel(DataPowerLogSearchOptions searchOptions) {
        super(searchOptions);
    }

    @Override
    protected void createControls() {
        super.createControls();
        this.cbxFollowTransactions = new JMCheckBox("Follow Transactions", ((DataPowerLogSearchOptions)this.searchOptions).followTransactions());
        this.cbxFollowGlobalTransactions = new JMCheckBox("Follow Global Transactions", ((DataPowerLogSearchOptions)this.searchOptions).followGlobalTransactions());
        this.cbxAutoClearLogs = new JMCheckBox("Auto Clear Logs", ((DataPowerLogSearchOptions)this.searchOptions).autoClearOldLogs());
        this.addAll(this.cbxFollowTransactions, this.cbxFollowGlobalTransactions, this.cbxAutoClearLogs);
    }

    @Override
    protected void setSearchOptions(DataPowerLogSearchOptions searchOptions) {
        super.setSearchOptions(searchOptions);
        if (this.cbxFollowTransactions != null) {
            this.cbxFollowTransactions.setSelected(((DataPowerLogSearchOptions)this.searchOptions).followTransactions());
        }
        if (this.cbxFollowGlobalTransactions != null) {
            this.cbxFollowGlobalTransactions.setSelected(((DataPowerLogSearchOptions)this.searchOptions).followGlobalTransactions());
        }
        if (this.cbxAutoClearLogs != null) {
            this.cbxAutoClearLogs.setSelected(((DataPowerLogSearchOptions)this.searchOptions).autoClearOldLogs());
        }
    }

    @Override
    protected DataPowerLogSearchOptions createSearchOptions() {
        return new DataPowerLogSearchOptions();
    }

    @Override
    protected void saveOptions() {
        super.saveOptions();
        AbstractPanel.logger.finer("(): Starting");
        ((DataPowerLogSearchOptions)this.searchOptions).setFollowTransactions(this.cbxFollowTransactions.isSelected());
        ((DataPowerLogSearchOptions)this.searchOptions).setFollowGlobalTransactions(this.cbxFollowGlobalTransactions.isSelected());
        ((DataPowerLogSearchOptions)this.searchOptions).setAutoClearOldLogs(this.cbxAutoClearLogs.isSelected());
        AbstractPanel.logger.finer("(): Done");
    }

    @Override
    public boolean parentDialogClosing() {
        this.saveOptions();
        return super.parentDialogClosing();
    }
}

