/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.dialog.logSearchOptions;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.swing.JMCheckBox;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.config.ConfigLogTarget;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.ui.dialog.logSearchOptions.AbstractLogSettingsPanel;
import java.util.ArrayList;

public class DataPowerLogSettingsPanel
extends AbstractLogSettingsPanel {
    private static final String[] DISPLAY_LOG_LEVELS = new String[]{"emergency", "alert", "critical", "error", "warning", "notice", "information", "debug"};
    private JMCheckBox cbxLogRBM;
    private JMCheckBox cbxLogInternal;
    private boolean defaultLogSelected;

    public DataPowerLogSettingsPanel(DynamicBean logSettings) {
        super(logSettings);
    }

    @Override
    protected void createControls() {
        super.createControls();
        ArrayList selectedLoggingTargets = (ArrayList)this.logSettings.getProperty("loggingTargets");
        for (DataPowerConfig config : selectedLoggingTargets) {
            ConfigLogTarget logTargetConfig = (ConfigLogTarget)config;
            if (!logTargetConfig.getName().equals("default-log") || !logTargetConfig.getSourceDomain().getName().equals("default")) continue;
            this.defaultLogSelected = true;
        }
        if (this.defaultLogSelected) {
            this.cbxLogRBM = new JMCheckBox("Log RBM");
            this.cbxLogInternal = new JMCheckBox("Log Internal");
            this.addAll(this.cbxLogRBM, this.cbxLogInternal);
        }
    }

    @Override
    protected String getComboBoxLabel() {
        return "Log Level:";
    }

    @Override
    protected String[] getComboBoxElements() {
        return DISPLAY_LOG_LEVELS;
    }

    @Override
    protected String getDefaultSelectedItem() {
        return DISPLAY_LOG_LEVELS[DISPLAY_LOG_LEVELS.length - 1];
    }

    @Override
    protected int getDefaultFileSize() {
        return 500;
    }

    @Override
    protected int getMinimumFileSize() {
        return 100;
    }

    @Override
    protected int getMaximumFileSize() {
        return 50000;
    }

    @Override
    protected String getSelectedLogLevel() {
        int selectedLogLevel = this.cbxLevel.getSelectedIndex();
        return DPEnumerations.LOG_LEVEL[selectedLogLevel];
    }

    @Override
    public boolean parentDialogClosing() {
        if (this.defaultLogSelected) {
            boolean logInternal = this.cbxLogInternal.isSelected();
            boolean logRBM = this.cbxLogRBM.isSelected();
            this.logSettings.setProperty("logInternal", logInternal);
            this.logSettings.setProperty("logRBM", logRBM);
        }
        return super.parentDialogClosing();
    }
}

