/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.dialog.preferences;

import com.jmorgan.beans.util.BeanService;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.annotations.PreferencesInfo;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.preferences.Preference;
import com.kumbasoft.core.util.FileUtility;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;

public class PreferencesPropertyResolver
extends AbstractTool {
    private static final Class<KumbaCoreConstants> CORE_CONSTANTS = KumbaCoreConstants.class;
    private static final Class<KumbaCoreUIConstants> UI_CONSTANTS = KumbaCoreUIConstants.class;
    private ArrayList<Preference> preferences = new ArrayList();

    public PreferencesPropertyResolver() {
        this.resolvePreferencesFromClass(CORE_CONSTANTS);
        this.resolvePreferencesFromClass(UI_CONSTANTS);
    }

    public List<Preference> getPreferences() {
        return this.preferences;
    }

    private void resolvePreferencesFromClass(Class<?> type) {
        logger.finer(() -> LMG.log("(type=%s):  Starting", () -> type.getSimpleName()));
        HashMap<String, Field> fieldMap = BeanService.getFieldMap(type, PreferencesInfo.class);
        for (String fieldName : fieldMap.keySet()) {
            Field field = fieldMap.get(fieldName);
            Preference preference = new Preference(field);
            preference.setHelpFileContents(this.getHelpFileContents(preference));
            this.preferences.add(preference);
        }
        logger.finer(() -> LMG.log("(type=%s):  Done", () -> type.getSimpleName()));
    }

    private String getHelpFileContents(Preference preference) {
        PreferencesInfo preferencesInfo = preference.getPreferenceInfo();
        String helpFileContents = null;
        if (preferencesInfo != null) {
            String baseHelpFileName = preferencesInfo.helpFile();
            Locale locale = Locale.getDefault();
            String language = locale.getISO3Language();
            String helpFileName = String.format("./configs/%s/preferences/%s", language, baseHelpFileName);
            File helpFile = new File(helpFileName);
            if (helpFile.exists()) {
                try {
                    helpFileContents = FileUtility.readFile(helpFileName);
                }
                catch (IOException iOException) {}
            } else {
                helpFileName = String.format("./configs/eng/preferences/%s", baseHelpFileName);
                helpFile = new File(helpFileName);
                if (!helpFile.exists()) {
                    try {
                        this.createDefaultHelpFile(helpFile, preference);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    helpFileContents = FileUtility.readFile(helpFileName);
                }
                catch (IOException e1) {
                    helpFileContents = "";
                }
            }
        } else {
            helpFileContents = "";
        }
        return helpFileContents;
    }

    private void createDefaultHelpFile(File helpFile, Preference preference) throws IOException {
        PreferencesInfo preferencesInfo = preference.getPreferenceInfo();
        Field field = preference.getField();
        Class<Object> type = field.getType();
        String typeName = type.getSimpleName();
        if (type.isAssignableFrom(Number.class) || typeName.equals("int") || typeName.equals("long")) {
            typeName = "value";
        }
        if (type.isAssignableFrom(Icon.class)) {
            typeName = "icon";
        }
        StringBuilder sb = new StringBuilder("<html>\n\t<body>\n\t\t<p>The ");
        sb.append(typeName);
        sb.append(" used for ");
        sb.append(preferencesInfo.displayName());
        sb.append(".</p>\n\t\t<br/>\n");
        if (preferencesInfo.defaultIntValue() > 0) {
            sb.append("\t\t<p>The default value is ");
            sb.append(preferencesInfo.defaultIntValue());
            if (preferencesInfo.minimum() > 0) {
                sb.append(" and has a range from ");
                sb.append(preferencesInfo.minimum());
                sb.append(" to ");
                sb.append(preferencesInfo.maximum());
            }
            sb.append(".</p>\n");
        }
        sb.append("\t</body>\n</html>");
        FileUtility.writeFile(helpFile, sb.toString());
    }
}

