/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.editors;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.util.BeanIndexer;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.table.ComboBoxTableCellEditor;
import com.jmorgan.util.Index;
import com.jmorgan.util.collection.CollectionPropertySelector;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.event.TableModelEvent;

public class DPObjectListTableCellEditor
extends ComboBoxTableCellEditor {
    private String displayProperty;
    private String filterProperty;
    private String filterPropertyValue;
    private boolean isRequired;
    private ArrayList<StatusObjectStatus> objectList;
    private ArrayList<String> displayedList;
    private Index<String, StatusObjectStatus> objectsByFilterProperty;

    public DPObjectListTableCellEditor(ArrayList<StatusObjectStatus> objects) {
        this.isRequired = false;
        this.displayProperty = "name";
        this.setObjects(objects);
    }

    public DPObjectListTableCellEditor(Index<Appliance, Domain> domains, String objectTypeExpression, String displayProperty, boolean isRequired) {
        this.isRequired = isRequired;
        this.displayProperty = displayProperty;
        new AsynchMethodInvoker((Object)this, "getObjectList", new Object[]{domains, objectTypeExpression});
    }

    @Reflected
    private void getObjectList(Index<Appliance, Domain> domains, String objectTypeExpression) {
        if (objectTypeExpression.startsWith("com.kumbasoft.core.beans.config.Config")) {
            objectTypeExpression = objectTypeExpression.replace("com.kumbasoft.core.beans.config.Config", "");
        }
        ConfigurationManager configurationManager = new ConfigurationManager();
        this.objectList = configurationManager.listObjects(domains, objectTypeExpression, ".*");
        if (CollectionUtility.isEmpty(this.objectList)) {
            return;
        }
        this.showElements(this.objectList);
    }

    public ArrayList<StatusObjectStatus> getObjects() {
        return this.objectList;
    }

    public void setObjects(ArrayList<StatusObjectStatus> objectList) {
        this.objectList = objectList;
        this.showElements(this.objectList);
    }

    public String getFilterProperty() {
        return this.filterProperty;
    }

    public void setFilterProperty(String filterProperty) {
        this.filterProperty = filterProperty;
        if (this.filterProperty == null) {
            this.objectsByFilterProperty.clear();
            this.objectsByFilterProperty = null;
            this.filterPropertyValue = null;
            this.showElements(this.objectList);
            return;
        }
        if (this.objectsByFilterProperty != null) {
            this.objectsByFilterProperty.clear();
            this.objectsByFilterProperty = null;
        }
    }

    public String getFilterPropertyValue() {
        return this.filterPropertyValue;
    }

    public void setFilterPropertyValue(String filterPropertyValue) {
        if (this.objectList != null && this.filterProperty != null && this.objectsByFilterProperty == null) {
            BeanIndexer<StatusObjectStatus> filterPropertyIndexer = new BeanIndexer<StatusObjectStatus>(this.objectList);
            this.objectsByFilterProperty = filterPropertyIndexer.getIndexOf(this.filterProperty, "");
        }
        this.filterPropertyValue = filterPropertyValue;
        Collection<StatusObjectStatus> elementsToShow = this.objectsByFilterProperty.get(filterPropertyValue);
        this.showElements(elementsToShow);
    }

    private void showElements(Collection<StatusObjectStatus> elementsToShow) {
        CollectionPropertySelector<StatusObjectStatus> displayPropertySelector = new CollectionPropertySelector<StatusObjectStatus>(elementsToShow);
        Collection<String> allDisplayProperties = displayPropertySelector.get(this.displayProperty, String.class);
        UniqueArrayList<String> displayProperties = new UniqueArrayList<String>(allDisplayProperties);
        if (!this.isRequired) {
            displayProperties.add("");
        }
        displayProperties.sort();
        this.displayedList = displayProperties;
        this.setComboBoxElements(displayProperties);
    }

    public String getDisplayProperty() {
        return this.displayProperty;
    }

    public ArrayList<String> getDisplayedElements() {
        return this.displayedList;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
    }
}

