/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.editors;

import com.jmorgan.beans.util.BeanService;
import com.jmorgan.util.Index;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.ui.editors.DPEnumerationTableCellEditor;
import com.kumbasoft.core.ui.editors.DPFileTableCellEditor;
import com.kumbasoft.core.ui.editors.DPObjectListTableCellEditor;
import com.kumbasoft.core.util.DataPowerFileUtility;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.table.TableCellEditor;

public class DataPowerComponentFactory
extends AbstractTool {
    private HashMap<Appliance, Index<Domain, StatusObjectStatus>> objectCache;
    private HashMap<Appliance, Index<Domain, DataPowerFileInfo>> fileCache;

    public TableCellEditor createTableEditor(DataPowerConfig dataPowerConfig, String propertyName) {
        Method method = BeanService.getPropertyAccessor(dataPowerConfig, propertyName);
        XMLInfo xmlInfo = (XMLInfo)BeanService.getMethodAnnotation(method, XMLInfo.class);
        boolean isURL = false;
        boolean isReference = false;
        String referencedType = "";
        String validationRegexp = ".*";
        String[] allowedValues = new String[]{};
        int numericalMinimum = -1;
        long numericalMaximum = -1L;
        int minimumLength = -1;
        int maximumLength = -1;
        validationRegexp = xmlInfo.validationRegex();
        allowedValues = xmlInfo.allowedValues();
        numericalMinimum = xmlInfo.minimum();
        numericalMaximum = xmlInfo.maximum();
        minimumLength = xmlInfo.minimumLength();
        maximumLength = xmlInfo.maximumLength();
        if (xmlInfo.isEnumeration()) {
            return this.getEnumerationCellEditor(xmlInfo);
        }
        String dataPowerType = xmlInfo.dataPowerType();
        if (dataPowerType.equals("dmURL") || dataPowerType.equals("dmFSFile")) {
            return this.getFileCellEditor(dataPowerConfig);
        }
        if (dataPowerType.equals("dmReference")) {
            isReference = true;
            referencedType = xmlInfo.refType();
            return this.getReferenceCellEditor(dataPowerConfig, referencedType);
        }
        return null;
    }

    private DPEnumerationTableCellEditor getEnumerationCellEditor(XMLInfo xmlInfo) {
        String enumerationName = xmlInfo.dataPowerType();
        DPEnumerationTableCellEditor cellEditor = new DPEnumerationTableCellEditor(enumerationName);
        return cellEditor;
    }

    private DPFileTableCellEditor getFileCellEditor(DataPowerConfig dataPowerConfig) {
        Appliance appliance = dataPowerConfig.getAppliance();
        Domain domain = dataPowerConfig.getSourceDomain();
        ArrayList<String> domainFiles = DataPowerFileUtility.getDomainFiles(appliance, domain);
        DPFileTableCellEditor cellEditor = new DPFileTableCellEditor(domainFiles);
        return cellEditor;
    }

    private DPObjectListTableCellEditor getReferenceCellEditor(DataPowerConfig dataPowerConfig, String referencedType) {
        Appliance appliance = dataPowerConfig.getAppliance();
        Domain domain = dataPowerConfig.getSourceDomain();
        Index<Appliance, Domain> selectedDomains = new Index<Appliance, Domain>();
        selectedDomains.put(appliance, domain);
        ConfigurationManager configurationManager = new ConfigurationManager();
        ArrayList<StatusObjectStatus> allObjects = configurationManager.listObjects(selectedDomains, referencedType, null);
        DPObjectListTableCellEditor cellEditor = new DPObjectListTableCellEditor(allObjects);
        return cellEditor;
    }
}

