/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.editors;

import com.jmorgan.lang.Application;
import com.jmorgan.util.ThreadUtility;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.config.ConfigEthernetInterface;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;

public class EthernetInterfaceTableCellEditor
extends DefaultCellEditor
implements TableCellRenderer {
    private static ArrayList<ConfigEthernetInterface> ethernetInterfaces = null;
    private DefaultComboBoxModel<String> cbxModel;
    private JComboBox<String> editor = (JComboBox)this.getComponent();
    private JTextField renderer;

    static {
        Application app = Application.getApplication();
        while (ethernetInterfaces == null) {
            ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT * 4);
            ethernetInterfaces = (ArrayList)app.getAttribute("Ethernet Interfaces");
        }
    }

    public EthernetInterfaceTableCellEditor() {
        super(new JComboBox(new DefaultComboBoxModel()));
        this.cbxModel = (DefaultComboBoxModel)this.editor.getModel();
        this.renderer = new JTextField();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (column == 1) {
            this.cbxModel.removeAllElements();
            String applianceName = (String)table.getValueAt(row, 0);
            ArrayList<String> ec = new ArrayList<String>();
            for (ConfigEthernetInterface eth : ethernetInterfaces) {
                if (!eth.getAppliance().getName().equals(applianceName)) continue;
                ec.add(eth.getName());
            }
            Collections.sort(ec);
            for (String s : ec) {
                this.cbxModel.addElement(s);
            }
            return this.editor;
        }
        this.renderer.setText(value == null ? "" : value.toString());
        return this.renderer;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            this.renderer.setText("");
        } else {
            this.renderer.setText(value.toString());
        }
        return this.renderer;
    }
}

