/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.models;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.swing.table.BeanColumnModel;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.swing.table.TableCellEditorRenderer;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.collection.UniqueArrayList;
import com.kumbasoft.core.beans.ImportConfigurationBean;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.ui.editors.DeploymentPolicyConfigTableCellEditor;
import com.kumbasoft.core.ui.editors.DeploymentPolicyVariablesTableCellEditor;
import com.kumbasoft.core.ui.editors.ImportFileTypeTableCellEditor;
import java.io.File;
import javax.swing.table.TableColumn;

public class ImportConfigurationColumnModel
extends BeanColumnModel<ImportConfigurationBean> {
    private DeploymentPolicyConfigTableCellEditor deploymentPolicyEditor;
    private DeploymentPolicyVariablesTableCellEditor deploymentPolicyVariablesEditor;
    private TableCellEditorRenderer importOrderEditor;

    public ImportConfigurationColumnModel() {
        super(ImportConfigurationBean.class);
        this.setupModel();
    }

    public ImportConfigurationColumnModel(BeanTableModel<ImportConfigurationBean> tableModel) {
        super(tableModel);
        this.setupModel();
    }

    private void setupModel() {
        this.setColumnOrder("fileName", "fileType", "overwriteFiles", "overwriteObjects", "deploymentPolicy");
        this.setColumnWidth("fileName", 500);
        this.setColumnWidth("fileType", 85);
        this.setColumnWidth("overwriteFiles", 125);
        this.setColumnWidth("overwriteObjects", 125);
        this.setColumnWidth("deploymentPolicy", 350);
        int columnCount = this.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            TableColumn column = this.getColumn(i);
            Object columnName = column.getIdentifier();
            switch (columnName.toString()) {
                case "fileType": {
                    ImportFileTypeTableCellEditor typeEditor = new ImportFileTypeTableCellEditor();
                    column.setCellRenderer(typeEditor);
                    column.setCellEditor(typeEditor);
                    break;
                }
                case "deploymentPolicy": {
                    this.deploymentPolicyEditor = new DeploymentPolicyConfigTableCellEditor();
                    column.setCellEditor(this.deploymentPolicyEditor);
                    column.setCellRenderer(this.deploymentPolicyEditor);
                    break;
                }
                case "deploymentPolicyVariables": {
                    this.deploymentPolicyVariablesEditor = new DeploymentPolicyVariablesTableCellEditor();
                    column.setCellEditor(this.deploymentPolicyVariablesEditor);
                    column.setCellRenderer(this.deploymentPolicyVariablesEditor);
                    break;
                }
                case "importOrder": {
                    this.importOrderEditor = new TableCellEditorRenderer();
                    column.setCellEditor(this.importOrderEditor);
                    column.setCellRenderer(this.importOrderEditor);
                }
            }
            ++i;
        }
    }

    public void setDeploymentPolicies(UniqueArrayList<String> deploymentPolicies) {
        this.deploymentPolicyEditor.setDeploymentPolicies(deploymentPolicies);
    }

    public void setDeploymentPolicyVariables(UniqueArrayList<String> deploymentPolicyVariables) {
        this.deploymentPolicyVariablesEditor.setDeploymentPolicyVariables(deploymentPolicyVariables);
    }

    @Reflected
    private void addFile(File file) {
        String fileName = file.getName();
        String fileExt = "ZIP";
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot >= 0) {
            String ext = fileName.substring(lastDot + 1).toUpperCase();
            if (ext.equals("XCFG")) {
                ext = "XML";
            }
            if (Comparison.isIn(ext, DPEnumerations.IMPORT_FORMAT)) {
                fileExt = ext;
            }
        }
        ImportConfigurationBean newRow = new ImportConfigurationBean(file.getAbsolutePath(), fileExt, true, true);
        this.getTableModel().addRow(newRow);
    }
}

