/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.panel;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMList;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.event.ListSelectionEventInvoker;
import com.jmorgan.swing.list.JMListCellRenderer;
import com.jmorgan.swing.list.JMListModel;
import com.jmorgan.util.Date;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.Index;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.Time;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ApplianceGroup;
import com.kumbasoft.core.beans.ApplianceGroupObject;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.DomainGroup;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.tools.ActionController;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.applianceManagement.ApplianceManagementDialog;
import com.kumbasoft.core.ui.renderers.ApplianceGroupListCellValueRenderer;
import com.kumbasoft.core.ui.renderers.DomainListCellValueRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.ListModel;

public class ApplianceDomainListPanel
extends AbstractPanel {
    private JMListModel<ApplianceGroupObject> applianceGroupListModel;
    private JMListModel<DomainGroup> domainGroupListModel;
    private JMList<ApplianceGroupObject> applianceGroupList;
    private JMList<DomainGroup> domainGroupList;
    private DomainListCellValueRenderer domainListCellRenderer;
    private ArrayList<ApplianceGroupObject> applianceGroups;
    private HashSet<Appliance> uniqueApplianceSet = new HashSet();
    private JMButton btnQuiesceAppliance = new JMButton(KumbaCoreUIConstants.SLEEP_ICON, "Quiesce Selected Appliances");
    private JMButton btnUnQuiesceAppliance;
    private JMButton btnReloadFirmware;
    private JMButton btnManageAppliances;
    private JMButton btnQuiesceDomain;
    private JMButton btnUnQuiesceDomain;
    private JMButton btnRestartDomain;
    private JMButton btnCreateCheckpoint;
    private JMButton btnSaveDomain;
    private boolean changingApplianceSelection;
    private AsynchMethodInvoker<Void> applianceHealthCheckThread;

    public ApplianceDomainListPanel() {
        super(KumbaCoreUIConstants.createBorderLayout());
        new ActionEventInvoker(this.btnQuiesceAppliance, this, "setupQuickAction", "Quiesce Selected Appliances", "This will quiesce all selected appliances.  Continue?", "Quiesce Appliances", "quiesceAppliance", true);
        this.btnUnQuiesceAppliance = new JMButton(KumbaCoreUIConstants.WAKE_ICON, "Un-Quiesce Selected Appliances");
        new ActionEventInvoker(this.btnUnQuiesceAppliance, this, "setupQuickAction", "Un-Quiesce Selected Appliances", "This will un-quiesce all selected appliances.  Continue?", "Un-Quiesce Appliances", "unQuiesceAppliance", true);
        this.btnReloadFirmware = new JMButton(KumbaCoreUIConstants.REFRESH_ICON, "Reload Firmware on Selected Appliances");
        new ActionEventInvoker(this.btnReloadFirmware, this, "setupQuickAction", "Reload firmware on Selected Appliances", "This will reload firmware on all selected appliances.  Continue?", "Reload Firmware", "reloadFirmware", true);
        this.btnManageAppliances = new JMButton(KumbaCoreUIConstants.EDIT_ICON, "Manage Appliances");
        new ActionEventInvoker(this.btnManageAppliances, this, "fileOpen");
        JMPanel listsPanel = new JMPanel(new GridLayout(2, 1, 20, 10));
        this.applianceGroupListModel = new JMListModel();
        this.domainGroupListModel = new JMListModel();
        this.applianceGroupList = this.createList(this.applianceGroupListModel);
        this.applianceGroupList.setName("Appliance Group List");
        this.applianceGroupList.setCellRenderer(new JMListCellRenderer(new ApplianceGroupListCellValueRenderer()));
        this.domainGroupList = this.createList(this.domainGroupListModel);
        this.domainGroupList.setName("Domain Group List");
        this.domainListCellRenderer = new DomainListCellValueRenderer();
        this.domainGroupList.setCellRenderer(new JMListCellRenderer(this.domainListCellRenderer));
        JMLabel applianceLabel = new JMLabel("Appliances:");
        JMScrollPane applianceSP = this.createScrollPane(this.applianceGroupList);
        JMPanel applianceActions = new JMPanel(new GridLayout(1, 2, 5, 1));
        applianceActions.addAll(this.btnQuiesceAppliance, this.btnUnQuiesceAppliance, this.btnReloadFirmware, this.btnManageAppliances);
        JMPanel applianceLabelPanel = new JMPanel(new BorderLayout());
        applianceLabelPanel.add((Component)applianceLabel, "Center");
        applianceLabelPanel.add((Component)applianceActions, "East");
        JMPanel appliancePanel = new JMPanel(new BorderLayout(5, 5));
        appliancePanel.add((Component)applianceLabelPanel, "North");
        appliancePanel.add((Component)applianceSP, "Center");
        JMPanel domainActions = new JMPanel(new GridLayout(1, 5, 5, 1));
        this.btnQuiesceDomain = new JMButton(KumbaCoreUIConstants.SLEEP_ICON, "Quiesce Selected Domains");
        new ActionEventInvoker(this.btnQuiesceDomain, this, "setupQuickAction", "Quiesce Selected Domains", "This will quiesce all selected domains (except default).  Continue?", "Quiesce Domains", "quiesceDomains", false);
        this.btnUnQuiesceDomain = new JMButton(KumbaCoreUIConstants.WAKE_ICON, "Un-Quiesce Selected Domains");
        new ActionEventInvoker(this.btnUnQuiesceDomain, this, "setupQuickAction", "Un-Quiesce Selected Domains", "This will un-quiesce all selected domains (except default).  Continue?", "Un-Quiesce Domains", "unQuiesceDomains", false);
        this.btnRestartDomain = new JMButton(KumbaCoreUIConstants.REFRESH_ICON, "Restart Selected Domains");
        new ActionEventInvoker(this.btnRestartDomain, this, "setupQuickAction", "Restart Selected Domains", "This will restart all selected domains (except default).  Continue?", "Restart Domains", "restartDomains", false);
        this.btnCreateCheckpoint = new JMButton(KumbaCoreUIConstants.CHECKPOINT_ICON, "Create Checkpoint for Selected Domains");
        new ActionEventInvoker(this.btnCreateCheckpoint, this, "setupQuickAction", "Create a Checkpoint on Selected Domains", "This will create checkpoints for all selected domains.  Continue?", "Create Checkpoint", "createCheckpoints", false);
        this.btnSaveDomain = new JMButton(KumbaCoreUIConstants.SAVE_ICON, "Save Configuration of Selected Domains");
        new ActionEventInvoker(this.btnSaveDomain, this, "setupQuickAction", "Save Configuration for Selected Domains", "This will save the configurations for all selected domains.  Continue?", "Save Configurations", "saveConfigs", false);
        domainActions.addAll(this.btnQuiesceDomain, this.btnUnQuiesceDomain, this.btnRestartDomain, this.btnCreateCheckpoint, this.btnSaveDomain);
        JMLabel domainListTitle = new JMLabel("Domains:");
        JMPanel domainLabelPanel = new JMPanel(new BorderLayout(5, 5));
        domainLabelPanel.add((Component)domainListTitle, "Center");
        domainLabelPanel.add((Component)domainActions, "East");
        JMPanel domainPanel = new JMPanel(new BorderLayout(5, 5));
        domainPanel.add((Component)domainLabelPanel, "North");
        domainPanel.add(this.createScrollPane(this.domainGroupList));
        listsPanel.add(appliancePanel);
        listsPanel.add(domainPanel);
        this.add((Component)listsPanel, "Center");
        ApplianceDomainChangeMonitor changeMonitor = ApplianceDomainChangeMonitor.getInstance();
        changeMonitor.setApplianceGroupList(this.applianceGroupList);
        changeMonitor.setDomainGroupList(this.domainGroupList);
        new ListSelectionEventInvoker(this.applianceGroupList, this, "applianceSelectionChanged");
        new ListSelectionEventInvoker(this.domainGroupList, this, "domainSelectionChanged");
        Application.getApplication().setAttribute("healthChecksAllowed", Boolean.TRUE);
        new AsynchMethodInvoker((Object)this, "repaintDomainList", KumbaCoreConstants.DOMAIN_HEALTH_CHECK_INTERVAL * 6);
    }

    private JMList<?> createList(JMListModel<?> listModel) {
        JMList list = new JMList((ListModel<?>)listModel);
        return list;
    }

    private JMScrollPane createScrollPane(JMList<?> list) {
        JMScrollPane scrollPane = KumbaCoreUIConstants.createScrollPane(list);
        Dimension preferredSize = scrollPane.getPreferredSize();
        preferredSize.height = 300;
        scrollPane.setPreferredSize(preferredSize);
        return scrollPane;
    }

    public List<ApplianceGroupObject> getSelectedApplianceGroup() {
        return this.applianceGroupList.getSelectedValuesList();
    }

    public List<DomainGroup> getSelectedDomainGroup() {
        return this.domainGroupList.getSelectedValuesList();
    }

    public void setApplianceGroups(ArrayList<ApplianceGroupObject> applianceGroups) {
        AbstractPanel.logger.fine("(applianceGroups): Entering");
        this.uniqueApplianceSet.clear();
        if (this.applianceGroupListModel != null) {
            AbstractPanel.logger.finest("(applianceGroups): Creating the appliance groups list model.");
            this.applianceGroupList.clearSelection();
            this.applianceGroupListModel.clear();
        }
        if (CollectionUtility.isEmpty(applianceGroups)) {
            AbstractPanel.logger.fine("(applianceGroups): Appliance Groups is empty.");
            this.fileOpen();
        } else {
            AbstractPanel.logger.finer("(applianceGroups): Getting only active appliances.");
            ArrayList<ApplianceGroupObject> activeApplianceGroups = new ArrayList<ApplianceGroupObject>();
            for (ApplianceGroupObject ago : applianceGroups) {
                ArrayList<Appliance> groupAppliances = ago.getAppliances();
                if (CollectionUtility.isEmpty(groupAppliances)) continue;
                if (ago.isCreatedFromCategory()) {
                    activeApplianceGroups.add(ago);
                    continue;
                }
                Appliance appliance = ago.getAppliances().get(0);
                if (!appliance.isActive()) continue;
                activeApplianceGroups.add(ago);
            }
            AbstractPanel.logger.fine("(applianceGroups): Adding Appliance Groups to List Model.");
            Collections.sort(activeApplianceGroups);
            this.applianceGroups = activeApplianceGroups;
            this.applianceGroupListModel.addAll(this.applianceGroups);
            new AsynchMethodInvoker((Object)this, "selectAllGroup", 500);
            for (ApplianceGroupObject ago : this.applianceGroups) {
                ArrayList<Appliance> appliances = ago.getAppliances();
                for (Appliance appliance : appliances) {
                    if (!appliance.isActive()) continue;
                    this.uniqueApplianceSet.add(appliance);
                }
            }
            Boolean openApplianceManagementDialog = (Boolean)Application.getApplication().getAttribute("openApplianceManagementOnStartup");
            if (openApplianceManagementDialog != null && openApplianceManagementDialog.booleanValue()) {
                AbstractPanel.logger.fine("(applianceGroups): Open on startup was selected.  Turning off attribute.");
                Application.getApplication().setAttribute("openApplianceManagementOnStartup", Boolean.FALSE);
                boolean appliancesHaveDomains = false;
                while (!appliancesHaveDomains) {
                    for (Appliance appliance : this.uniqueApplianceSet) {
                        ArrayList<Domain> domains = appliance.getDomains();
                        if (!CollectionUtility.isNotEmpty(domains)) continue;
                        appliancesHaveDomains = true;
                        break;
                    }
                    if (appliancesHaveDomains) continue;
                    ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
                    AbstractPanel.logger.fine("(applianceGroups): Waiting for at least one appliance to have domains.");
                }
                AbstractPanel.logger.fine("(applianceGroups): Open on startup was selected.  Opening appliance management dialog.");
                new AsynchMethodInvoker((Object)this, "fileOpen", KumbaCoreConstants.THREAD_WAIT);
            } else if (this.applianceHealthCheckThread == null) {
                AbstractPanel.logger.fine("(applianceGroups): Starting Appliance Health Checks.");
                this.checkApplianceHealth();
            }
        }
        AbstractPanel.logger.fine("(applianceGroups): Done");
    }

    private void checkApplianceHealth() {
        AbstractPanel.logger.finer("(): Starting");
        if (this.applianceHealthCheckThread != null) {
            this.applianceHealthCheckThread.cancel();
        }
        ArrayList<Appliance> looper = new ArrayList<Appliance>(this.uniqueApplianceSet);
        for (Appliance appliance : looper) {
            String applianceName = appliance.getName();
            try {
                appliance.getDomain("default");
            }
            catch (IllegalStateException e) {
                AbstractPanel.logger.severe(() -> LMG.log("Failed to get domains from %s.  Is appliance still up?", () -> applianceName));
                appliance.setConnected(false);
            }
            this.touchUpApplianceListDisplay(appliance);
        }
        AbstractPanel.logger.finer("Rescheduling health checks");
        this.applianceHealthCheckThread = new AsynchMethodInvoker((Object)this, "checkApplianceHealth", KumbaCoreConstants.HEALTH_CHECK_INTERVAL);
        AbstractPanel.logger.finer("Done");
    }

    @Reflected
    private void repaintDomainList() {
        new AsynchMethodInvoker(this.domainGroupList, "repaint");
        new AsynchMethodInvoker((Object)this, "repaintDomainList", KumbaCoreConstants.DOMAIN_HEALTH_CHECK_INTERVAL);
    }

    private void touchUpApplianceListDisplay(Appliance appliance) {
        this.applianceGroupList.repaintCellOf(appliance);
        for (ApplianceGroup applianceGroup : this.applianceGroups) {
            ArrayList<Appliance> appliances = applianceGroup.getAppliances();
            if (!appliances.contains(appliance)) continue;
            this.applianceGroupList.repaintCellOf((ApplianceGroupObject)applianceGroup);
            break;
        }
    }

    public void addDomain(Domain domain) {
        DomainGroup domainGroup = new DomainGroup(domain);
        this.domainGroupListModel.addElement(domainGroup);
    }

    public void removeDomain(Domain domain) {
        ArrayList domainGroups = (ArrayList)this.domainGroupListModel.getAll();
        DomainGroup domainGroupToDelete = null;
        for (DomainGroup dg : domainGroups) {
            if (!dg.getGroupName().equals(domain.getName())) continue;
            domainGroupToDelete = dg;
            break;
        }
        if (domainGroupToDelete != null) {
            this.domainGroupListModel.removeElement(domainGroupToDelete);
        }
    }

    public void setSelectedAppliances(ArrayList<ApplianceGroupObject> appliances) {
        if (CollectionUtility.isEmpty(appliances)) {
            return;
        }
        int[] indices = new int[appliances.size()];
        int i = 0;
        for (ApplianceGroupObject ago : appliances) {
            int index = this.applianceGroupList.getIndexOf(ago);
            indices[i++] = index;
        }
        this.applianceGroupList.setSelectedIndices(indices);
    }

    public void setSelectedDomain(String domainName) {
        Collection<DomainGroup> domainGroups = this.domainGroupListModel.getAll();
        for (DomainGroup dg : domainGroups) {
            if (!dg.getGroupName().equals(domainName)) continue;
            this.domainGroupList.setSelectedValue(dg, true);
            break;
        }
    }

    @Reflected
    private void selectAllGroup() {
        for (ApplianceGroup applianceGroup : this.applianceGroups) {
            if (!applianceGroup.getGroupName().equals("All")) continue;
            this.applianceGroupList.setSelectedValue(applianceGroup, true);
            break;
        }
    }

    @Reflected
    public void applianceSelectionChanged() {
        if (this.changingApplianceSelection) {
            return;
        }
        this.changingApplianceSelection = true;
        List applianceGroups = this.applianceGroupList.getSelectedValuesList();
        ArrayList iteratorClone = new ArrayList(applianceGroups);
        for (ApplianceGroupObject applianceGroup : iteratorClone) {
            String applianceGroupName = applianceGroup.getGroupName();
            if (applianceGroupName != "All" || applianceGroups.size() <= 1) continue;
            applianceGroups.remove(applianceGroup);
            int allIndex = this.applianceGroupList.getIndexOf(applianceGroup);
            this.applianceGroupList.removeSelectionInterval(allIndex, allIndex);
            break;
        }
        List selectedDomains = null;
        try {
            selectedDomains = this.domainGroupList.getSelectedValuesList();
        }
        catch (IndexOutOfBoundsException e) {
            this.changingApplianceSelection = false;
            return;
        }
        this.domainGroupListModel.clear();
        UniqueArrayList<DomainGroup> selectedDomainGroups = new UniqueArrayList<DomainGroup>();
        Index<String, Domain> allDomainsFromSelectedAppliances = new Index<String, Domain>();
        DomainGroup allGroup = new DomainGroup("All");
        for (ApplianceGroupObject applianceGroup : applianceGroups) {
            ArrayList<Appliance> appliances = applianceGroup.getAppliances();
            Iterator<Appliance> iterator = appliances.iterator();
            while (iterator.hasNext()) {
                Appliance appliance = iterator.next();
                ArrayList<Domain> domains = appliance.getDomains();
                if (domains == null) {
                    logger.info(() -> LMG.log("(): No domains returned from appliance %s.  Is it up?", () -> appliance.getName()));
                    continue;
                }
                ArrayList<Domain> domainLooper = new ArrayList<Domain>(domains);
                for (Domain domain : domainLooper) {
                    DomainGroup dg = new DomainGroup(domain);
                    selectedDomainGroups.add(dg);
                    allGroup.addDomain(domain);
                    allDomainsFromSelectedAppliances.put(domain.getName(), domain);
                }
            }
        }
        selectedDomainGroups.add(allGroup);
        selectedDomainGroups.sort();
        this.domainListCellRenderer.setDomainsInScope(allDomainsFromSelectedAppliances);
        this.domainGroupListModel.addAll(selectedDomainGroups);
        if (selectedDomains.size() > 0) {
            ArrayList<Integer> indicies = new ArrayList<Integer>();
            for (DomainGroup dg : selectedDomains) {
                int idx = this.domainGroupList.getIndexOf(dg);
                indicies.add(idx);
            }
            int[] selectedIndicies = new int[indicies.size()];
            int i = 0;
            for (Integer idx : indicies) {
                selectedIndicies[i++] = idx;
            }
            this.domainGroupList.setSelectedIndices(selectedIndicies);
        }
        if (this.domainGroupList.getSelectedIndices().length == 0) {
            this.domainGroupList.setSelectedValue(allGroup, true);
        }
        this.changingApplianceSelection = false;
        new AsynchMethodInvoker(this.domainGroupList, "repaint");
    }

    @Reflected
    private void domainSelectionChanged() {
        List domainGroups = this.domainGroupList.getSelectedValuesList();
        for (DomainGroup domainGroup : domainGroups) {
            if (!domainGroup.getGroupName().equals("All") || domainGroups.size() <= 1) continue;
            int allIndex = this.domainGroupList.getIndexOf(domainGroup);
            this.domainGroupList.removeSelectionInterval(allIndex, allIndex);
            break;
        }
    }

    @Reflected
    public void fileOpen() {
        ArrayList appliances;
        AbstractPanel.logger.fine("(): Starting");
        Application.getApplication().setAttribute("healthChecksAllowed", Boolean.FALSE);
        Boolean openOnStartup = (Boolean)Application.getApplication().getAttribute("openApplianceManagementOnStartup");
        Application.getApplication().setAttribute("openApplianceManagementOnStartup", Boolean.FALSE);
        if (openOnStartup != null && openOnStartup.booleanValue()) {
            AbstractPanel.logger.finer("(): Open on startup is true.  Looking for appliances to be present.");
            appliances = (ArrayList)Application.getApplication().getAttribute("Appliances");
            int numberOfAttempts = 0;
            while (CollectionUtility.isEmpty(appliances)) {
                AbstractPanel.logger.finer("(): Open on startup is true.  Appliances aren't present yet.  Should they be?");
                ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
                appliances = (ArrayList)Application.getApplication().getAttribute("Appliances");
                if (++numberOfAttempts == 20) break;
            }
        }
        AbstractPanel.logger.finer("(): Opening ApplianceManagementDialog");
        new ApplianceManagementDialog(AbstractPanel.frame);
        AbstractPanel.logger.finer("(): ApplianceManagementDialog Closed");
        Application.getApplication().setAttribute("healthChecksAllowed", Boolean.TRUE);
        appliances = (ArrayList)Application.getApplication().getAttribute("Appliances");
        if (CollectionUtility.isEmpty(appliances)) {
            AbstractPanel.logger.warning("(): No appliances in application after closing the ApplianceManagementDialog.  Did user not create or delete all?");
            return;
        }
    }

    @Reflected
    private void setupQuickAction(String dialogTitle, String dialogMessage, String commandMessage, String methodName, boolean forAppliancesOnly) {
        String loggerPrefix = String.format("(String dialogTitle, String dialogMessage, String commandMessage, String methodName=%s, boolean forAppliancesOnly=%b)", methodName, forAppliancesOnly);
        AbstractPanel.logger.finer(() -> LMG.log("%s: Starting.", () -> loggerPrefix));
        ApplianceDomainChangeMonitor adMonitor = ApplianceDomainChangeMonitor.getInstance();
        if (adMonitor.isAllApplianceGroupSelected() && !this.continueAction(dialogTitle, "All appliances are selected.  Do you want to continue?")) {
            return;
        }
        if (!forAppliancesOnly && adMonitor.isAllDomainGroupSelected() && !this.continueAction(dialogTitle, "All domains are selected.  Do you want to continue?")) {
            return;
        }
        if (!this.continueAction(dialogTitle, dialogMessage)) {
            return;
        }
        this.openResultsDialogAndSetWaitCursor(commandMessage);
        AbstractPanel.logger.finer(() -> LMG.log("%s: Invoking the method for each selected appliance/domain.", () -> loggerPrefix));
        adMonitor.invokeProcessByApplianceSelection(this, methodName, forAppliancesOnly);
        this.waitForResultsDialogToCloseAndResetCursor();
        AbstractPanel.logger.finer(() -> LMG.log("%s: Done.", () -> loggerPrefix));
    }

    @Reflected
    private void quiesceAppliance(Appliance appliance) {
        ActionController.quiesceAppliance(appliance, 60, 0, this.commandResultsDialog);
    }

    @Reflected
    private void unQuiesceAppliance(Appliance appliance) {
        ActionController.unquiesceAppliance(appliance, this.commandResultsDialog);
    }

    @Reflected
    private void reloadFirmware(Appliance appliance) {
        ActionController.shutdownAppliance(appliance, DPEnumerations.SHUTDOWN_MODE[1], 60, this.commandResultsDialog);
    }

    @Reflected
    private void quiesceDomains(Appliance appliance, Domain domain) {
        ActionController.quiesceDomain(appliance, domain, 60, 5, this.commandResultsDialog);
    }

    @Reflected
    private void unQuiesceDomains(Appliance appliance, Domain domain) {
        ActionController.unquiesceDomain(appliance, domain, this.commandResultsDialog);
    }

    @Reflected
    private void restartDomains(Appliance appliance, Domain domain) {
        ActionController.restartDomain(appliance, domain, this.commandResultsDialog);
    }

    @Reflected
    private void createCheckpoints(Appliance appliance, Domain domain) {
        DateTime checkpointTime = new DateTime();
        checkpointTime.getDate().setFormat(Date.SQL_FORMAT);
        checkpointTime.getTime().setFormat(Time.COMPRESSED_FORMAT);
        String time = checkpointTime.toString();
        time = time.replace(' ', '_');
        String checkpointName = String.format("%s_%s", domain.getName(), time);
        ActionController.saveCheckpoint(appliance, domain, checkpointName, this.commandResultsDialog);
    }

    @Reflected
    private void saveConfigs(Appliance appliance, Domain domain) {
        String loggerPrefix = String.format("(Appliance appliance=%s, Domain domain=%s[%d])", appliance.getName(), domain.getName(), domain.hashCode());
        AbstractPanel.logger.finer(() -> LMG.log("%s: Starting", () -> loggerPrefix));
        String saveNeeded = domain.getStatusDomainStatus().getSaveNeeded();
        if (saveNeeded.equals("on")) {
            AbstractPanel.logger.finer(() -> LMG.log("%s:  Saving configuration due to save needed.", () -> loggerPrefix));
            ConfigurationManager.saveConfiguration(appliance, domain, this.commandResultsDialog);
        } else {
            AbstractPanel.logger.finer(() -> LMG.log("%s:  Not saving configuration.  Save needed=%s.", () -> loggerPrefix, () -> saveNeeded));
        }
        AbstractPanel.logger.finer(() -> LMG.log("%s: Done", () -> loggerPrefix));
    }
}

