/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.panel;

import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMTable;
import com.jmorgan.swing.table.BeanColumnModel;
import com.jmorgan.swing.table.BeanRowSorter;
import com.jmorgan.swing.table.BeanTableModel;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.ManagementCommandError;
import com.kumbasoft.core.beans.ManagementCommandResult;
import com.kumbasoft.core.beans.ManagementCommandStatus;
import com.kumbasoft.core.beans.ManagementCommandSubscriber;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import java.awt.BorderLayout;

public class CommandResultPanel
extends JMPanel
implements ManagementCommandSubscriber {
    private BeanColumnModel<ManagementCommandResult> columnModel;
    private BeanTableModel<ManagementCommandResult> tableModel = new BeanTableModel<ManagementCommandResult>(ManagementCommandResult.class);
    private JMTable resultsTable;
    private boolean tableWidthSet;

    public CommandResultPanel() {
        super(new BorderLayout());
        this.columnModel = new BeanColumnModel<ManagementCommandResult>(ManagementCommandResult.class);
        BeanRowSorter<ManagementCommandResult> rowSorter = new BeanRowSorter<ManagementCommandResult>(this.tableModel);
        this.setupModelProperties();
        this.resultsTable = new JMTable(this.tableModel, this.columnModel);
        this.resultsTable.setRowSorter(rowSorter);
        this.add(KumbaCoreUIConstants.createScrollPane(this.resultsTable));
    }

    public void clearModel() {
        if (this.tableModel.getRowCount() == 0) {
            return;
        }
        try {
            this.tableModel.reset();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.tableWidthSet = false;
        this.resultsTable.repaint();
    }

    public boolean isModelEmtpy() {
        return this.tableModel.getRowCount() == 0;
    }

    @Override
    public void commandSucceeded(ManagementCommandStatus commandStatus) {
        this.handleManagementCommand(commandStatus);
    }

    @Override
    public void commandFailed(ManagementCommandError commandError) {
        this.handleManagementCommand(commandError);
    }

    private void handleManagementCommand(ManagementCommandResult command) {
        try {
            this.tableModel.addRow(command);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (!this.tableWidthSet) {
            this.tableWidthSet = true;
            new AsynchMethodInvoker((Object)this.resultsTable, "optimizeColumnWidths", KumbaCoreConstants.THREAD_WAIT);
        }
    }

    private void setupModelProperties() {
        this.tableModel.setValueExpression("appliance", "name");
        this.tableModel.setValueExpression("domain", "name");
        this.columnModel.setColumnOrder("appliance", "domain", "commandDescription", "resultMessage", "resultTime");
        this.columnModel.hideColumns("additionalCommandInfo", "commandInitiator");
    }
}

