/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.panel;

import com.jmorgan.beans.util.BeanService;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.util.ArrayUtility;
import com.kumbasoft.core.beans.ConfigPropertyUIMetaData;
import com.kumbasoft.core.ui.beans.ConfigUIMetaData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;

public class DynamicConfigUIPanel
extends JMPanel {
    private ConfigUIMetaData configUIMetaData;
    private JMPanel dynamicPanel = new JMPanel(null);

    public DynamicConfigUIPanel() {
        super(new BorderLayout(5, 5));
        this.add((Component)this.dynamicPanel, "Center");
    }

    public ConfigUIMetaData getConfigUIMetaData() {
        return this.configUIMetaData;
    }

    public void setConfigUIMetaData(ConfigUIMetaData configUIMetaData) {
        Object[] components = this.dynamicPanel.getComponents();
        if (!ArrayUtility.isEmpty(components)) {
            Object[] objectArray = components;
            int n = components.length;
            int n2 = 0;
            while (n2 < n) {
                Object component = objectArray[n2];
                String componentType = component.getClass().getName();
                if (componentType.equals("com.jmorgan.swing.JMLabel")) {
                    this.dynamicPanel.remove((Component)component);
                } else {
                    String propertyName = ((Component)component).getName();
                    this.dynamicPanel.remove((Component)component);
                }
                ++n2;
            }
        }
        this.configUIMetaData = configUIMetaData;
        int x = 10;
        int y = 10;
        int labelWidth = 100;
        int labelHeight = 23;
        int fieldWidth = 200;
        int fieldHeight = 23;
        HashMap<String, ConfigPropertyUIMetaData> propertyMetaData = this.configUIMetaData.getPropertyMetaData();
        for (String propertyName : propertyMetaData.keySet()) {
            ConfigPropertyUIMetaData propertyUIMetaData = propertyMetaData.get(propertyName);
            String uiLabel = propertyUIMetaData.getUiLabel();
            String fieldType = propertyUIMetaData.getUiFieldType();
            JMLabel label = new JMLabel(uiLabel);
            Rectangle labelBounds = propertyUIMetaData.getLabelLocation();
            if (labelBounds == null) {
                labelBounds = new Rectangle(x, y, labelWidth, fieldHeight);
                propertyUIMetaData.setLabelLocation(labelBounds);
            } else {
                x = labelBounds.x;
                y = labelBounds.y;
                labelWidth = labelBounds.width;
                labelHeight = labelBounds.height;
            }
            label.setBounds(labelBounds);
            this.dynamicPanel.add(label);
            try {
                Component field = (Component)BeanService.getBean(fieldType);
                Rectangle fieldBounds = propertyUIMetaData.getFieldLocation();
                if (fieldBounds == null) {
                    fieldBounds = new Rectangle(x + labelBounds.width + 10, y, fieldWidth, fieldHeight);
                } else {
                    x = fieldBounds.x;
                    y = fieldBounds.y;
                    fieldWidth = fieldBounds.width;
                    fieldHeight = fieldBounds.height;
                }
                field.setBounds(fieldBounds);
                field.setName(propertyName);
                this.dynamicPanel.add(field);
                y = fieldBounds.y + fieldBounds.height + 10;
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        this.dynamicPanel.repaint();
    }
}

