/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.panel.logs;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.rules.PropertyValueRule;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMTable;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.dialog.DialogPanel;
import com.jmorgan.swing.dialog.GenericDialog;
import com.jmorgan.swing.menu.JMPopupMenu;
import com.jmorgan.swing.menu.PopupMenuController;
import com.jmorgan.swing.table.BeanRowFilter;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.swing.table.CellHoverListener;
import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.DateTimeException;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.comparator.BeanComparator;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.AbstractLogEntry;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ApplianceGroupObject;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.LogEntrySubscriber;
import com.kumbasoft.core.beans.LogFilterEventListener;
import com.kumbasoft.core.beans.config.ConfigAuditLog;
import com.kumbasoft.core.beans.config.ConfigLogTarget;
import com.kumbasoft.core.tools.LogTargetProcessListener;
import com.kumbasoft.core.tools.LogTargetProcessor;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.AbstractSearchPanel;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.beans.AbstractLogSearchOptions;
import com.kumbasoft.core.ui.beans.RelativeAnchor;
import com.kumbasoft.core.ui.beans.RelativeTimeMeasure;
import com.kumbasoft.core.ui.dialog.logSearchOptions.AbstractSearchOptionsPanel;
import com.kumbasoft.core.ui.panel.logs.AbstractLogFiltersComponent;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Robot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.RowSorter;

abstract class AbstractLogDisplayPanel<LogTargetType extends DataPowerConfig, LogEntryType extends AbstractLogEntry, LogFiltersComponentType extends AbstractLogFiltersComponent<LogEntryType>, SearchOptionsType extends AbstractLogSearchOptions, SearchOptionsPanelType extends AbstractSearchOptionsPanel<SearchOptionsType>>
extends AbstractSearchPanel<LogEntryType>
implements LogTargetProcessListener,
LogEntrySubscriber<LogEntryType>,
LogFilterEventListener<LogEntryType>,
CellHoverListener,
PopupMenuController {
    protected ArrayList<LogTargetType> selectedLogTargets;
    protected SearchOptionsType searchOptions;
    protected JMButton btnOpenSearchOptions;
    protected JMCheckBox cbxEnableHoverPopup;
    protected BeanRowFilter<LogEntryType> rowFilter;
    protected boolean searchRunning;
    protected LogTargetProcessor logTargetProcessor;
    private final Object LOCK = new Object();
    private int totalEntriesRead;
    private int totalEntriesShown;
    protected LogFiltersComponentType logFiltersComponent;
    private String[] preferredTooltipColumnOrder;
    private long startProcessing;
    private long lastCallToAddLogEntries;

    public AbstractLogDisplayPanel(Class<LogEntryType> elementType) {
        super(elementType);
        this.getPopupMenu(this.displayTable);
        this.cbxEnableHoverPopup = ComponentFactory.createCheckbox(null, "Enable Hover", "Controls the display of the hover popup for menu items", true, true, null, null, new Object[0]);
        JMPanel centerControls = new JMPanel(new FlowLayout(2));
        centerControls.addAll(this.cbxEnableHoverPopup);
        this.topControlsPanel.add(centerControls);
        this.logFiltersComponent = this.createQuickFiltersPanel();
        ((AbstractLogFiltersComponent)this.logFiltersComponent).addLogFilterEventListener(this);
        this.leftPanel.add((Component)this.logFiltersComponent);
        this.displayTable.addCellHoverListener(this);
        this.preferredTooltipColumnOrder = this.getPreferredColumnOrder();
    }

    @Override
    protected int getMatchPatternLabelWidth() {
        return 130;
    }

    @Override
    protected JMPopupMenu getPopupMenu(Component popupMenuClient) {
        JMPopupMenu popupMenu = super.getPopupMenu(popupMenuClient);
        popupMenu.addMenuItem("Copy all or selected to clipboard", (Object)this, "simulateEditCopy");
        return popupMenu;
    }

    @Reflected
    private void simulateEditCopy() {
        AbstractPanel.logger.finer("(): Starting");
        try {
            int selectedRowCount = this.displayTable.getSelectedRowCount();
            if (selectedRowCount == 0) {
                this.displayTable.selectAll();
            }
            this.displayTable.requestFocus();
            ThreadUtility.sleep(50L);
            Robot robot = new Robot();
            robot.keyPress(17);
            robot.keyPress(67);
            robot.keyRelease(67);
            robot.keyRelease(17);
            ThreadUtility.sleep(50L);
            if (selectedRowCount == 0) {
                this.displayTable.clearSelection();
            }
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
        AbstractPanel.logger.finer("(): Done");
    }

    @Override
    protected boolean includeClearCacheButton() {
        return false;
    }

    protected abstract SearchOptionsType createSearchOptions();

    protected void createDefaultSearchOptions() {
        this.searchOptions = this.createSearchOptions();
        ((AbstractLogSearchOptions)this.searchOptions).setCaseSensitive(false);
        ((AbstractLogSearchOptions)this.searchOptions).setRelativeAnchor(RelativeAnchor.NOW);
        ((AbstractLogSearchOptions)this.searchOptions).setRelativeTimeMeasure(RelativeTimeMeasure.YEARS);
        ((AbstractLogSearchOptions)this.searchOptions).setTimeAmount(10);
    }

    protected abstract SearchOptionsPanelType createSearchOptionsPanel(SearchOptionsType var1);

    @Override
    protected JMPanel getSearchFieldPanel() {
        JMPanel searchFieldPanel = super.getSearchFieldPanel();
        this.btnOpenSearchOptions = ComponentFactory.createButton(KumbaCoreUIConstants.FILTER_ICON, null, "Open Search Filters Dialog", true, this, "searchFilters", new Object[0]);
        this.searchFieldPanel.add(this.btnOpenSearchOptions);
        return searchFieldPanel;
    }

    protected abstract String getSearchOptionsPanelTitle();

    @Reflected
    private void searchFilters() {
        if (this.searchOptions == null) {
            this.searchOptions = this.createSearchOptions();
        }
        SearchOptionsPanelType searchOptionsPanel = this.createSearchOptionsPanel(this.searchOptions);
        GenericDialog dialog = new GenericDialog(GUIServices.getFrame(this), this.getSearchOptionsPanelTitle(), (DialogPanel)searchOptionsPanel);
        dialog.setModal(true);
        dialog.setVisible(true);
    }

    protected abstract LogFiltersComponentType createQuickFiltersPanel();

    public ArrayList<LogTargetType> getSelectedLogTargets() {
        return this.selectedLogTargets;
    }

    public void setSelectedLogTargets(ArrayList<LogTargetType> selectedLogTargets) {
        logger.finer("(ArrayList<LogTargetType> selectedLogTarget): Starting");
        ((AbstractLogFiltersComponent)this.logFiltersComponent).resetQuickFilters();
        this.tableModel.reset();
        this.resetProcessors();
        this.selectedLogTargets = selectedLogTargets;
        this.btnSearch.setEnabled(this.selectedLogTargets != null);
        this.displayTable.setToolTipText(null);
        this.displayTable.repaint();
        logger.finer("(ArrayList<LogTargetType> selectedLogTarget): Done");
    }

    @Override
    public BeanTableModel<LogEntryType> getTableModel() {
        BeanTableModel tableModel = super.getTableModel();
        tableModel.setValueExpression("appliance", "name");
        tableModel.setValueExpression("domain", "name");
        this.rowFilter = new BeanRowFilter(this.tableModel);
        return tableModel;
    }

    @Override
    protected String getTFPatternLabel() {
        return "Search Expression:";
    }

    @Override
    protected String getProcessMethodName() {
        return "searchLogs";
    }

    @Override
    protected boolean includeCaseSensitivityButton() {
        return false;
    }

    @Reflected
    protected void searchLogs() {
        logger.finer("(): Starting.  Clearing sorter and resetting processors.");
        this.rowSorter.clearSorter();
        this.resetProcessors();
        if (CollectionUtility.isEmpty(this.selectedLogTargets)) {
            logger.info("(): No logging targets selected.  Returning quietly.");
            return;
        }
        if (this.frameStatusBar == null) {
            logger.finer("(): Status bar is null.  Timing issue?  Trying to repair.");
            this.frameStatusBar = frame.getStatusBar();
            if (this.frameStatusBar == null) {
                logger.severe("() : Status bar still not present.  Hopelessly broken.  Fix it.");
            }
        }
        if (this.frameStatusBar != null) {
            this.frameStatusBar.setMessage("");
        }
        this.totalEntriesRead = 0;
        this.totalEntriesShown = 0;
        ((AbstractLogFiltersComponent)this.logFiltersComponent).resetQuickFilters();
        if (this.searchOptions == null) {
            logger.fine("(): Search Options is NULL.  Creating default options.");
            this.createDefaultSearchOptions();
        }
        ((AbstractLogSearchOptions)this.searchOptions).computeTimeRange();
        String filterExpression = this.getMatchPattern();
        if (((AbstractLogSearchOptions)this.searchOptions).isCaseSensitive() && filterExpression.startsWith("(?i)")) {
            filterExpression = filterExpression.substring(4);
        }
        String finalFilterExpression = filterExpression;
        logger.fine(() -> LMG.log("(): Search Expression: %s", () -> finalFilterExpression));
        ((AbstractLogSearchOptions)this.searchOptions).setFilterExpression(filterExpression);
        logger.finer(() -> LMG.log("():  Search Options:\n\t%s", () -> ((AbstractLogSearchOptions)this.searchOptions).toString()));
        int estimatedFileCount = this.getEstimatedFileCount();
        logger.finer(() -> LMG.log("(): Estimated number of files to read: %d", () -> estimatedFileCount));
        this.showProgressBar(estimatedFileCount);
        this.logTargetProcessor = this.getLogTargetProcessor();
        logger.finer(() -> LMG.log("(): Setting up log target processor:  %s", () -> this.logTargetProcessor.getClass().getSimpleName()));
        this.logTargetProcessor.addLogEntrySubscriber(this);
        this.lastCallToAddLogEntries = this.startProcessing = System.currentTimeMillis();
        this.logTargetProcessor.addLogTargetProcessListener(this);
        logger.finer("(): Starting search");
        this.searchRunning = true;
        new AsynchMethodInvoker((Object)this, "completeSearch", KumbaCoreConstants.STARTUP_DELAY);
        logger.finer("(): Done");
    }

    protected abstract int getEstimatedFileCount();

    protected abstract LogTargetProcessor getLogTargetProcessor();

    protected void completeSearch() {
        boolean logTargetProcessorIsRunning;
        logger.finer("(): Starting.  Waiting for confirmation *some* processing has started.");
        while (this.startProcessing == this.lastCallToAddLogEntries && this.displayTable.getRowCount() == 0) {
            ThreadUtility.sleep(KumbaCoreConstants.LOG_READ_TIMEOUT);
        }
        logger.finer("(): Waiting for all processing to complete.");
        boolean timedOut = false;
        while (this.logTargetProcessor != null && this.logTargetProcessor.isRunning()) {
            long currentTime = System.currentTimeMillis();
            long timeDelta = currentTime - this.lastCallToAddLogEntries;
            logger.finer(() -> LMG.log("(): Last Add: %d, Current Time: %d, Time Delta: %d", () -> this.lastCallToAddLogEntries, () -> currentTime, () -> timeDelta));
            if (timeDelta > (long)KumbaCoreConstants.THREAD_TIMEOUT) {
                timedOut = true;
                if (this.frameStatusBar != null) {
                    this.frameStatusBar.setMessage("Timed out waiting for all log reads.  No longer blocking on long-running process.");
                }
                logger.warning("(): Timed out waiting for log read threads to complete!  More logs may show, but we're not going to continue to hold up the user.");
                break;
            }
            ThreadUtility.sleep(KumbaCoreConstants.LOG_READ_TIMEOUT);
        }
        logger.finer("(): Cleaning up.");
        this.searchRunning = false;
        this.hideProgressBar();
        this.resetUI();
        boolean continuousPoll = ((AbstractLogSearchOptions)this.searchOptions).isContinuousPoll();
        int displayRowCount = this.displayTable.getRowCount();
        boolean bl = logTargetProcessorIsRunning = this.logTargetProcessor != null && this.logTargetProcessor.isRunning();
        if (timedOut) {
            if (displayRowCount == 0 && continuousPoll) {
                logger.info("(): Timed out while running with continuous poll on.  To prevent a race condition, continuous polling has been turned off.");
                if (this.frameStatusBar != null) {
                    this.frameStatusBar.setMessage("Timed out while running with continuous poll on.  To prevent a race condition, continuous polling has been turned off.");
                }
                ((AbstractLogSearchOptions)this.searchOptions).setContinuousPoll(false);
            }
        } else if (this.frameStatusBar != null) {
            this.frameStatusBar.setMessage("Done.");
        }
        if (!logTargetProcessorIsRunning && continuousPoll) {
            if (displayRowCount == 0) {
                logger.finer("(): Continuous polling is on and no logs match.  Resubmitting.");
                if (this.frameStatusBar != null) {
                    this.frameStatusBar.setMessage("No logs matched this poll cycle.  Resubmitting due to continuous polling.");
                }
                new AsynchMethodInvoker((Object)this, "searchFind", ((AbstractLogSearchOptions)this.searchOptions).getContinuousPollDelay());
            } else {
                logger.fine("(): Continuous polling is on and logs were found to match.  Done.");
                if (this.frameStatusBar != null) {
                    this.frameStatusBar.setMessage("Found at least one match.  Continuous polling remains on, but no more polling will occur this cycle.");
                }
            }
        }
        logger.finer("(): Done");
    }

    protected void resetProcessors() {
        logger.finer("(): Starting");
        if (this.logTargetProcessor != null) {
            if (this.isRunning()) {
                logger.finer("():  Log processing is running.  Sending abort signal");
                this.abortProcessing();
                while (!this.isAborted()) {
                    ThreadUtility.sleep(KumbaCoreConstants.LOG_READ_TIMEOUT);
                }
            }
            logger.finer("(): Clearing logging target processors.");
            this.logTargetProcessor = null;
        }
        logger.finer("(): Done");
    }

    protected boolean isRunning() {
        boolean isRunning = this.logTargetProcessor == null ? false : this.logTargetProcessor.isRunning();
        logger.finest(() -> LMG.log("(): returning %b", () -> isRunning));
        return isRunning;
    }

    protected void abortProcessing() {
        logger.finer("(): Starting");
        this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
        if (this.isAborting()) {
            logger.info("(): Process is already aborting.  Will abandon this attempt.");
            this.btnSearch.setEnabled(true);
            this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
            return;
        }
        logger.info("(): Aborting log processing");
        this.btnSearch.setEnabled(false);
        if (this.frameStatusBar != null) {
            this.frameStatusBar.setMessage("Stopping current process...");
        }
        this.logTargetProcessor.abort();
        this.waitForAbort();
        this.btnSearch.setEnabled(true);
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
        if (this.frameStatusBar != null) {
            this.frameStatusBar.setMessage("The last process was stopped before it completed!");
        }
        logger.finer("(): Done");
    }

    private void waitForAbort() {
        logger.finer("(): Starting");
        long timeoutTime = System.currentTimeMillis() + KumbaCoreConstants.LOG_ABORT_TIMEOUT;
        while (this.isAborting() && System.currentTimeMillis() < timeoutTime) {
            ThreadUtility.sleep(KumbaCoreConstants.LOG_READ_TIMEOUT);
        }
        if (System.currentTimeMillis() > timeoutTime) {
            logger.info("(): Timed out waiting for processes to stop.");
        }
        logger.finer("(): Done");
    }

    protected boolean isAborting() {
        boolean isAborting = this.logTargetProcessor == null ? false : this.logTargetProcessor.isAborting();
        logger.finer(() -> LMG.log("(): returning %b", () -> isAborting));
        return isAborting;
    }

    protected boolean isAborted() {
        boolean isAborted = this.logTargetProcessor == null ? true : this.logTargetProcessor.isAborted();
        logger.finer(() -> LMG.log("(): returning %b", () -> isAborted));
        return isAborted;
    }

    @Override
    public void listingLogTargetFiles() {
        this.progressBar.setValue(0);
    }

    @Override
    public void setLogTargetFileCount(int count) {
        this.progressBar.setMaximum(count);
    }

    @Override
    public void readingFile(DataPowerFileInfo file) {
    }

    @Override
    public void processingComplete() {
    }

    protected ConfigLogTarget getProxyLogTarget(Appliance appliance, Domain domain, LogTargetType logTarget) {
        logger.finer(() -> LMG.log("(appliance='%s', domain='%s', logTarget='%s'): Starting.", () -> appliance.getName(), () -> domain.getName(), () -> logTarget.getName()));
        ConfigLogTarget proxyLogTarget = new ConfigLogTarget();
        proxyLogTarget.setAppliance(appliance);
        proxyLogTarget.setSourceDomain(domain);
        String logTargetName = ((DataPowerConfig)logTarget).getName();
        proxyLogTarget.setName(logTargetName);
        String format = logTarget instanceof ConfigAuditLog ? "text" : (String)BeanService.getPropertyValue(logTarget, "format");
        logger.finer(() -> LMG.log("(appliance='%s', domain='%s', logTarget='%s'): Format is '%s'.", () -> appliance.getName(), () -> domain.getName(), () -> logTarget.getName(), () -> format));
        proxyLogTarget.setFormat(format);
        proxyLogTarget.setRotate((Long)BeanService.getPropertyValue(logTarget, "rotate"));
        String localFile = logTarget instanceof ConfigAuditLog ? "audit:/audit-log" : (String)BeanService.getPropertyValue(logTarget, "localFile");
        logger.finer(() -> LMG.log("(appliance='%s', domain='%s', logTarget='%s'): Local File is '%s'.", () -> appliance.getName(), () -> domain.getName(), () -> logTarget.getName(), () -> localFile));
        proxyLogTarget.setLocalFile(localFile);
        logger.finer(() -> LMG.log("(appliance='%s', domain='%s', logTarget='%s'): Done returning the proxy '%s'.", () -> appliance.getName(), () -> domain.getName(), () -> logTarget.getName(), () -> proxyLogTarget.getFQON()));
        return proxyLogTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLogEntries(ArrayList<LogEntryType> logEntries) {
        logger.finer(() -> LMG.log("(logEntries): Starting for %d entries", () -> logEntries.size()));
        int entryCount = logEntries.size();
        this.totalEntriesRead += entryCount;
        DateTime beginTime = ((AbstractLogSearchOptions)this.searchOptions).getBeginTime();
        DateTime endTime = ((AbstractLogSearchOptions)this.searchOptions).getEndTime();
        AbstractPanel.logger.finer(() -> LMG.log("(ArrayList<LogEntryType> logEntries): %d -> beginDate=%s, endDate=%s", () -> entryCount, () -> beginTime, () -> endTime));
        ArrayList<AbstractLogEntry> matchingEntries = new ArrayList<AbstractLogEntry>(logEntries.size());
        for (AbstractLogEntry logEntry : logEntries) {
            DateTime logDate;
            DateTime localizedLogDate = logDate = logEntry.getTime();
            try {
                localizedLogDate = new DateTime(logDate.toString());
            }
            catch (DateTimeException e) {
                localizedLogDate = logDate;
            }
            boolean withinDateRange = true;
            if (localizedLogDate.isBefore(beginTime)) {
                withinDateRange = false;
            }
            if (localizedLogDate.isAfter(endTime)) {
                withinDateRange = false;
            }
            DateTime finalLogDate = localizedLogDate;
            boolean isInDateRange = withinDateRange;
            AbstractPanel.logger.finest(() -> LMG.log("(ArrayList<LogEntryType> logEntries):\n\tLog Date: %s.\n\tLocalized Log Date: %s.\n\tBegin Time: %s.\n\tEnd Time: %s.\n\tWithin Date Range: %b", () -> logDate, () -> finalLogDate, () -> beginTime, () -> endTime, () -> isInDateRange));
            if (!withinDateRange || !this.isMatching(logEntry)) continue;
            matchingEntries.add(logEntry);
            ++this.totalEntriesShown;
        }
        matchingEntries.trimToSize();
        logger.finer(() -> LMG.log("(logEntries): Of %d entries, %d match.  Adding.", () -> logEntries.size(), () -> matchingEntries.size()));
        Object object = this.LOCK;
        synchronized (object) {
            this.tableModel.addAll(matchingEntries);
        }
        logger.finer(() -> LMG.log("(logEntries): Done adding %d to display.  Updating stats.", () -> matchingEntries.size()));
        ((AbstractLogFiltersComponent)this.logFiltersComponent).updateFilterTitleCounts();
        this.progressBar.incrementValue();
        if (this.frameStatusBar != null) {
            this.frameStatusBar.setMessage(String.format("Added %d more.  Displaying %d of %d total log entries", logEntries.size(), this.totalEntriesShown, this.totalEntriesRead));
        }
        this.lastCallToAddLogEntries = System.currentTimeMillis();
        logger.finer(() -> LMG.log("(logEntries): Updating last add time to %d", () -> this.lastCallToAddLogEntries));
        logger.finer(() -> LMG.log("(logEntries): Complete for %d entries", () -> logEntries.size()));
    }

    protected abstract boolean isMatching(LogEntryType var1);

    @Override
    public void logFilterChanging() {
        this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
    }

    @Override
    public void logFilterEvent(PropertyValueRule<LogEntryType> logFilterRule) {
        logger.finer("(PropertyValueRule<LogEntryType> logFilterRule):  Starting.");
        this.rowFilter.setFilteringRule(logFilterRule);
        logger.finer("(PropertyValueRule<LogEntryType> logFilterRule):  Filtering Complete.  Sorting.");
        List<RowSorter.SortKey> sortKeys = this.rowSorter.getSortKeys();
        if (CollectionUtility.isEmpty(sortKeys)) {
            logger.fine("(PropertyValueRule<LogEntryType> logFilterRule):  No sort keys.  Sorting by default values.");
            ArrayList rows = this.tableModel.getModelData(false);
            if (CollectionUtility.isNotEmpty(rows)) {
                BeanComparator sorter = new BeanComparator("time", "lineNumber", "appliance.name", "domain.name", "logTargetName");
                Collections.sort(rows, sorter);
                this.tableModel.setModelData(rows);
            }
        } else {
            this.rowSorter.sort();
        }
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
        logger.finer("(PropertyValueRule<LogEntryType> logFilterRule):  Done.");
    }

    @Override
    public void cellUnderCursor(JMTable table, int row, int column) {
        String loggerPrefix = String.format("(JMTable table, int row=%d, int column=%d)", row, column);
        logger.finer(() -> LMG.log("%s: Starting", () -> loggerPrefix));
        this.displayTable.setToolTipText(null);
        if (!this.cbxEnableHoverPopup.isSelected()) {
            logger.finer(() -> LMG.log("%s: Hover pupup disabled.", () -> loggerPrefix));
            return;
        }
        if (this.tableModel.getRowCount() == 0) {
            logger.finer(() -> LMG.log("%s: No rows in the table.  Nothing to show.", () -> loggerPrefix));
            return;
        }
        if (this.isRunning()) {
            logger.finer(() -> LMG.log("%s: Logs are running.  Not allowing hover popup.", () -> loggerPrefix));
            return;
        }
        int modelRow = this.displayTable.convertRowIndexToModel(row);
        logger.finer(() -> LMG.log("%s: Row in model = %d.  Rows in model: %d", () -> loggerPrefix, () -> modelRow, () -> this.tableModel.getRowCount()));
        AbstractLogEntry logEntry = null;
        try {
            logEntry = (AbstractLogEntry)this.tableModel.getValue(modelRow);
            if (logEntry == null) {
                return;
            }
        }
        catch (Exception e) {
            logger.warning(() -> LMG.log("%s: Row in model = %d.  Rows in model: %d.  Error getting model row:\n\t\t%s", () -> loggerPrefix, () -> modelRow, () -> this.tableModel.getRowCount(), () -> e.getMessage()));
            return;
        }
        StringBuilder html = new StringBuilder("<html><body><table border='0'>");
        logger.finer(() -> LMG.log("%s: Building poup HTML model", () -> loggerPrefix));
        String[] stringArray = this.preferredTooltipColumnOrder;
        int n = this.preferredTooltipColumnOrder.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            String title = StringUtility.getDisplayableTitle(columnName);
            String value = null;
            logger.finer(() -> LMG.log("%s: Getting value for column %s", () -> loggerPrefix, () -> columnName));
            switch (columnName) {
                case "appliance": {
                    ApplianceGroupObject ago = logEntry.getAppliance();
                    if (ago == null) {
                        value = "";
                        break;
                    }
                    value = ago.getGroupName();
                    break;
                }
                case "domain": {
                    Domain domain = logEntry.getDomain();
                    if (domain == null) {
                        value = "";
                        break;
                    }
                    value = domain.getName();
                    break;
                }
                case "lineNumber": {
                    long lineNumber = (Long)BeanService.getPropertyValue(logEntry, columnName);
                    value = Long.toString(lineNumber);
                    break;
                }
                case "transactionID": {
                    long transactionID = (Long)BeanService.getPropertyValue(logEntry, columnName);
                    value = Long.toString(transactionID);
                    break;
                }
                case "message": {
                    value = logEntry.getMessage();
                    if (value == null) {
                        value = "";
                        break;
                    }
                    value = value.replace("<", "&lt;");
                    value = value.replace(">", "&gt;");
                    break;
                }
                case "time": {
                    DateTime time = logEntry.getTime();
                    if (time == null) {
                        value = "";
                        break;
                    }
                    value = time.toString();
                    break;
                }
                default: {
                    value = (String)BeanService.getPropertyValue(logEntry, columnName);
                }
            }
            if (StringUtility.isEmpty(value)) {
                logger.finer(() -> LMG.log("%s: Value is blank or null. Skipping.", () -> loggerPrefix));
            } else {
                logger.finer(() -> LMG.log("%s: Adding value to HTML.", () -> loggerPrefix));
                value = StringUtility.wordWrap(value, 80);
                if (value.contains("\n")) {
                    value = value.replace("\n", "<br/>");
                }
                html.append(String.format("<tr><td align='right'>%s:</td><td>%s</td></tr>", title, value));
            }
            ++n2;
        }
        html.append("</table></body></html>");
        this.displayTable.setToolTipText(html.toString());
        logger.finer(() -> LMG.log("%s: Done.", () -> loggerPrefix));
    }

    protected abstract String[] getPreferredColumnOrder();

    @Override
    public boolean isPopupReady() {
        int rowCount = this.displayTable.getRowCount();
        return rowCount > 0;
    }
}

