/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.panel.logs;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.rules.PropertyValueRule;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMList;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.component.AccordionComponent;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.event.ListSelectionEventInvoker;
import com.jmorgan.swing.list.JMListModel;
import com.jmorgan.util.StringUtility;
import com.kumbasoft.core.beans.LogFilterEventListener;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JScrollPane;

public abstract class AbstractLogFiltersComponent<LogEntryType>
extends AbstractPanel {
    private final Object LOCK = new Object();
    protected String[] FILTER_TITLES = this.getFilterTitles();
    protected String[] FILTER_PROPERTIES = this.getFilterProperties();
    private JMButton btnClearFilters;
    private AccordionComponent accordionControl;
    protected HashMap<String, String> accordionFilterProperties;
    protected HashMap<String, JMListModel<String>> accordionListModels;
    private HashMap<String, JMList<String>> accordionLists;
    private boolean filterListItemChanging;
    private ArrayList<LogFilterEventListener<LogEntryType>> logFilterEventListeners;

    public AbstractLogFiltersComponent() {
        super(new BorderLayout());
        this.createControls();
    }

    protected void createControls() {
        this.accordionControl = new AccordionComponent();
        this.accordionFilterProperties = new HashMap();
        this.accordionListModels = new HashMap();
        this.accordionLists = new HashMap();
        int i = 0;
        while (i < this.FILTER_TITLES.length) {
            String filterTitle = this.FILTER_TITLES[i];
            String filterProperty = this.FILTER_PROPERTIES[i];
            JMListModel listModel = new JMListModel();
            listModel.setOrdered(true);
            JMList list = new JMList(listModel);
            new ListSelectionEventInvoker(list, this, "filterListItemChanged", filterTitle);
            this.accordionFilterProperties.put(filterTitle, filterProperty);
            this.accordionListModels.put(filterTitle, listModel);
            this.accordionLists.put(filterTitle, list);
            this.accordionControl.addCategory(filterTitle, new JScrollPane(list));
            ++i;
        }
        this.accordionControl.setPreferredSize(150, 200);
        this.accordionControl.setSize(150, 200);
        this.btnClearFilters = new JMButton(KumbaCoreUIConstants.FILTER_CLEAR_ICON, "Clear Filters");
        this.btnClearFilters.setEnabled(false);
        new ActionEventInvoker(this.btnClearFilters, this, "clearQuickFilters");
        Label label = new Label("Quick Filters");
        JMPanel topPanel = new JMPanel(new BorderLayout());
        topPanel.add((Component)label, "Center");
        topPanel.add((Component)this.btnClearFilters, "East");
        JMPanel quickFiltersPanel = KumbaCoreUIConstants.createBorderLayoutPanel();
        quickFiltersPanel.add((Component)topPanel, "North");
        quickFiltersPanel.add((Component)this.accordionControl, "Center");
        this.add((Component)quickFiltersPanel, "Center");
    }

    protected abstract String[] getFilterTitles();

    protected abstract String[] getFilterProperties();

    @Reflected
    private void clearQuickFilters() {
        String[] stringArray = this.FILTER_TITLES;
        int n = this.FILTER_TITLES.length;
        int n2 = 0;
        while (n2 < n) {
            String filterTitle = stringArray[n2];
            JMList<String> list = this.accordionLists.get(filterTitle);
            list.clearSelection();
            ++n2;
        }
        this.btnClearFilters.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetQuickFilters() {
        String[] stringArray = this.FILTER_TITLES;
        int n = this.FILTER_TITLES.length;
        int n2 = 0;
        while (n2 < n) {
            String filterTitle = stringArray[n2];
            JMList<String> list = this.accordionLists.get(filterTitle);
            list.clearSelection();
            Object object = this.LOCK;
            synchronized (object) {
                JMListModel<String> listModel = this.accordionListModels.get(filterTitle);
                listModel.clear();
            }
            ++n2;
        }
        this.updateFilterTitleCounts();
        this.btnClearFilters.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFilterTitleCounts() {
        logger.finer("(): Starting");
        String[] stringArray = this.FILTER_TITLES;
        int n = this.FILTER_TITLES.length;
        int n2 = 0;
        while (n2 < n) {
            String filterTitle = stringArray[n2];
            JMButton button = this.accordionControl.getCategoryButton(filterTitle);
            int listSize = 0;
            Object object = this.LOCK;
            synchronized (object) {
                JMListModel<String> listModel = this.accordionListModels.get(filterTitle);
                listSize = listModel.getSize();
            }
            String newButtonTitle = listSize == 0 ? filterTitle : (listSize == 1 ? String.format("%d %s", listSize, filterTitle) : String.format("%d %s", listSize, StringUtility.pluralize(filterTitle)));
            button.setText(newButtonTitle);
            ++n2;
        }
        logger.finer("(): Done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadQuickFilters(LogEntryType logEntry) {
        String[] stringArray = this.FILTER_TITLES;
        int n = this.FILTER_TITLES.length;
        int n2 = 0;
        while (n2 < n) {
            String filterTitle = stringArray[n2];
            String filterProperty = this.accordionFilterProperties.get(filterTitle);
            Object propertyValue = BeanService.getPropertyValue(logEntry, filterProperty);
            if (propertyValue != null) {
                JMListModel<String> listModel = this.accordionListModels.get(filterTitle);
                String valueToAdd = String.valueOf(propertyValue);
                Object object = this.LOCK;
                synchronized (object) {
                    if (!listModel.contains(valueToAdd)) {
                        listModel.addElement(valueToAdd);
                    }
                }
            }
            ++n2;
        }
    }

    public void addLogFilterEventListener(LogFilterEventListener<LogEntryType> logFilterEventListener) {
        if (logFilterEventListener == null) {
            return;
        }
        if (this.logFilterEventListeners == null) {
            this.logFilterEventListeners = new ArrayList();
        }
        this.logFilterEventListeners.add(logFilterEventListener);
    }

    @Reflected
    private void filterListItemChanged(String selectedFilterTitle) {
        if (this.filterListItemChanging) {
            return;
        }
        for (LogFilterEventListener<LogEntryType> listener : this.logFilterEventListeners) {
            listener.logFilterChanging();
        }
        this.filterListItemChanging = true;
        JMList<String> selectedList = this.accordionLists.get(selectedFilterTitle);
        selectedList.repaint();
        PropertyValueRule propertyValueRule = new PropertyValueRule();
        String[] stringArray = this.FILTER_TITLES;
        int n = this.FILTER_TITLES.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            String filterProperty = this.accordionFilterProperties.get(string);
            JMList<String> list = this.accordionLists.get(string);
            List selectedItems = list.getSelectedValuesList();
            int selectedItemCount = selectedItems.size();
            JMButton button = this.accordionControl.getCategoryButton(string);
            button.setIcon(selectedItemCount == 0 ? null : KumbaCoreUIConstants.FILTER_ICON);
            new AsynchMethodInvoker((Object)button, "repaint", 50);
            if (selectedItemCount != 0) {
                List listToApply = selectedItems;
                if (filterProperty.equals("transactionID")) {
                    ArrayList<Long> selectedNumbers = new ArrayList<Long>(selectedItems.size());
                    for (String selectedItem : selectedItems) {
                        selectedNumbers.add(Long.parseLong(selectedItem));
                    }
                    listToApply = selectedNumbers;
                }
                if (selectedItemCount == 1) {
                    propertyValueRule.addPropertyValueMap(filterProperty, listToApply.get(0));
                } else {
                    propertyValueRule.addPropertyValueMap(filterProperty, listToApply, 10);
                }
            }
            ++n2;
        }
        this.btnClearFilters.setEnabled(propertyValueRule.getRuleCount() > 0);
        for (LogFilterEventListener logFilterEventListener : this.logFilterEventListeners) {
            logFilterEventListener.logFilterEvent(propertyValueRule);
        }
        this.filterListItemChanging = false;
    }
}

