/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.panel.logs;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.lang.Types;
import com.jmorgan.swing.table.BeanColumnModel;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.LogEntry;
import com.kumbasoft.core.beans.actions.ActionDeleteFile;
import com.kumbasoft.core.beans.config.ConfigLogTarget;
import com.kumbasoft.core.tools.ActionTool;
import com.kumbasoft.core.tools.LogTargetProcessor;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.beans.DataPowerLogSearchOptions;
import com.kumbasoft.core.ui.dialog.logSearchOptions.DataPowerLogSearchOptionsPanel;
import com.kumbasoft.core.ui.panel.logs.AbstractLogDisplayPanel;
import com.kumbasoft.core.ui.panel.logs.DataPowerLogFiltersComponent;
import com.kumbasoft.core.ui.renderers.LogEntryBeanTableCellRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class DisplayLogEntryPanel
extends AbstractLogDisplayPanel<ConfigLogTarget, LogEntry, DataPowerLogFiltersComponent, DataPowerLogSearchOptions, DataPowerLogSearchOptionsPanel> {
    private HashSet<Long> matchingTransactionIDs;
    private Index<Long, LogEntry> transactionLogEntryCache;
    private HashSet<String> matchingGlobalTranctionIDs;
    private Index<String, LogEntry> globalTransactionLogEntryCache;

    public DisplayLogEntryPanel() {
        super(LogEntry.class);
    }

    @Override
    protected DataPowerLogSearchOptions createSearchOptions() {
        return new DataPowerLogSearchOptions();
    }

    @Override
    protected DataPowerLogSearchOptionsPanel createSearchOptionsPanel(DataPowerLogSearchOptions searchOptions) {
        return new DataPowerLogSearchOptionsPanel(searchOptions);
    }

    @Override
    protected String getSearchOptionsPanelTitle() {
        return "Logging Target Search Options";
    }

    @Override
    protected DataPowerLogFiltersComponent createQuickFiltersPanel() {
        return new DataPowerLogFiltersComponent();
    }

    @Override
    protected BeanColumnModel<LogEntry> getColumnModel() {
        logger.finer("(): Starting");
        BeanColumnModel<LogEntry> columnModel = super.getColumnModel();
        LogEntryBeanTableCellRenderer cellRenderer = new LogEntryBeanTableCellRenderer(this.tableModel);
        this.columnModel.setRenderer(".*", cellRenderer);
        columnModel.hideColumn("lineNumber");
        columnModel.setColumnOrder(this.getPreferredColumnOrder());
        logger.finer("(): Done.  Returning model.");
        return columnModel;
    }

    @Override
    protected String[] getPreferredColumnOrder() {
        logger.finer("(): Returning column order");
        return new String[]{"appliance", "domain", "logTargetName", "time", "logCategory", "logLevel", "transactionID", "lineNumber", "globalTransactionID", "objectClass", "object", "client", "errorCode", "message"};
    }

    @Override
    protected int getEstimatedFileCount() {
        int estimatedFileCount = 0;
        for (ConfigLogTarget logTarget : this.selectedLogTargets) {
            int numberOfRotations = (int)logTarget.getRotate();
            estimatedFileCount += numberOfRotations;
        }
        return estimatedFileCount;
    }

    @Override
    protected LogTargetProcessor getLogTargetProcessor() {
        return new LogTargetProcessor(this.selectedLogTargets);
    }

    @Override
    protected void searchLogs() {
        logger.finer("(): Starting");
        if (this.searchOptions == null) {
            this.createDefaultSearchOptions();
        }
        if (((DataPowerLogSearchOptions)this.searchOptions).autoClearOldLogs()) {
            logger.fine("(): Auto Clear is ON.  Removing old log files.");
            this.deleteOldLogs();
        }
        if (((DataPowerLogSearchOptions)this.searchOptions).followTransactions()) {
            logger.fine("(): Follow Transactions is ON");
            if (this.transactionLogEntryCache != null) {
                try {
                    this.transactionLogEntryCache.clear();
                    this.matchingTransactionIDs.clear();
                }
                catch (Exception e) {
                    logger.warning("(): Clearing transaction logs and matching IDs errored.  Recovering...");
                }
            } else {
                this.transactionLogEntryCache = new Index();
                this.matchingTransactionIDs = new HashSet();
            }
        }
        if (((DataPowerLogSearchOptions)this.searchOptions).followGlobalTransactions()) {
            logger.fine("(): Follow Global Transactions is ON");
            if (this.globalTransactionLogEntryCache != null) {
                try {
                    this.globalTransactionLogEntryCache.clear();
                    this.matchingGlobalTranctionIDs.clear();
                }
                catch (Exception e) {
                    logger.warning("(): Clearing global transaction logs and matching IDs errored.  Recovering...");
                }
            } else {
                this.globalTransactionLogEntryCache = new Index();
                this.matchingGlobalTranctionIDs = new HashSet();
            }
        }
        super.searchLogs();
        logger.finer("(): Done");
    }

    @Reflected
    private void deleteOldLogs() {
        logger.finer("(): Starting.  ");
        logger.fine("(): Invoking 'deleteOldLogs' async by appliance domain.");
        MultiThreadInvocationListener threadSync = ApplianceDomainChangeMonitor.getInstance().invokeProcessByApplianceSelection(this, "deleteOldLogs", false);
        boolean completedOnTime = ThreadManager.monitorAsynchThreadLifeCycle("DisplayLogEntryPanel.deleteOldLogs()", threadSync, KumbaCoreConstants.STARTUP_DELAY, 0);
        if (!completedOnTime) {
            logger.warning("(): Delete old logs did not complete on time.  Continuing anyway.");
        }
        logger.finer("(): Done");
    }

    @Reflected
    private void deleteOldLogs(Appliance appliance, Domain domain) {
        String loggerPrefix = String.format("(appliance=%s, domain=%s)", appliance.getName(), domain.getName());
        logger.finer(() -> LMG.log("%s: Starting", () -> loggerPrefix));
        MultiThreadInvocationListener threadSync = new MultiThreadInvocationListener();
        for (ConfigLogTarget logTarget : this.selectedLogTargets) {
            ConfigLogTarget proxyLogTarget = this.getProxyLogTarget(appliance, domain, logTarget);
            String baseFileName = proxyLogTarget.getLocalFile();
            if (baseFileName == null) {
                logger.warning(() -> LMG.log("%s: Base file name for %s is null.  How or why?", () -> loggerPrefix, () -> logTarget.getFQON()));
                continue;
            }
            long numberOfRotations = proxyLogTarget.getRotate();
            logger.fine(() -> LMG.log("%s: Clearing out %d logs for %s,", () -> loggerPrefix, () -> numberOfRotations, () -> proxyLogTarget.getName()));
            long i = numberOfRotations;
            while (i > 0L) {
                Object currentFileName = "";
                currentFileName = i > 0L ? baseFileName + "." + i : baseFileName;
                String cfn = currentFileName;
                logger.info(() -> LMG.log("%s:  Deleting old log file for %s: %s\n", () -> loggerPrefix, () -> proxyLogTarget.getName(), () -> cfn));
                ActionDeleteFile deleteFile = new ActionDeleteFile();
                deleteFile.setFile((String)currentFileName);
                ActionTool actionTool = new ActionTool(appliance, domain, deleteFile);
                actionTool.setCommandDescription(String.format("Delete file %s in %s domain of %s", currentFileName, domain.getName(), appliance.getName()));
                actionTool.addAdditionalCommandInfo("file", currentFileName);
                threadSync.addThread(actionTool.getProcessThread());
                --i;
            }
        }
        logger.finer(() -> LMG.log("%s: Waiting for all threads in this appliance/domain to complete.", () -> loggerPrefix));
        String threadName = String.format("DisplayLogEntryPanel.deleteOldLogs%s", loggerPrefix);
        boolean completedOnTime = ThreadManager.monitorAsynchThreadLifeCycle(threadName, threadSync, KumbaCoreConstants.STARTUP_DELAY, 0);
        if (!completedOnTime) {
            logger.warning(() -> LMG.log("%s: Not all threads in this appliance/domain completed on time.  Continuing anyway.", () -> loggerPrefix));
        }
        logger.finer(() -> LMG.log("%s: Done", () -> loggerPrefix));
    }

    @Override
    protected boolean isMatching(LogEntry logEntry) {
        boolean matches;
        logger.finer(() -> LMG.log("(LogEntry): Starting.  logEntry:\n\t%s", () -> logEntry.toString()));
        String filterExpression = ((DataPowerLogSearchOptions)this.searchOptions).getFilterExpression();
        String message = Types.returnIfNull(logEntry.getMessage(), "");
        String errorCode = Types.returnIfNull(logEntry.getErrorCode(), "");
        String objectClass = Types.returnIfNull(logEntry.getObjectClass(), "");
        String objectName = Types.returnIfNull(logEntry.getObject(), "");
        String logLevel = Types.returnIfNull(logEntry.getLogLevel(), "");
        long transactionID = logEntry.getTransactionID();
        String transID = "" + transactionID;
        String gTransactionID = Types.returnIfNull(logEntry.getGlobalTransactionID(), "");
        String clientIP = Types.returnIfNull(logEntry.getClient(), "");
        boolean isMatching = matches = message.matches(filterExpression) || errorCode.matches(filterExpression) || objectClass.matches(filterExpression) || objectName.matches(filterExpression) || logLevel.matches(filterExpression) || transID.matches(filterExpression) || gTransactionID.matches(filterExpression) || clientIP.matches(filterExpression);
        logger.finer(() -> LMG.log("(LogEntry): Base field match is %b", () -> isMatching));
        if (StringUtility.isNotEmpty(filterExpression) && ((DataPowerLogSearchOptions)this.searchOptions).followTransactions()) {
            Collection<LogEntry> cachedEntries;
            logger.finer("(LogEntry): Follow Transactions is ON");
            if (matches) {
                logger.finer(() -> LMG.log("(LogEntry): Follow Transactions is ON and this entry matches - Adding cached entries matching %d.", () -> transactionID));
                cachedEntries = this.transactionLogEntryCache.get(transactionID);
                if (CollectionUtility.isNotEmpty(cachedEntries)) {
                    ArrayList<LogEntry> looper = new ArrayList<LogEntry>(cachedEntries);
                    for (LogEntry cachedEntry : looper) {
                        this.addRow(cachedEntry);
                    }
                }
                logger.finer(() -> LMG.log("(LogEntry): Follow Transactions is ON and this entry matches - Removing cache for %d so they don't repeat", () -> transactionID));
                this.transactionLogEntryCache.removeAll(transactionID);
                logger.finer(() -> LMG.log("(LogEntry): Follow Transactions is ON and this entry matches - Adding %d to matching IDs", () -> transactionID));
                this.matchingTransactionIDs.add(transactionID);
            } else if (this.matchingTransactionIDs == null) {
                logger.finer("(LogEntry): Follow Transactions is ON and there are no matching transation ids.");
                matches = false;
            } else if (this.matchingTransactionIDs.contains(transactionID)) {
                logger.finer(() -> LMG.log("(LogEntry): Follow Transactions is ON and this does not match but %d is in the matching transaction IDs. Forcing it to match", () -> transactionID));
                matches = true;
            } else {
                logger.finer(() -> LMG.log("(LogEntry): Follow Transactions is ON and %d is not contained in the matching transaction IDs. Adding %d to the transaction log entry cache.", () -> transactionID, () -> transactionID));
                this.transactionLogEntryCache.put((Long)transactionID, logEntry);
            }
            if (StringUtility.isNotEmpty(filterExpression) && ((DataPowerLogSearchOptions)this.searchOptions).followGlobalTransactions() && StringUtility.isNotEmpty(gTransactionID)) {
                if (matches) {
                    logger.finer(() -> LMG.log("(LogEntry): Follow Global Transactions is ON and this entry matches - Adding cached entries matching %s.", () -> gTransactionID));
                    cachedEntries = this.globalTransactionLogEntryCache.get(gTransactionID);
                    if (CollectionUtility.isNotEmpty(cachedEntries)) {
                        for (LogEntry cachedEntry : cachedEntries) {
                            this.addRow(cachedEntry);
                        }
                    }
                    logger.finer(() -> LMG.log("(LogEntry): Follow Global Transactions is ON and this entry matches - Removing cache for %s so they don't repeat", () -> gTransactionID));
                    this.globalTransactionLogEntryCache.removeAll(gTransactionID);
                    logger.finer(() -> LMG.log("(LogEntry): Follow Global Transactions is ON and this entry matches - Adding %s to matching IDs", () -> gTransactionID));
                    this.matchingGlobalTranctionIDs.add(gTransactionID);
                } else if (this.matchingGlobalTranctionIDs.contains(gTransactionID)) {
                    logger.finer(() -> LMG.log("(LogEntry): Follow Global Transactions is ON and this does not match but %s is in the matching global transaction IDs. Forcing it to match", () -> gTransactionID));
                    matches = true;
                } else {
                    logger.finer(() -> LMG.log("(LogEntry): Follow Global Transactions is ON and %s  is not contained in the matching global transaction IDs. Adding %s  to the global transaction log entry cache.", () -> gTransactionID, () -> gTransactionID));
                    this.globalTransactionLogEntryCache.put(gTransactionID, logEntry);
                }
            }
        }
        if (matches) {
            logger.finer("(LogEntry):  Log entry matches.  Adding its data to quick filters.");
            ((DataPowerLogFiltersComponent)this.logFiltersComponent).loadQuickFilters(logEntry);
            logger.finer("(LogEntry):  Log entry matches.  Done adding its data to quick filters.");
        }
        boolean finalMatch = matches;
        logger.finer(() -> LMG.log("(LogEntry): Done.  Returning %b", () -> finalMatch));
        return matches;
    }
}

