/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.panel.logs;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.beans.util.BeanIndexer;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMList;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.dialog.DialogPanel;
import com.jmorgan.swing.dialog.GenericDialog;
import com.jmorgan.swing.event.ListSelectionEventInvoker;
import com.jmorgan.swing.list.JMListCellRenderer;
import com.jmorgan.swing.list.JMListModel;
import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.PropertyValueSelector;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.actions.ActionSetLogLevel;
import com.kumbasoft.core.beans.config.ConfigAuditLog;
import com.kumbasoft.core.beans.config.ConfigLogLabel;
import com.kumbasoft.core.beans.config.ConfigLogTarget;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.beans.types.LogEvent;
import com.kumbasoft.core.tools.ActionTool;
import com.kumbasoft.core.tools.ModifyProperty;
import com.kumbasoft.core.tools.ModifyTool;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.logSearchOptions.AbstractLogSettingsPanel;
import com.kumbasoft.core.ui.dialog.logSearchOptions.AuditLogSettingsPanel;
import com.kumbasoft.core.ui.dialog.logSearchOptions.DataPowerLogSettingsPanel;
import com.kumbasoft.core.ui.panel.logs.AbstractLogDisplayPanel;
import com.kumbasoft.core.ui.panel.logs.DisplayAuditLogPanel;
import com.kumbasoft.core.ui.panel.logs.DisplayLogEntryPanel;
import com.kumbasoft.core.ui.renderers.LogTargetListCellValueRenderer;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.ListModel;

public class DisplayLogPanel
extends AbstractPanel {
    private static final String[] EXEMPT_TARGETS = new String[]{"cli-log", "compile-log", "diag-log", "usage-log", "xact-log", "startup-errors"};
    private ConfigurationManager configurationManager = new ConfigurationManager();
    private Index<String, StatusObjectStatus> logTargetIndexByName;
    private JMListModel<String> logTargetListModel;
    private JMList<String> logTargetList;
    private LogTargetListCellValueRenderer logTargetRenderer;
    private ArrayList<DataPowerConfig> logTargetConfigs;
    private boolean domainsChanging;
    private AsynchMethodInvoker<Void> domainChangeReinvocationThread;
    private JMButton btnRefreshLogTargetList;
    private JMButton btnEnableLogTargets;
    private JMButton btnDisableLogTargets;
    private JMButton btnLogTargetSettings;
    private JMPanel logContainer;
    private CardLayout cardLayout;
    private DisplayLogEntryPanel logEntryPanel;
    private DisplayAuditLogPanel auditLogPanel;
    private boolean auditLogSelectionActionChanging = false;
    private AsynchMethodInvoker<Void> statusUpdateThread;

    public DisplayLogPanel() {
        super(KumbaCoreUIConstants.createBorderLayout());
        JMPanel listPanel = this.createListPanel();
        this.add((Component)listPanel, "West");
        this.logEntryPanel = new DisplayLogEntryPanel();
        this.auditLogPanel = new DisplayAuditLogPanel();
        this.cardLayout = new CardLayout();
        this.logContainer = new JMPanel(this.cardLayout);
        this.logContainer.add((Component)this.logEntryPanel, "LogEntryPanel");
        this.logContainer.add((Component)this.auditLogPanel, "AuditLogPanel");
        this.add((Component)this.logContainer, "Center");
        ApplianceDomainChangeMonitor.getInstance().addDomainChangeSubscriber(this, "domainsChanged");
    }

    private JMPanel createListPanel() {
        JMPanel listPanel = KumbaCoreUIConstants.createBorderLayoutPanel();
        JMPanel titlePanel = new JMPanel(new BorderLayout());
        this.btnLogTargetSettings = ComponentFactory.createButton(KumbaCoreUIConstants.EDIT_ICON, null, "Edit Log Target Settings", true, this, "fileOpen", new Object[0]);
        titlePanel.add(ComponentFactory.createSpacer(20, 12), "North");
        titlePanel.add((Component)new JMLabel("Logging Targets:"), "Center");
        this.btnRefreshLogTargetList = ComponentFactory.createButton(KumbaCoreUIConstants.REFRESH_ICON, null, "Refresh list of logging targets", true, this, "refreshLogTargets", new Object[0]);
        this.btnEnableLogTargets = ComponentFactory.createButton(KumbaCoreUIConstants.ENABLED_ICON, null, "Enable selected logging targets", true, this, "setLogTargetState", true);
        this.btnDisableLogTargets = ComponentFactory.createButton(KumbaCoreUIConstants.DISABLED_ICON, null, "Disable selected logging targets", true, this, "setLogTargetState", false);
        JMPanel buttonPanel = new JMPanel(new FlowLayout(2, 5, 0));
        buttonPanel.addAll(this.btnRefreshLogTargetList, this.btnEnableLogTargets, this.btnDisableLogTargets, this.btnLogTargetSettings);
        titlePanel.add((Component)buttonPanel, "East");
        listPanel.add((Component)titlePanel, "North");
        this.logTargetListModel = new JMListModel();
        this.logTargetListModel.setOrdered(true);
        this.logTargetList = new JMList<String>((ListModel<String>)this.logTargetListModel);
        this.logTargetRenderer = new LogTargetListCellValueRenderer();
        this.logTargetList.setCellRenderer(new JMListCellRenderer(this.logTargetRenderer));
        this.logTargetList.setSelectionMode(2);
        new ListSelectionEventInvoker(this.logTargetList, this, "logTargetChanged");
        JMScrollPane scrollPanel = KumbaCoreUIConstants.createScrollPane(this.logTargetList);
        listPanel.add((Component)scrollPanel, "Center");
        return listPanel;
    }

    @Reflected
    private void fileOpen() {
        AbstractPanel.logger.finer("(): Starting");
        List selectedItems = this.logTargetList.getSelectedValuesList();
        boolean auditLogSelected = false;
        for (String logTargetName : selectedItems) {
            if (!logTargetName.equals("audit-log")) continue;
            auditLogSelected = true;
        }
        DynamicBean logSettings = new DynamicBean();
        logSettings.setProperty("loggingTargets", this.logTargetConfigs);
        AbstractLogSettingsPanel panel = auditLogSelected ? new AuditLogSettingsPanel(logSettings) : new DataPowerLogSettingsPanel(logSettings);
        String title = auditLogSelected ? "Audit Log Settings" : "Log Target Settings";
        GenericDialog dialog = new GenericDialog(GUIServices.getFrame(this), title, (DialogPanel)panel);
        dialog.setModal(true);
        dialog.setVisible(true);
        if (dialog.wasCancelled()) {
            return;
        }
        this.openResultsDialogAndSetWaitCursor("Define Log Target Settings");
        for (DataPowerConfig selectedLogTarget : this.logTargetConfigs) {
            if (selectedLogTarget == null || Comparison.isIn(selectedLogTarget.getName(), EXEMPT_TARGETS)) continue;
            if (selectedLogTarget.getSourceDomain().getName().equals("default") && selectedLogTarget.getName().equals("default-log")) {
                this.setDefaultLogLevel(selectedLogTarget, logSettings);
                continue;
            }
            if (selectedLogTarget instanceof ConfigAuditLog) {
                this.changeAuditLogConfig(selectedLogTarget, logSettings);
                continue;
            }
            this.changeLogTargetConfig(selectedLogTarget, logSettings);
        }
        this.waitForResultsDialogToCloseAndResetCursor();
        AbstractPanel.logger.finer("(): Done");
    }

    @Reflected
    private void setLogTargetState(boolean state) {
        AbstractPanel.logger.finer(() -> LMG.log("(state=%b): Starting", () -> state));
        ArrayList selectedLoggingTargets = (ArrayList)this.logTargetList.getSelectedValuesList();
        if (CollectionUtility.isEmpty(selectedLoggingTargets)) {
            AbstractPanel.logger.info(() -> LMG.log("(state=%b): No logging targets selected.  Nothing to do.", () -> state));
            return;
        }
        String title = state ? "Enable" : "Disable";
        this.openResultsDialogAndSetWaitCursor(title + " Logging Targets");
        String newAdminState = state ? "enabled" : "disabled";
        String changeFromAdminState = state ? "disabled" : "enabled";
        BeanIndexer<DataPowerConfig> nameIndexer = new BeanIndexer<DataPowerConfig>(this.logTargetConfigs);
        Index<String, DataPowerConfig> logTargetConfigsByName = nameIndexer.getIndexOf("name", "");
        for (String logTargetName : selectedLoggingTargets) {
            if (Comparison.isIn(logTargetName, EXEMPT_TARGETS) || logTargetName.equals("audit-log")) {
                AbstractPanel.logger.finer(() -> LMG.log("(state=%b): Ignoring exempt pseudo target '%s'", () -> state, () -> logTargetName));
                continue;
            }
            Collection<StatusObjectStatus> logTargets = this.logTargetIndexByName.get(logTargetName);
            Collection<DataPowerConfig> logTargetConfigs = logTargetConfigsByName.get(logTargetName);
            if (logTargetConfigs == null) {
                AbstractPanel.logger.info(() -> LMG.log("(state=%b): No logging target configs found by name: '%s'", () -> state, () -> logTargetName));
                continue;
            }
            for (StatusObjectStatus logTargetStatus : logTargets) {
                if (!logTargetStatus.getAdminState().equals(changeFromAdminState)) continue;
                AbstractPanel.logger.config(() -> LMG.log("(state=%b): Setting admin state to '%s' for '%s'.", () -> state, () -> newAdminState, () -> logTargetStatus.getFQON()));
                ModifyProperty<String> setAdminState = new ModifyProperty<String>(logTargetStatus, "mAdminState", newAdminState);
                setAdminState.addManagementCommandSubscriber(this.commandResultsDialog);
                logTargetStatus.setAdminState(newAdminState);
                for (DataPowerConfig logTargetConfig : logTargetConfigs) {
                    if (!logTargetConfig.getAppliance().equals(logTargetStatus.getAppliance()) || !logTargetConfig.getSourceDomain().equals(logTargetStatus.getSourceDomain()) || !logTargetConfig.getName().equals(logTargetStatus.getName())) continue;
                    logTargetConfig.setAdminState(newAdminState);
                }
            }
        }
        this.waitForResultsDialogToCloseAndResetCursor();
        this.logTargetList.repaint();
        AbstractPanel.logger.finer(() -> LMG.log("(state=%b): Done", () -> state));
    }

    @Reflected
    private void logTargetChanged() {
        if (this.domainsChanging) {
            return;
        }
        AbstractPanel.logger.finer("():  Starting");
        if (this.auditLogSelectionActionChanging) {
            AbstractPanel.logger.finer("():  Clearing selection for audit log is indicated... Reselecting audit then returning");
            this.auditLogSelectionActionChanging = false;
            this.logTargetList.setSelectedValue("audit-log", false);
            return;
        }
        List selectedLogTargets = this.logTargetList.getSelectedValuesList();
        if (CollectionUtility.isEmpty(selectedLogTargets)) {
            AbstractPanel.logger.finer("():  No logging targets selected.  Returning.");
            return;
        }
        this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
        this.logEntryPanel.setSelectedLogTargets((ArrayList)null);
        ArrayList<StatusObjectStatus> matchingLogTargets = new ArrayList<StatusObjectStatus>();
        boolean auditLogSelected = false;
        int exemptTargetCount = 0;
        for (String selectedLogTarget : selectedLogTargets) {
            Collection<StatusObjectStatus> actualSelectedTargets;
            if (selectedLogTarget.equals("audit-log")) {
                if (selectedLogTargets.size() > 1 && !this.auditLogSelectionActionChanging) {
                    AbstractPanel.logger.finer("():  Audit Log Selected... clearing others");
                    this.auditLogSelectionActionChanging = true;
                    this.logTargetList.clearSelection();
                    AbstractPanel.logger.finer("():  Audit Log Selected... clearing others completed.  Returning.");
                    return;
                }
                auditLogSelected = true;
                selectedLogTarget = "AuditLog-Settings";
                AbstractPanel.logger.finer("():  Audit Log Selected ... Moving on");
            }
            if (Comparison.isIn(selectedLogTarget, EXEMPT_TARGETS)) {
                ++exemptTargetCount;
            }
            if ((actualSelectedTargets = this.logTargetIndexByName.get(selectedLogTarget)) == null) {
                String finalSelectedLogTarget = selectedLogTarget;
                AbstractPanel.logger.finer(() -> LMG.log("():  Actual log targets for %s returns null.", () -> finalSelectedLogTarget));
                continue;
            }
            matchingLogTargets.addAll(actualSelectedTargets);
        }
        boolean newButtonState = exemptTargetCount != selectedLogTargets.size();
        this.btnLogTargetSettings.setEnabled(newButtonState);
        this.btnEnableLogTargets.setEnabled(newButtonState && !auditLogSelected);
        this.btnDisableLogTargets.setEnabled(newButtonState && !auditLogSelected);
        Class objectClass = null;
        String objectNameExpression = null;
        AbstractLogDisplayPanel displayPanel = null;
        try {
            if (auditLogSelected) {
                this.cardLayout.show(this.logContainer, "AuditLogPanel");
                objectClass = ConfigAuditLog.class;
                objectNameExpression = "AuditLog-Settings";
                displayPanel = this.auditLogPanel;
            } else {
                this.cardLayout.show(this.logContainer, "LogEntryPanel");
                objectClass = ConfigLogTarget.class;
                objectNameExpression = String.format("(%s)", StringUtility.getDelimitedString(selectedLogTargets, "|"));
                displayPanel = this.logEntryPanel;
            }
            new AsynchMethodInvoker((Object)this, "loadLogTargetObjects", new Object[]{matchingLogTargets, objectClass, objectNameExpression, displayPanel});
        }
        finally {
            this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
        }
        AbstractPanel.logger.finer("():  Done");
    }

    @Reflected
    private void loadLogTargetObjects(ArrayList<StatusObjectStatus> logTargets, Class<? extends DataPowerConfig> objectClass, String objectNameExpression, AbstractLogDisplayPanel displayPanel) {
        logger.finer("(...):  Start getting logging target configurations");
        this.logTargetConfigs = this.configurationManager.getObjects(logTargets);
        displayPanel.setSelectedLogTargets(this.logTargetConfigs);
        logger.finer("(...):  Done getting logging target configurations");
    }

    @Reflected
    private void refreshLogTargets() {
        Index<Appliance, Domain> selectedDomains = ApplianceDomainChangeMonitor.getInstance().getCurrentDomainSelection();
        this.domainsChanged(selectedDomains);
    }

    @Reflected
    private void domainsChanged(Index<Appliance, Domain> selectedDomains) {
        if (this.domainsChanging) {
            if (this.statusUpdateThread != null) {
                this.statusUpdateThread.cancel();
            }
            if (this.domainChangeReinvocationThread != null) {
                this.domainChangeReinvocationThread.cancel();
            }
            this.domainChangeReinvocationThread = new AsynchMethodInvoker((Object)this, "domainsChanged", (Object)selectedDomains, KumbaCoreConstants.THREAD_WAIT);
            return;
        }
        this.domainsChanging = true;
        logger.entering(this.getClass().getName(), "domainsChanged(Index<Appliance, Domain> selectedDomains)");
        this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
        if (this.logTargetIndexByName == null) {
            this.logTargetIndexByName = new Index();
        } else {
            this.logTargetIndexByName.clear();
        }
        this.logTargetList.clearSelection();
        this.logTargetListModel.clear();
        this.logEntryPanel.resetTableData();
        this.auditLogPanel.resetTableData();
        logger.finer(() -> LMG.log("(Index<Appliance, Domain> selectedDomains): Looking for logging targets", new Supplier[0]));
        try {
            ArrayList<StatusObjectStatus> logTargets = this.configurationManager.listObjects(selectedDomains, "(LogTarget|AuditLog)", ".*");
            ArrayList<DataPowerConfig> logTargetConfigs = this.configurationManager.getObjects(logTargets);
            PropertyValueSelector<DataPowerConfig> configSelector = new PropertyValueSelector<DataPowerConfig>(logTargetConfigs);
            UniqueArrayList<String> tempModel = new UniqueArrayList<String>();
            for (StatusObjectStatus logTarget : logTargets) {
                ConfigLogTarget logTargetConfig;
                String logTargetType;
                String name = logTarget.getName();
                configSelector.addPropertyValueMap("appliance", logTarget.getAppliance());
                configSelector.addPropertyValueMap("sourceDomain", logTarget.getSourceDomain());
                configSelector.addPropertyValueMap("name", logTarget.getName());
                ArrayList matchingLogTargetConfigs = (ArrayList)configSelector.getSelectedElements();
                DataPowerConfig matchingLogTargetConfig = (DataPowerConfig)matchingLogTargetConfigs.get(0);
                if (matchingLogTargetConfig instanceof ConfigLogTarget && !(logTargetType = (logTargetConfig = (ConfigLogTarget)matchingLogTargetConfig).getType()).equals("file")) continue;
                this.logTargetIndexByName.put(name, logTarget);
                if (name.equals("AuditLog-Settings")) {
                    name = "audit-log";
                }
                String finalName = name;
                logger.finest(() -> LMG.log("(Index<Appliance, Domain> selectedDomains):  Adding to working unique list model %s", () -> finalName));
                tempModel.add(name);
            }
            logger.finer("(Index<Appliance, Domain> selectedDomains):  Updating Renderer");
            this.logTargetRenderer.setLogTargetIndexByName(this.logTargetIndexByName);
            logger.finer("(Index<Appliance, Domain> selectedDomains):  Setting unique list of elements to model");
            this.logTargetListModel.addAll(tempModel);
        }
        catch (Exception e) {
            logger.config(e.toString());
        }
        new AsynchMethodInvoker((Object)this.logTargetList, "setSelectedValue", new Object[]{"default-log", true}, 125);
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
        this.domainsChanging = false;
        logger.finer("(Index<Appliance, Domain> selectedDomains): Domain changing complete.  Starting status update.");
        this.statusUpdateThread = new AsynchMethodInvoker((Object)this, "updateLogTargetStatus", KumbaCoreConstants.HEALTH_CHECK_INTERVAL);
        logger.finer("(Index<Appliance, Domain> selectedDomains): Done");
    }

    @Reflected
    private void updateLogTargetStatus() {
        AbstractPanel.logger.finer("(): Starting");
        if (this.domainsChanging) {
            AbstractPanel.logger.finer("(): Domains changing when this invoked.  Returning.");
            return;
        }
        if (!this.isShowing()) {
            AbstractPanel.logger.finer("(): Panel is not showing.  Replaying after interval.");
            this.statusUpdateThread = new AsynchMethodInvoker((Object)this, "updateLogTargetStatus", KumbaCoreConstants.HEALTH_CHECK_INTERVAL);
            return;
        }
        try {
            AbstractPanel.logger.finer("(): Getting updated status list.");
            Index<Appliance, Domain> selectedDomains = ApplianceDomainChangeMonitor.getInstance().getCurrentDomainSelection();
            ArrayList logTargetNames = (ArrayList)this.logTargetListModel.getAll();
            if (logTargetNames.contains("audit-log")) {
                logTargetNames.add("AuditLog-Settings");
                logTargetNames.remove("audit-log");
            }
            String matchExpression = StringUtility.getRegexMatchExpression(logTargetNames);
            ArrayList<StatusObjectStatus> newlogTargetStatus = this.configurationManager.listObjects(selectedDomains, "(LogTarget|AuditLog)", matchExpression);
            AbstractPanel.logger.finer("(): New status list obtained.  Repainting list.");
            BeanIndexer<StatusObjectStatus> logTargetIndexer = new BeanIndexer<StatusObjectStatus>(newlogTargetStatus);
            Index<String, StatusObjectStatus> index = logTargetIndexer.getIndexOf("name", "");
            this.logTargetRenderer.setLogTargetIndexByName(index);
            this.logTargetList.repaint();
        }
        catch (Exception e) {
            AbstractPanel.logger.info(() -> LMG.log("(): Exception '%s' during status update.  Ignoring.", () -> e.getClass().getSimpleName()));
        }
        if (this.isShowing() && !this.domainsChanging) {
            AbstractPanel.logger.finer("(): Panel is showing and domains not changing.  Checking status again after interval.");
            this.statusUpdateThread = new AsynchMethodInvoker((Object)this, "updateLogTargetStatus", KumbaCoreConstants.HEALTH_CHECK_INTERVAL);
        }
        AbstractPanel.logger.finer("(): Done");
    }

    private void changeAuditLogConfig(DataPowerConfig auditLogConfig, DynamicBean logSettings) {
        String loggerPrefix = String.format("(DataPowerConfig auditLogConfig, ConfigAuditLog logSettings)  Appliance %s:", auditLogConfig.getAppliance().getName());
        String auditLevel = (String)logSettings.getProperty("logLevel");
        long fileSize = (Long)logSettings.getProperty("fileSize");
        long rotations = (Long)logSettings.getProperty("rotations");
        String loggerSuffix = String.format("Audit log log settings to with Audit Level=%s, File Size=%d, Rotations=%d", auditLevel, fileSize, rotations);
        logger.config(() -> LMG.log("%s Modifying %s", () -> loggerPrefix, () -> loggerSuffix));
        ConfigAuditLog newConfig = (ConfigAuditLog)auditLogConfig;
        newConfig.setAuditLevel(auditLevel);
        newConfig.setSize(fileSize);
        newConfig.setRotate(rotations);
        ModifyTool modifyTool = new ModifyTool(auditLogConfig.getAppliance(), auditLogConfig.getSourceDomain(), newConfig);
        modifyTool.addManagementCommandSubscriber(this.commandResultsDialog);
        logger.finer(() -> LMG.log("%s Completed Modifying %s", () -> loggerPrefix, () -> loggerSuffix));
    }

    private void changeLogTargetConfig(DataPowerConfig logTargetConfig, DynamicBean logSettings) {
        String loggerPrefix = String.format("(DataPowerConfig logTargetConfig=%s, ConfigLogTarget logSettings)  Appliance %s, Domain %s:", logTargetConfig.getName(), logTargetConfig.getAppliance().getName(), logTargetConfig.getSourceDomain().getName());
        ConfigLogTarget newConfig = (ConfigLogTarget)logTargetConfig;
        String logLevel = (String)logSettings.getProperty("logLevel");
        long fileSize = (Long)logSettings.getProperty("fileSize");
        long rotations = (Long)logSettings.getProperty("rotations");
        ArrayList<LogEvent> logEvents = newConfig.getLogEvents();
        boolean allCategoryFound = false;
        for (LogEvent logEvent : logEvents) {
            ObjectReference<ConfigLogLabel> category = logEvent.getDataPowerClass();
            String categoryName = category.getName();
            if (!categoryName.equals("all")) continue;
            logEvent.setPriority(logLevel);
            allCategoryFound = true;
            break;
        }
        if (!allCategoryFound) {
            LogEvent allEvent = new LogEvent();
            allEvent.setPriority(logLevel);
            ObjectReference<ConfigLogLabel> allCategory = new ObjectReference<ConfigLogLabel>();
            allCategory.setName("all");
            allCategory.setClassName("LogLabel");
            ConfigLogLabel logLabel = new ConfigLogLabel();
            logLabel.setName("all");
            logLabel.setAdminState("enabled");
            allCategory.setReferencedObject(logLabel);
            allEvent.setDataPowerClass(allCategory);
            logEvents.add(allEvent);
        }
        String loggerSuffix = String.format("File Size=%d, Rotations=%d, Event Count=%d", fileSize, rotations, logEvents.size());
        logger.config(() -> LMG.log("%s Setting logging target properties to %s", () -> loggerPrefix, () -> loggerSuffix));
        if (CollectionUtility.isNotEmpty(logEvents)) {
            newConfig.setLogEvents(logEvents);
        }
        newConfig.setSize(fileSize);
        newConfig.setRotate(rotations);
        ModifyTool modifyTool = new ModifyTool(newConfig.getAppliance(), newConfig.getSourceDomain(), newConfig);
        modifyTool.addManagementCommandSubscriber(this.commandResultsDialog);
        logger.finer(() -> LMG.log("%s Completed setting logging target properties to %s", () -> loggerPrefix, () -> loggerSuffix));
    }

    private void setDefaultLogLevel(DataPowerConfig defaultLogConfig, DynamicBean logSettings) {
        String loggerPrefix = String.format("(DataPowerConfig defaultLogConfig, DynamicBean logSettings)  Appliance %s:", defaultLogConfig.getAppliance().getName());
        boolean internalLogging = (Boolean)logSettings.getProperty("logInternal");
        boolean rbmLogging = (Boolean)logSettings.getProperty("logRBM");
        String selectedLoggingLevel = (String)logSettings.getProperty("logLevel");
        String loggerSuffix = String.format("Set 'default' log level to %s.  RBM Logging is %s.  Internal Logging is %s.", selectedLoggingLevel, rbmLogging, internalLogging);
        logger.config(() -> LMG.log("%s Setting %s.", () -> loggerPrefix, () -> loggerSuffix));
        ActionSetLogLevel actionSetLogLevel = new ActionSetLogLevel();
        if (defaultLogConfig.getSourceDomain().getName().equals("default")) {
            actionSetLogLevel.setInternalLog(internalLogging ? "on" : "off");
            actionSetLogLevel.setRBMLog(rbmLogging ? "on" : "off");
        }
        actionSetLogLevel.setLogLevel(selectedLoggingLevel);
        ActionTool actionTool = new ActionTool(defaultLogConfig.getAppliance(), defaultLogConfig.getSourceDomain(), actionSetLogLevel);
        actionTool.addManagementCommandSubscriber(this.commandResultsDialog);
        logger.finer(() -> LMG.log("%s Completed setting %s.", () -> loggerPrefix, () -> loggerSuffix));
    }
}

