/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.panels.users;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.beans.JMBean;
import com.jmorgan.beans.util.BeanIndexer;
import com.jmorgan.rules.PropertyValueRule;
import com.jmorgan.swing.menu.JMPopupMenu;
import com.jmorgan.swing.table.BeanColumnModel;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.PropertyValueSelector;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.DataPowerStatusCache;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ManagementCommandStatus;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.actions.ActionDisconnect;
import com.kumbasoft.core.beans.actions.ActionUserForcePasswordChange;
import com.kumbasoft.core.beans.actions.ActionUserResetFailedLogin;
import com.kumbasoft.core.beans.config.ConfigUser;
import com.kumbasoft.core.beans.config.ConfigUserGroup;
import com.kumbasoft.core.beans.status.StatusActiveUsers;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.tools.ActionTool;
import com.kumbasoft.core.tools.DataPowerStatusMonitor;
import com.kumbasoft.core.tools.ModifyProperty;
import com.kumbasoft.core.ui.AbstractCRUDPanel;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.dialog.ChangeUserPasswordDialog;
import com.kumbasoft.core.ui.editors.DPEnumerationTableCellEditor;
import com.kumbasoft.core.ui.editors.UserGroupTableCellEditor;
import com.kumbasoft.core.ui.panels.users.ManageUsersPopupMenu;
import com.kumbasoft.core.util.RegexUtility;
import java.util.ArrayList;
import java.util.Collection;

public class UserManagementPanel
extends AbstractCRUDPanel<ConfigUser> {
    private UserGroupTableCellEditor groupEditor;
    private ArrayList<ConfigUserGroup> userGroups;

    public UserManagementPanel() {
        super(ConfigUser.class);
    }

    @Override
    protected int getMatchPatternLabelWidth() {
        return 130;
    }

    @Override
    protected JMPopupMenu getPopupMenu() {
        return new ManageUsersPopupMenu(this, this.displayTable, this.displayTableScrollPane);
    }

    @Override
    protected boolean isPopupReady() {
        return ((ManageUsersPopupMenu)this.popupMenu).isPopupReady();
    }

    @Override
    protected ConfigUser getNewInstance() {
        return new ConfigUser();
    }

    @Override
    protected boolean canDelete(String configObjectName) {
        return !configObjectName.equals("admin");
    }

    @Override
    protected String getDeleteConfirmationMessage(ArrayList<ConfigUser> selectedConfigs) {
        PropertyValueSelector<ConfigUser> adminSelector = new PropertyValueSelector<ConfigUser>(selectedConfigs);
        adminSelector.addPropertyValueMap("name", "admin");
        String message = adminSelector.getSelectedElements().size() == 0 ? "Delete all selected users?" : "Delete all selected users except 'admin' users?";
        return message;
    }

    @Reflected
    private void forcePasswordChange() {
        ArrayList selectedUsers;
        if (this.continueAction("Force Password Change", "Force a password change for all selected users?") && CollectionUtility.isNotEmpty(selectedUsers = this.getSelectedValues())) {
            this.openResultsDialogAndSetWaitCursor("Force Password Change");
            for (ConfigUser user : selectedUsers) {
                if (user.getName().equals("admin")) {
                    ManagementCommandStatus commandStatus = new ManagementCommandStatus(user.getAppliance(), user.getSourceDomain(), "Force Password Change", null, "Skipping changes for 'admin' user.");
                    this.commandResultsDialog.commandSucceeded(commandStatus);
                    continue;
                }
                ActionUserForcePasswordChange actionInfo = new ActionUserForcePasswordChange();
                actionInfo.setUser(user.getName());
                ActionTool actionTool = new ActionTool(user.getAppliance(), user.getSourceDomain(), actionInfo);
                actionTool.addManagementCommandSubscriber(this.commandResultsDialog);
            }
            this.waitForResultsDialogToCloseAndResetCursor();
        }
    }

    @Reflected
    private void resetFailedLogin() {
        ArrayList selectedUsers;
        if (this.continueAction("Reset Failed Login?", "Reset failed login for all selected users?") && CollectionUtility.isNotEmpty(selectedUsers = this.getSelectedValues())) {
            this.openResultsDialogAndSetWaitCursor("Reset Failed Login");
            for (ConfigUser user : selectedUsers) {
                ActionUserResetFailedLogin actionInfo = new ActionUserResetFailedLogin();
                actionInfo.setUser(user.getName());
                ActionTool actionTool = new ActionTool(user.getAppliance(), user.getSourceDomain(), actionInfo);
                actionTool.addManagementCommandSubscriber(this.commandResultsDialog);
            }
            this.waitForResultsDialogToCloseAndResetCursor();
        }
    }

    @Reflected
    private void changePassword() {
        if (this.continueAction("Change Password?", "Change the password for all selected users?")) {
            Boolean adminPasswordChangeConfirmed = null;
            new ChangeUserPasswordDialog(frame);
            String newPassword = ChangeUserPasswordDialog.getNewPassword();
            if (StringUtility.isEmpty(newPassword)) {
                return;
            }
            ArrayList selectedUsers = this.getSelectedValues();
            if (CollectionUtility.isNotEmpty(selectedUsers)) {
                this.openResultsDialogAndSetWaitCursor("Change Password");
                for (ConfigUser user : selectedUsers) {
                    if (user.getName().equals("admin")) {
                        if (adminPasswordChangeConfirmed == null) {
                            adminPasswordChangeConfirmed = this.continueAction("Change 'admin' password?", "Also change the password for the 'admin' account?");
                        }
                        if (!adminPasswordChangeConfirmed.booleanValue()) {
                            ManagementCommandStatus commandStatus = new ManagementCommandStatus(user.getAppliance(), user.getSourceDomain(), "Change Password", null, "Skipping changes for 'admin' user.");
                            this.commandResultsDialog.commandSucceeded(commandStatus);
                            continue;
                        }
                    }
                    Appliance appliance = user.getAppliance();
                    Domain domain = appliance.getDomain("default");
                    ModifyProperty<String> modifyProperty = new ModifyProperty<String>(appliance, domain, user.getConfigObjectType(), user.getName(), "Password", newPassword);
                    modifyProperty.addManagementCommandSubscriber(this.commandResultsDialog);
                }
            }
            this.waitForResultsDialogToCloseAndResetCursor();
        }
    }

    @Reflected
    private void disconnectUser() {
        ArrayList selectedUsers;
        if (this.continueAction("Disconnect Users", "Do you want to disconnect all selected users?") && CollectionUtility.isNotEmpty(selectedUsers = this.getSelectedValues())) {
            DataPowerStatusCache activeUsersStatus = new DataPowerStatusCache();
            UniqueArrayList<Appliance> selectedAppliances = ApplianceDomainChangeMonitor.getInstance().getCurrentApplianceSelection();
            for (Appliance appliance : selectedAppliances) {
                DataPowerStatusMonitor statusMonitor = new DataPowerStatusMonitor(appliance, appliance.getDomain("default"), "ActiveUsers", 0L);
                statusMonitor.addStatusListener(activeUsersStatus);
            }
            while (!activeUsersStatus.isComplete()) {
                ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
            }
            ArrayList activeUsers = activeUsersStatus.getStatusCache();
            if (CollectionUtility.isEmpty(activeUsers)) {
                return;
            }
            BeanIndexer indexer = new BeanIndexer(activeUsers);
            Index activeUserIndex = indexer.getIndexOf("name", "---xxxxxx---");
            this.openResultsDialogAndSetWaitCursor("Disconnect Users");
            for (ConfigUser user : selectedUsers) {
                String userName = user.getName();
                if (userName.equals("admin")) {
                    ManagementCommandStatus commandStatus = new ManagementCommandStatus(user.getAppliance(), user.getSourceDomain(), "Disconnect User", null, "Not disconnecting 'admin' user.");
                    this.commandResultsDialog.commandSucceeded(commandStatus);
                    continue;
                }
                Appliance appliance = user.getAppliance();
                Collection thisUsersConnections = activeUserIndex.get(userName);
                if (CollectionUtility.isEmpty(thisUsersConnections)) {
                    ManagementCommandStatus commandStatus = new ManagementCommandStatus(user.getAppliance(), user.getSourceDomain(), "Disconnect User", null, user.getName() + " has no active connections.");
                    this.commandResultsDialog.commandSucceeded(commandStatus);
                    continue;
                }
                for (StatusActiveUsers userConnection : thisUsersConnections) {
                    if (!userConnection.getAppliance().equals(appliance)) continue;
                    ActionDisconnect disconnectAction = new ActionDisconnect();
                    disconnectAction.setId(userConnection.getSession());
                    ActionTool actionTool = new ActionTool(appliance, (JMBean)disconnectAction);
                    actionTool.setCommandDescription(String.format("Disconnecting %s", userName));
                    actionTool.addManagementCommandSubscriber(this.commandResultsDialog);
                }
            }
            this.waitForResultsDialogToCloseAndResetCursor();
        }
    }

    @Override
    public void commandSucceeded(ManagementCommandStatus commandStatus) {
        DynamicBean additionalInfo = commandStatus.getAdditionalCommandInfo();
        String applianceName = commandStatus.getAppliance().getName();
        String userName = (String)additionalInfo.getProperty("user");
        int rowCount = this.tableModel.getRowCount();
        int r = rowCount - 1;
        while (r >= 0) {
            ConfigUser user = (ConfigUser)this.tableModel.getValue(r);
            if (user.getAppliance().getName().equals(applianceName) && user.getName().equals(userName)) {
                this.tableModel.deleteRow(r);
            }
            --r;
        }
    }

    @Override
    protected String getSearchSaveConfirmMessage() {
        return "The current user list is about to change,\nbut you made changes to the current list of users.\n\nDo you want to save those changes first?";
    }

    @Override
    @Reflected
    protected void listObjects() {
        AbstractPanel.logger.finer("(): Starting");
        UniqueArrayList<Appliance> appliances = ApplianceDomainChangeMonitor.getInstance().getCurrentApplianceSelection();
        this.userGroups = this.configurationManager.getObjects(appliances, ConfigUserGroup.class, ".*");
        AbstractPanel.logger.finer("(selectedAppliances):  Done Getting all User Groups.");
        this.listUsersByAppliance(appliances);
        AbstractPanel.logger.finer("(): Done");
    }

    @Reflected
    private void listUsersByAppliance(UniqueArrayList<Appliance> selectedAppliances) {
        AbstractPanel.logger.finer("(selectedAppliances): Starting");
        this.groupEditor.setUserGroups(this.userGroups);
        String matchPattern = RegexUtility.normalizeRegex(this.getMatchPattern(), this.useCaseSensitiveSearch);
        AbstractPanel.logger.fine(() -> LMG.log("(selectedAppliances): Searching for users with names matching '%s'", () -> matchPattern));
        ArrayList<ConfigUser> users = this.configurationManager.getObjects(selectedAppliances, ConfigUser.class, matchPattern);
        AbstractPanel.logger.fine(() -> LMG.log("(selectedAppliances): Found %d users with names matching '%s'", () -> users.size(), () -> matchPattern));
        for (ConfigUser user : users) {
            if (user == null) continue;
            String userName = user.getName();
            if (userName.equals("admin")) {
                AbstractPanel.logger.finer("(selectedAppliances): Ensuring 'admin' user is read only");
                user.setIsReadOnly(true);
            }
            if (!userName.matches(matchPattern)) continue;
            this.addRow(user);
        }
        this.resetUI();
        this.displayTable.optimizeColumnWidths();
        this.dirty = false;
        AbstractPanel.logger.finer("(selectedAppliances): Done");
    }

    @Override
    protected String getTFPatternLabel() {
        return "User Name Pattern:";
    }

    @Override
    protected boolean isForAppliancesOnly() {
        return true;
    }

    @Override
    public BeanTableModel<ConfigUser> getTableModel() {
        AbstractPanel.logger.finer("(): Starting");
        BeanTableModel<ConfigUser> tableModel = super.getTableModel();
        tableModel.setValueExpression("groupName", "name");
        tableModel.setEditableColumns("adminState", "name", "password", "accessLevel", "groupName", "userSummary");
        PropertyValueRule adminRule = new PropertyValueRule();
        adminRule.addPropertyValueMap("name", (Object)"admin", 1);
        tableModel.addRowEditabilityRule(adminRule);
        PropertyValueRule passwordRule = new PropertyValueRule();
        passwordRule.addPropertyValueMap("status.configState", (Object)"new", 1);
        tableModel.addCellEditabilityRule("password", passwordRule);
        tableModel.addCellEditabilityRule("name", passwordRule);
        tableModel.addTableModelListener(this);
        AbstractPanel.logger.finer("(): Done");
        return tableModel;
    }

    @Override
    protected BeanColumnModel<ConfigUser> getColumnModel() {
        AbstractPanel.logger.finer("(): Starting");
        BeanColumnModel<ConfigUser> columnModel = super.getColumnModel();
        columnModel.setColumnOrder("appliance", "name", "adminState", "password", "accessLevel", "groupName", "isIntrinsic", "isReadOnly", "userSummary");
        columnModel.setColumnTitle("userSummary", "Comments");
        columnModel.hideColumns("sourceDomain", "configObjectType", "hashedPassword", "hashedSnmpCreds", "userDomain", "isExternal", "isLocal", "quiesceState", "snmpCreds", "suppressPasswordChange", "status", "fQON");
        DPEnumerationTableCellEditor adminStateEditor = new DPEnumerationTableCellEditor("ADMIN_STATE");
        columnModel.setEditor("adminState", adminStateEditor);
        DPEnumerationTableCellEditor accessLevelEditor = new DPEnumerationTableCellEditor("USER_ACCESS");
        columnModel.setEditor("accessLevel", accessLevelEditor);
        this.groupEditor = new UserGroupTableCellEditor();
        columnModel.setEditor("groupName", this.groupEditor);
        AbstractPanel.logger.finer("(): Done");
        return columnModel;
    }

    @Override
    protected void synchronizeChanges(ConfigUser editedUser, int row, ConfigUser user, String columnName) {
        String userName = user.getName();
        if (userName.equals("admin")) {
            return;
        }
        String editedStatus = editedUser.getStatus().getConfigState();
        String editAdminState = editedUser.getAdminState();
        String editAccessLevel = editedUser.getAccessLevel();
        ObjectReference<ConfigUserGroup> groupReference = editedUser.getGroupName();
        String editGroupName = groupReference == null ? null : groupReference.getName();
        String editComments = editedUser.getUserSummary();
        if (editedStatus.equals("new") && columnName.equals("name") && user.getStatus().getConfigState().equals("new") || userName.equals(editedUser.getName())) {
            user.setAdminState(editAdminState);
            user.setName(editedUser.getName());
            user.setPassword(editedUser.getPassword());
            user.setAccessLevel(editAccessLevel);
            if (editGroupName != null) {
                ObjectReference<ConfigUserGroup> userGroup = user.getGroupName();
                if (userGroup == null) {
                    user.setGroupName(groupReference);
                } else {
                    userGroup.setName(editGroupName);
                }
            }
            user.setUserSummary(editComments);
            user.getStatus().setConfigState(editedUser.getStatus().getConfigState());
        }
    }

    @Override
    protected void resolveColumnChanges(ConfigUser editedUser, String columnName) {
        if (columnName.equals("groupName")) {
            editedUser.setAccessLevel(DPEnumerations.USER_ACCESS[2]);
        }
        if (columnName.equals("accessLevel") && editedUser.getAccessLevel() != null && editedUser.getAccessLevel().equals("privileged")) {
            editedUser.setGroupName(null);
        }
    }
}

