/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.renderers;

import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.util.collection.CollectionUtility;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ApplianceGroupObject;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.renderers.AbstractListCellValueRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class ApplianceGroupListCellValueRenderer
extends AbstractListCellValueRenderer {
    private JMLabel applianceName = new JMLabel();
    private JMLabel quiescedIcon = new JMLabel(KumbaCoreUIConstants.SLEEP_ICON);
    private JMLabel diagModeIcon = new JMLabel(KumbaCoreUIConstants.DIAGNOSIS_ICON);
    private JMLabel disConnectedIcon = new JMLabel(KumbaCoreUIConstants.CONNECT_ICON);
    private JLabel failsafeIcon = new JLabel(KumbaCoreUIConstants.FAILSAFE_ICON);
    private JLabel interfaceStateIcon = new JLabel(KumbaCoreUIConstants.MANAGEMENT_TRAFFIC_ONLY_ICON);
    private JLabel quarantineIcon = new JLabel(KumbaCoreUIConstants.QUARANTINE_ICON);
    private JMLabel categoryCountLabel = new JMLabel("");
    private JMPanel iconPanel = new JMPanel(new FlowLayout(2, 2, 0));

    public ApplianceGroupListCellValueRenderer() {
        this.iconPanel.setOpaque(true);
        this.iconPanel.addAll(this.quiescedIcon, this.diagModeIcon, this.disConnectedIcon, this.categoryCountLabel, this.failsafeIcon, this.interfaceStateIcon, this.quarantineIcon);
        this.add((Component)this.applianceName, "Center");
        this.add((Component)this.iconPanel, "East");
    }

    @Override
    public void renderValueToComponent(Object value, boolean isSelected) {
        this.disConnectedIcon.setVisible(false);
        this.quiescedIcon.setVisible(false);
        this.diagModeIcon.setVisible(false);
        this.failsafeIcon.setVisible(false);
        this.interfaceStateIcon.setVisible(false);
        this.quarantineIcon.setVisible(false);
        this.categoryCountLabel.setVisible(false);
        ApplianceGroupObject applianceGroup = (ApplianceGroupObject)value;
        this.applianceName.setText(applianceGroup.getGroupName());
        this.applianceName.setFont(UIManager.getFont("Label.font"));
        double connectedPct = applianceGroup.getPercentOfAppliancesConnected();
        Color foreground = KumbaCoreUIConstants.LIST_UNSELECTED_FOREGROUND;
        Color background = KumbaCoreUIConstants.LIST_UNSELECTED_BACKGROUND;
        if (connectedPct == 0.0) {
            foreground = KumbaCoreUIConstants.APPLIANCE_UNCONNECTED_FOREGROUND;
            background = KumbaCoreUIConstants.APPLIANCE_UNCONNECTED_BACKGROUND;
        } else if (connectedPct < 1.0) {
            foreground = KumbaCoreUIConstants.APPLIANCE_GROUP_PARTIALLY_CONNECTED_FOREGROUND;
            background = KumbaCoreUIConstants.APPLIANCE_GROUP_PARTIALLY_CONNECTED_BACKGROUND;
        }
        if (isSelected) {
            foreground = KumbaCoreUIConstants.LIST_SELECTED_FOREGROUND;
            background = KumbaCoreUIConstants.LIST_SELECTED_BACKGROUND;
        }
        this.applianceName.setForeground(foreground);
        this.setBackground(background);
        this.iconPanel.setBackground(background);
        if (applianceGroup.isCreatedFromCategory()) {
            int totalAppliances = applianceGroup.getAppliances().size();
            int connectedAppliances = applianceGroup.getAppliancesConnected().size();
            this.categoryCountLabel.setText(String.format("%d/%d", connectedAppliances, totalAppliances));
            this.categoryCountLabel.setFont(UIManager.getFont("Label.font"));
            this.categoryCountLabel.setForeground(foreground);
            this.categoryCountLabel.setBackground(background);
            this.categoryCountLabel.setVisible(true);
            this.iconPanel.setVisible(true);
            return;
        }
        ArrayList<Appliance> appliances = applianceGroup.getAppliances();
        if (CollectionUtility.isEmpty(appliances) || appliances.size() > 1) {
            return;
        }
        Appliance appliance = appliances.get(0);
        boolean isConnected = appliance.isConnected();
        boolean isQuiesced = appliance.isQuiesced();
        boolean isInDiagMode = appliance.isInDiagnosticMode();
        boolean isInFailsafeMode = appliance.isInFailsafeMode();
        boolean isInterfaceLinkError = appliance.hasInterfaceLinkError();
        boolean isQuarantined = appliance.isQuarantined();
        this.quiescedIcon.setVisible(isQuiesced);
        if (isQuiesced) {
            this.quiescedIcon.setBackground(background);
        }
        this.disConnectedIcon.setVisible(!isConnected);
        if (!isConnected) {
            this.disConnectedIcon.setBackground(background);
        }
        this.diagModeIcon.setVisible(isInDiagMode);
        if (isInDiagMode) {
            this.diagModeIcon.setBackground(background);
        }
        this.failsafeIcon.setVisible(isInFailsafeMode);
        if (isInFailsafeMode) {
            this.failsafeIcon.setBackground(background);
        }
        this.interfaceStateIcon.setVisible(isInterfaceLinkError);
        if (isInterfaceLinkError) {
            this.interfaceStateIcon.setBackground(background);
        }
        this.quarantineIcon.setVisible(isQuarantined);
        if (isQuarantined) {
            this.quarantineIcon.setBackground(background);
        }
        this.iconPanel.setVisible(!isConnected || isQuiesced || isInDiagMode || isInFailsafeMode || isInterfaceLinkError || isQuarantined);
    }
}

