/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.renderers;

import com.jmorgan.beans.util.BeanService;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.DomainGroup;
import com.kumbasoft.core.beans.status.StatusDomainStatus;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.renderers.AbstractListCellValueRenderer;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class DomainListCellValueRenderer
extends AbstractListCellValueRenderer {
    private JLabel domainName = new JLabel();
    private JLabel debugIcon = new JLabel(KumbaCoreUIConstants.DEBUG_ICON);
    private JLabel diagIcon = new JLabel(KumbaCoreUIConstants.DIAGNOSIS_ICON);
    private JLabel probeIcon = new JLabel(KumbaCoreUIConstants.PROBE_ICON);
    private JLabel quiesceIcon = new JLabel(KumbaCoreUIConstants.SLEEP_ICON);
    private JLabel disabledIcon = new JLabel(KumbaCoreUIConstants.STOP_ICON);
    private JLabel dirtyIcon = new JLabel(KumbaCoreUIConstants.DIRTY_ICON);
    private JLabel traceIcon = new JLabel(KumbaCoreUIConstants.TRACE_ICON);
    private JLabel runningCommandIcon = new JLabel(KumbaCoreUIConstants.RUN_ICON);
    private JLabel failsafeIcon = new JLabel(KumbaCoreUIConstants.FAILSAFE_ICON);
    private JLabel interfaceStateIcon = new JLabel(KumbaCoreUIConstants.MANAGEMENT_TRAFFIC_ONLY_ICON);
    private JLabel quarantineIcon = new JLabel(KumbaCoreUIConstants.QUARANTINE_ICON);
    private JMPanel iconPanel = new JMPanel(new FlowLayout(2, 2, 0));
    private Index<String, Domain> domainsInScope;

    public DomainListCellValueRenderer() {
        this.iconPanel.setOpaque(true);
        this.iconPanel.addAll(this.dirtyIcon, this.debugIcon, this.probeIcon, this.quiesceIcon, this.disabledIcon, this.diagIcon, this.traceIcon, this.runningCommandIcon, this.failsafeIcon, this.interfaceStateIcon, this.quarantineIcon);
        this.add((Component)this.domainName, "Center");
        this.add((Component)this.iconPanel, "East");
    }

    public void setDomainsInScope(Index<String, Domain> domainsInScope) {
        this.domainsInScope = domainsInScope;
    }

    @Override
    public void renderValueToComponent(Object value, boolean isSelected) {
        this.domainName.setFont(UIManager.getFont("Label.font"));
        if (value == null) {
            this.domainName.setText("");
            return;
        }
        if (isSelected) {
            this.domainName.setForeground(KumbaCoreUIConstants.LIST_SELECTED_FOREGROUND);
            this.setBackground(KumbaCoreUIConstants.LIST_SELECTED_BACKGROUND);
        } else {
            this.domainName.setForeground(KumbaCoreUIConstants.LIST_UNSELECTED_FOREGROUND);
            this.setBackground(KumbaCoreUIConstants.LIST_UNSELECTED_BACKGROUND);
        }
        DomainGroup domainGroup = (DomainGroup)value;
        this.domainName.setText(domainGroup.getGroupName());
        ArrayList<Domain> domains = domainGroup.getDomains();
        int domainCount = domains.size();
        if (domainCount == 0 || domainCount > 1) {
            this.iconPanel.setVisible(false);
            return;
        }
        Domain domain = domains.get(0);
        StatusDomainStatus domainStatus = domain.getStatusDomainStatus();
        if (domainStatus == null) {
            return;
        }
        String domainName = domain.getName();
        ArrayList domainGroups = (ArrayList)this.domainsInScope.get(domainName);
        if (CollectionUtility.isEmpty(domainGroups)) {
            return;
        }
        this.debugIcon.setVisible(DomainListCellValueRenderer.isAnyStatusEqual(domainGroups, "debugEnabled", "on"));
        DomainListCellValueRenderer.setIconBackground(this.debugIcon, isSelected);
        this.diagIcon.setVisible(DomainListCellValueRenderer.isAnyStatusEqual(domainGroups, "diagEnabled", "on"));
        DomainListCellValueRenderer.setIconBackground(this.diagIcon, isSelected);
        this.probeIcon.setVisible(DomainListCellValueRenderer.isAnyStatusEqual(domainGroups, "probeEnabled", "on"));
        DomainListCellValueRenderer.setIconBackground(this.probeIcon, isSelected);
        this.quiesceIcon.setVisible(DomainListCellValueRenderer.isAnyStatusEqual(domainGroups, "quiesceState", "quiesced"));
        DomainListCellValueRenderer.setIconBackground(this.quiesceIcon, isSelected);
        this.disabledIcon.setVisible(DomainListCellValueRenderer.isAnyDomainDisabled(domainGroups));
        DomainListCellValueRenderer.setIconBackground(this.disabledIcon, isSelected);
        this.dirtyIcon.setVisible(DomainListCellValueRenderer.isAnyStatusEqual(domainGroups, "saveNeeded", "on"));
        DomainListCellValueRenderer.setIconBackground(this.dirtyIcon, isSelected);
        this.traceIcon.setVisible(DomainListCellValueRenderer.isAnyStatusEqual(domainGroups, "traceEnabled", "on"));
        DomainListCellValueRenderer.setIconBackground(this.traceIcon, isSelected);
        this.runningCommandIcon.setVisible(DomainListCellValueRenderer.isAnyDomainRunningACommand(domainGroups));
        DomainListCellValueRenderer.setIconBackground(this.runningCommandIcon, isSelected);
        this.failsafeIcon.setVisible(DomainListCellValueRenderer.isAnyStatusEqual(domainGroups, "failsafeMode", "management"));
        DomainListCellValueRenderer.setIconBackground(this.failsafeIcon, isSelected);
        this.interfaceStateIcon.setVisible(DomainListCellValueRenderer.isAnyStatusEqual(domainGroups, "interfaceState", "linkErrors"));
        DomainListCellValueRenderer.setIconBackground(this.interfaceStateIcon, isSelected);
        this.quarantineIcon.setVisible(DomainListCellValueRenderer.isAnyStatusEqual(domainGroups, "quarantineEnabled", "on"));
        DomainListCellValueRenderer.setIconBackground(this.quarantineIcon, isSelected);
        this.iconPanel.setBackground(isSelected ? KumbaCoreUIConstants.LIST_SELECTED_BACKGROUND : KumbaCoreUIConstants.LIST_UNSELECTED_BACKGROUND);
        this.iconPanel.setVisible(true);
    }

    private static boolean isAnyStatusEqual(ArrayList<Domain> domains, String propertyName, String propertyValue) {
        boolean anyEqual = false;
        for (Domain domain : domains) {
            String value;
            StatusDomainStatus domainStatus = domain.getStatusDomainStatus();
            if (domainStatus == null || (value = (String)BeanService.getPropertyValue(domainStatus, propertyName)) == null || !value.equals(propertyValue)) continue;
            anyEqual = true;
            break;
        }
        return anyEqual;
    }

    private static boolean isAnyDomainDisabled(ArrayList<Domain> domains) {
        boolean anyDisabled = false;
        for (Domain domain : domains) {
            StatusObjectStatus domainObjectStatus = domain.getObjectStatus();
            if (domainObjectStatus == null || !domainObjectStatus.getAdminState().equals("disabled")) continue;
            anyDisabled = true;
            break;
        }
        return anyDisabled;
    }

    private static boolean isAnyDomainRunningACommand(ArrayList<Domain> domains) {
        boolean anyRunningCurrentCommand = false;
        for (Domain domain : domains) {
            StatusDomainStatus domainStatus = domain.getStatusDomainStatus();
            if (domainStatus == null || !StringUtility.isNotEmpty(domainStatus.getCurrentCommand())) continue;
            anyRunningCurrentCommand = true;
            break;
        }
        return anyRunningCurrentCommand;
    }

    private static void setIconBackground(JLabel icon, boolean isSelected) {
        if (icon.isVisible()) {
            if (isSelected) {
                icon.setBackground(KumbaCoreUIConstants.LIST_SELECTED_BACKGROUND);
            } else {
                icon.setBackground(KumbaCoreUIConstants.LIST_UNSELECTED_BACKGROUND);
            }
        }
    }
}

