/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;

public class CertificateReader {
    private File certificateFile;

    public CertificateReader() {
    }

    public CertificateReader(String fileName) {
        this(new File(fileName));
    }

    public CertificateReader(File certFile) {
        this.setCertificateFile(certFile);
    }

    public Certificate readCertificate(String fileName) {
        return this.readCertificate(new File(fileName));
    }

    public Certificate readCertificate(File file) {
        this.setCertificateFile(file);
        return this.readCertificate();
    }

    public Certificate readCertificate() {
        if (this.certificateFile == null) {
            throw new IllegalStateException("Certificate file not set");
        }
        if (!this.certificateFile.exists()) {
            throw new IllegalStateException("Certificate file does not exist");
        }
        try {
            FileInputStream fin = new FileInputStream(this.certificateFile);
            int bufferSize = (int)this.certificateFile.length();
            if (bufferSize < 16384) {
                bufferSize = 16384;
            }
            BufferedInputStream bin = new BufferedInputStream(fin, bufferSize);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            if (bin.available() > 0) {
                Certificate certificate = cf.generateCertificate(bin);
                return certificate;
            }
            bin.close();
        }
        catch (IOException | CertificateException e) {
            e.printStackTrace();
        }
        return null;
    }

    public File getCertificateFile() {
        return this.certificateFile;
    }

    public void setCertificateFile(String fileName) {
        this.setCertificateFile(new File(fileName));
    }

    public void setCertificateFile(File certificateFile) {
        this.certificateFile = certificateFile;
    }
}

