/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.util;

import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.ThreadUtility;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigObjectCache;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.tools.ListFiles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;

public final class DataPowerFileUtility {
    public static final String[] DEFAULT_DOMAIN_FILESTORES = new String[]{"pubcert:", "sharedcert:", "store:", "image:", "tasktemplates:"};
    public static final String[] FILESTORE_EXCLUSIONS = new String[]{"policyframework:"};
    public static final String[] CRYPTO_FILESTORES = new String[]{"cert:", "isamcert:", "sharedcert:", "pubcert:"};
    public static final String[] NORMAL_FILE_FILESTORES = new String[]{"local:", "store:", "temporary:"};
    public static final String VALID_FILE_NAME_CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_-.";
    public static final String[] SECURE_BACKUP_FILES = new String[]{"backupmanifest.xml", "cert.tgz", "chkpoints.tgz", "config.tgz", "local.tgz", "password-map.tgz", "root.tgz", "sharedcert.tgz", "store.tgz", "raid-volume.tgz"};

    private DataPowerFileUtility() {
    }

    public static ArrayList<String> getDomainFiles(Appliance appliance, Domain domain) {
        ConfigObjectCache<DataPowerFileInfo> fileCache = new ConfigObjectCache<DataPowerFileInfo>();
        DataPowerFileUtility.loadDomainFiles(appliance, appliance.getDomain("default"), "store:", fileCache);
        DataPowerFileUtility.loadDomainFiles(appliance, appliance.getDomain("default"), "pubcert:", fileCache);
        DataPowerFileUtility.loadDomainFiles(appliance, appliance.getDomain("default"), "sharedcert:", fileCache);
        DataPowerFileUtility.loadDomainFiles(appliance, domain, "local:", fileCache);
        DataPowerFileUtility.loadDomainFiles(appliance, domain, "cert:", fileCache);
        DataPowerFileUtility.loadDomainFiles(appliance, domain, "temporary:", fileCache);
        Vector<DataPowerFileInfo> files = fileCache.getObjectCache();
        ArrayList<String> fileNames = new ArrayList<String>(files.size());
        for (DataPowerFileInfo file : files) {
            String fileName = file.getAbsolutePath();
            fileNames.add(fileName);
        }
        Collections.sort(fileNames);
        return fileNames;
    }

    public static final void loadDomainFiles(Appliance appliance, Domain domain, String fileStore, ConfigObjectCache<DataPowerFileInfo> fileCache) {
        SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
        ListFiles listFiles = new ListFiles(appliance, domain, fileStore, null);
        listFiles.addConfigObjectSubscriber(DataPowerFileInfo.class, fileCache);
        listFiles.getProcessThread().addInvocationListener(stil);
        while (!stil.invocationComplete()) {
            ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
        }
    }

    public static final boolean isFileNameValid(String fileName) {
        if (fileName.length() > 128) {
            return false;
        }
        if (fileName.startsWith(" ") || fileName.endsWith(" ")) {
            return false;
        }
        if (fileName.contains("..")) {
            return false;
        }
        String ucaseFileName = fileName.toUpperCase();
        String validFileName = StringUtility.removeAllExcept(ucaseFileName, VALID_FILE_NAME_CHARACTERS);
        return validFileName.equals(ucaseFileName);
    }
}

