/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.util;

import com.jmorgan.io.ASCFileReader;
import com.jmorgan.io.ASCFileWriter;
import com.jmorgan.j2ee.xml.XMLAttribute;
import com.jmorgan.j2ee.xml.XMLElement;
import com.jmorgan.j2ee.xml.XMLParser;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.Index;
import com.jmorgan.util.NumberUtility;
import com.jmorgan.util.Pair;
import com.jmorgan.util.StringIndexer;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.kumbasoft.core.beans.DataPowerXMLClassInfo;
import com.kumbasoft.core.beans.DataPowerXMLPropertyInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.w3c.dom.Node;

public final class DataPowerXMLMgmtProcessor {
    private static final String[] CONFIG_ATTRIBUTES = new String[]{"name", "isLocal", "isIntrinsic", "isRead-only", "isExternal"};
    public static boolean printDebugStatements = false;
    private String dpWSDLFileName;
    private File dpWSDLFile;
    private File workingParentDirectory;
    private File xmlMgmtWorkingFile;
    private HashMap<String, DataPowerXMLClassInfo> classIndex;
    private HashMap<String, Integer> propertyCountIndex;
    private Index<String, String> enumerationIndex;
    private HashMap<String, String> typeMap;

    public DataPowerXMLMgmtProcessor(String fileName) {
        this(new File(fileName));
    }

    public DataPowerXMLMgmtProcessor(File file) {
        this.dpWSDLFileName = file.getAbsolutePath();
        this.dpWSDLFile = file;
        if (!this.dpWSDLFile.exists()) {
            String message = String.format("(String fileName=\"%s\"):  Error - File does not exist.  Please provide the xml-mgmt.wsdl file name.", this.dpWSDLFileName);
            throw new IllegalArgumentException(message, new InstantiationException(message));
        }
        if (this.dpWSDLFile.isDirectory()) {
            String message = String.format("(String fileName=\"%s\"):  Error - File is a directory.  Please provide the xml-mgmt.wsdl file name.", this.dpWSDLFileName);
            throw new IllegalArgumentException(message, new InstantiationException(message));
        }
        this.typeMap = new HashMap();
        this.workingParentDirectory = this.dpWSDLFile.getParentFile();
        String combinedFileName = "combined-" + this.dpWSDLFile.getName();
        File combinedFile = this.createCombinedFile(combinedFileName);
        this.processDataPowerXMLMgmt(combinedFile);
    }

    private File createCombinedFile(String combineFileName) {
        ArrayList<String> combinedFileData = new ArrayList<String>();
        this.preProcessFile(this.dpWSDLFile, combinedFileData, false);
        try {
            File combinedFile = new File(this.workingParentDirectory, combineFileName);
            new ASCFileWriter(combinedFile, combinedFileData);
            return combinedFile;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void preProcessFile(File file, ArrayList<String> newData, boolean stripRoot) {
        if (printDebugStatements) {
            System.out.printf("Processing %s\n", file.getName());
        }
        boolean rootFound = false;
        boolean insideRoot = false;
        String includeFileName = null;
        Collection<String> data = DataPowerXMLMgmtProcessor.readFileData(file);
        for (String line : data) {
            if (line.contains("<xsd:include")) {
                int equals = line.indexOf(61);
                int firstQuote = line.indexOf(34, equals) + 1;
                int secondQuote = line.indexOf(34, firstQuote);
                includeFileName = line.substring(firstQuote, secondQuote);
                File includeFile = new File(this.workingParentDirectory, includeFileName);
                newData.add("\n\t<!-- Beginning Include Of " + includeFileName + " -->\n");
                this.preProcessFile(includeFile, newData, true);
                continue;
            }
            if (stripRoot) {
                if (line.contains("<xsd:schema")) {
                    rootFound = true;
                    insideRoot = true;
                    continue;
                }
                if (!rootFound) continue;
                if (insideRoot) {
                    if (!line.endsWith(">")) continue;
                    insideRoot = false;
                    continue;
                }
                if (line.contains("</xsd:schema>")) {
                    if (includeFileName == null) continue;
                    newData.add("\n\t<!-- End Include Of " + includeFileName + " -->\n");
                    continue;
                }
                newData.add(line);
                continue;
            }
            newData.add(line);
        }
    }

    private static Collection<String> readFileData(File file) {
        try {
            ASCFileReader fr = new ASCFileReader(file);
            Collection<String> data = fr.getData();
            return data;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void processDataPowerXMLMgmt(File combinedFileName) {
        if (printDebugStatements) {
            System.out.printf("DataPowerXMLMgmtProcessor.parseAndMap(String combinedFileName=%s)\n", combinedFileName);
        }
        try {
            FileReader fr = new FileReader(combinedFileName);
            if (printDebugStatements) {
                System.out.printf("DataPowerXMLMgmtProcessor.parseAndMap(String combinedFileName=%s) Parsing\n", combinedFileName);
            }
            XMLParser xmlParser = new XMLParser(fr);
            Node rootNode = xmlParser.getRootNode();
            XMLElement rootElement = new XMLElement(rootNode);
            DataPowerXMLMgmtProcessor.removeCommentNodes(rootElement);
            this.refactorAttributeGroups(rootElement);
            this.resolveAttributeTypes(rootElement);
            this.mapEnumerations(rootElement);
            this.resolveUnions(rootElement);
            DataPowerXMLMgmtProcessor.resolveElementGroups(rootElement);
            this.resolveSimpleTypes(rootElement);
            DataPowerXMLMgmtProcessor.resolveReferences(rootElement);
            this.resolveRestrictionTypes(rootElement);
            this.resolveElementTypes(rootElement);
            this.resolveExtensions(rootElement);
            Collection<XMLElement> schemaNodes = rootElement.getNodes("//xsd.schema");
            if (printDebugStatements) {
                System.out.printf("DataPowerXMLMgmtProcessor.parseAndMap(combinedFileName) Mapping Types.  %d elements\n", schemaNodes.size());
            }
            for (XMLElement schemaNode : schemaNodes) {
                this.mapTypes(schemaNode);
            }
            this.mapPropertiesToTypes(rootElement);
            this.writeWorkingWSDL(rootElement);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private static void removeCommentNodes(XMLElement rootElement) {
        Collection<XMLElement> commentNodes = rootElement.getNodes("//#comment");
        if (printDebugStatements) {
            System.out.printf("DataPowerXMLMgmtProcessor.removeCommentNodes(rootElement):  %d nodes.\n", commentNodes.size());
        }
        for (XMLElement commentNode : commentNodes) {
            XMLElement parentNode = commentNode.getParentNode();
            parentNode.removeNode(commentNode);
        }
    }

    private void refactorAttributeGroups(XMLElement rootElement) {
        XMLElement parentNode;
        Index<String, Pair<String, String>> attributeGroupIndex = new Index<String, Pair<String, String>>();
        ArrayList<XMLElement> refGroups = new ArrayList<XMLElement>();
        Collection<XMLElement> attributeGroups = rootElement.getNodes("//xsd.attributeGroup");
        if (printDebugStatements) {
            System.out.printf("DataPowerXMLMgmtProcessor.mapAttributeGroups(rootElement):  %d nodes.\n", attributeGroups.size());
        }
        for (XMLElement attributeGroup : attributeGroups) {
            String groupName = attributeGroup.getAttributeValue("name");
            if (groupName == null) {
                refGroups.add(attributeGroup);
                continue;
            }
            Collection<XMLElement> attributes = attributeGroup.getNodes("//xsd.attribute");
            for (XMLElement attribute : attributes) {
                String attributeName = attribute.getAttributeValue("name");
                String attributeType = attribute.getAttributeValue("type");
                String javaType = this.getJavaType(attributeType);
                attributeGroupIndex.put(groupName, new Pair<String, String>(attributeName, javaType));
            }
            parentNode = attributeGroup.getParentNode();
            parentNode.removeNode(attributeGroup);
        }
        for (XMLElement attributeGroup : refGroups) {
            String refName = attributeGroup.getAttributeValue("ref");
            if (refName.startsWith("tns:")) {
                refName = refName.substring(4);
            }
            Collection referencedGroup = attributeGroupIndex.get(refName);
            parentNode = attributeGroup.getParentNode();
            parentNode.removeNode(attributeGroup);
            for (Pair newAttribute : referencedGroup) {
                XMLElement attributeNode = new XMLElement("xsd:attribute");
                Object attributeName = (String)newAttribute.first;
                if (((String)newAttribute.second).equals("boolean")) {
                    attributeName = "is" + ((String)attributeName).toUpperCase().charAt(0) + ((String)attributeName).substring(1);
                }
                attributeNode.addAttribute("name", (String)attributeName);
                attributeNode.addAttribute("type", (String)newAttribute.second);
                parentNode.addNode(attributeNode);
            }
        }
    }

    private void resolveAttributeTypes(XMLElement rootElement) {
        Collection<XMLElement> attributes = rootElement.getNodes("//xsd.attribute");
        if (printDebugStatements) {
            System.out.printf("DataPowerXMLMgmtProcessor.resolveAttributeTypes(rootElement): %d attribute nodes.\n", attributes.size());
        }
        for (XMLElement attribute : attributes) {
            String attributeType = attribute.getAttributeValue("type");
            if (attributeType == null) {
                attributeType = "xsd:string";
            }
            attributeType = attributeType.replaceAll("tns:", "");
            String javaType = this.getJavaType(attributeType);
            attribute.addAttribute("javaType", javaType);
        }
    }

    private void mapEnumerations(XMLElement rootElement) {
        this.enumerationIndex = new Index();
        Collection<XMLElement> enumeratedNodes = rootElement.getNodes("//xsd.enumeration");
        if (printDebugStatements) {
            System.out.printf("DataPowerXMLMgmtProcessor.mapEnumerations(rootElement):  %d enumerated nodes.\n", enumeratedNodes.size());
        }
        XMLElement restrictionElement = null;
        String enumerationType = null;
        XMLElement enumerationEncloser = null;
        String enumerationName = null;
        for (XMLElement enumeratedNode : enumeratedNodes) {
            if (restrictionElement != null && enumeratedNode.getParentNode() != restrictionElement) {
                restrictionElement = null;
                enumerationType = null;
                enumerationEncloser = null;
                enumerationName = null;
            }
            if (restrictionElement == null) {
                restrictionElement = enumeratedNode.getParentNode();
                enumerationType = restrictionElement.getAttributeValue("base");
                if (!enumerationType.equals("xsd:string") && printDebugStatements) {
                    System.out.printf("***** WARNING:  DataPowerXMLMgmtProcessor.mapEnumerations(rootElement):  Enumeration Base is NOT xsd:string, but instead %s\n", enumerationType);
                }
                if ((enumerationName = (enumerationEncloser = restrictionElement.getParentNode()).getAttributeValue("name")) == null) {
                    enumerationName = (enumerationEncloser = enumerationEncloser.getParentNode()).getAttributeValue("name");
                    if (enumerationName == null) continue;
                    enumerationEncloser.addAttribute("isEnumeration", "true");
                }
            }
            String value = enumeratedNode.getAttributeValue("value");
            this.enumerationIndex.put(enumerationName, value);
        }
        ArrayList<XMLElement> removedNodes = new ArrayList<XMLElement>();
        for (XMLElement enumeratedNode : enumeratedNodes) {
            XMLElement nextParent;
            XMLElement restriction = enumeratedNode.getParentNode();
            XMLElement enumerationTypeNode = restriction.getParentNode();
            String enumerationTypeNodeName = enumerationTypeNode.getAttributeValue("name");
            if (enumerationTypeNodeName == null && !(nextParent = enumerationTypeNode.getParentNode()).getName().equals("xsd:attribute") || removedNodes.contains(enumerationTypeNode)) continue;
            XMLElement enumerationParentNode = enumerationTypeNode.getParentNode();
            removedNodes.add(enumerationTypeNode);
            enumerationParentNode.removeNode(enumerationTypeNode);
        }
    }

    private void resolveUnions(XMLElement rootElement) {
        Collection<XMLElement> unionNodes = rootElement.getNodes("//xsd.union");
        if (printDebugStatements) {
            System.out.printf("DataPowerXMLMgmtProcessor.resolveUnions(rootElement):  %d union nodes\n", unionNodes.size());
        }
        for (XMLElement unionNode : unionNodes) {
            String typeName = this.getUnionType(unionNode);
            XMLElement unionParent = unionNode.getParentNode();
            String parentName = unionParent.getAttributeValue("name");
            if (parentName == null) {
                XMLElement unionEncloser = unionParent.getParentNode();
                unionEncloser.addAttribute("type", typeName);
                unionEncloser.removeNode(unionParent);
                continue;
            }
            unionParent.addAttribute("type", typeName);
            unionParent.removeNode(unionNode);
        }
    }

    private String getUnionType(XMLElement unionNode) {
        String memberTypes = unionNode.getAttributeValue("memberTypes");
        String memberType = (memberTypes = memberTypes.replaceAll("tns:dmEmptyElement", "").trim()).replace("tns:", "");
        if (memberType.indexOf(32) >= 0 && printDebugStatements) {
            System.out.printf("DataPowerXMLMgmtProcessor.getUnionType(unionNode):  Union has more than one non empty element type.\n%s\n", memberType);
        }
        String typeName = memberType;
        return typeName;
    }

    private static void resolveElementGroups(XMLElement rootElement) {
        Collection<XMLElement> groupNodes = rootElement.getNodes("//xsd.group");
        if (printDebugStatements) {
            System.out.printf("DataPowerXMLMgmtProcessor.resolveElementGroups(rootElement):  %d group nodes\n", groupNodes.size());
        }
        for (XMLElement groupNode : groupNodes) {
            String groupName = groupNode.getAttributeValue("name");
            if (groupName != null) {
                groupNode.setName("xsd:complexType");
                String groupClass = DataPowerXMLMgmtProcessor.getJavaClassName(groupName);
                groupNode.addAttribute("type", groupClass);
                continue;
            }
            String refNode = groupNode.getAttributeValue("ref");
            if (refNode.startsWith("tns:")) {
                refNode = refNode.substring(4);
            }
            String groupClass = DataPowerXMLMgmtProcessor.getJavaClassName(refNode);
            XMLElement parent = groupNode.getParentNode();
            if (parent.getName().equals("xsd:choice")) {
                groupNode.setName("xsd:element");
                groupNode.removeAttribute("ref");
                groupNode.addAttribute("type", groupClass);
                groupNode.addAttribute("name", groupClass);
                continue;
            }
            parent = parent.getParentNode();
            parent.addAttribute("type", groupClass);
        }
    }

    private void resolveSimpleTypes(XMLElement rootElement) {
        Collection<XMLElement> simpleTypeNodes = rootElement.getNodes("//xsd.simpleType");
        if (printDebugStatements) {
            System.out.printf("DataPowerXMLMgmtProcessor.resolveSimpleTypes(rootElement): %d simpleType Nodes\n", simpleTypeNodes.size());
        }
        for (XMLElement simpleTypeNode : simpleTypeNodes) {
            String typeNodeName = simpleTypeNode.getAttributeValue("name");
            if (typeNodeName == null || typeNodeName.equals("dmEmptyElement")) continue;
            Collection<XMLElement> childNodes = simpleTypeNode.getNodes();
            XMLElement[] childArray = new XMLElement[childNodes.size()];
            int i = 0;
            for (XMLElement child : childNodes) {
                childArray[i++] = child;
            }
            if (childNodes.size() > 1 && printDebugStatements) {
                System.out.printf("DataPowerXMLMgmtProcessor.resolveSimpleTypes(rootElement):  Child node count of simpleType %s %d\n", typeNodeName, childNodes.size());
            }
            XMLElement[] xMLElementArray = childArray;
            int n = childArray.length;
            int n2 = 0;
            while (n2 < n) {
                XMLElement child;
                child = xMLElementArray[n2];
                String childNodeName = child.getName();
                if (childNodeName.equals("xsd:restriction")) {
                    String base = child.getAttributeValue("base");
                    simpleTypeNode.addAttribute("type", base);
                    Collection<XMLElement> moveNodes = child.getNodes();
                    for (XMLElement moveNode : moveNodes) {
                        simpleTypeNode.addNode(moveNode);
                    }
                    simpleTypeNode.removeNode(child);
                } else if (printDebugStatements) {
                    System.out.printf("DataPowerXMLMgmtProcessor.resolveSimpleTypes(rootElement):  Simple Type Child Not Processed: %s\n", childNodeName);
                }
                ++n2;
            }
        }
    }

    private static void resolveReferences(XMLElement rootElement) {
        Collection<XMLElement> elements = rootElement.getNodes("//xsd.element");
        if (printDebugStatements) {
            System.out.printf("DataPowerXMLMgmtProcessor.resolveReferences(rootElement): Processing %d nodes\n", elements.size());
        }
        for (XMLElement element : elements) {
            String type = element.getAttributeValue("type");
            if (type == null || !type.equals("tns:dmReference")) continue;
            String name = element.getAttributeValue("name");
            XMLAttribute javaType = element.getAttribute("javaType");
            if (javaType != null) continue;
            element.addAttribute("javaType", name);
        }
    }

    private void resolveRestrictionTypes(XMLElement rootElement) {
        Collection<XMLElement> restrictionElements = rootElement.getNodes("//xsd.restriction");
        if (printDebugStatements) {
            System.out.printf("DataPowerXMLMgmtProcessor.resolveRestrictionTypes(rootElement):  %d restriction elements\n", restrictionElements.size());
        }
        block7: for (XMLElement restrictionElement : restrictionElements) {
            String parentNodeName;
            String restrictionBase = restrictionElement.getAttributeValue("base");
            String javaType = this.getJavaType(restrictionBase);
            XMLElement restrictionParent = restrictionElement.getParentNode();
            switch (parentNodeName = restrictionParent.getName()) {
                case "xsd:complexType": 
                case "xsd:simpleType": {
                    String nameAttribute = restrictionParent.getAttributeValue("name");
                    if (nameAttribute == null) {
                        XMLElement element = restrictionParent.getParentNode();
                        String elementName = element.getName();
                        if (elementName.equals("xsd:element")) {
                            element.addAttribute("type", restrictionBase);
                            element.addAttribute("javaType", javaType);
                            break;
                        }
                        if (!printDebugStatements) continue block7;
                        System.out.printf("DataPowerXMLMgmtProcessor.resolveElementTypes(rootElement):  Restriction element is not element.  It is %s\n", elementName);
                        break;
                    }
                    String typeAttribute = restrictionParent.getAttributeValue("type");
                    if (typeAttribute != null) continue block7;
                    restrictionParent.addAttribute("type", restrictionBase);
                    restrictionParent.addAttribute("javaType", javaType);
                    break;
                }
                default: {
                    if (!printDebugStatements) continue block7;
                    System.out.printf("DataPowerXMLMgmtProcessor.resolveExtensions(rootElement)  Restriction Parent is not one of simpleType or complexType. It is: %s\n", parentNodeName);
                }
            }
        }
    }

    private void resolveElementTypes(XMLElement rootElement) {
        Collection<XMLElement> elements = rootElement.getNodes("//xsd.(element|simpleType|complexType)");
        if (printDebugStatements) {
            System.out.printf("DataPowerXMLMgmtProcessor.resolveElementTypes(rootElement):  processing %d nodes.\n", elements.size());
        }
        for (XMLElement element : elements) {
            String javaType;
            String dpType;
            String name = element.getAttributeValue("name");
            if (name != null && name.equals("file")) {
                XMLElement contentNode = new XMLElement("xsd:element");
                contentNode.addAttribute("name", "fileData");
                contentNode.addAttribute("type", "xsd:string");
                contentNode.addAttribute("javaType", "String");
                element.addNode(contentNode);
            }
            if ((dpType = element.getAttributeValue("type")) == null) {
                dpType = name;
            }
            if (dpType == null || (javaType = element.getAttributeValue("javaType")) != null) continue;
            String type = this.getJavaType(dpType);
            if (type.equals(dpType) || dpType.contains(type)) {
                type = DataPowerXMLMgmtProcessor.getJavaClassName(type);
            }
            if (!this.typeMap.containsKey(dpType)) {
                this.typeMap.put(dpType, type);
            }
            if (!this.typeMap.containsKey(name)) {
                this.typeMap.put(name, type);
            }
            element.addAttribute("javaType", type);
        }
    }

    private void resolveExtensions(XMLElement rootElement) {
        Collection<XMLElement> extensions = rootElement.getNodes("//xsd.extension");
        if (printDebugStatements) {
            System.out.printf("DataPowerXMLMgmtProcessor.resolveExtensions(rootElement):  %d extension nodes.\n", extensions.size());
        }
        for (XMLElement extension : extensions) {
            String baseType = extension.getAttributeValue("base");
            if (baseType.equals("xsd:base64Binary") || baseType.equals("xsd:string")) {
                baseType = "JMBean";
            }
            XMLElement appliedType = extension.getParentNode().getParentNode();
            if (baseType.startsWith("tns:")) {
                baseType = baseType.substring(4);
            }
            appliedType.addAttribute("extends", baseType);
        }
    }

    private void mapTypes(XMLElement schemaNode) {
        Collection<XMLElement> allNodes = schemaNode.getNodes();
        if (printDebugStatements) {
            System.out.printf("DataPowerXMLMgmtProcessor.mapTypes(rootElement):  Mapping %d Nodes\n", allNodes.size());
        }
        for (XMLElement node : allNodes) {
            String typeName = node.getAttributeValue("name");
            if (typeName != null && typeName.equals("dmEmptyElement")) continue;
            this.mapType(node);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void mapType(XMLElement typeNode) {
        String nodeName = typeNode.getName();
        String nameAttribute = typeNode.getAttributeValue("name");
        String typeName = typeNode.getAttributeValue("type");
        String javaType = this.getJavaType(typeName);
        block12 : switch (nodeName) {
            case "xsd:extension": 
            case "xsd:pattern": {
                return;
            }
            case "xsd:all": 
            case "xsd:any": 
            case "xsd:sequence": 
            case "xsd:complexContent": 
            case "xsd:simpleContent": 
            case "xsd:choice": {
                this.processChildrenOf(typeNode);
                return;
            }
            case "xsd:complexType": 
            case "xsd:simpleType": {
                if (nameAttribute == null) {
                    if (!printDebugStatements) break;
                    System.out.printf("DataPowerXMLMgmtProcessor.mapType(typeNode=%s): Name attribute null\n", nodeName);
                    break;
                }
                if (javaType != null || !(javaType = nameAttribute).startsWith("dm")) break;
                javaType = javaType.substring(2);
                break;
            }
            default: {
                if (typeName == null) {
                    switch (nodeName) {
                        case "xsd:attribute": {
                            javaType = "String";
                            break block12;
                        }
                        case "xsd:attributeGroup": {
                            String attributeGroupRef = typeNode.getAttributeValue("ref");
                            javaType = attributeGroupRef = attributeGroupRef.replaceAll("tns:", "");
                            break block12;
                        }
                    }
                    if (!printDebugStatements) break;
                    System.out.printf("DataPowerXMLMgmtProcessor.mapType(typeNode=%s):  type attribute doesn't exist\n", nodeName);
                    break;
                }
                if (javaType != null) break;
                javaType = this.getJavaType(typeName);
            }
        }
        if (typeNode.getAttribute("javaType") == null) {
            typeNode.addAttribute("javaType", javaType);
        }
        if (!this.typeMap.containsKey(nameAttribute)) {
            this.typeMap.put(nameAttribute, javaType);
        }
        this.processChildrenOf(typeNode);
    }

    private void processChildrenOf(XMLElement node) {
        Collection<XMLElement> childNodes = node.getNodes();
        for (XMLElement childNode : childNodes) {
            this.mapType(childNode);
        }
    }

    private void mapPropertiesToTypes(XMLElement rootElement) {
        this.classIndex = new HashMap();
        this.propertyCountIndex = new HashMap();
        Collection<XMLElement> complexTypes = rootElement.getNodes("//xsd.complexType");
        for (XMLElement complexType : complexTypes) {
            String dataPowerClassName = complexType.getAttributeValue("name");
            if (dataPowerClassName == null || dataPowerClassName.equals("dmReference")) continue;
            String javaClassName = complexType.getAttributeValue("javaType");
            if (this.classIndex.containsKey(javaClassName)) {
                if (!printDebugStatements) continue;
                System.out.printf("**** WARNING:  Java Class %s already exists in class index for %s\n", javaClassName, dataPowerClassName);
                continue;
            }
            boolean configCategory = javaClassName.startsWith("Config") || javaClassName.startsWith("Modify");
            String extensionType = complexType.getAttributeValue("extends");
            if (extensionType == null) {
                extensionType = configCategory ? "DataPowerConfig" : (javaClassName.startsWith("Status") ? "DataPowerStatus" : (javaClassName.startsWith("Action") ? "DataPowerAction" : "JMBean"));
            }
            DataPowerXMLClassInfo xmlClassInfo = new DataPowerXMLClassInfo();
            xmlClassInfo.setElementType(complexType.getName());
            xmlClassInfo.setDataPowerType(dataPowerClassName);
            xmlClassInfo.setJavaType(javaClassName);
            xmlClassInfo.setSuperType(extensionType);
            this.classIndex.put(javaClassName, xmlClassInfo);
            Integer propertyCountValue = this.propertyCountIndex.get(extensionType);
            int propertyCount = propertyCountValue == null ? 0 : propertyCountValue;
            Collection<XMLElement> attributes = complexType.getNodes("//xsd:attribute");
            for (XMLElement attribute : attributes) {
                boolean isEnumeration = false;
                String name = DataPowerXMLMgmtProcessor.getJavaKeywordAdjustedName(attribute.getAttributeValue("name"));
                if (configCategory && Comparison.isInIgnoreCase(name, CONFIG_ATTRIBUTES)) continue;
                String attributeType = attribute.getAttributeValue("type");
                if (attributeType == null) {
                    attributeType = "xsd:string";
                } else if (attributeType.startsWith("tns:")) {
                    attributeType = attributeType.substring(4);
                }
                isEnumeration = this.enumerationIndex.containsKey(attributeType);
                String javaType = attribute.getAttributeValue("javaType");
                if (isEnumeration) {
                    javaType = "String";
                }
                String attributeExtensionType = DataPowerXMLMgmtProcessor.isExistingJavaType(javaType) ? "" : "JMBean";
                String variableName = DataPowerXMLMgmtProcessor.getVariableName(name);
                DataPowerXMLPropertyInfo propertyInfo = new DataPowerXMLPropertyInfo();
                propertyInfo.setElementType("attribute");
                propertyInfo.setPropertyName(variableName);
                propertyInfo.setElementOrder(0);
                propertyInfo.setDataPowerType(attributeType);
                propertyInfo.setEnumeration(isEnumeration);
                propertyInfo.setJavaPropertyName(variableName);
                propertyInfo.setJavaPropertyType(javaType);
                propertyInfo.setSuperType(attributeExtensionType);
                propertyInfo.setRequired(true);
                propertyInfo.setMultiplicity(1);
                xmlClassInfo.addProperty(propertyInfo);
            }
            Collection<XMLElement> elements = complexType.getNodes("//xsd:element");
            for (XMLElement element : elements) {
                String propertyName = element.getAttributeValue("name");
                if (propertyName.equals("filler")) continue;
                int elementOrder = propertyCount++;
                String dataPowerType = element.getAttributeValue("type");
                if (dataPowerType == null) {
                    dataPowerType = "*** UNKNOWN ***";
                } else if (dataPowerType.startsWith("tns:")) {
                    dataPowerType = dataPowerType.substring(4);
                }
                boolean isEnumeration = this.enumerationIndex.containsKey(dataPowerType);
                String javaPropertyName = DataPowerXMLMgmtProcessor.getVariableName(propertyName);
                String javaPropertyType = element.getAttributeValue("javaType");
                int minOccurs = DataPowerXMLMgmtProcessor.getMultiplicity(element, "minOccurs");
                int maxOccurs = DataPowerXMLMgmtProcessor.getMultiplicity(element, "maxOccurs");
                boolean required = minOccurs > 0;
                int multiplicity = maxOccurs;
                ArrayList patterns = (ArrayList)DataPowerXMLMgmtProcessor.getPatterns(element);
                DataPowerXMLPropertyInfo propertyInfo = new DataPowerXMLPropertyInfo();
                propertyInfo.setElementType("element");
                propertyInfo.setPropertyName(propertyName);
                propertyInfo.setElementOrder(elementOrder);
                propertyInfo.setDataPowerType(dataPowerType);
                propertyInfo.setEnumeration(isEnumeration);
                propertyInfo.setJavaPropertyName(javaPropertyName);
                propertyInfo.setJavaPropertyType(javaPropertyType);
                propertyInfo.setSuperType(extensionType);
                propertyInfo.setRequired(required);
                propertyInfo.setMultiplicity(multiplicity);
                propertyInfo.setPatterns(patterns);
                xmlClassInfo.addProperty(propertyInfo);
            }
            this.propertyCountIndex.put(javaClassName, propertyCount);
        }
    }

    public static int getMultiplicity(XMLElement child, String attribute) {
        int multiplicity = 0;
        String attrValue = child.getAttributeValue(attribute);
        if (attrValue == null) {
            multiplicity = 1;
        } else if (attrValue.equals("unbounded")) {
            multiplicity = Integer.MAX_VALUE;
        } else if (NumberUtility.isNumber(attrValue)) {
            multiplicity = Integer.parseInt(attrValue);
        }
        return multiplicity;
    }

    private static Collection<String> getPatterns(XMLElement propertyNode) {
        XMLElement simpleTypeNode = propertyNode.getNode("xsd:simpleType");
        if (simpleTypeNode == null) {
            return null;
        }
        XMLElement restrictionNode = simpleTypeNode.getNode("xsd:restriction");
        if (restrictionNode == null) {
            return null;
        }
        Collection<XMLElement> patternNodes = restrictionNode.getNodes("//xsd:pattern");
        if (CollectionUtility.isEmpty(patternNodes)) {
            return null;
        }
        ArrayList<String> patterns = new ArrayList<String>(patternNodes.size());
        for (XMLElement patternNode : patternNodes) {
            String patternValue = patternNode.getAttributeValue("value");
            patterns.add(patternValue);
        }
        return patterns;
    }

    private String getJavaType(String type) {
        if (type == null) {
            return "null";
        }
        int colon = type.indexOf(58);
        String dataPowerType = type.substring(colon + 1);
        String javaType = this.typeMap.get(dataPowerType);
        if (javaType != null) {
            return javaType;
        }
        switch (dataPowerType) {
            case "boolean": {
                javaType = "boolean";
                break;
            }
            case "anyURI": 
            case "base64Binary": 
            case "string": 
            case "dmURL": {
                javaType = "String";
                break;
            }
            case "dmUInt16": 
            case "int": 
            case "unsignedShort": 
            case "dmInt32": 
            case "integer": {
                javaType = "int";
                break;
            }
            case "dmUInt32": 
            case "unsignedInt": {
                javaType = "long";
                break;
            }
            case "dmUInt64": 
            case "dmCounter64": 
            case "unsignedLong": {
                javaType = "java.math.BigInteger";
                break;
            }
            case "dmIPHostAddress": {
                javaType = "com.jmorgan.beans.IPAddress";
                break;
            }
            case "file": {
                javaType = "DPFile";
                break;
            }
            default: {
                javaType = type.replaceAll("tns:", "");
                if (javaType.startsWith("dm")) {
                    javaType = javaType.substring(2);
                }
                if (!javaType.equals(type)) break;
                javaType = DataPowerXMLMgmtProcessor.getJavaClassName(javaType);
            }
        }
        if (javaType.equals("Reference")) {
            javaType = "ObjectReference";
        }
        this.typeMap.put(dataPowerType, javaType);
        return javaType;
    }

    public static String getJavaClassName(String name) {
        if (DataPowerXMLMgmtProcessor.isExistingJavaType(name)) {
            return name;
        }
        String variableName = DataPowerXMLMgmtProcessor.getVariableName(name);
        String className = StringUtility.capitalize(variableName);
        return className;
    }

    public static String getVariableName(String name) {
        if (name.equals("mAdminState")) {
            return "adminState";
        }
        char[] nameChars = name.toCharArray();
        char[] varChars = new char[nameChars.length - StringIndexer.countCharacter(nameChars, '-')];
        int lastChar = 32;
        int i = 0;
        int j = 0;
        while (i < nameChars.length) {
            if (i == 0 && Character.isUpperCase(nameChars[i])) {
                varChars[j++] = Character.toLowerCase(nameChars[i]);
            } else if (nameChars[i] == '.') {
                varChars[j++] = 95;
            } else if (nameChars[i] != '-') {
                varChars[j++] = nameChars[i];
            }
            if (lastChar == 45 || lastChar == 95) {
                varChars[j - 1] = Character.toUpperCase(nameChars[i]);
            }
            lastChar = nameChars[i];
            ++i;
        }
        String variableName = new String(varChars);
        Object cleanedName = DataPowerXMLMgmtProcessor.getJavaKeywordAdjustedName(variableName);
        if (!Character.isLowerCase(((String)cleanedName).charAt(0))) {
            cleanedName = ((String)cleanedName).toLowerCase().charAt(0) + ((String)cleanedName).substring(1);
        }
        return cleanedName;
    }

    private static boolean isExistingJavaType(XMLElement element) {
        String javaType = element.getAttributeValue("javaType");
        if (javaType == null) {
            return false;
        }
        return DataPowerXMLMgmtProcessor.isExistingJavaType(javaType);
    }

    public static boolean isExistingJavaType(String type) {
        switch (type) {
            case "String": 
            case "java.math.BigInteger": 
            case "int": 
            case "long": 
            case "boolean": 
            case "java.io.File": {
                return true;
            }
        }
        return false;
    }

    public static String getJavaKeywordAdjustedName(String elementName) {
        String name = elementName;
        switch (elementName.toLowerCase()) {
            case "class": {
                name = "DataPowerClass";
                break;
            }
            case "interface": {
                name = "EthernetInterface";
                break;
            }
            case "enum": {
                name = "EnumType";
                break;
            }
            case "default": {
                name = "DefaultType";
                break;
            }
            case "static": {
                name = "StaticType";
                break;
            }
            case "public": {
                name = "TypePublic";
                break;
            }
            case "switch": {
                name = "LogicSwitch";
                break;
            }
            case "case": {
                name = "LogicCase";
                break;
            }
            case "catch": {
                name = "CatchClause";
                break;
            }
            case "finally": {
                name = "FinallyClause";
            }
        }
        return name;
    }

    public static final String getEnumerationVariableName(String enumerationName) {
        if (enumerationName.startsWith("dm")) {
            enumerationName = enumerationName.substring(2);
        }
        StringBuilder sb = new StringBuilder();
        char lastChar = 'z';
        int i = 0;
        while (i < enumerationName.length()) {
            char c = enumerationName.charAt(i);
            if (!(i <= 0 || Character.isDigit(lastChar) || Character.isUpperCase(lastChar) || !Character.isUpperCase(c) && Character.isLetterOrDigit(c))) {
                sb.append("_");
            }
            if (Character.isLetterOrDigit(c)) {
                sb.append(c);
            }
            lastChar = c;
            ++i;
        }
        return sb.toString().toUpperCase();
    }

    private void writeWorkingWSDL(XMLElement rootElement) {
        try {
            this.xmlMgmtWorkingFile = new File(this.workingParentDirectory, "working-xml-mgmt.wsdl");
            new ASCFileWriter(this.xmlMgmtWorkingFile, rootElement.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getDpWSDLFileName() {
        return this.dpWSDLFileName;
    }

    public void setDpWSDLFileName(String dpWSDLFileName) {
        this.dpWSDLFileName = dpWSDLFileName;
    }

    public File getXmlMgmtWorkingFile() {
        return this.xmlMgmtWorkingFile;
    }

    public void setXmlMgmtWorkingFile(File xmlMgmtWorkingFile) {
        this.xmlMgmtWorkingFile = xmlMgmtWorkingFile;
    }

    public File getWorkingParentDirectory() {
        return this.workingParentDirectory;
    }

    public HashMap<String, DataPowerXMLClassInfo> getClassIndex() {
        return this.classIndex;
    }

    public HashMap<String, Integer> getPropertyCountIndex() {
        return this.propertyCountIndex;
    }

    public Index<String, String> getEnumerationIndex() {
        return this.enumerationIndex;
    }

    public HashMap<String, String> getTypeMap() {
        return this.typeMap;
    }
}

