/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.util.logging;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.kumbasoft.core.app.KumbaCoreApplicationProperties;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.util.FileUtility;
import com.kumbasoft.core.util.logging.AuditLogFormatter;
import com.kumbasoft.core.util.logging.AuditLogRecord;
import com.kumbasoft.core.util.logging.ConsolePublisher;
import com.kumbasoft.core.util.logging.FilePublisherSettings;
import com.kumbasoft.core.util.logging.LogPublisher;
import com.kumbasoft.core.util.logging.PublisherSettings;
import com.kumbasoft.core.util.logging.StreamPublisher;
import com.kumbasoft.core.util.security.LicenseInformation;
import com.kumbasoft.core.util.security.SecurityManager;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class AuditLogHandler
extends Handler {
    public static final String AUDIT_LOG_SETTINGS_CONFIG_FILENAME;
    private static final AuditLogHandler instance;
    private String licensedUser;
    private String applicationUser;
    private LogPublisher publisher;

    static {
        Application application = Application.getApplication();
        KumbaCoreApplicationProperties appProps = (KumbaCoreApplicationProperties)application.getApplicationProperties();
        String configsDirectory = appProps.getConfigsDirectory();
        AUDIT_LOG_SETTINGS_CONFIG_FILENAME = String.format("%sAuditLogSettings.xgn", configsDirectory);
        instance = new AuditLogHandler();
    }

    public static final AuditLogHandler getInstance() {
        return instance;
    }

    private AuditLogHandler() {
        this.setLevel(Level.CONFIG);
        this.setFormatter(new AuditLogFormatter());
        this.loadPublisher();
        new AsynchMethodInvoker((Object)this, "waitForLicense", 1000);
        new AsynchMethodInvoker((Object)this, "waitForUser", 5000);
    }

    private void loadPublisher() {
        PublisherSettings settings = (PublisherSettings)FileUtility.readObject(AUDIT_LOG_SETTINGS_CONFIG_FILENAME, null);
        if (settings == null) {
            this.setupDefaultPublisherSettings();
        } else {
            String settingsType = settings.getClass().getSimpleName();
            String settingsPackage = StringUtility.substringBefore(settings.getClass().getName(), settingsType);
            String publisherType = String.format("%s%s", settingsPackage, settingsType.replace("Settings", ""));
            try {
                this.publisher = (LogPublisher)BeanService.getBean(publisherType);
                this.publisher.setPublisherSettings(settings);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
                this.setupDefaultPublisherSettings();
            }
        }
    }

    private void setupDefaultPublisherSettings() {
        this.publisher = new ConsolePublisher();
        FilePublisherSettings filePublisherSettings = new FilePublisherSettings();
        filePublisherSettings.setDirectoryName("./logs/AuditLog/");
        filePublisherSettings.setMaximumRotations(Integer.MAX_VALUE);
        filePublisherSettings.setMaximumSize(2048000);
        this.publisher.setPublisherSettings(filePublisherSettings);
    }

    @Reflected
    private void waitForLicense() {
        LicenseInformation licenseInformation = new LicenseInformation();
        this.licensedUser = licenseInformation.getUserID();
    }

    @Reflected
    private void waitForUser() {
        ArrayList appliances = (ArrayList)Application.getApplication().getAttribute("Appliances");
        if (CollectionUtility.isEmpty(appliances)) {
            new AsynchMethodInvoker((Object)this, "waitForUser", 1000);
            return;
        }
        try {
            char[] userName = SecurityManager.getUserName();
            this.applicationUser = new String(userName);
        }
        catch (NullPointerException npe) {
            new AsynchMethodInvoker((Object)this, "waitForUser", 1000);
        }
    }

    public void setApplicationUser(String applicationUser) {
        this.applicationUser = applicationUser;
    }

    @Override
    public void publish(LogRecord record) {
        if (record instanceof AuditLogRecord) {
            Formatter formatter;
            AuditLogRecord auditLogRecord = (AuditLogRecord)record;
            auditLogRecord.setLicensedUser(this.licensedUser);
            auditLogRecord.setApplicationUser(this.applicationUser);
            record = auditLogRecord;
            if (this.publisher == null) {
                this.publisher = new ConsolePublisher();
            }
            if ((formatter = this.publisher.getFormatter()) == null) {
                formatter = this.getFormatter();
            }
            String formattedMessage = formatter.format(record);
            this.publisher.publish(formattedMessage);
        }
    }

    public LogPublisher getPublisher() {
        return this.publisher;
    }

    public void setPublisher(LogPublisher publisher) {
        if (this.publisher != null) {
            System.out.printf("AuditLogHandler.setPublisher(publisher=%s)\n", publisher.getClass().getName());
            Appliance appliance = new Appliance("** ALL **");
            appliance.setXmlManagementHost("all.appliance.hosts");
            appliance.setXmlManagementUserName("---Audit Logger---".toCharArray());
            appliance.setSshManagementUserName("--- Audit Logger ---".toCharArray());
            Domain domain = new Domain("default");
            String message = String.format("Audit Log publisher changed from %s to %s", this.publisher.getClass().getSimpleName(), publisher.getClass().getSimpleName());
            AuditLogRecord auditLogRecord = new AuditLogRecord(appliance, domain, this.applicationUser);
            auditLogRecord.setSourceClassName(this.getClass().getName());
            auditLogRecord.setSourceMethodName("setPublisher");
            auditLogRecord.setMessage(message);
            this.publish(auditLogRecord);
        }
        this.publisher = publisher;
    }

    @Override
    public void flush() {
        LogPublisher logPublisher = this.publisher;
        if (logPublisher instanceof StreamPublisher) {
            StreamPublisher streamPublisher = (StreamPublisher)logPublisher;
            streamPublisher.flush();
        }
    }

    @Override
    public void close() throws SecurityException {
        LogPublisher logPublisher = this.publisher;
        if (logPublisher instanceof StreamPublisher) {
            StreamPublisher streamPublisher = (StreamPublisher)logPublisher;
            streamPublisher.close();
        }
    }
}

